/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.io.ByteArrayInputStream;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Calendar;
import org.nhindirect.config.model.exceptions.CertificateConversionException;

@JsonIgnoreProperties(ignoreUnknown=true)
public class TrustBundleAnchor {
    private long id = -1L;
    private byte[] anchorData;
    private String thumbprint;
    private Calendar validStartDate;
    private Calendar validEndDate;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @JsonIgnore
    public X509Certificate getAsX509Certificate() {
        if (this.anchorData == null) return null;
        if (this.anchorData.length == 0) {
            return null;
        }
        try (ByteArrayInputStream bais = new ByteArrayInputStream(this.anchorData);){
            X509Certificate x509Certificate = (X509Certificate)CertificateFactory.getInstance("X.509").generateCertificate(bais);
            return x509Certificate;
        }
        catch (Exception e) {
            throw new CertificateConversionException("Data cannot be converted to a valid X.509 Certificate", e);
        }
    }

    public long getId() {
        return this.id;
    }

    public byte[] getAnchorData() {
        return this.anchorData;
    }

    public String getThumbprint() {
        return this.thumbprint;
    }

    public Calendar getValidStartDate() {
        return this.validStartDate;
    }

    public Calendar getValidEndDate() {
        return this.validEndDate;
    }

    public void setId(long id) {
        this.id = id;
    }

    public void setAnchorData(byte[] anchorData) {
        this.anchorData = anchorData;
    }

    public void setThumbprint(String thumbprint) {
        this.thumbprint = thumbprint;
    }

    public void setValidStartDate(Calendar validStartDate) {
        this.validStartDate = validStartDate;
    }

    public void setValidEndDate(Calendar validEndDate) {
        this.validEndDate = validEndDate;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TrustBundleAnchor)) {
            return false;
        }
        TrustBundleAnchor other = (TrustBundleAnchor)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getId() != other.getId()) {
            return false;
        }
        if (!Arrays.equals(this.getAnchorData(), other.getAnchorData())) {
            return false;
        }
        String this$thumbprint = this.getThumbprint();
        String other$thumbprint = other.getThumbprint();
        if (this$thumbprint == null ? other$thumbprint != null : !this$thumbprint.equals(other$thumbprint)) {
            return false;
        }
        Calendar this$validStartDate = this.getValidStartDate();
        Calendar other$validStartDate = other.getValidStartDate();
        if (this$validStartDate == null ? other$validStartDate != null : !((Object)this$validStartDate).equals(other$validStartDate)) {
            return false;
        }
        Calendar this$validEndDate = this.getValidEndDate();
        Calendar other$validEndDate = other.getValidEndDate();
        return !(this$validEndDate == null ? other$validEndDate != null : !((Object)this$validEndDate).equals(other$validEndDate));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TrustBundleAnchor;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $id = this.getId();
        result = result * 59 + (int)($id >>> 32 ^ $id);
        result = result * 59 + Arrays.hashCode(this.getAnchorData());
        String $thumbprint = this.getThumbprint();
        result = result * 59 + ($thumbprint == null ? 43 : $thumbprint.hashCode());
        Calendar $validStartDate = this.getValidStartDate();
        result = result * 59 + ($validStartDate == null ? 43 : ((Object)$validStartDate).hashCode());
        Calendar $validEndDate = this.getValidEndDate();
        result = result * 59 + ($validEndDate == null ? 43 : ((Object)$validEndDate).hashCode());
        return result;
    }

    public String toString() {
        return "TrustBundleAnchor(id=" + this.getId() + ", anchorData=" + Arrays.toString(this.getAnchorData()) + ", thumbprint=" + this.getThumbprint() + ", validStartDate=" + this.getValidStartDate() + ", validEndDate=" + this.getValidEndDate() + ")";
    }
}

