/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.model.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import javax.security.auth.x500.X500Principal;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.nhindirect.config.model.exceptions.CertificateConversionException;

public class CertUtils {
    private static final byte[] KEY_PAIR_START_STRING;
    private static final int RFC822Name_TYPE = 1;
    private static final int DNSName_TYPE = 2;
    private static final String DEFAULT_JCE_PROVIDER_STRING = "BC";
    private static final String JCE_PROVIDER_STRING_SYS_PARAM = "org.nhindirect.config.JCEProviderName";

    private static byte[] getSafeChars() {
        byte[] retVal = null;
        try {
            retVal = "STARTCERTPRIVKEYPAIR".getBytes("ASCII");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retVal;
    }

    public static String getJCEProviderName() {
        String retVal = System.getProperty(JCE_PROVIDER_STRING_SYS_PARAM);
        if (retVal == null || retVal.isEmpty()) {
            retVal = DEFAULT_JCE_PROVIDER_STRING;
        }
        return retVal;
    }

    public static void setJCEProviderName(String name) {
        if (name == null || name.isEmpty()) {
            System.setProperty(JCE_PROVIDER_STRING_SYS_PARAM, DEFAULT_JCE_PROVIDER_STRING);
        } else {
            System.setProperty(JCE_PROVIDER_STRING_SYS_PARAM, name);
        }
    }

    public static String getOwner(X509Certificate certificate) {
        String address = "";
        Collection<List<?>> altNames = null;
        try {
            altNames = certificate.getSubjectAlternativeNames();
        }
        catch (CertificateParsingException certificateParsingException) {
            // empty catch block
        }
        if (altNames != null) {
            for (List<?> entries : altNames) {
                if (entries.size() < 2) continue;
                Integer nameType = (Integer)entries.get(0);
                if (nameType == 1) {
                    address = (String)entries.get(1);
                    continue;
                }
                if (nameType != 2 || !address.isEmpty()) continue;
                address = (String)entries.get(1);
            }
        }
        if (!address.isEmpty()) {
            return address;
        }
        X500Principal issuerPrin = certificate.getSubjectX500Principal();
        HashMap<String, String> oidMap = new HashMap<String, String>();
        oidMap.put("1.2.840.113549.1.9.1", "EMAILADDRESS");
        String prinName = issuerPrin.getName("RFC1779", oidMap);
        String searchString = "EMAILADDRESS=";
        int index = prinName.indexOf(searchString);
        if (index == -1 && (index = prinName.indexOf(searchString = "CN=")) == -1) {
            return "";
        }
        int endIndex = prinName.indexOf(",", index);
        address = endIndex > -1 ? prinName.substring(index + searchString.length(), endIndex) : prinName.substring(index + searchString.length());
        return address;
    }

    public static byte[] pkcs12ToStrippedPkcs12(byte[] bytes, String passphrase) {
        return CertUtils.changePkcs12Protection(bytes, passphrase.toCharArray(), passphrase.toCharArray(), "".toCharArray(), "".toCharArray());
    }

    public static byte[] changePkcs12Protection(byte[] bytes, char[] oldKeyStorePassPhrase, char[] oldPrivateKeyPassPhrase, char[] newKeystorePassPhrase, char[] newPrivateKeyPassPhrase) {
        if (bytes == null || bytes.length == 0) {
            throw new IllegalArgumentException("Pkcs byte stream cannot be null or empty.");
        }
        byte[] retVal = null;
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        ByteArrayOutputStream outStr = new ByteArrayOutputStream();
        try {
            KeyStore localKeyStore = KeyStore.getInstance("PKCS12", CertUtils.getJCEProviderName());
            localKeyStore.load(bais, oldKeyStorePassPhrase);
            Enumeration<String> aliases = localKeyStore.aliases();
            if (aliases.hasMoreElements()) {
                String alias = aliases.nextElement();
                X509Certificate cert = (X509Certificate)localKeyStore.getCertificate(alias);
                Key key = localKeyStore.getKey(alias, oldPrivateKeyPassPhrase);
                if (key != null && key instanceof PrivateKey) {
                    localKeyStore.setKeyEntry("privCert", key, newPrivateKeyPassPhrase, new Certificate[]{cert});
                    localKeyStore.store(outStr, newKeystorePassPhrase);
                    retVal = outStr.toByteArray();
                }
            }
        }
        catch (Exception e) {
            throw new CertificateConversionException("Failed to strip encryption for PKCS stream.", e);
        }
        finally {
            try {
                bais.close();
            }
            catch (Exception exception) {}
            try {
                outStr.close();
            }
            catch (Exception exception) {}
        }
        return retVal;
    }

    public static X509Certificate toX509Certificate(byte[] data) {
        return CertUtils.toX509Certificate(data, "");
    }

    public static X509Certificate toX509Certificate(byte[] data, String passPhrase) {
        if (data == null || data.length == 0) {
            throw new IllegalArgumentException("Byte stream cannot be null or empty.");
        }
        if (passPhrase == null) {
            passPhrase = "";
        }
        if (CertUtils.isByteDataWrappedKeyPair(data)) {
            CertContainer cont = CertUtils.toCertContainer(data, null, null);
            return cont.getCert();
        }
        X509Certificate retVal = null;
        ByteArrayInputStream bais = new ByteArrayInputStream(data);
        try {
            try {
                KeyStore localKeyStore = KeyStore.getInstance("PKCS12", CertUtils.getJCEProviderName());
                localKeyStore.load(bais, passPhrase.toCharArray());
                Enumeration<String> aliases = localKeyStore.aliases();
                if (aliases.hasMoreElements()) {
                    String alias = aliases.nextElement();
                    X509Certificate cert = (X509Certificate)localKeyStore.getCertificate(alias);
                    Key key = localKeyStore.getKey(alias, passPhrase.toCharArray());
                    if (key != null && key instanceof PrivateKey) {
                        retVal = cert;
                    }
                }
            }
            catch (Exception localKeyStore) {
                // empty catch block
            }
            if (retVal == null) {
                bais.reset();
                bais = new ByteArrayInputStream(data);
                retVal = (X509Certificate)CertificateFactory.getInstance("X.509").generateCertificate(bais);
            }
        }
        catch (Exception e) {
            throw new CertificateConversionException("Failed to convert byte stream to a certificate.", e);
        }
        finally {
            try {
                bais.close();
            }
            catch (IOException iOException) {}
        }
        return retVal;
    }

    public X509Certificate certFromFile(String certFile) {
        File theCertFile = new File(certFile);
        try {
            return CertUtils.toX509Certificate(FileUtils.readFileToByteArray((File)theCertFile));
        }
        catch (Exception e) {
            return null;
        }
    }

    public static CertContainer toCertContainer(byte[] data) throws CertificateConversionException {
        return CertUtils.toCertContainer(data, true);
    }

    public static CertContainer toCertContainer(byte[] data, boolean loadPrivateKey) throws CertificateConversionException {
        return CertUtils.toCertContainer(data, "".toCharArray(), "".toCharArray(), loadPrivateKey);
    }

    protected static boolean isByteDataWrappedKeyPair(byte[] data) {
        if (data.length <= KEY_PAIR_START_STRING.length) {
            return false;
        }
        for (int idx = 0; idx < KEY_PAIR_START_STRING.length; ++idx) {
            if (data[idx] == KEY_PAIR_START_STRING[idx]) continue;
            return false;
        }
        return true;
    }

    public static CertContainer toCertContainer(byte[] data, char[] keyStorePassPhrase, char[] privateKeyPassPhrase) throws CertificateConversionException {
        return CertUtils.toCertContainer(data, keyStorePassPhrase, privateKeyPassPhrase, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static CertContainer toCertContainer(byte[] data, char[] keyStorePassPhrase, char[] privateKeyPassPhrase, boolean loadPrivateKey) throws CertificateConversionException {
        CertContainer certContainer = null;
        try {
            ByteArrayInputStream bais;
            block11: {
                InputStream inputStream = null;
                if (CertUtils.isByteDataWrappedKeyPair(data)) {
                    int idx = KEY_PAIR_START_STRING.length;
                    int high = data[idx] >= 0 ? data[idx] : data[idx] + 256;
                    int low = data[++idx] >= 0 ? data[idx] : data[idx] + 256;
                    int wrappedDatasize = low | high << 8;
                    byte[] wrappedData = Arrays.copyOfRange(data, ++idx, idx + wrappedDatasize);
                    ByteArrayInputStream bais2 = new ByteArrayInputStream(Arrays.copyOfRange(data, idx += wrappedDatasize, data.length));
                    try {
                        CertContainer certContainer2 = new CertContainer((X509Certificate)CertificateFactory.getInstance("X.509").generateCertificate(bais2), wrappedData);
                        return certContainer2;
                    }
                    finally {
                        IOUtils.closeQuietly((InputStream)bais2);
                        IOUtils.closeQuietly(inputStream);
                    }
                }
                bais = new ByteArrayInputStream(data);
                try {
                    KeyStore localKeyStore = KeyStore.getInstance("PKCS12", CertUtils.getJCEProviderName());
                    localKeyStore.load(bais, keyStorePassPhrase);
                    Enumeration<String> aliases = localKeyStore.aliases();
                    if (!aliases.hasMoreElements()) break block11;
                    String alias = aliases.nextElement();
                    X509Certificate cert = (X509Certificate)localKeyStore.getCertificate(alias);
                    if (loadPrivateKey) {
                        Key key = localKeyStore.getKey(alias, privateKeyPassPhrase);
                        if (key != null && key instanceof PrivateKey) {
                            certContainer = new CertContainer(cert, key);
                        }
                        break block11;
                    }
                    certContainer = new CertContainer(cert, (Key)null);
                }
                catch (Exception localKeyStore) {
                    // empty catch block
                }
            }
            if (certContainer == null) {
                bais.reset();
                bais = new ByteArrayInputStream(data);
                X509Certificate cert = (X509Certificate)CertificateFactory.getInstance("X.509").generateCertificate(bais);
                certContainer = new CertContainer(cert, (Key)null);
            }
            bais.close();
            return certContainer;
        }
        catch (Exception e) {
            throw new CertificateConversionException("Data cannot be converted to a valid X.509 Certificate", e);
        }
    }

    public static byte[] certAndWrappedKeyToRawByteFormat(byte[] wrappedKey, X509Certificate cert) throws CertificateConversionException {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        try {
            outStream.write(KEY_PAIR_START_STRING);
            int size = wrappedKey.length;
            outStream.write((byte)(size >> 8 & 0xFF));
            outStream.write((byte)(size & 0xFF));
            outStream.write(wrappedKey);
            outStream.write(cert.getEncoded());
            byte[] byArray = outStream.toByteArray();
            return byArray;
        }
        catch (Exception e) {
            throw new CertificateConversionException("Failed to convert wrapped key and cert to byte stream.", e);
        }
        finally {
            IOUtils.closeQuietly((OutputStream)outStream);
        }
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
        KEY_PAIR_START_STRING = CertUtils.getSafeChars();
    }

    public static class CertContainer {
        private final X509Certificate cert;
        private final Key key;
        private final byte[] wrappedKeyData;

        public CertContainer(X509Certificate cert, Key key) {
            this.cert = cert;
            this.key = key;
            this.wrappedKeyData = null;
        }

        public CertContainer(X509Certificate cert, byte[] wrappedKeyData) {
            this.cert = cert;
            this.key = null;
            this.wrappedKeyData = wrappedKeyData;
        }

        public X509Certificate getCert() {
            return this.cert;
        }

        public Key getKey() {
            return this.key;
        }

        public byte[] getWrappedKeyData() {
            return this.wrappedKeyData;
        }
    }
}

