/*
 * Decompiled with CFR 0.152.
 */
package org.nhind.config.rest.feign;

import java.util.Collection;
import org.nhindirect.common.rest.exceptions.ServiceException;
import org.nhindirect.common.rest.feign.DefaultFeignClientConfiguration;
import org.nhindirect.config.model.Address;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;

@FeignClient(name="direct-config-service", url="${direct.config.service.url}", configuration={DefaultFeignClientConfiguration.class})
public interface AddressClient {
    @GetMapping(value={"/address/{address}"})
    public Address getAddress(@PathVariable(value="address") String var1) throws ServiceException;

    @GetMapping(value={"/address/domain/{domainName}"})
    public Collection<Address> getAddressesByDomain(@PathVariable(value="domainName") String var1) throws ServiceException;

    @PutMapping(value={"/address"}, consumes={"application/json"})
    public ResponseEntity<Void> addAddress(@RequestBody Address var1) throws ServiceException;

    @PostMapping(value={"/address"}, consumes={"application/json"})
    public void updateAddress(@RequestBody Address var1) throws ServiceException;

    @DeleteMapping(value={"address/{address}"}, consumes={"application/json"})
    public ResponseEntity<Void> removeAddress(@PathVariable(value="address") String var1) throws ServiceException;
}

