/*
 * Decompiled with CFR 0.152.
 */
package org.nhind.config.rest.feign;

import java.util.Collection;
import org.nhindirect.common.rest.exceptions.ServiceException;
import org.nhindirect.common.rest.feign.DefaultFeignClientConfiguration;
import org.nhindirect.config.model.Certificate;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;

@FeignClient(name="direct-config-service", url="${direct.config.service.url}", configuration={DefaultFeignClientConfiguration.class})
public interface CertificateClient {
    @GetMapping(value={"/certificate"})
    public Collection<Certificate> getAllCertificates() throws ServiceException;

    @GetMapping(value={"/certificate/{owner}"})
    public Collection<Certificate> getCertificatesByOwner(@PathVariable(value="owner") String var1) throws ServiceException;

    @GetMapping(value={"/certificate/{owner}/{thumbprint}"})
    public Certificate getCertificatesByOwnerAndThumbprint(@PathVariable(value="owner") String var1, @PathVariable(value="thumbprint") String var2) throws ServiceException;

    @PutMapping(value={"/certificate"}, consumes={"application/json"})
    public void addCertificate(@RequestBody Certificate var1) throws ServiceException;

    @DeleteMapping(value={"/certificate/ids/{ids}"})
    public void removeCertificatesByIds(@PathVariable(value="ids") String var1) throws ServiceException;

    @DeleteMapping(value={"/certificate/{owner}"})
    public void removeCertificatesByOwner(@PathVariable(value="owner") String var1) throws ServiceException;
}

