/*
 * Decompiled with CFR 0.152.
 */
package org.nhind.config.rest.feign;

import java.util.Collection;
import org.nhindirect.common.rest.exceptions.ServiceException;
import org.nhindirect.common.rest.feign.DefaultFeignClientConfiguration;
import org.nhindirect.config.model.CertPolicy;
import org.nhindirect.config.model.CertPolicyGroup;
import org.nhindirect.config.model.CertPolicyGroupDomainReltn;
import org.nhindirect.config.model.CertPolicyGroupUse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;

@FeignClient(name="direct-config-service", url="${direct.config.service.url}", configuration={DefaultFeignClientConfiguration.class})
public interface CertificatePolicyClient {
    @GetMapping(value={"/certpolicy"})
    public Collection<CertPolicy> getPolicies() throws ServiceException;

    @GetMapping(value={"/certpolicy/{policyName}"})
    public CertPolicy getPolicyByName(@PathVariable(value="policyName") String var1) throws ServiceException;

    @PutMapping(value={"/certpolicy"})
    public void addPolicy(@RequestBody CertPolicy var1) throws ServiceException;

    @DeleteMapping(value={"/certpolicy/{policyName}"})
    public void removePolicyByName(@PathVariable(value="policyName") String var1) throws ServiceException;

    @PostMapping(value={"/certpolicy/{policyName}/policyAttributes"}, consumes={"application/json"})
    public void updatePolicyAttributes(@PathVariable(value="policyName") String var1, @RequestBody CertPolicy var2) throws ServiceException;

    @GetMapping(value={"/certpolicy/groups"})
    public Collection<CertPolicyGroup> getPolicyGroups() throws ServiceException;

    @GetMapping(value={"/certpolicy/groups/{groupName}"})
    public CertPolicyGroup getPolicyGroupByName(@PathVariable(value="groupName") String var1) throws ServiceException;

    @PutMapping(value={"/certpolicy/groups"}, consumes={"application/json"})
    public void addPolicyGroup(@RequestBody CertPolicyGroup var1) throws ServiceException;

    @DeleteMapping(value={"/certpolicy/groups/{groupName}"})
    public void removePolicyGroupByName(@PathVariable(value="groupName") String var1) throws ServiceException;

    @PostMapping(value={"/certpolicy/groups/{groupName}/groupAttributes"}, consumes={"application/json"})
    public void updateGroupAttributes(@PathVariable(value="groupName") String var1, @RequestBody String var2) throws ServiceException;

    @PostMapping(value={"/certpolicy/groups/uses/{group}"}, consumes={"application/json"})
    public void addPolicyUseToGroup(@PathVariable(value="group") String var1, @RequestBody CertPolicyGroupUse var2) throws ServiceException;

    @PostMapping(value={"/certpolicy/groups/uses/{group}/removePolicy"}, consumes={"application/json"})
    public void removedPolicyUseFromGroup(@PathVariable(value="group") String var1, @RequestBody CertPolicyGroupUse var2) throws ServiceException;

    @GetMapping(value={"/certpolicy/groups/domain"})
    public Collection<CertPolicyGroupDomainReltn> getPolicyGroupDomainReltns() throws ServiceException;

    @GetMapping(value={"/certpolicy/groups/domain/{domain}"})
    public Collection<CertPolicyGroup> getPolicyGroupsByDomain(@PathVariable(value="domain") String var1) throws ServiceException;

    @PostMapping(value={"/certpolicy/groups/domain/{group}/{domain}"})
    public void associatePolicyGroupToDomain(@PathVariable(value="group") String var1, @PathVariable(value="domain") String var2) throws ServiceException;

    @DeleteMapping(value={"/certpolicy/groups/domain/{group}/{domain}"})
    public void disassociatePolicyGroupFromDomain(@PathVariable(value="group") String var1, @PathVariable(value="domain") String var2) throws ServiceException;

    @DeleteMapping(value={"/certpolicy/groups/domain/{domain}/deleteFromDomain"})
    public void disassociatePolicyGroupsFromDomain(@PathVariable(value="domain") String var1) throws ServiceException;

    @DeleteMapping(value={"/certpolicy/groups/domain/{group}/deleteFromGroup"})
    public void disassociatePolicyGroupFromDomains(@PathVariable(value="group") String var1) throws ServiceException;
}

