/*
 * Decompiled with CFR 0.152.
 */
package org.nhind.config.rest.feign;

import java.util.Collection;
import org.nhindirect.common.rest.exceptions.ServiceException;
import org.nhindirect.common.rest.feign.DefaultFeignClientConfiguration;
import org.nhindirect.config.model.Setting;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;

@FeignClient(name="direct-config-service", url="${direct.config.service.url}", configuration={DefaultFeignClientConfiguration.class})
public interface SettingClient {
    @GetMapping(value={"/setting"})
    public Collection<Setting> getAllSettings() throws ServiceException;

    @GetMapping(value={"/setting/{name}"})
    public Setting getSettingByName(@PathVariable(value="name") String var1) throws ServiceException;

    @PutMapping(value={"/setting/{name}/{value}"})
    public void addSetting(@PathVariable(value="name") String var1, @PathVariable(value="value") String var2) throws ServiceException;

    @PostMapping(value={"/setting/{name}/{value}"})
    public void updateSetting(@PathVariable(value="name") String var1, @PathVariable(value="value") String var2) throws ServiceException;

    @DeleteMapping(value={"/setting/{name}"})
    public void removeSettingByName(@PathVariable(value="name") String var1) throws ServiceException;
}

