/*
 * Decompiled with CFR 0.152.
 */
package org.nhind.config.rest.impl;

import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Collections;
import org.nhind.config.rest.TrustBundleService;
import org.nhind.config.rest.feign.TrustBundleClient;
import org.nhindirect.common.rest.exceptions.ServiceException;
import org.nhindirect.common.rest.exceptions.ServiceMethodException;
import org.nhindirect.config.model.TrustBundle;
import org.nhindirect.config.model.TrustBundleDomainReltn;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DefaultTrustBundleService
implements TrustBundleService {
    protected TrustBundleClient bundleClient;

    public DefaultTrustBundleService(TrustBundleClient bundleClient) {
        this.bundleClient = bundleClient;
    }

    @Autowired
    public void setTrustBundleClient(TrustBundleClient bundleClient) {
        this.bundleClient = bundleClient;
    }

    @Override
    public Collection<TrustBundle> getTrustBundles(boolean fetchAnchors) throws ServiceException {
        Collection<TrustBundle> bundles = this.bundleClient.getTrustBundles(fetchAnchors);
        return bundles == null ? Collections.emptyList() : bundles;
    }

    @Override
    public Collection<TrustBundleDomainReltn> getTrustBundlesByDomain(String domainName, boolean fetchAnchors) throws ServiceException {
        Collection<TrustBundleDomainReltn> bundles = this.bundleClient.getTrustBundlesByDomain(domainName, fetchAnchors);
        return bundles == null ? Collections.emptyList() : bundles;
    }

    @Override
    public Collection<TrustBundleDomainReltn> getAllTrustBundleDomainReltns(boolean fetchAnchors) throws ServiceException {
        Collection<TrustBundleDomainReltn> bundles = this.bundleClient.getAllTrustBundleDomainRelts(fetchAnchors);
        return bundles == null ? Collections.emptyList() : bundles;
    }

    @Override
    public TrustBundle getTrustBundle(String bundleName) throws ServiceException {
        try {
            return this.bundleClient.getTrustBundleByName(bundleName);
        }
        catch (ServiceMethodException e) {
            if (e.getResponseCode() == 404) {
                return null;
            }
            throw e;
        }
    }

    @Override
    public void addTrustBundle(TrustBundle bundle) throws ServiceException {
        this.bundleClient.addTrustBundle(bundle);
    }

    @Override
    public void refreshTrustBundle(String bundleName) throws ServiceException {
        this.bundleClient.refreshTrustBundle(bundleName);
    }

    @Override
    public void deleteTrustBundle(String bundleName) throws ServiceException {
        this.bundleClient.deleteBundle(bundleName);
    }

    @Override
    public void updateSigningCert(String bundleName, X509Certificate cert) throws ServiceException {
        try {
            byte[] certBytes = cert == null ? new byte[]{} : cert.getEncoded();
            this.bundleClient.updateSigningCert(bundleName, certBytes);
        }
        catch (ServiceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ServiceException("Invalid Certificate");
        }
    }

    @Override
    public void updateTrustBundleAttributes(String bundleName, TrustBundle bundleData) throws ServiceException {
        this.bundleClient.updateBundleAttributes(bundleName, bundleData);
    }

    @Override
    public void associateTrustBundleToDomain(String bundleName, String domainName, boolean incoming, boolean outgoing) throws ServiceException {
        this.bundleClient.associateTrustBundleToDomain(bundleName, domainName, incoming, outgoing);
    }

    @Override
    public void disassociateTrustBundleFromDomain(String bundleName, String domainName) throws ServiceException {
        this.bundleClient.disassociateTrustBundleFromDomain(bundleName, domainName);
    }

    @Override
    public void disassociateTrustBundlesFromDomain(String domainName) throws ServiceException {
        this.bundleClient.disassociateTrustBundlesFromDomain(domainName);
    }

    @Override
    public void disassociateTrustBundleFromDomains(String bundleName) throws ServiceException {
        this.bundleClient.disassociateTrustBundleFromDomains(bundleName);
    }
}

