/*
 * Decompiled with CFR 0.152.
 */
package org.nhind.config.rest.feign;

import java.util.Collection;
import org.nhindirect.common.rest.exceptions.ServiceException;
import org.nhindirect.common.rest.feign.DefaultFeignClientConfiguration;
import org.nhindirect.config.model.TrustBundle;
import org.nhindirect.config.model.TrustBundleDomainReltn;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

@FeignClient(name="direct-config-service", url="${direct.config.service.url}", configuration={DefaultFeignClientConfiguration.class})
public interface TrustBundleClient {
    @GetMapping(value={"/trustbundle"})
    public Collection<TrustBundle> getTrustBundles(@RequestParam(name="fetchAnchors", defaultValue="true") boolean var1) throws ServiceException;

    @GetMapping(value={"/trustbundle/domains/{domainName}"})
    public Collection<TrustBundleDomainReltn> getTrustBundlesByDomain(@PathVariable(value="domainName") String var1, @RequestParam(name="fetchAnchors", defaultValue="true") boolean var2) throws ServiceException;

    @GetMapping(value={"/trustbundle/domains/bundles/reltns"})
    public Collection<TrustBundleDomainReltn> getAllTrustBundleDomainRelts(@RequestParam(name="fetchAnchors", defaultValue="true") boolean var1) throws ServiceException;

    @GetMapping(value={"/trustbundle/{bundleName}"})
    public TrustBundle getTrustBundleByName(@PathVariable(value="bundleName") String var1) throws ServiceException;

    @PutMapping(value={"/trustbundle"}, consumes={"application/json"})
    public void addTrustBundle(@RequestBody TrustBundle var1) throws ServiceException;

    @PostMapping(value={"/trustbundle/{bundle}/refreshBundle"})
    public void refreshTrustBundle(@PathVariable(value="bundle") String var1) throws ServiceException;

    @DeleteMapping(value={"/trustbundle/{bundle}"})
    public void deleteBundle(@PathVariable(value="bundle") String var1) throws ServiceException;

    @PostMapping(value={"/trustbundle/{bundle}/signingCert"}, consumes={"application/json"})
    public void updateSigningCert(@PathVariable(value="bundle") String var1, @RequestBody(required=false) byte[] var2) throws ServiceException;

    @PostMapping(value={"/trustbundle/{bundle}/bundleAttributes"}, consumes={"application/json"})
    public void updateBundleAttributes(@PathVariable(value="bundle") String var1, @RequestBody TrustBundle var2) throws ServiceException;

    @PostMapping(value={"/trustbundle/{bundle}/{domain}"})
    public void associateTrustBundleToDomain(@PathVariable(value="bundle") String var1, @PathVariable(value="domain") String var2, @RequestParam(name="incoming", defaultValue="true") boolean var3, @RequestParam(name="outgoing", defaultValue="true") boolean var4) throws ServiceException;

    @DeleteMapping(value={"/trustbundle/{bundle}/{domain}"})
    public void disassociateTrustBundleFromDomain(@PathVariable(value="bundle") String var1, @PathVariable(value="domain") String var2) throws ServiceException;

    @DeleteMapping(value={"/trustbundle/{domain}/deleteFromDomain"})
    public void disassociateTrustBundlesFromDomain(@PathVariable(value="domain") String var1) throws ServiceException;

    @DeleteMapping(value={"/trustbundle/{bundle}/deleteFromBundle"})
    public void disassociateTrustBundleFromDomains(@PathVariable(value="bundle") String var1) throws ServiceException;
}

