/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.service.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.jws.WebService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nhindirect.config.service.ConfigurationServiceException;
import org.nhindirect.config.service.DomainService;
import org.nhindirect.config.store.Domain;
import org.nhindirect.config.store.EntityStatus;
import org.nhindirect.config.store.dao.DomainDao;
import org.springframework.beans.factory.annotation.Autowired;

@WebService(endpointInterface="org.nhindirect.config.service.DomainService")
public class DomainServiceImpl
implements DomainService {
    private static final Log log = LogFactory.getLog(DomainServiceImpl.class);
    private DomainDao dao;

    public void init() {
        log.info((Object)"DomainService initialized");
    }

    @Override
    public void addDomain(Domain domain) throws ConfigurationServiceException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Enter");
        }
        this.dao.add(domain);
        log.info((Object)("Added Domain: " + domain.getDomainName()));
        if (log.isDebugEnabled()) {
            log.debug((Object)"Exit");
        }
    }

    @Override
    public void updateDomain(Domain domain) throws ConfigurationServiceException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Enter");
        }
        if (domain != null) {
            this.dao.update(domain);
            log.info((Object)("Modified Domain: " + domain.getDomainName()));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Exit");
        }
    }

    @Override
    public int getDomainCount() throws ConfigurationServiceException {
        return this.dao.count();
    }

    @Override
    public Collection<Domain> getDomains(Collection<String> domainNames, EntityStatus status) throws ConfigurationServiceException {
        ArrayList<String> domains = new ArrayList<String>(domainNames);
        return this.dao.getDomains(domains, status);
    }

    @Override
    public void removeDomain(String domainName) throws ConfigurationServiceException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Enter");
        }
        this.dao.delete(domainName);
        log.info((Object)("Modified Domain: " + domainName));
        if (log.isDebugEnabled()) {
            log.debug((Object)"Exit");
        }
    }

    @Override
    public Collection<Domain> listDomains(String lastDomainName, int maxResults) throws ConfigurationServiceException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Enter");
        }
        List result = this.dao.listDomains(lastDomainName, maxResults);
        if (log.isDebugEnabled()) {
            if (result == null) {
                log.debug((Object)"Exit: NULL");
            } else {
                log.debug((Object)("Exit: " + result.toString()));
            }
        }
        return result;
    }

    @Override
    public Collection<Domain> searchDomain(String domain, EntityStatus status) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Enter");
        }
        List result = this.dao.searchDomain(domain, status);
        if (log.isDebugEnabled()) {
            if (result == null) {
                log.debug((Object)"Exit: NULL");
            } else {
                log.debug((Object)("Exit: " + result.toString()));
            }
        }
        return result;
    }

    @Override
    public Domain getDomain(Long id) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Enter");
        }
        Domain result = this.dao.getDomain(id);
        if (log.isDebugEnabled()) {
            if (result == null) {
                log.debug((Object)"Exit: NULL");
            } else {
                log.debug((Object)("Exit: " + result.toString()));
            }
        }
        return result;
    }

    @Autowired
    public void setDao(DomainDao aDao) {
        this.dao = aDao;
    }
}

