/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.service.impl;

import java.io.ByteArrayInputStream;
import java.security.Key;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import javax.jws.WebService;
import javax.security.auth.x500.X500Principal;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.nhindirect.config.service.CertificateService;
import org.nhindirect.config.service.ConfigurationServiceException;
import org.nhindirect.config.service.impl.CertificateGetOptions;
import org.nhindirect.config.store.Certificate;
import org.nhindirect.config.store.EntityStatus;
import org.nhindirect.config.store.dao.CertificateDao;
import org.springframework.beans.factory.annotation.Autowired;

@WebService(endpointInterface="org.nhindirect.config.service.CertificateService")
public class CertificateServiceImpl
implements CertificateService {
    private static final int RFC822Name_TYPE = 1;
    private static final int DNSName_TYPE = 2;
    private static final Log log = LogFactory.getLog(CertificateServiceImpl.class);
    private CertificateDao dao;

    @Autowired
    public void setDao(CertificateDao aDao) {
        this.dao = aDao;
    }

    public void init() {
        log.info((Object)"CertificateService initialized");
    }

    @Override
    public void addCertificates(Collection<Certificate> certs) throws ConfigurationServiceException {
        if (certs != null && certs.size() > 0) {
            for (Certificate cert : certs) {
                String theOwner;
                CertContainer cont;
                if ((cert.getOwner() == null || cert.getOwner().isEmpty()) && cert.getData() != null && (cont = this.toCertContainer(cert.getData())) != null && cont.getCert() != null && (theOwner = this.getOwner(cont.getCert())) != null && !theOwner.isEmpty()) {
                    cert.setOwner(theOwner);
                }
                this.dao.save(cert);
            }
        }
    }

    @Override
    public Certificate getCertificate(String owner, String thumbprint, CertificateGetOptions options) throws ConfigurationServiceException {
        return this.dao.load(owner, thumbprint);
    }

    @Override
    public Collection<Certificate> getCertificates(Collection<Long> certIds, CertificateGetOptions options) throws ConfigurationServiceException {
        return this.dao.list(new ArrayList<Long>(certIds));
    }

    @Override
    public Collection<Certificate> getCertificatesForOwner(String owner, CertificateGetOptions options) throws ConfigurationServiceException {
        return this.dao.list(owner);
    }

    @Override
    public void setCertificateStatus(Collection<Long> certificateIDs, EntityStatus status) throws ConfigurationServiceException {
        this.dao.setStatus(new ArrayList<Long>(certificateIDs), status);
    }

    @Override
    public void setCertificateStatusForOwner(String owner, EntityStatus status) throws ConfigurationServiceException {
        this.dao.setStatus(owner, status);
    }

    @Override
    public void removeCertificates(Collection<Long> certificateIds) throws ConfigurationServiceException {
        this.dao.delete(new ArrayList<Long>(certificateIds));
    }

    @Override
    public void removeCertificatesForOwner(String owner) throws ConfigurationServiceException {
        this.dao.delete(owner);
    }

    @Override
    public Collection<Certificate> listCertificates(long lastCertificateID, int maxResults, CertificateGetOptions options) throws ConfigurationServiceException {
        return this.dao.list((String)null);
    }

    @Override
    public boolean contains(Certificate cert) {
        return this.dao.load(cert.getOwner(), cert.getThumbprint()) != null;
    }

    public CertContainer toCertContainer(byte[] data) throws ConfigurationServiceException {
        CertContainer certContainer = null;
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(data);
            try {
                KeyStore localKeyStore = KeyStore.getInstance("PKCS12", Certificate.getJCEProviderName());
                localKeyStore.load(bais, "".toCharArray());
                Enumeration<String> aliases = localKeyStore.aliases();
                if (aliases.hasMoreElements()) {
                    String alias = aliases.nextElement();
                    X509Certificate cert = (X509Certificate)localKeyStore.getCertificate(alias);
                    Key key = localKeyStore.getKey(alias, "".toCharArray());
                    if (key != null && key instanceof PrivateKey) {
                        certContainer = new CertContainer(cert, key);
                    }
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            if (certContainer == null) {
                bais.reset();
                bais = new ByteArrayInputStream(data);
                X509Certificate cert = (X509Certificate)CertificateFactory.getInstance("X.509").generateCertificate(bais);
                certContainer = new CertContainer(cert, null);
            }
            bais.close();
        }
        catch (Exception e) {
            throw new ConfigurationServiceException("Data cannot be converted to a valid X.509 Certificate", e);
        }
        return certContainer;
    }

    private String getOwner(X509Certificate certificate) {
        String address = "";
        Collection<List<?>> altNames = null;
        try {
            altNames = certificate.getSubjectAlternativeNames();
        }
        catch (CertificateParsingException ex) {
            // empty catch block
        }
        if (altNames != null) {
            for (List<?> entries : altNames) {
                if (entries.size() < 2) continue;
                Integer nameType = (Integer)entries.get(0);
                if (nameType == 1) {
                    address = (String)entries.get(1);
                    continue;
                }
                if (nameType != 2 || !address.isEmpty()) continue;
                address = (String)entries.get(1);
            }
        }
        if (!address.isEmpty()) {
            return address;
        }
        X500Principal issuerPrin = certificate.getSubjectX500Principal();
        HashMap<String, String> oidMap = new HashMap<String, String>();
        oidMap.put("1.2.840.113549.1.9.1", "EMAILADDRESS");
        String prinName = issuerPrin.getName("RFC1779", oidMap);
        String searchString = "EMAILADDRESS=";
        int index = prinName.indexOf(searchString);
        if (index == -1 && (index = prinName.indexOf(searchString = "CN=")) == -1) {
            return "";
        }
        int endIndex = prinName.indexOf(",", index);
        address = endIndex > -1 ? prinName.substring(index + searchString.length(), endIndex) : prinName.substring(index + searchString.length());
        return address;
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }

    public static class CertContainer {
        private final X509Certificate cert;
        private final Key key;

        public CertContainer(X509Certificate cert, Key key) {
            this.cert = cert;
            this.key = key;
        }

        public X509Certificate getCert() {
            return this.cert;
        }

        public Key getKey() {
            return this.key;
        }
    }
}

