/* 
Copyright (c) 2010, NHIN Direct Project
All rights reserved.

Redistribution and use in source and binary forms, with or without modification, are permitted provided that the following conditions are met:

1. Redistributions of source code must retain the above copyright notice, this list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following disclaimer 
   in the documentation and/or other materials provided with the distribution.  
3. Neither the name of the The NHIN Direct Project (nhindirect.org) nor the names of its contributors may be used to endorse or promote 
   products derived from this software without specific prior written permission.
   
THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, 
THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS 
BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE 
GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, 
STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF 
THE POSSIBILITY OF SUCH DAMAGE.
 */

package org.nhindirect.config.service.impl;

import org.nhindirect.config.store.EntityStatus;

/**
 * A set of options relating to a Certificate.
 */
public class CertificateGetOptions {

    private boolean includeData = false;
    private boolean includePrivateKey = false;

    private EntityStatus status;

    /**
     * A CertificateGetOptions instance.
     */
    public static final CertificateGetOptions DEFAULT = new CertificateGetOptions();

    /**
     * Default constructor.
     */
    CertificateGetOptions() {
    }

    /**
     * Return the value of includeData.
     * 
     * @return the value of includeData.
     */
    public boolean isIncludeData() {
        return includeData;
    }

    /**
     * Set the value of includeData.
     * 
     * @param includeData
     *            The value of includeData.
     */
    public void setIncludeData(boolean includeData) {
        this.includeData = includeData;
    }

    /**
     * Get the value of includePrvateKey.
     * 
     * @return the value of includePrivateKey.
     */
    public boolean isIncludePrivateKey() {
        return includePrivateKey;
    }

    /**
     * Set the value of includePrivateKey.
     * 
     * @param includePrivateKey
     *            The value of includePrivateKey.
     */
    public void setIncludePrivateKey(boolean includePrivateKey) {
        this.includePrivateKey = includePrivateKey;
    }

    /**
     * Get the value of status.
     * 
     * @return the value of status.
     */
    public EntityStatus getStatus() {
        return status;
    }

    /**
     * Set the value of status.
     * 
     * @param status
     *            The value of status.
     */
    public void setStatus(EntityStatus status) {
        this.status = status;
    }

}
