/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.service.impl;

import java.util.Arrays;
import java.util.Collection;
import javax.jws.WebService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nhindirect.config.service.ConfigurationServiceException;
import org.nhindirect.config.service.SettingService;
import org.nhindirect.config.store.Setting;
import org.nhindirect.config.store.dao.SettingDao;
import org.springframework.beans.factory.annotation.Autowired;

@WebService(endpointInterface="org.nhindirect.config.service.SettingService")
public class SettingServiceImpl
implements SettingService {
    private static final Log log = LogFactory.getLog(SettingServiceImpl.class);
    private SettingDao dao;

    public void init() {
        log.info((Object)"SettingService initialized");
    }

    @Override
    public void addSetting(String name, String value) throws ConfigurationServiceException {
        this.dao.add(name, value);
    }

    @Override
    public void deleteSetting(Collection<String> names) throws ConfigurationServiceException {
        this.dao.delete(names);
    }

    @Override
    public Collection<Setting> getAllSettings() throws ConfigurationServiceException {
        return this.dao.getAll();
    }

    @Override
    public Setting getSettingByName(String name) throws ConfigurationServiceException {
        Collection settings = this.dao.getByNames(Arrays.asList(name));
        if (settings == null || settings.size() == 0) {
            return null;
        }
        return (Setting)settings.iterator().next();
    }

    @Override
    public Collection<Setting> getSettingsByNames(Collection<String> names) throws ConfigurationServiceException {
        return this.dao.getByNames(names);
    }

    @Override
    public void updateSetting(String name, String value) throws ConfigurationServiceException {
        this.dao.update(name, value);
    }

    @Autowired
    public void setDao(SettingDao dao) {
        this.dao = dao;
    }

    public SettingDao getDao() {
        return this.dao;
    }
}

