/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.resources;

import com.google.inject.Singleton;
import java.net.URI;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.apache.camel.ProducerTemplate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nhindirect.config.model.exceptions.CertificateConversionException;
import org.nhindirect.config.model.utils.CertUtils;
import org.nhindirect.config.resources.ProtectedResource;
import org.nhindirect.config.resources.util.EntityModelConversion;
import org.nhindirect.config.store.Domain;
import org.nhindirect.config.store.TrustBundle;
import org.nhindirect.config.store.TrustBundleDomainReltn;
import org.nhindirect.config.store.dao.DomainDao;
import org.nhindirect.config.store.dao.TrustBundleDao;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
@Path(value="trustbundle/")
@Singleton
public class TrustBundleResource
extends ProtectedResource {
    private static final Log log = LogFactory.getLog(TrustBundleResource.class);
    protected TrustBundleDao bundleDao;
    protected DomainDao domainDao;
    protected ProducerTemplate template;

    @Autowired
    public void setTrustBundleDao(TrustBundleDao bundleDao) {
        this.bundleDao = bundleDao;
    }

    @Autowired
    public void setDomainDao(DomainDao domainDao) {
        this.domainDao = domainDao;
    }

    @Autowired
    @Qualifier(value="bundleRefresh")
    public void setTemplate(ProducerTemplate template) {
        this.template = template;
    }

    @GET
    @Produces(value={"application/json"})
    public Response getTrustBundles(@QueryParam(value="fetchAnchors") @DefaultValue(value="true") boolean fetchAnchors) {
        Collection retBundles = null;
        try {
            retBundles = this.bundleDao.getTrustBundles();
            if (retBundles.isEmpty()) {
                return Response.noContent().cacheControl(noCache).build();
            }
        }
        catch (Throwable e) {
            log.error((Object)"Error looking up trust bundles", e);
            return Response.serverError().cacheControl(noCache).build();
        }
        ArrayList<org.nhindirect.config.model.TrustBundle> modelBundles = new ArrayList<org.nhindirect.config.model.TrustBundle>();
        for (TrustBundle bundle : retBundles) {
            if (!fetchAnchors) {
                bundle.setTrustBundleAnchors(new ArrayList());
            }
            modelBundles.add(EntityModelConversion.toModelTrustBundle(bundle));
        }
        GenericEntity<Collection<org.nhindirect.config.model.TrustBundle>> entity = new GenericEntity<Collection<org.nhindirect.config.model.TrustBundle>>(modelBundles){};
        return Response.ok((Object)entity).cacheControl(noCache).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="domains/{domainName}")
    public Response getTrustBundlesByDomain(@PathParam(value="domainName") String domainName, @QueryParam(value="fetchAnchors") @DefaultValue(value="true") boolean fetchAnchors) {
        Domain entityDomain;
        try {
            entityDomain = this.domainDao.getDomainByName(domainName);
            if (entityDomain == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).cacheControl(noCache).build();
            }
        }
        catch (Exception e) {
            log.error((Object)"Error looking up domain.", (Throwable)e);
            return Response.serverError().cacheControl(noCache).build();
        }
        Collection retBundles = null;
        try {
            retBundles = this.bundleDao.getTrustBundlesByDomain(entityDomain.getId().longValue());
            if (retBundles.isEmpty()) {
                return Response.noContent().cacheControl(noCache).build();
            }
        }
        catch (Throwable e) {
            log.error((Object)"Error looking up trust bundles", e);
            return Response.serverError().cacheControl(noCache).build();
        }
        ArrayList<org.nhindirect.config.model.TrustBundleDomainReltn> modelBundles = new ArrayList<org.nhindirect.config.model.TrustBundleDomainReltn>();
        for (TrustBundleDomainReltn bundleReltn : retBundles) {
            if (!fetchAnchors) {
                bundleReltn.getTrustBundle().setTrustBundleAnchors(new ArrayList());
            }
            org.nhindirect.config.model.TrustBundleDomainReltn newReltn = new org.nhindirect.config.model.TrustBundleDomainReltn();
            newReltn.setIncoming(bundleReltn.isIncoming());
            newReltn.setOutgoing(bundleReltn.isOutgoing());
            newReltn.setDomain(EntityModelConversion.toModelDomain(bundleReltn.getDomain()));
            newReltn.setTrustBundle(EntityModelConversion.toModelTrustBundle(bundleReltn.getTrustBundle()));
            modelBundles.add(newReltn);
        }
        GenericEntity<Collection<org.nhindirect.config.model.TrustBundleDomainReltn>> entity = new GenericEntity<Collection<org.nhindirect.config.model.TrustBundleDomainReltn>>(modelBundles){};
        return Response.ok((Object)entity).cacheControl(noCache).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="{bundleName}")
    public Response getTrustBundleByName(@PathParam(value="bundleName") String bundleName) {
        try {
            TrustBundle retBundle = this.bundleDao.getTrustBundleByName(bundleName);
            if (retBundle == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).cacheControl(noCache).build();
            }
            org.nhindirect.config.model.TrustBundle modelBundle = EntityModelConversion.toModelTrustBundle(retBundle);
            return Response.ok((Object)modelBundle).cacheControl(noCache).build();
        }
        catch (Throwable e) {
            log.error((Object)"Error looking up trust bundles", e);
            return Response.serverError().cacheControl(noCache).build();
        }
    }

    @PUT
    @Consumes(value={"application/json"})
    public Response addTrustBundle(@Context UriInfo uriInfo, org.nhindirect.config.model.TrustBundle bundle) {
        try {
            if (this.bundleDao.getTrustBundleByName(bundle.getBundleName()) != null) {
                return Response.status((Response.Status)Response.Status.CONFLICT).cacheControl(noCache).build();
            }
        }
        catch (Exception e) {
            log.error((Object)"Error looking up bundle.", (Throwable)e);
            return Response.serverError().cacheControl(noCache).build();
        }
        try {
            TrustBundle entityBundle = EntityModelConversion.toEntityTrustBundle(bundle);
            this.bundleDao.addTrustBundle(entityBundle);
            UriBuilder newLocBuilder = uriInfo.getBaseUriBuilder();
            URI newLoc = newLocBuilder.path("trustbundle/" + bundle.getBundleName()).build(new Object[0]);
            this.template.sendBody((Object)entityBundle);
            return Response.created((URI)newLoc).cacheControl(noCache).build();
        }
        catch (Exception e) {
            log.error((Object)"Error adding trust bundle.", (Throwable)e);
            return Response.serverError().cacheControl(noCache).build();
        }
    }

    @Path(value="{bundle}/refreshBundle")
    @POST
    public Response refreshTrustBundle(@PathParam(value="bundle") String bundleName) {
        try {
            TrustBundle entityBundle = this.bundleDao.getTrustBundleByName(bundleName);
            if (entityBundle == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).cacheControl(noCache).build();
            }
            this.template.sendBody((Object)entityBundle);
            return Response.noContent().cacheControl(noCache).build();
        }
        catch (Exception e) {
            log.error((Object)"Error refreshing bundle.", (Throwable)e);
            return Response.serverError().cacheControl(noCache).build();
        }
    }

    @DELETE
    @Path(value="{bundle}")
    public Response deleteBundle(@PathParam(value="bundle") String bundleName) {
        TrustBundle entityBundle;
        try {
            entityBundle = this.bundleDao.getTrustBundleByName(bundleName);
            if (entityBundle == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).cacheControl(noCache).build();
            }
        }
        catch (Exception e) {
            log.error((Object)"Error looking up bundle.", (Throwable)e);
            return Response.serverError().cacheControl(noCache).build();
        }
        try {
            this.bundleDao.deleteTrustBundles(new long[]{entityBundle.getId()});
            return Response.ok().cacheControl(noCache).build();
        }
        catch (Exception e) {
            log.error((Object)"Error deleting trust bundle.", (Throwable)e);
            return Response.serverError().cacheControl(noCache).build();
        }
    }

    @POST
    @Path(value="{bundle}/signingCert")
    @Consumes(value={"application/json"})
    public Response updateSigningCert(@PathParam(value="bundle") String bundleName, byte[] certData) {
        TrustBundle entityBundle;
        X509Certificate signingCert = null;
        if (certData.length > 0) {
            try {
                signingCert = CertUtils.toX509Certificate((byte[])certData);
            }
            catch (CertificateConversionException ex) {
                log.error((Object)("Signing certificate is not in a valid format " + bundleName), (Throwable)ex);
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).cacheControl(noCache).build();
            }
        }
        try {
            entityBundle = this.bundleDao.getTrustBundleByName(bundleName);
            if (entityBundle == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).cacheControl(noCache).build();
            }
        }
        catch (Exception e) {
            log.error((Object)"Error looking up bundle.", (Throwable)e);
            return Response.serverError().cacheControl(noCache).build();
        }
        try {
            this.bundleDao.updateTrustBundleSigningCertificate(entityBundle.getId(), signingCert);
            return Response.noContent().cacheControl(noCache).build();
        }
        catch (Exception e) {
            log.error((Object)"Error updating trust bundle signing certificate.", (Throwable)e);
            return Response.serverError().cacheControl(noCache).build();
        }
    }

    @POST
    @Path(value="{bundle}/bundleAttributes")
    @Consumes(value={"application/json"})
    public Response updateBundleAttributes(@PathParam(value="bundle") String bundleName, org.nhindirect.config.model.TrustBundle bundleData) {
        TrustBundle entityBundle;
        try {
            entityBundle = this.bundleDao.getTrustBundleByName(bundleName);
            if (entityBundle == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).cacheControl(noCache).build();
            }
        }
        catch (Exception e) {
            log.error((Object)"Error looking up bundle.", (Throwable)e);
            return Response.serverError().cacheControl(noCache).build();
        }
        String oldBundleURL = entityBundle.getBundleURL();
        X509Certificate newSigningCert = null;
        if (bundleData.getSigningCertificateData() != null) {
            try {
                newSigningCert = CertUtils.toX509Certificate((byte[])bundleData.getSigningCertificateData());
            }
            catch (CertificateConversionException ex) {
                log.error((Object)("Signing certificate is not in a valid format " + bundleName), (Throwable)ex);
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).cacheControl(noCache).build();
            }
        }
        try {
            this.bundleDao.updateTrustBundleAttributes(entityBundle.getId(), bundleData.getBundleName(), bundleData.getBundleURL(), newSigningCert, bundleData.getRefreshInterval());
            if (bundleData.getBundleURL() != null && !bundleData.getBundleURL().isEmpty() && !oldBundleURL.equals(bundleData.getBundleURL())) {
                entityBundle = this.bundleDao.getTrustBundleById(entityBundle.getId());
                this.template.sendBody((Object)entityBundle);
            }
            return Response.noContent().cacheControl(noCache).build();
        }
        catch (Exception e) {
            log.error((Object)"Error updating trust bundle attributes.", (Throwable)e);
            return Response.serverError().cacheControl(noCache).build();
        }
    }

    @POST
    @Path(value="{bundle}/{domain}")
    public Response associateTrustBundleToDomain(@PathParam(value="bundle") String bundleName, @PathParam(value="domain") String domainName, @QueryParam(value="incoming") @DefaultValue(value="true") boolean incoming, @QueryParam(value="outgoing") @DefaultValue(value="true") boolean outgoing) {
        Domain entityDomain;
        TrustBundle entityBundle;
        try {
            entityBundle = this.bundleDao.getTrustBundleByName(bundleName);
            if (entityBundle == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).cacheControl(noCache).build();
            }
        }
        catch (Exception e) {
            log.error((Object)"Error looking up bundle.", (Throwable)e);
            return Response.serverError().cacheControl(noCache).build();
        }
        try {
            entityDomain = this.domainDao.getDomainByName(domainName);
            if (entityDomain == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).cacheControl(noCache).build();
            }
        }
        catch (Exception e) {
            log.error((Object)"Error looking up domain.", (Throwable)e);
            return Response.serverError().cacheControl(noCache).build();
        }
        try {
            this.bundleDao.associateTrustBundleToDomain(entityDomain.getId().longValue(), entityBundle.getId(), incoming, outgoing);
            return Response.noContent().cacheControl(noCache).build();
        }
        catch (Exception e) {
            log.error((Object)"Error associating trust bundle to domain.", (Throwable)e);
            return Response.serverError().cacheControl(noCache).build();
        }
    }

    @DELETE
    @Path(value="{bundle}/{domain}")
    public Response disassociateTrustBundleFromDomain(@PathParam(value="bundle") String bundleName, @PathParam(value="domain") String domainName) {
        Domain entityDomain;
        TrustBundle entityBundle;
        try {
            entityBundle = this.bundleDao.getTrustBundleByName(bundleName);
            if (entityBundle == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).cacheControl(noCache).build();
            }
        }
        catch (Exception e) {
            log.error((Object)"Error looking up bundle.", (Throwable)e);
            return Response.serverError().cacheControl(noCache).build();
        }
        try {
            entityDomain = this.domainDao.getDomainByName(domainName);
            if (entityDomain == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).cacheControl(noCache).build();
            }
        }
        catch (Exception e) {
            log.error((Object)"Error looking up domain.", (Throwable)e);
            return Response.serverError().cacheControl(noCache).build();
        }
        try {
            this.bundleDao.disassociateTrustBundleFromDomain(entityDomain.getId().longValue(), entityBundle.getId());
            return Response.ok().cacheControl(noCache).build();
        }
        catch (Exception e) {
            log.error((Object)"Error disassociating trust bundle from domain.", (Throwable)e);
            return Response.serverError().cacheControl(noCache).build();
        }
    }

    @DELETE
    @Path(value="{domain}/deleteFromDomain")
    public Response disassociateTrustBundlesFromDomain(@PathParam(value="domain") String domainName) {
        Domain entityDomain;
        try {
            entityDomain = this.domainDao.getDomainByName(domainName);
            if (entityDomain == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).cacheControl(noCache).build();
            }
        }
        catch (Exception e) {
            log.error((Object)"Error looking up domain.", (Throwable)e);
            return Response.serverError().cacheControl(noCache).build();
        }
        try {
            this.bundleDao.disassociateTrustBundlesFromDomain(entityDomain.getId().longValue());
            return Response.ok().cacheControl(noCache).build();
        }
        catch (Exception e) {
            log.error((Object)"Error disassociating trust bundles from domain.", (Throwable)e);
            return Response.serverError().cacheControl(noCache).build();
        }
    }

    @DELETE
    @Path(value="{bundle}/deleteFromBundle")
    public Response disassociateTrustBundleFromDomains(@PathParam(value="bundle") String bundleName) {
        TrustBundle entityBundle;
        try {
            entityBundle = this.bundleDao.getTrustBundleByName(bundleName);
            if (entityBundle == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).cacheControl(noCache).build();
            }
        }
        catch (Exception e) {
            log.error((Object)"Error looking up bundle.", (Throwable)e);
            return Response.serverError().cacheControl(noCache).build();
        }
        try {
            this.bundleDao.disassociateTrustBundleFromDomains(entityBundle.getId());
            return Response.ok().cacheControl(noCache).build();
        }
        catch (Exception e) {
            log.error((Object)"Error disassociating trust bundle from domains.", (Throwable)e);
            return Response.serverError().cacheControl(noCache).build();
        }
    }
}

