/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.resources.util;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Locale;
import org.nhindirect.config.model.Anchor;
import org.nhindirect.config.model.BundleRefreshError;
import org.nhindirect.config.model.CertPolicy;
import org.nhindirect.config.model.CertPolicyGroup;
import org.nhindirect.config.model.CertPolicyGroupDomainReltn;
import org.nhindirect.config.model.CertPolicyGroupUse;
import org.nhindirect.config.model.Certificate;
import org.nhindirect.config.model.DNSRecord;
import org.nhindirect.config.model.Domain;
import org.nhindirect.config.model.EntityStatus;
import org.nhindirect.config.model.Setting;
import org.nhindirect.config.model.exceptions.CertificateConversionException;
import org.nhindirect.config.model.utils.CertUtils;
import org.nhindirect.config.store.Address;
import org.nhindirect.config.store.CertPolicyGroupReltn;
import org.nhindirect.config.store.CertPolicyUse;
import org.nhindirect.config.store.CertificateException;
import org.nhindirect.config.store.TrustBundle;
import org.nhindirect.config.store.TrustBundleAnchor;
import org.nhindirect.policy.PolicyLexicon;

public class EntityModelConversion {
    public static org.nhindirect.config.store.Domain toEntityDomain(Domain domain) {
        org.nhindirect.config.store.Domain retVal = new org.nhindirect.config.store.Domain();
        ArrayList<Address> addresses = new ArrayList<Address>();
        if (domain.getAddresses() != null) {
            for (org.nhindirect.config.model.Address address : domain.getAddresses()) {
                addresses.add(EntityModelConversion.toEntityAddress(address));
            }
        }
        retVal.setAddresses(addresses);
        retVal.setCreateTime(domain.getCreateTime());
        retVal.setDomainName(domain.getDomainName());
        retVal.setId(Long.valueOf(domain.getId()));
        if (domain.getPostmasterAddress() != null) {
            retVal.setPostMasterEmail(domain.getPostmasterAddress().getEmailAddress());
        }
        if (domain.getStatus() != null) {
            retVal.setStatus(org.nhindirect.config.store.EntityStatus.valueOf((String)domain.getStatus().toString()));
        }
        retVal.setUpdateTime(domain.getUpdateTime());
        return retVal;
    }

    public static Domain toModelDomain(org.nhindirect.config.store.Domain domain) {
        Domain retVal = new Domain();
        ArrayList<org.nhindirect.config.model.Address> addresses = new ArrayList<org.nhindirect.config.model.Address>();
        if (domain.getAddresses() != null) {
            for (Address address : domain.getAddresses()) {
                addresses.add(EntityModelConversion.toModelAddress(address));
            }
        }
        retVal.setAddresses(addresses);
        retVal.setCreateTime(domain.getCreateTime());
        retVal.setDomainName(domain.getDomainName());
        retVal.setId(domain.getId().longValue());
        if (domain.getPostMasterEmail() != null && !domain.getPostMasterEmail().isEmpty()) {
            System.out.println("Postmaster email address: " + domain.getPostMasterEmail());
            if (domain.getAddresses().size() > 0 && domain.getPostmasterAddressId() != null && domain.getPostmasterAddressId() > 0L) {
                for (Address address : domain.getAddresses()) {
                    if (!address.getId().equals(domain.getPostmasterAddressId())) continue;
                    retVal.setPostmasterAddress(EntityModelConversion.toModelAddress(address));
                    break;
                }
            }
        }
        if (domain.getStatus() != null) {
            retVal.setStatus(EntityStatus.valueOf((String)domain.getStatus().toString()));
        }
        retVal.setUpdateTime(domain.getUpdateTime());
        return retVal;
    }

    public static org.nhindirect.config.model.Address toModelAddress(Address address) {
        if (address == null) {
            return null;
        }
        org.nhindirect.config.model.Address retVal = new org.nhindirect.config.model.Address();
        retVal.setCreateTime(address.getCreateTime());
        retVal.setDisplayName(address.getDisplayName());
        retVal.setEmailAddress(address.getEmailAddress());
        retVal.setEndpoint(address.getEndpoint());
        retVal.setId(address.getId().longValue());
        if (address.getStatus() != null) {
            retVal.setStatus(EntityStatus.valueOf((String)address.getStatus().toString()));
        }
        retVal.setType(address.getType());
        retVal.setUpdateTime(address.getUpdateTime());
        if (address.getDomain() != null) {
            retVal.setDomainName(address.getDomain().getDomainName());
        }
        return retVal;
    }

    public static Address toEntityAddress(org.nhindirect.config.model.Address address) {
        if (address == null) {
            return null;
        }
        Address retVal = new Address();
        retVal.setCreateTime(address.getCreateTime());
        retVal.setDisplayName(address.getDisplayName());
        retVal.setEmailAddress(address.getEmailAddress());
        retVal.setEndpoint(address.getEndpoint());
        retVal.setId(Long.valueOf(address.getId()));
        if (address.getStatus() != null) {
            retVal.setStatus(org.nhindirect.config.store.EntityStatus.valueOf((String)address.getStatus().toString()));
        }
        retVal.setType(address.getType());
        retVal.setUpdateTime(address.getUpdateTime());
        return retVal;
    }

    public static Anchor toModelAnchor(org.nhindirect.config.store.Anchor anchor) {
        if (anchor == null) {
            return null;
        }
        Anchor retVal = new Anchor();
        retVal.setCertificateData(anchor.getData());
        retVal.setCertificateId(anchor.getCertificateId());
        retVal.setCreateTime(anchor.getCreateTime());
        retVal.setId(anchor.getId());
        retVal.setIncoming(anchor.isIncoming());
        retVal.setOutgoing(anchor.isOutgoing());
        retVal.setOwner(anchor.getOwner());
        retVal.setStatus(EntityStatus.valueOf((String)anchor.getStatus().toString()));
        retVal.setThumbprint(anchor.getThumbprint());
        retVal.setValidEndDate(anchor.getValidEndDate());
        retVal.setValidStartDate(anchor.getValidStartDate());
        return retVal;
    }

    public static org.nhindirect.config.store.Anchor toEntityAnchor(Anchor anchor) throws CertificateException {
        if (anchor == null) {
            return null;
        }
        org.nhindirect.config.store.Anchor retVal = new org.nhindirect.config.store.Anchor();
        retVal.setData(anchor.getCertificateData());
        retVal.setCertificateId(anchor.getCertificateId());
        retVal.setCreateTime(anchor.getCreateTime());
        retVal.setId(anchor.getId());
        retVal.setIncoming(anchor.isIncoming());
        retVal.setOutgoing(anchor.isOutgoing());
        retVal.setOwner(anchor.getOwner());
        retVal.setStatus(org.nhindirect.config.store.EntityStatus.valueOf((String)anchor.getStatus().toString()));
        retVal.setValidEndDate(anchor.getValidEndDate());
        retVal.setValidStartDate(anchor.getValidStartDate());
        return retVal;
    }

    public static Certificate toModelCertificate(org.nhindirect.config.store.Certificate cert) {
        if (cert == null) {
            return null;
        }
        Certificate retVal = new Certificate();
        retVal.setOwner(cert.getOwner());
        retVal.setCreateTime(cert.getCreateTime());
        retVal.setData(cert.getData());
        retVal.setId(cert.getId());
        retVal.setPrivateKey(cert.isPrivateKey());
        if (cert.getStatus() != null) {
            retVal.setStatus(EntityStatus.valueOf((String)cert.getStatus().toString()));
        }
        retVal.setThumbprint(cert.getThumbprint());
        retVal.setValidEndDate(cert.getValidEndDate());
        retVal.setValidStartDate(cert.getValidStartDate());
        return retVal;
    }

    public static org.nhindirect.config.store.Certificate toEntityCertificate(Certificate cert) throws CertificateException {
        if (cert == null) {
            return null;
        }
        org.nhindirect.config.store.Certificate retVal = new org.nhindirect.config.store.Certificate();
        retVal.setOwner(cert.getOwner());
        retVal.setCreateTime(cert.getCreateTime());
        retVal.setData(cert.getData());
        retVal.setId(cert.getId());
        if (cert.getStatus() != null) {
            retVal.setStatus(org.nhindirect.config.store.EntityStatus.valueOf((String)cert.getStatus().toString()));
        }
        CertUtils.CertContainer cont = CertUtils.toCertContainer((byte[])retVal.getData());
        Calendar endDate = Calendar.getInstance(Locale.getDefault());
        endDate.setTime(cont.getCert().getNotAfter());
        retVal.setValidEndDate(endDate);
        Calendar startDate = Calendar.getInstance(Locale.getDefault());
        startDate.setTime(cont.getCert().getNotBefore());
        retVal.setValidStartDate(startDate);
        return retVal;
    }

    public static DNSRecord toModelDNSRecord(org.nhindirect.config.store.DNSRecord record) {
        if (record == null) {
            return null;
        }
        DNSRecord retVal = new DNSRecord();
        retVal.setCreateTime(record.getCreateTime());
        retVal.setData(record.getData());
        retVal.setDclass(record.getDclass());
        retVal.setId(record.getId());
        retVal.setName(record.getName());
        retVal.setTtl(record.getTtl());
        retVal.setType(record.getType());
        return retVal;
    }

    public static org.nhindirect.config.store.DNSRecord toEntityDNSRecord(DNSRecord record) {
        if (record == null) {
            return null;
        }
        org.nhindirect.config.store.DNSRecord retVal = new org.nhindirect.config.store.DNSRecord();
        retVal.setCreateTime(record.getCreateTime());
        retVal.setData(record.getData());
        retVal.setDclass(record.getDclass());
        retVal.setId(record.getId());
        retVal.setName(record.getName());
        retVal.setTtl(record.getTtl());
        retVal.setType(record.getType());
        return retVal;
    }

    public static Setting toModelSetting(org.nhindirect.config.store.Setting setting) {
        if (setting == null) {
            return null;
        }
        Setting retVal = new Setting();
        retVal.setId(setting.getId());
        retVal.setName(setting.getName());
        if (setting.getStatus() != null) {
            retVal.setStatus(EntityStatus.valueOf((String)setting.getStatus().toString()));
        }
        retVal.setUpdateTime(setting.getUpdateTime());
        retVal.setCreateTime(setting.getCreateTime());
        retVal.setValue(setting.getValue());
        return retVal;
    }

    public static org.nhindirect.config.model.TrustBundle toModelTrustBundle(TrustBundle bundle) {
        if (bundle == null) {
            return null;
        }
        org.nhindirect.config.model.TrustBundle retVal = new org.nhindirect.config.model.TrustBundle();
        ArrayList<org.nhindirect.config.model.TrustBundleAnchor> trustAnchors = new ArrayList<org.nhindirect.config.model.TrustBundleAnchor>();
        if (bundle.getTrustBundleAnchors() != null) {
            for (TrustBundleAnchor anchor : bundle.getTrustBundleAnchors()) {
                org.nhindirect.config.model.TrustBundleAnchor retAnchor = new org.nhindirect.config.model.TrustBundleAnchor();
                retAnchor.setAnchorData(anchor.getData());
                retAnchor.setThumbprint(anchor.getThumbprint());
                retAnchor.setId(anchor.getId());
                retAnchor.setValidEndDate(anchor.getValidEndDate());
                retAnchor.setValidStartDate(anchor.getValidStartDate());
                trustAnchors.add(retAnchor);
            }
        }
        retVal.setBundleName(bundle.getBundleName());
        retVal.setBundleURL(bundle.getBundleURL());
        retVal.setCheckSum(bundle.getCheckSum());
        retVal.setCreateTime(bundle.getCreateTime());
        retVal.setId(bundle.getId());
        retVal.setLastRefreshAttempt(bundle.getLastRefreshAttempt());
        if (bundle.getLastRefreshError() != null) {
            retVal.setLastRefreshError(BundleRefreshError.valueOf((String)bundle.getLastRefreshError().toString()));
        }
        retVal.setLastSuccessfulRefresh(bundle.getLastSuccessfulRefresh());
        retVal.setRefreshInterval(bundle.getRefreshInterval());
        retVal.setSigningCertificateData(bundle.getSigningCertificateData());
        retVal.setTrustBundleAnchors(trustAnchors);
        return retVal;
    }

    public static TrustBundle toEntityTrustBundle(org.nhindirect.config.model.TrustBundle bundle) {
        if (bundle == null) {
            return null;
        }
        TrustBundle retVal = new TrustBundle();
        ArrayList<TrustBundleAnchor> trustAnchors = new ArrayList<TrustBundleAnchor>();
        if (bundle.getTrustBundleAnchors() != null) {
            for (org.nhindirect.config.model.TrustBundleAnchor anchor : bundle.getTrustBundleAnchors()) {
                TrustBundleAnchor retAnchor = new TrustBundleAnchor();
                try {
                    retAnchor.setData(anchor.getAnchorData());
                }
                catch (CertificateException e) {
                    throw new CertificateConversionException((Throwable)e);
                }
                retAnchor.setTrustBundle(retVal);
                trustAnchors.add(retAnchor);
            }
        }
        retVal.setBundleName(bundle.getBundleName());
        retVal.setBundleURL(bundle.getBundleURL());
        if (bundle.getCheckSum() == null) {
            retVal.setCheckSum("");
        } else {
            retVal.setCheckSum(bundle.getCheckSum());
        }
        retVal.setCreateTime(bundle.getCreateTime());
        retVal.setId(bundle.getId());
        retVal.setLastRefreshAttempt(bundle.getLastRefreshAttempt());
        if (bundle.getLastRefreshError() != null) {
            retVal.setLastRefreshError(org.nhindirect.config.store.BundleRefreshError.valueOf((String)bundle.getLastRefreshError().toString()));
        }
        retVal.setLastSuccessfulRefresh(bundle.getLastSuccessfulRefresh());
        retVal.setRefreshInterval(bundle.getRefreshInterval());
        if (bundle.getSigningCertificateData() != null) {
            try {
                retVal.setSigningCertificateData(bundle.getSigningCertificateData());
            }
            catch (CertificateException e) {
                throw new CertificateConversionException((Throwable)e);
            }
        }
        retVal.setTrustBundleAnchors(trustAnchors);
        return retVal;
    }

    public static CertPolicy toModelCertPolicy(org.nhindirect.config.store.CertPolicy policy) {
        if (policy == null) {
            return null;
        }
        CertPolicy retVal = new CertPolicy();
        retVal.setPolicyName(policy.getPolicyName());
        retVal.setCreateTime(policy.getCreateTime());
        if (policy.getLexicon() != null) {
            retVal.setLexicon(PolicyLexicon.valueOf((String)policy.getLexicon().toString()));
        }
        retVal.setPolicyData(policy.getPolicyData());
        return retVal;
    }

    public static org.nhindirect.config.store.CertPolicy toEntityCertPolicy(CertPolicy policy) {
        if (policy == null) {
            return null;
        }
        org.nhindirect.config.store.CertPolicy retVal = new org.nhindirect.config.store.CertPolicy();
        retVal.setPolicyName(policy.getPolicyName());
        retVal.setCreateTime(policy.getCreateTime());
        if (policy.getLexicon() != null) {
            retVal.setLexicon(PolicyLexicon.valueOf((String)policy.getLexicon().toString()));
        }
        retVal.setPolicyData(policy.getPolicyData());
        return retVal;
    }

    public static CertPolicyGroup toModelCertPolicyGroup(org.nhindirect.config.store.CertPolicyGroup group) {
        if (group == null) {
            return null;
        }
        CertPolicyGroup retVal = new CertPolicyGroup();
        ArrayList<CertPolicyGroupUse> uses = new ArrayList<CertPolicyGroupUse>();
        if (group.getCertPolicyGroupReltn() != null) {
            for (CertPolicyGroupReltn reltn : group.getCertPolicyGroupReltn()) {
                CertPolicyGroupUse use = new CertPolicyGroupUse();
                use.setPolicy(EntityModelConversion.toModelCertPolicy(reltn.getCertPolicy()));
                if (reltn.getPolicyUse() != null) {
                    use.setPolicyUse(org.nhindirect.config.model.CertPolicyUse.valueOf((String)reltn.getPolicyUse().toString()));
                }
                use.setIncoming(reltn.isIncoming());
                use.setOutgoing(reltn.isOutgoing());
                uses.add(use);
            }
        }
        retVal.setPolicyGroupName(group.getPolicyGroupName());
        retVal.setCreateTime(group.getCreateTime());
        retVal.setPolicies(uses);
        return retVal;
    }

    public static org.nhindirect.config.store.CertPolicyGroup toEntityCertPolicyGroup(CertPolicyGroup group) {
        if (group == null) {
            return null;
        }
        org.nhindirect.config.store.CertPolicyGroup retVal = new org.nhindirect.config.store.CertPolicyGroup();
        ArrayList<CertPolicyGroupReltn> reltns = new ArrayList<CertPolicyGroupReltn>();
        if (group.getPolicies() != null) {
            for (CertPolicyGroupUse use : group.getPolicies()) {
                CertPolicyGroupReltn reltn = new CertPolicyGroupReltn();
                reltn.setCertPolicy(EntityModelConversion.toEntityCertPolicy(use.getPolicy()));
                reltn.setCertPolicyGroup(retVal);
                reltn.setIncoming(use.isIncoming());
                reltn.setOutgoing(use.isOutgoing());
                if (use.getPolicyUse() != null) {
                    reltn.setPolicyUse(CertPolicyUse.valueOf((String)use.getPolicyUse().toString()));
                }
                reltns.add(reltn);
            }
        }
        retVal.setPolicyGroupName(group.getPolicyGroupName());
        retVal.setCreateTime(group.getCreateTime());
        retVal.setCertPolicyGroupReltn(reltns);
        return retVal;
    }

    public static CertPolicyGroupDomainReltn toModelCertPolicyGroupDomainReltn(org.nhindirect.config.store.CertPolicyGroupDomainReltn reltn) {
        if (reltn == null) {
            return null;
        }
        CertPolicyGroupDomainReltn retVal = new CertPolicyGroupDomainReltn();
        retVal.setId(reltn.getId());
        retVal.setPolicyGroup(EntityModelConversion.toModelCertPolicyGroup(reltn.getCertPolicyGroup()));
        retVal.setDomain(EntityModelConversion.toModelDomain(reltn.getDomain()));
        return retVal;
    }
}

