/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.service;

import java.util.Calendar;
import java.util.Collection;
import javax.jws.WebMethod;
import javax.jws.WebParam;
import org.nhindirect.config.service.ConfigurationServiceException;
import org.nhindirect.config.store.BundleRefreshError;
import org.nhindirect.config.store.Certificate;
import org.nhindirect.config.store.TrustBundle;
import org.nhindirect.config.store.TrustBundleDomainReltn;

public interface TrustBundleService {
    @WebMethod(operationName="getTrustBundles", action="urn:GetTrustBundles")
    public Collection<TrustBundle> getTrustBundles(@WebParam(name="fetchAnchors") boolean var1) throws ConfigurationServiceException;

    @WebMethod(operationName="getTrustBundleByName", action="urn:GetTrustBundleByName")
    public TrustBundle getTrustBundleByName(@WebParam(name="bundleName") String var1) throws ConfigurationServiceException;

    @WebMethod(operationName="getTrustBundleById", action="urn:GetTrustBundleById")
    public TrustBundle getTrustBundleById(@WebParam(name="id") long var1) throws ConfigurationServiceException;

    @WebMethod(operationName="addTrustBundle", action="urn:AddTrustBundle")
    public void addTrustBundle(@WebParam(name="bundle") TrustBundle var1) throws ConfigurationServiceException;

    @WebMethod(operationName="refreshTrustBundle", action="urn:RefreshTrustBundle")
    public void refreshTrustBundle(@WebParam(name="id") long var1) throws ConfigurationServiceException;

    @WebMethod(operationName="updateLastUpdateError", action="urn:UpdateLastUpdateError")
    public void updateLastUpdateError(@WebParam(name="trustBundleId") long var1, @WebParam(name="attemptTime") Calendar var3, @WebParam(name="error") BundleRefreshError var4) throws ConfigurationServiceException;

    @WebMethod(operationName="deleteTrustBundles", action="urn:DeleteTrustBundles")
    public void deleteTrustBundles(@WebParam(name="trustBundleIds") long[] var1) throws ConfigurationServiceException;

    @WebMethod(operationName="updateTrustBundleSigningCertificate", action="urn:UpdateTrustBundleSigningCertificate")
    public void updateTrustBundleSigningCertificate(@WebParam(name="trustBundleIds") long var1, @WebParam(name="signingCert") Certificate var3) throws ConfigurationServiceException;

    @WebMethod(operationName="updateTrustBundleAttributes", action="urn:UpdateTrustBundleAttributes")
    public void updateTrustBundleAttributes(@WebParam(name="trustBundleId") long var1, @WebParam(name="trustBundleName") String var3, @WebParam(name="trustBundleURL") String var4, @WebParam(name="signingCert") Certificate var5, @WebParam(name="trustBundleRefreshInterval") int var6) throws ConfigurationServiceException;

    @WebMethod(operationName="associateTrustBundleToDomain", action="urn:AssociateTrustBundleToDomain")
    public void associateTrustBundleToDomain(@WebParam(name="domainId") long var1, @WebParam(name="trustBundleId") long var3, @WebParam(name="incoming") boolean var5, @WebParam(name="outgoing") boolean var6) throws ConfigurationServiceException;

    @WebMethod(operationName="disassociateTrustBundleFromDomain", action="urn:DisassociateTrustBundleFromDomain")
    public void disassociateTrustBundleFromDomain(@WebParam(name="domainId") long var1, @WebParam(name="trustBundleId") long var3) throws ConfigurationServiceException;

    @WebMethod(operationName="disassociateTrustBundlesFromDomain", action="urn:DisassociateTrustBundlesFromDomain")
    public void disassociateTrustBundlesFromDomain(@WebParam(name="domainId") long var1) throws ConfigurationServiceException;

    @WebMethod(operationName="disassociateTrustBundleFromDomains", action="urn:DisassociateTrustBundleFromDomains")
    public void disassociateTrustBundleFromDomains(@WebParam(name="trustBundleId") long var1) throws ConfigurationServiceException;

    @WebMethod(operationName="getTrustBundlesByDomain", action="urn:GetTrustBundlesByDomain")
    public Collection<TrustBundleDomainReltn> getTrustBundlesByDomain(@WebParam(name="domainId") long var1, @WebParam(name="fetchAnchors") boolean var3) throws ConfigurationServiceException;
}

