/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.service.impl;

import java.util.Collection;
import javax.jws.WebService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nhindirect.config.service.CertificatePolicyService;
import org.nhindirect.config.service.ConfigurationServiceException;
import org.nhindirect.config.store.CertPolicy;
import org.nhindirect.config.store.CertPolicyGroup;
import org.nhindirect.config.store.CertPolicyGroupDomainReltn;
import org.nhindirect.config.store.CertPolicyUse;
import org.nhindirect.config.store.dao.CertPolicyDao;
import org.nhindirect.policy.PolicyLexicon;
import org.springframework.beans.factory.annotation.Autowired;

@WebService(endpointInterface="org.nhindirect.config.service.CertificatePolicyServiceImpl")
public class CertificatePolicyServiceImpl
implements CertificatePolicyService {
    private static final Log log = LogFactory.getLog(CertificatePolicyServiceImpl.class);
    private CertPolicyDao dao;

    public void init() {
        log.info((Object)"CertificatePolicyServiceImpl initialized");
    }

    @Autowired
    public void setDao(CertPolicyDao dao) {
        this.dao = dao;
    }

    public CertPolicyDao getDao() {
        return this.dao;
    }

    @Override
    public Collection<CertPolicy> getPolicies() throws ConfigurationServiceException {
        return this.dao.getPolicies();
    }

    @Override
    public CertPolicy getPolicyByName(String policyName) throws ConfigurationServiceException {
        return this.dao.getPolicyByName(policyName);
    }

    @Override
    public CertPolicy getPolicyById(long id) throws ConfigurationServiceException {
        return this.dao.getPolicyById(id);
    }

    @Override
    public void addPolicy(CertPolicy policy) throws ConfigurationServiceException {
        this.dao.addPolicy(policy);
    }

    @Override
    public void deletePolicies(long[] policyIds) throws ConfigurationServiceException {
        this.dao.deletePolicies(policyIds);
    }

    @Override
    public void updatePolicyAttributes(long id, String policyName, PolicyLexicon lexicon, byte[] policyData) throws ConfigurationServiceException {
        this.dao.updatePolicyAttributes(id, policyName, lexicon, policyData);
    }

    @Override
    public Collection<CertPolicyGroup> getPolicyGroups() throws ConfigurationServiceException {
        return this.dao.getPolicyGroups();
    }

    @Override
    public CertPolicyGroup getPolicyGroupByName(String policyGroupName) throws ConfigurationServiceException {
        return this.dao.getPolicyGroupByName(policyGroupName);
    }

    @Override
    public CertPolicyGroup getPolicyGroupById(long id) throws ConfigurationServiceException {
        return this.dao.getPolicyGroupById(id);
    }

    @Override
    public void addPolicyGroup(CertPolicyGroup group) throws ConfigurationServiceException {
        this.dao.addPolicyGroup(group);
    }

    @Override
    public void deletePolicyGroups(long[] groupIds) throws ConfigurationServiceException {
        this.dao.deletePolicyGroups(groupIds);
    }

    @Override
    public void updateGroupAttributes(long id, String groupName) throws ConfigurationServiceException {
        this.dao.updateGroupAttributes(id, groupName);
    }

    @Override
    public void addPolicyUseToGroup(long groupId, long policyId, CertPolicyUse policyUse, boolean incoming, boolean outgoing) throws ConfigurationServiceException {
        this.dao.addPolicyUseToGroup(groupId, policyId, policyUse, incoming, outgoing);
    }

    @Override
    public void removePolicyUseFromGroup(long policyGroupReltnId) throws ConfigurationServiceException {
        this.dao.removePolicyUseFromGroup(policyGroupReltnId);
    }

    @Override
    public void associatePolicyGroupToDomain(long domainId, long policyGroupId) throws ConfigurationServiceException {
        this.dao.associatePolicyGroupToDomain(domainId, policyGroupId);
    }

    @Override
    public void disassociatePolicyGroupFromDomain(long domainId, long policyGroupId) throws ConfigurationServiceException {
        this.dao.disassociatePolicyGroupFromDomain(domainId, policyGroupId);
    }

    @Override
    public void disassociatePolicyGroupsFromDomain(long domainId) throws ConfigurationServiceException {
        this.dao.disassociatePolicyGroupsFromDomain(domainId);
    }

    @Override
    public void disassociatePolicyGroupFromDomains(long policyGroupId) throws ConfigurationServiceException {
        this.dao.disassociatePolicyGroupFromDomains(policyGroupId);
    }

    @Override
    public Collection<CertPolicyGroupDomainReltn> getPolicyGroupDomainReltns() throws ConfigurationServiceException {
        return this.dao.getPolicyGroupDomainReltns();
    }

    @Override
    public Collection<CertPolicyGroupDomainReltn> getPolicyGroupsByDomain(long domainId) throws ConfigurationServiceException {
        return this.dao.getPolicyGroupsByDomain(domainId);
    }
}

