/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.service.impl;

import java.util.Calendar;
import java.util.Collection;
import javax.jws.WebService;
import javax.xml.ws.FaultAction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nhindirect.config.service.AddressService;
import org.nhindirect.config.service.AnchorService;
import org.nhindirect.config.service.CertificatePolicyService;
import org.nhindirect.config.service.CertificateService;
import org.nhindirect.config.service.ConfigurationFault;
import org.nhindirect.config.service.ConfigurationService;
import org.nhindirect.config.service.ConfigurationServiceException;
import org.nhindirect.config.service.DNSService;
import org.nhindirect.config.service.DomainService;
import org.nhindirect.config.service.SettingService;
import org.nhindirect.config.service.TrustBundleService;
import org.nhindirect.config.service.impl.CertificateGetOptions;
import org.nhindirect.config.store.Address;
import org.nhindirect.config.store.Anchor;
import org.nhindirect.config.store.BundleRefreshError;
import org.nhindirect.config.store.CertPolicy;
import org.nhindirect.config.store.CertPolicyGroup;
import org.nhindirect.config.store.CertPolicyGroupDomainReltn;
import org.nhindirect.config.store.CertPolicyUse;
import org.nhindirect.config.store.Certificate;
import org.nhindirect.config.store.DNSRecord;
import org.nhindirect.config.store.Domain;
import org.nhindirect.config.store.EntityStatus;
import org.nhindirect.config.store.Setting;
import org.nhindirect.config.store.TrustBundle;
import org.nhindirect.config.store.TrustBundleDomainReltn;
import org.nhindirect.policy.PolicyLexicon;
import org.springframework.beans.factory.annotation.Autowired;

@WebService(endpointInterface="org.nhindirect.config.service.ConfigurationService")
public class ConfigurationServiceImpl
implements ConfigurationService {
    private static Log log = LogFactory.getLog(ConfigurationServiceImpl.class);
    private DomainService domainSvc;
    private AddressService addressSvc;
    private CertificateService certSvc;
    private AnchorService anchorSvc;
    private SettingService settingSvc;
    private DNSService dnsSvc;
    private TrustBundleService trustBundleSvc;
    private CertificatePolicyService certPolicySvc;

    public void init() {
        log.info((Object)"ConfigurationService initialized");
    }

    @Override
    @FaultAction(className=ConfigurationFault.class)
    public void addAddress(Collection<Address> address) throws ConfigurationServiceException {
        this.addressSvc.addAddress(address);
    }

    @Override
    @FaultAction(className=ConfigurationFault.class)
    public void updateAddress(Address address) throws ConfigurationServiceException {
        this.addressSvc.updateAddress(address);
    }

    @Override
    @FaultAction(className=ConfigurationFault.class)
    public int getAddressCount() throws ConfigurationServiceException {
        return this.addressSvc.getAddressCount();
    }

    @Override
    @FaultAction(className=ConfigurationFault.class)
    public Collection<Address> getAddress(Collection<String> addressNames, EntityStatus status) throws ConfigurationServiceException {
        return this.addressSvc.getAddress(addressNames, status);
    }

    @Override
    @FaultAction(className=ConfigurationFault.class)
    public void removeAddress(String addressName) throws ConfigurationServiceException {
        this.addressSvc.removeAddress(addressName);
    }

    @Override
    @FaultAction(className=ConfigurationFault.class)
    public Collection<Address> listAddresss(String lastAddressName, int maxResults) throws ConfigurationServiceException {
        return this.addressSvc.listAddresss(lastAddressName, maxResults);
    }

    @Override
    @FaultAction(className=ConfigurationFault.class)
    public void addDomain(Domain domain) throws ConfigurationServiceException {
        this.domainSvc.addDomain(domain);
    }

    @Override
    @FaultAction(className=ConfigurationFault.class)
    public void updateDomain(Domain domain) throws ConfigurationServiceException {
        this.domainSvc.updateDomain(domain);
    }

    @Override
    @FaultAction(className=ConfigurationFault.class)
    public int getDomainCount() throws ConfigurationServiceException {
        int i;
        block2: {
            i = 0;
            try {
                i = this.domainSvc.getDomainCount();
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) break block2;
                log.error((Object)("Errors in getDomainCount " + e.getMessage()), (Throwable)e);
            }
        }
        return i;
    }

    @Override
    @FaultAction(className=ConfigurationFault.class)
    public Collection<Domain> getDomains(Collection<String> domainNames, EntityStatus status) throws ConfigurationServiceException {
        return this.domainSvc.getDomains(domainNames, status);
    }

    @Override
    @Deprecated
    @FaultAction(className=ConfigurationFault.class)
    public void removeDomain(String domainName) throws ConfigurationServiceException {
        this.domainSvc.removeDomain(domainName);
    }

    @Override
    @FaultAction(className=ConfigurationFault.class)
    public void removeDomainById(Long domainId) throws ConfigurationServiceException {
        this.domainSvc.removeDomainById(domainId);
    }

    @Override
    @FaultAction(className=ConfigurationFault.class)
    public Collection<Domain> listDomains(String lastDomainName, int maxResults) throws ConfigurationServiceException {
        Collection<Domain> domains;
        block2: {
            domains = null;
            try {
                domains = this.domainSvc.listDomains(lastDomainName, maxResults);
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) break block2;
                log.error((Object)("Errors in listDomains " + e.getMessage()), (Throwable)e);
            }
        }
        return domains;
    }

    @Override
    @FaultAction(className=ConfigurationFault.class)
    public Collection<Domain> searchDomain(String domain, EntityStatus status) {
        return this.domainSvc.searchDomain(domain, status);
    }

    @Override
    @FaultAction(className=ConfigurationFault.class)
    public Domain getDomain(Long id) {
        return this.domainSvc.getDomain(id);
    }

    @Override
    @FaultAction(className=ConfigurationFault.class)
    public void addCertificates(Collection<Certificate> certs) throws ConfigurationServiceException {
        this.certSvc.addCertificates(certs);
    }

    @Override
    @FaultAction(className=ConfigurationFault.class)
    public void setCertificateStatus(Collection<Long> certificateIds, EntityStatus status) throws ConfigurationServiceException {
        this.certSvc.setCertificateStatus(certificateIds, status);
    }

    @Override
    @FaultAction(className=ConfigurationFault.class)
    public void setCertificateStatusForOwner(String owner, EntityStatus status) throws ConfigurationServiceException {
        this.certSvc.setCertificateStatusForOwner(owner, status);
    }

    @Override
    @FaultAction(className=ConfigurationFault.class)
    public void removeCertificates(Collection<Long> certificateIds) throws ConfigurationServiceException {
        this.certSvc.removeCertificates(certificateIds);
    }

    @Override
    @FaultAction(className=ConfigurationFault.class)
    public void removeCertificatesForOwner(String owner) throws ConfigurationServiceException {
        this.certSvc.removeCertificatesForOwner(owner);
    }

    @Override
    @FaultAction(className=ConfigurationFault.class)
    public boolean contains(Certificate cert) {
        return this.certSvc.contains(cert);
    }

    @Override
    @FaultAction(className=ConfigurationFault.class)
    public void addAnchors(Collection<Anchor> anchors) throws ConfigurationServiceException {
        this.anchorSvc.addAnchors(anchors);
    }

    @Override
    @FaultAction(className=ConfigurationFault.class)
    public void setAnchorStatusForOwner(String owner, EntityStatus status) throws ConfigurationServiceException {
        this.anchorSvc.setAnchorStatusForOwner(owner, status);
    }

    @Override
    @FaultAction(className=ConfigurationFault.class)
    public void removeAnchors(Collection<Long> anchorIds) throws ConfigurationServiceException {
        this.anchorSvc.removeAnchors(anchorIds);
    }

    @Override
    @FaultAction(className=ConfigurationFault.class)
    public void removeAnchorsForOwner(String owner) throws ConfigurationServiceException {
        this.anchorSvc.removeAnchorsForOwner(owner);
    }

    public DomainService getDomainSvc() {
        return this.domainSvc;
    }

    @Autowired
    public void setDomainSvc(DomainService domainSvc) {
        this.domainSvc = domainSvc;
    }

    public AddressService getAddressSvc() {
        return this.addressSvc;
    }

    @Autowired
    public void setAddressSvc(AddressService addressSvc) {
        this.addressSvc = addressSvc;
    }

    public CertificateService getCertSvc() {
        return this.certSvc;
    }

    @Autowired
    public void setCertSvc(CertificateService certSvc) {
        this.certSvc = certSvc;
    }

    public SettingService getSettingSvc() {
        return this.settingSvc;
    }

    @Autowired
    public void setSettingSvc(SettingService settingSvc) {
        this.settingSvc = settingSvc;
    }

    public AnchorService getAnchorSvc() {
        return this.anchorSvc;
    }

    @Autowired
    public void setAnchorSvc(AnchorService anchorSvc) {
        this.anchorSvc = anchorSvc;
    }

    public DNSService getDNSSvc() {
        return this.dnsSvc;
    }

    @Autowired
    public void setDNSSvc(DNSService dnsSvc) {
        this.dnsSvc = dnsSvc;
    }

    public TrustBundleService getTrustBundleSvc() {
        return this.trustBundleSvc;
    }

    @Autowired
    public void setTrustBundleSvc(TrustBundleService trustBundleSvc) {
        this.trustBundleSvc = trustBundleSvc;
    }

    public CertificatePolicyService getCertificatePolicySvc() {
        return this.certPolicySvc;
    }

    @Autowired
    public void setCertificatePolicySvc(CertificatePolicyService certPolicySvc) {
        this.certPolicySvc = certPolicySvc;
    }

    @Override
    @FaultAction(className=ConfigurationFault.class)
    public Certificate getCertificate(String owner, String thumbprint, CertificateGetOptions options) throws ConfigurationServiceException {
        return this.certSvc.getCertificate(owner, thumbprint, options);
    }

    @Override
    @FaultAction(className=ConfigurationFault.class)
    public Collection<Certificate> getCertificates(Collection<Long> certIds, CertificateGetOptions options) throws ConfigurationServiceException {
        return this.certSvc.getCertificates(certIds, options);
    }

    @Override
    @FaultAction(className=ConfigurationFault.class)
    public Collection<Certificate> getCertificatesForOwner(String owner, CertificateGetOptions options) throws ConfigurationServiceException {
        try {
            return this.certSvc.getCertificatesForOwner(owner, options);
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.error((Object)("Errors in getDomainCount " + e.getMessage()), (Throwable)e);
            }
            return null;
        }
    }

    @Override
    @FaultAction(className=ConfigurationFault.class)
    public Collection<Certificate> listCertificates(long lastCertificateId, int maxResults, CertificateGetOptions options) throws ConfigurationServiceException {
        return this.certSvc.listCertificates(lastCertificateId, maxResults, options);
    }

    @Override
    @FaultAction(className=ConfigurationFault.class)
    public Anchor getAnchor(String owner, String thumbprint, CertificateGetOptions options) throws ConfigurationServiceException {
        return this.anchorSvc.getAnchor(owner, thumbprint, options);
    }

    @Override
    @FaultAction(className=ConfigurationFault.class)
    public Collection<Anchor> getAnchors(Collection<Long> anchorIds, CertificateGetOptions options) throws ConfigurationServiceException {
        return this.anchorSvc.getAnchors(anchorIds, options);
    }

    @Override
    @FaultAction(className=ConfigurationFault.class)
    public Collection<Anchor> getAnchorsForOwner(String owner, CertificateGetOptions options) throws ConfigurationServiceException {
        Collection<Anchor> anchors;
        block2: {
            anchors = null;
            try {
                anchors = this.anchorSvc.getAnchorsForOwner(owner, options);
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) break block2;
                log.error((Object)("Errors in getAnchorsForOwner " + e.getMessage()), (Throwable)e);
            }
        }
        return anchors;
    }

    @Override
    @FaultAction(className=ConfigurationFault.class)
    public Collection<Anchor> getIncomingAnchors(String owner, CertificateGetOptions options) throws ConfigurationServiceException {
        return this.anchorSvc.getIncomingAnchors(owner, options);
    }

    @Override
    @FaultAction(className=ConfigurationFault.class)
    public Collection<Anchor> getOutgoingAnchors(String owner, CertificateGetOptions options) throws ConfigurationServiceException {
        return this.anchorSvc.getOutgoingAnchors(owner, options);
    }

    @Override
    @FaultAction(className=ConfigurationFault.class)
    public Collection<Anchor> listAnchors(Long lastAnchorID, int maxResults, CertificateGetOptions options) throws ConfigurationServiceException {
        return this.anchorSvc.listAnchors(lastAnchorID, maxResults, options);
    }

    @Override
    @FaultAction(className=ConfigurationFault.class)
    public void addSetting(String name, String value) throws ConfigurationServiceException {
        this.settingSvc.addSetting(name, value);
    }

    @Override
    @FaultAction(className=ConfigurationFault.class)
    public Collection<Setting> getAllSettings() throws ConfigurationServiceException {
        return this.settingSvc.getAllSettings();
    }

    @Override
    @FaultAction(className=ConfigurationFault.class)
    public Setting getSettingByName(String name) throws ConfigurationServiceException {
        Setting settings;
        block2: {
            settings = null;
            try {
                settings = this.settingSvc.getSettingByName(name);
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) break block2;
                log.error((Object)("Errors in getSettingByName " + e.getMessage()), (Throwable)e);
            }
        }
        return settings;
    }

    @Override
    @FaultAction(className=ConfigurationFault.class)
    public Collection<Setting> getSettingsByNames(Collection<String> names) throws ConfigurationServiceException {
        return this.settingSvc.getSettingsByNames(names);
    }

    @Override
    @FaultAction(className=ConfigurationFault.class)
    public void updateSetting(String name, String value) throws ConfigurationServiceException {
        this.settingSvc.updateSetting(name, value);
    }

    @Override
    @FaultAction(className=ConfigurationFault.class)
    public void deleteSetting(Collection<String> names) throws ConfigurationServiceException {
        this.settingSvc.deleteSetting(names);
    }

    @Override
    @FaultAction(className=ConfigurationFault.class)
    public void addDNS(Collection<DNSRecord> records) throws ConfigurationServiceException {
        this.dnsSvc.addDNS(records);
    }

    @Override
    @FaultAction(className=ConfigurationFault.class)
    public Collection<DNSRecord> getDNSByName(String name) throws ConfigurationServiceException {
        return this.dnsSvc.getDNSByName(name);
    }

    @Override
    @FaultAction(className=ConfigurationFault.class)
    public Collection<DNSRecord> getDNSByNameAndType(String name, int type) throws ConfigurationServiceException {
        return this.dnsSvc.getDNSByNameAndType(name, type);
    }

    @Override
    @FaultAction(className=ConfigurationFault.class)
    public DNSRecord getDNSByRecordId(long recordId) throws ConfigurationServiceException {
        return this.dnsSvc.getDNSByRecordId(recordId);
    }

    @Override
    @FaultAction(className=ConfigurationFault.class)
    public Collection<DNSRecord> getDNSByRecordIds(long[] recordIds) throws ConfigurationServiceException {
        return this.dnsSvc.getDNSByRecordIds(recordIds);
    }

    @Override
    @FaultAction(className=ConfigurationFault.class)
    public Collection<DNSRecord> getDNSByType(int type) throws ConfigurationServiceException {
        return this.dnsSvc.getDNSByType(type);
    }

    @Override
    @FaultAction(className=ConfigurationFault.class)
    public int getDNSCount() throws ConfigurationServiceException {
        return this.dnsSvc.getDNSCount();
    }

    @Override
    @FaultAction(className=ConfigurationFault.class)
    public void removeDNS(Collection<DNSRecord> records) throws ConfigurationServiceException {
        this.dnsSvc.removeDNS(records);
    }

    @Override
    public void removeDNSByRecordId(long recordId) throws ConfigurationServiceException {
        this.dnsSvc.removeDNSByRecordId(recordId);
    }

    @Override
    @FaultAction(className=ConfigurationFault.class)
    public void removeDNSByRecordIds(long[] recordIds) throws ConfigurationServiceException {
        this.dnsSvc.removeDNSByRecordIds(recordIds);
    }

    @Override
    @FaultAction(className=ConfigurationFault.class)
    public void updateDNS(long recordId, DNSRecord record) throws ConfigurationServiceException {
        this.dnsSvc.updateDNS(recordId, record);
    }

    @Override
    @FaultAction(className=ConfigurationFault.class)
    public Collection<TrustBundle> getTrustBundles(boolean fetchAnchors) throws ConfigurationServiceException {
        Collection<TrustBundle> bundles;
        block2: {
            bundles = null;
            try {
                bundles = this.trustBundleSvc.getTrustBundles(fetchAnchors);
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) break block2;
                log.error((Object)("Errors in getTrustBundles " + e.getMessage()), (Throwable)e);
            }
        }
        return bundles;
    }

    @Override
    @FaultAction(className=ConfigurationFault.class)
    public TrustBundle getTrustBundleByName(String bundleName) throws ConfigurationServiceException {
        return this.trustBundleSvc.getTrustBundleByName(bundleName);
    }

    @Override
    @FaultAction(className=ConfigurationFault.class)
    public TrustBundle getTrustBundleById(long id) throws ConfigurationServiceException {
        return this.trustBundleSvc.getTrustBundleById(id);
    }

    @Override
    @FaultAction(className=ConfigurationFault.class)
    public void addTrustBundle(TrustBundle bundle) throws ConfigurationServiceException {
        this.trustBundleSvc.addTrustBundle(bundle);
    }

    @Override
    @FaultAction(className=ConfigurationFault.class)
    public void refreshTrustBundle(long id) throws ConfigurationServiceException {
        this.trustBundleSvc.refreshTrustBundle(id);
    }

    @Override
    @FaultAction(className=ConfigurationFault.class)
    public void updateLastUpdateError(long trustBundleId, Calendar attemptTime, BundleRefreshError error) throws ConfigurationServiceException {
        this.trustBundleSvc.updateLastUpdateError(trustBundleId, attemptTime, error);
    }

    @Override
    @FaultAction(className=ConfigurationFault.class)
    public void deleteTrustBundles(long[] trustBundleIds) throws ConfigurationServiceException {
        this.trustBundleSvc.deleteTrustBundles(trustBundleIds);
    }

    @Override
    @FaultAction(className=ConfigurationFault.class)
    public void updateTrustBundleSigningCertificate(long trustBundleId, Certificate signingCert) throws ConfigurationServiceException {
        this.trustBundleSvc.updateTrustBundleSigningCertificate(trustBundleId, signingCert);
    }

    @Override
    @FaultAction(className=ConfigurationFault.class)
    public void updateTrustBundleAttributes(long trustBundleId, String bundleName, String bundleUrl, Certificate signingCert, int refreshInterval) throws ConfigurationServiceException {
        this.trustBundleSvc.updateTrustBundleAttributes(trustBundleId, bundleName, bundleUrl, signingCert, refreshInterval);
    }

    @Override
    @FaultAction(className=ConfigurationFault.class)
    public void associateTrustBundleToDomain(long domainId, long trustBundleId, boolean incoming, boolean outgoing) throws ConfigurationServiceException {
        this.trustBundleSvc.associateTrustBundleToDomain(domainId, trustBundleId, incoming, outgoing);
    }

    @Override
    @FaultAction(className=ConfigurationFault.class)
    public void disassociateTrustBundleFromDomain(long domainId, long trustBundleId) throws ConfigurationServiceException {
        this.trustBundleSvc.disassociateTrustBundleFromDomain(domainId, trustBundleId);
    }

    @Override
    @FaultAction(className=ConfigurationFault.class)
    public void disassociateTrustBundlesFromDomain(long domainId) throws ConfigurationServiceException {
        this.trustBundleSvc.disassociateTrustBundlesFromDomain(domainId);
    }

    @Override
    @FaultAction(className=ConfigurationFault.class)
    public void disassociateTrustBundleFromDomains(long trustBundleId) throws ConfigurationServiceException {
        this.trustBundleSvc.disassociateTrustBundleFromDomains(trustBundleId);
    }

    @Override
    @FaultAction(className=ConfigurationFault.class)
    public Collection<TrustBundleDomainReltn> getTrustBundlesByDomain(long domainId, boolean fetchAnchors) throws ConfigurationServiceException {
        Collection<TrustBundleDomainReltn> bundles;
        block2: {
            bundles = null;
            try {
                bundles = this.trustBundleSvc.getTrustBundlesByDomain(domainId, fetchAnchors);
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) break block2;
                log.error((Object)("Errors in getTrustBundles " + e.getMessage()), (Throwable)e);
            }
        }
        return bundles;
    }

    @Override
    @FaultAction(className=ConfigurationFault.class)
    public Collection<CertPolicy> getPolicies() throws ConfigurationServiceException {
        return this.certPolicySvc.getPolicies();
    }

    @Override
    @FaultAction(className=ConfigurationFault.class)
    public CertPolicy getPolicyByName(String policyName) throws ConfigurationServiceException {
        return this.certPolicySvc.getPolicyByName(policyName);
    }

    @Override
    @FaultAction(className=ConfigurationFault.class)
    public CertPolicy getPolicyById(long id) throws ConfigurationServiceException {
        return this.certPolicySvc.getPolicyById(id);
    }

    @Override
    @FaultAction(className=ConfigurationFault.class)
    public void addPolicy(CertPolicy policy) throws ConfigurationServiceException {
        this.certPolicySvc.addPolicy(policy);
    }

    @Override
    @FaultAction(className=ConfigurationFault.class)
    public void deletePolicies(long[] policyIds) throws ConfigurationServiceException {
        this.certPolicySvc.deletePolicies(policyIds);
    }

    @Override
    @FaultAction(className=ConfigurationFault.class)
    public void updatePolicyAttributes(long id, String policyName, PolicyLexicon lexicon, byte[] policyData) throws ConfigurationServiceException {
        this.certPolicySvc.updatePolicyAttributes(id, policyName, lexicon, policyData);
    }

    @Override
    @FaultAction(className=ConfigurationFault.class)
    public Collection<CertPolicyGroup> getPolicyGroups() throws ConfigurationServiceException {
        return this.certPolicySvc.getPolicyGroups();
    }

    @Override
    @FaultAction(className=ConfigurationFault.class)
    public CertPolicyGroup getPolicyGroupByName(String policyGroupName) throws ConfigurationServiceException {
        return this.certPolicySvc.getPolicyGroupByName(policyGroupName);
    }

    @Override
    @FaultAction(className=ConfigurationFault.class)
    public CertPolicyGroup getPolicyGroupById(long id) throws ConfigurationServiceException {
        return this.certPolicySvc.getPolicyGroupById(id);
    }

    @Override
    @FaultAction(className=ConfigurationFault.class)
    public void addPolicyGroup(CertPolicyGroup group) throws ConfigurationServiceException {
        this.certPolicySvc.addPolicyGroup(group);
    }

    @Override
    @FaultAction(className=ConfigurationFault.class)
    public void deletePolicyGroups(long[] groupIds) throws ConfigurationServiceException {
        this.certPolicySvc.deletePolicyGroups(groupIds);
    }

    @Override
    @FaultAction(className=ConfigurationFault.class)
    public void updateGroupAttributes(long id, String groupName) throws ConfigurationServiceException {
        this.certPolicySvc.updateGroupAttributes(id, groupName);
    }

    @Override
    @FaultAction(className=ConfigurationFault.class)
    public void addPolicyUseToGroup(long groupId, long policyId, CertPolicyUse policyUse, boolean incoming, boolean outgoing) throws ConfigurationServiceException {
        this.certPolicySvc.addPolicyUseToGroup(groupId, policyId, policyUse, incoming, outgoing);
    }

    @Override
    @FaultAction(className=ConfigurationFault.class)
    public void removePolicyUseFromGroup(long policyGroupReltnId) throws ConfigurationServiceException {
        this.certPolicySvc.removePolicyUseFromGroup(policyGroupReltnId);
    }

    @Override
    @FaultAction(className=ConfigurationFault.class)
    public void associatePolicyGroupToDomain(long domainId, long policyGroupId) throws ConfigurationServiceException {
        this.certPolicySvc.associatePolicyGroupToDomain(domainId, policyGroupId);
    }

    @Override
    @FaultAction(className=ConfigurationFault.class)
    public void disassociatePolicyGroupFromDomain(long domainId, long policyGroupId) throws ConfigurationServiceException {
        this.certPolicySvc.disassociatePolicyGroupFromDomain(domainId, policyGroupId);
    }

    @Override
    @FaultAction(className=ConfigurationFault.class)
    public void disassociatePolicyGroupsFromDomain(long domainId) throws ConfigurationServiceException {
        this.certPolicySvc.disassociatePolicyGroupsFromDomain(domainId);
    }

    @Override
    @FaultAction(className=ConfigurationFault.class)
    public void disassociatePolicyGroupFromDomains(long policyGroupId) throws ConfigurationServiceException {
        this.certPolicySvc.disassociatePolicyGroupFromDomains(policyGroupId);
    }

    @Override
    @FaultAction(className=ConfigurationFault.class)
    public Collection<CertPolicyGroupDomainReltn> getPolicyGroupDomainReltns() throws ConfigurationServiceException {
        Collection<CertPolicyGroupDomainReltn> domains;
        block2: {
            domains = null;
            try {
                domains = this.certPolicySvc.getPolicyGroupDomainReltns();
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) break block2;
                log.error((Object)("Errors in getPolicyGroupDomainReltns " + e.getMessage()), (Throwable)e);
            }
        }
        return domains;
    }

    @Override
    @FaultAction(className=ConfigurationFault.class)
    public Collection<CertPolicyGroupDomainReltn> getPolicyGroupsByDomain(long domainId) throws ConfigurationServiceException {
        return this.certPolicySvc.getPolicyGroupsByDomain(domainId);
    }
}

