/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.resources;

import com.google.inject.Singleton;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nhindirect.config.resources.ProtectedResource;
import org.nhindirect.config.resources.util.EntityModelConversion;
import org.nhindirect.config.store.Address;
import org.nhindirect.config.store.Domain;
import org.nhindirect.config.store.dao.AddressDao;
import org.nhindirect.config.store.dao.DomainDao;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Path(value="address/")
@Singleton
public class AddressResource
extends ProtectedResource {
    private static final Log log = LogFactory.getLog(AddressResource.class);
    protected AddressDao dao;
    protected DomainDao domainDao;

    @Autowired
    public void setAddressDao(AddressDao dao) {
        this.dao = dao;
    }

    @Autowired
    public void setDomainDao(DomainDao domainDao) {
        this.domainDao = domainDao;
    }

    @Path(value="{address}")
    @Produces(value={"application/json"})
    @GET
    public Response getAddress(@PathParam(value="address") String address) {
        try {
            Address retAddress = this.dao.get(address);
            if (retAddress == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).cacheControl(noCache).build();
            }
            return Response.ok((Object)EntityModelConversion.toModelAddress(retAddress)).cacheControl(noCache).build();
        }
        catch (Exception e) {
            log.error((Object)"Error looking up address.", (Throwable)e);
            return Response.serverError().cacheControl(noCache).build();
        }
    }

    @Path(value="domain/{domain}")
    @Produces(value={"application/json"})
    @GET
    public Response getAddressesByDomain(@PathParam(value="domain") String domainName) {
        Domain domain = null;
        try {
            domain = this.domainDao.getDomainByName(domainName);
            if (domain == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).cacheControl(noCache).build();
            }
        }
        catch (Exception e) {
            log.error((Object)"Error looking up existing domain.", (Throwable)e);
            return Response.serverError().cacheControl(noCache).build();
        }
        try {
            List addresses = this.dao.getByDomain(domain, null);
            if (addresses == null || addresses.isEmpty()) {
                return Response.status((Response.Status)Response.Status.NO_CONTENT).cacheControl(noCache).build();
            }
            ArrayList<org.nhindirect.config.model.Address> retAddresses = new ArrayList<org.nhindirect.config.model.Address>();
            for (Address address : addresses) {
                retAddresses.add(EntityModelConversion.toModelAddress(address));
            }
            GenericEntity<Collection<org.nhindirect.config.model.Address>> entity = new GenericEntity<Collection<org.nhindirect.config.model.Address>>(retAddresses){};
            return Response.ok((Object)entity).cacheControl(noCache).build();
        }
        catch (Exception e) {
            log.error((Object)"Error looking up addresses.", (Throwable)e);
            return Response.serverError().cacheControl(noCache).build();
        }
    }

    @PUT
    @Consumes(value={"application/json"})
    public Response addAddress(@Context UriInfo uriInfo, org.nhindirect.config.model.Address address) {
        Domain domain;
        if (address.getDomainName() == null || address.getDomainName().isEmpty()) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).cacheControl(noCache).build();
        }
        try {
            domain = this.domainDao.getDomainByName(address.getDomainName());
            if (domain == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).cacheControl(noCache).build();
            }
        }
        catch (Exception e) {
            log.error((Object)"Error looking up existing domain.", (Throwable)e);
            return Response.serverError().cacheControl(noCache).build();
        }
        try {
            if (this.dao.get(address.getEmailAddress()) != null) {
                return Response.status((Response.Status)Response.Status.CONFLICT).cacheControl(noCache).build();
            }
        }
        catch (Exception e) {
            log.error((Object)"Error looking up existing address.", (Throwable)e);
            return Response.serverError().cacheControl(noCache).build();
        }
        Address toAdd = EntityModelConversion.toEntityAddress(address);
        toAdd.setDomain(domain);
        try {
            this.dao.add(toAdd);
            UriBuilder newLocBuilder = uriInfo.getBaseUriBuilder();
            URI newLoc = newLocBuilder.path("address/" + address.getEmailAddress()).build(new Object[0]);
            return Response.created((URI)newLoc).cacheControl(noCache).build();
        }
        catch (Exception e) {
            log.error((Object)"Error adding address.", (Throwable)e);
            return Response.serverError().cacheControl(noCache).build();
        }
    }

    @POST
    @Consumes(value={"application/json"})
    public Response updateAddress(org.nhindirect.config.model.Address address) {
        Domain domain;
        if (address.getDomainName() == null || address.getDomainName().isEmpty()) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).cacheControl(noCache).build();
        }
        try {
            domain = this.domainDao.getDomainByName(address.getDomainName());
            if (domain == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).cacheControl(noCache).build();
            }
        }
        catch (Exception e) {
            log.error((Object)"Error looking up existing domain.", (Throwable)e);
            return Response.serverError().cacheControl(noCache).build();
        }
        Address existingAdd = null;
        try {
            existingAdd = this.dao.get(address.getEmailAddress());
            if (existingAdd == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).cacheControl(noCache).build();
            }
        }
        catch (Exception e) {
            log.error((Object)"Error looking up existing address.", (Throwable)e);
            return Response.serverError().cacheControl(noCache).build();
        }
        Address toAdd = EntityModelConversion.toEntityAddress(address);
        toAdd.setId(existingAdd.getId());
        toAdd.setDomain(domain);
        try {
            this.dao.update(toAdd);
            return Response.noContent().cacheControl(noCache).build();
        }
        catch (Exception e) {
            log.error((Object)"Error updating address.", (Throwable)e);
            return Response.serverError().cacheControl(noCache).build();
        }
    }

    @DELETE
    @Path(value="{address}")
    public Response removedAddress(@PathParam(value="address") String address) {
        try {
            if (this.dao.get(address) == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).cacheControl(noCache).build();
            }
        }
        catch (Exception e) {
            log.error((Object)"Error looking up existing address.", (Throwable)e);
            return Response.serverError().cacheControl(noCache).build();
        }
        try {
            this.dao.delete(address);
            return Response.ok().cacheControl(noCache).build();
        }
        catch (Exception e) {
            log.error((Object)"Error deleting address.", (Throwable)e);
            return Response.serverError().cacheControl(noCache).build();
        }
    }
}

