/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.resources;

import com.google.inject.Singleton;
import java.net.URI;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nhindirect.config.model.Anchor;
import org.nhindirect.config.resources.ProtectedResource;
import org.nhindirect.config.resources.util.EntityModelConversion;
import org.nhindirect.config.store.Thumbprint;
import org.nhindirect.config.store.dao.AnchorDao;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Path(value="anchor/")
@Singleton
public class AnchorResource
extends ProtectedResource {
    private static final Log log = LogFactory.getLog(AnchorResource.class);
    protected AnchorDao anchorDao;

    @Autowired
    public void setAnchorDao(AnchorDao anchorDao) {
        this.anchorDao = anchorDao;
    }

    @Path(value="{owner}")
    @Produces(value={"application/json"})
    @GET
    public Response getAnchorForOwner(@QueryParam(value="incoming") @DefaultValue(value="false") boolean incoming, @QueryParam(value="outgoing") @DefaultValue(value="false") boolean outgoing, @QueryParam(value="thumbprint") @DefaultValue(value="") String thumbprint, @PathParam(value="owner") String owner) {
        List retAnchors;
        try {
            retAnchors = this.anchorDao.list(Arrays.asList(owner));
            if (retAnchors.isEmpty()) {
                return Response.status((Response.Status)Response.Status.NO_CONTENT).cacheControl(noCache).build();
            }
        }
        catch (Exception e) {
            log.error((Object)"Error looking up anchors.", (Throwable)e);
            return Response.serverError().cacheControl(noCache).build();
        }
        ArrayList<Anchor> modelAnchors = new ArrayList<Anchor>();
        for (org.nhindirect.config.store.Anchor anchor : retAnchors) {
            if (incoming && !anchor.isIncoming() || outgoing && !anchor.isOutgoing() || !thumbprint.isEmpty() && !thumbprint.equalsIgnoreCase(anchor.getThumbprint())) continue;
            modelAnchors.add(EntityModelConversion.toModelAnchor(anchor));
        }
        if (modelAnchors.isEmpty()) {
            return Response.status((Response.Status)Response.Status.NO_CONTENT).cacheControl(noCache).build();
        }
        GenericEntity<Collection<Anchor>> entity = new GenericEntity<Collection<Anchor>>(modelAnchors){};
        return Response.ok((Object)entity).cacheControl(noCache).build();
    }

    @Produces(value={"application/json"})
    @GET
    public Response getAnchors() {
        List retAnchors;
        try {
            retAnchors = this.anchorDao.listAll();
            if (retAnchors.isEmpty()) {
                return Response.status((Response.Status)Response.Status.NO_CONTENT).cacheControl(noCache).build();
            }
        }
        catch (Exception e) {
            log.error((Object)"Error looking up anchors.", (Throwable)e);
            return Response.serverError().cacheControl(noCache).build();
        }
        ArrayList<Anchor> modelAnchors = new ArrayList<Anchor>();
        for (org.nhindirect.config.store.Anchor anchor : retAnchors) {
            modelAnchors.add(EntityModelConversion.toModelAnchor(anchor));
        }
        GenericEntity<Collection<Anchor>> entity = new GenericEntity<Collection<Anchor>>(modelAnchors){};
        return Response.ok((Object)entity).cacheControl(noCache).build();
    }

    @PUT
    @Consumes(value={"application/json"})
    public Response addAnchor(@Context UriInfo uriInfo, Anchor anchor) {
        try {
            String thumbprint = anchor.getThumbprint() == null || anchor.getThumbprint().isEmpty() ? Thumbprint.toThumbprint((X509Certificate)anchor.getAnchorAsX509Certificate()).toString() : anchor.getThumbprint();
            List existingAnchors = this.anchorDao.list(Arrays.asList(anchor.getOwner()));
            for (org.nhindirect.config.store.Anchor existingAnchor : existingAnchors) {
                if (!existingAnchor.getThumbprint().equalsIgnoreCase(thumbprint)) continue;
                return Response.status((Response.Status)Response.Status.CONFLICT).cacheControl(noCache).build();
            }
        }
        catch (Exception e) {
            log.error((Object)"Error looking up existing anchor.", (Throwable)e);
            return Response.serverError().cacheControl(noCache).build();
        }
        try {
            this.anchorDao.add(EntityModelConversion.toEntityAnchor(anchor));
            UriBuilder newLocBuilder = uriInfo.getBaseUriBuilder();
            URI newLoc = newLocBuilder.path("anchor/" + anchor.getOwner()).build(new Object[0]);
            return Response.created((URI)newLoc).cacheControl(noCache).build();
        }
        catch (Exception e) {
            log.error((Object)"Error adding anchor.", (Throwable)e);
            return Response.serverError().cacheControl(noCache).build();
        }
    }

    @Path(value="ids/{ids}")
    @DELETE
    public Response removeAnchorsByIds(@PathParam(value="ids") String ids) {
        String[] idArray = ids.split(",");
        ArrayList<Long> idList = new ArrayList<Long>();
        try {
            for (String id : idArray) {
                idList.add(Long.parseLong(id));
            }
            this.anchorDao.delete(idList);
            return Response.ok().cacheControl(noCache).build();
        }
        catch (Exception e) {
            log.error((Object)"Error removing anchors by ids.", (Throwable)e);
            return Response.serverError().cacheControl(noCache).build();
        }
    }

    @DELETE
    @Path(value="{owner}")
    public Response removeAnchorsByOwner(@PathParam(value="owner") String owner) {
        try {
            this.anchorDao.delete(owner);
            return Response.ok().cacheControl(noCache).build();
        }
        catch (Exception e) {
            log.error((Object)"Error removing anchors by owner.", (Throwable)e);
            return Response.serverError().cacheControl(noCache).build();
        }
    }
}

