/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.resources;

import com.google.inject.Singleton;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nhindirect.config.model.CertPolicy;
import org.nhindirect.config.model.CertPolicyGroup;
import org.nhindirect.config.model.CertPolicyGroupDomainReltn;
import org.nhindirect.config.model.CertPolicyGroupUse;
import org.nhindirect.config.resources.util.EntityModelConversion;
import org.nhindirect.config.store.CertPolicyGroupReltn;
import org.nhindirect.config.store.CertPolicyUse;
import org.nhindirect.config.store.Domain;
import org.nhindirect.config.store.dao.CertPolicyDao;
import org.nhindirect.config.store.dao.DomainDao;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Path(value="certpolicy/")
@Singleton
public class CertPolicyResource {
    protected static final CacheControl noCache;
    private static final Log log;
    protected CertPolicyDao policyDao;
    protected DomainDao domainDao;

    @Autowired
    public void setCertPolicyDao(CertPolicyDao policyDao) {
        this.policyDao = policyDao;
    }

    @Autowired
    public void setDomainDao(DomainDao domainDao) {
        this.domainDao = domainDao;
    }

    @GET
    @Produces(value={"application/json"})
    public Response getPolicies() {
        Collection retPolicies;
        try {
            retPolicies = this.policyDao.getPolicies();
            if (retPolicies.isEmpty()) {
                return Response.status((Response.Status)Response.Status.NO_CONTENT).cacheControl(noCache).build();
            }
        }
        catch (Exception e) {
            log.error((Object)"Error looking up cert policies.", (Throwable)e);
            return Response.serverError().cacheControl(noCache).build();
        }
        ArrayList<CertPolicy> modelPolicies = new ArrayList<CertPolicy>();
        for (org.nhindirect.config.store.CertPolicy policy : retPolicies) {
            modelPolicies.add(EntityModelConversion.toModelCertPolicy(policy));
        }
        GenericEntity<Collection<CertPolicy>> entity = new GenericEntity<Collection<CertPolicy>>(modelPolicies){};
        return Response.ok((Object)entity).cacheControl(noCache).build();
    }

    @GET
    @Path(value="{policyName}")
    @Produces(value={"application/json"})
    public Response getPolicyByName(@PathParam(value="policyName") String policyName) {
        try {
            org.nhindirect.config.store.CertPolicy retPolicy = this.policyDao.getPolicyByName(policyName);
            if (retPolicy == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).cacheControl(noCache).build();
            }
            CertPolicy modelPolicy = EntityModelConversion.toModelCertPolicy(retPolicy);
            return Response.ok((Object)modelPolicy).cacheControl(noCache).build();
        }
        catch (Throwable e) {
            log.error((Object)"Error looking up cert policy", e);
            return Response.serverError().cacheControl(noCache).build();
        }
    }

    @PUT
    @Consumes(value={"application/json"})
    public Response addPolicy(@Context UriInfo uriInfo, CertPolicy policy) {
        try {
            if (this.policyDao.getPolicyByName(policy.getPolicyName()) != null) {
                return Response.status((Response.Status)Response.Status.CONFLICT).cacheControl(noCache).build();
            }
        }
        catch (Exception e) {
            log.error((Object)"Error looking up cert policy.", (Throwable)e);
            return Response.serverError().cacheControl(noCache).build();
        }
        try {
            org.nhindirect.config.store.CertPolicy entityPolicy = EntityModelConversion.toEntityCertPolicy(policy);
            this.policyDao.addPolicy(entityPolicy);
            UriBuilder newLocBuilder = uriInfo.getBaseUriBuilder();
            URI newLoc = newLocBuilder.path("certpolicy/" + policy.getPolicyName()).build(new Object[0]);
            return Response.created((URI)newLoc).cacheControl(noCache).build();
        }
        catch (Exception e) {
            log.error((Object)"Error adding trust cert policy.", (Throwable)e);
            return Response.serverError().cacheControl(noCache).build();
        }
    }

    @Path(value="{policyName}")
    @DELETE
    public Response removePolicyByName(@PathParam(value="policyName") String policyName) {
        org.nhindirect.config.store.CertPolicy enitityPolicy = null;
        try {
            enitityPolicy = this.policyDao.getPolicyByName(policyName);
            if (enitityPolicy == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).cacheControl(noCache).build();
            }
        }
        catch (Exception e) {
            log.error((Object)"Error looking up existing cert policy.", (Throwable)e);
            return Response.serverError().cacheControl(noCache).build();
        }
        try {
            this.policyDao.deletePolicies(new long[]{enitityPolicy.getId()});
            return Response.ok().cacheControl(noCache).build();
        }
        catch (Exception e) {
            log.error((Object)"Error deleting cert policy.", (Throwable)e);
            return Response.serverError().cacheControl(noCache).build();
        }
    }

    @POST
    @Path(value="{policyName}/policyAttributes")
    @Consumes(value={"application/json"})
    public Response updatePolicyAttributes(@PathParam(value="policyName") String policyName, CertPolicy policyData) {
        org.nhindirect.config.store.CertPolicy entityPolicy;
        try {
            entityPolicy = this.policyDao.getPolicyByName(policyName);
            if (entityPolicy == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).cacheControl(noCache).build();
            }
        }
        catch (Exception e) {
            log.error((Object)"Error looking up cert policy.", (Throwable)e);
            return Response.serverError().cacheControl(noCache).build();
        }
        try {
            this.policyDao.updatePolicyAttributes(entityPolicy.getId(), policyData.getPolicyName(), policyData.getLexicon(), policyData.getPolicyData());
            return Response.noContent().cacheControl(noCache).build();
        }
        catch (Exception e) {
            log.error((Object)"Error updating cert policy attributes.", (Throwable)e);
            return Response.serverError().cacheControl(noCache).build();
        }
    }

    @Path(value="groups")
    @GET
    @Produces(value={"application/json"})
    public Response getPolicyGroups() {
        Collection retGroups;
        try {
            retGroups = this.policyDao.getPolicyGroups();
            if (retGroups.isEmpty()) {
                return Response.status((Response.Status)Response.Status.NO_CONTENT).cacheControl(noCache).build();
            }
        }
        catch (Exception e) {
            log.error((Object)"Error looking up cert policy groups.", (Throwable)e);
            return Response.serverError().cacheControl(noCache).build();
        }
        ArrayList<CertPolicyGroup> modelGroups = new ArrayList<CertPolicyGroup>();
        for (org.nhindirect.config.store.CertPolicyGroup group : retGroups) {
            modelGroups.add(EntityModelConversion.toModelCertPolicyGroup(group));
        }
        GenericEntity<Collection<CertPolicyGroup>> entity = new GenericEntity<Collection<CertPolicyGroup>>(modelGroups){};
        return Response.ok((Object)entity).cacheControl(noCache).build();
    }

    @Path(value="groups/{groupName}")
    @GET
    @Produces(value={"application/json"})
    public Response getPolicyGroupByName(@PathParam(value="groupName") String groupName) {
        try {
            org.nhindirect.config.store.CertPolicyGroup retGroup = this.policyDao.getPolicyGroupByName(groupName);
            if (retGroup == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).cacheControl(noCache).build();
            }
            CertPolicyGroup modelGroup = EntityModelConversion.toModelCertPolicyGroup(retGroup);
            return Response.ok((Object)modelGroup).cacheControl(noCache).build();
        }
        catch (Throwable e) {
            log.error((Object)"Error looking up cert policy group", e);
            return Response.serverError().cacheControl(noCache).build();
        }
    }

    @PUT
    @Consumes(value={"application/json"})
    @Path(value="groups")
    public Response addPolicyGroup(@Context UriInfo uriInfo, CertPolicyGroup group) {
        try {
            if (this.policyDao.getPolicyGroupByName(group.getPolicyGroupName()) != null) {
                return Response.status((Response.Status)Response.Status.CONFLICT).cacheControl(noCache).build();
            }
        }
        catch (Exception e) {
            log.error((Object)"Error looking up cert policy group.", (Throwable)e);
            return Response.serverError().cacheControl(noCache).build();
        }
        try {
            org.nhindirect.config.store.CertPolicyGroup entityGroup = EntityModelConversion.toEntityCertPolicyGroup(group);
            this.policyDao.addPolicyGroup(entityGroup);
            UriBuilder newLocBuilder = uriInfo.getBaseUriBuilder();
            URI newLoc = newLocBuilder.path("certpolicy/group+/" + group.getPolicyGroupName()).build(new Object[0]);
            return Response.created((URI)newLoc).cacheControl(noCache).build();
        }
        catch (Exception e) {
            log.error((Object)"Error adding trust cert policy group.", (Throwable)e);
            return Response.serverError().cacheControl(noCache).build();
        }
    }

    @Path(value="groups/{groupName}")
    @DELETE
    public Response removePolicyGroupByName(@PathParam(value="groupName") String groupName) {
        org.nhindirect.config.store.CertPolicyGroup enitityGroup = null;
        try {
            enitityGroup = this.policyDao.getPolicyGroupByName(groupName);
            if (enitityGroup == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).cacheControl(noCache).build();
            }
        }
        catch (Exception e) {
            log.error((Object)"Error looking up existing cert policy group.", (Throwable)e);
            return Response.serverError().cacheControl(noCache).build();
        }
        try {
            this.policyDao.deletePolicyGroups(new long[]{enitityGroup.getId()});
            return Response.ok().cacheControl(noCache).build();
        }
        catch (Exception e) {
            log.error((Object)"Error deleting cert policy group.", (Throwable)e);
            return Response.serverError().cacheControl(noCache).build();
        }
    }

    @POST
    @Path(value="groups/{groupName}/groupAttributes")
    @Consumes(value={"application/json"})
    public Response updateGroupAttributes(@PathParam(value="groupName") String groupName, String newGroupName) {
        org.nhindirect.config.store.CertPolicyGroup entityGroup;
        try {
            entityGroup = this.policyDao.getPolicyGroupByName(groupName);
            if (entityGroup == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).cacheControl(noCache).build();
            }
        }
        catch (Exception e) {
            log.error((Object)"Error looking up cert policy group.", (Throwable)e);
            return Response.serverError().cacheControl(noCache).build();
        }
        try {
            this.policyDao.updateGroupAttributes(entityGroup.getId(), newGroupName);
            return Response.noContent().cacheControl(noCache).build();
        }
        catch (Exception e) {
            log.error((Object)"Error updating cert policy group attributes.", (Throwable)e);
            return Response.serverError().cacheControl(noCache).build();
        }
    }

    @POST
    @Path(value="groups/uses/{group}")
    @Consumes(value={"application/json"})
    public Response addPolicyUseToGroup(@PathParam(value="group") String groupName, CertPolicyGroupUse use) {
        org.nhindirect.config.store.CertPolicy entityPolicy;
        org.nhindirect.config.store.CertPolicyGroup entityGroup;
        try {
            entityGroup = this.policyDao.getPolicyGroupByName(groupName);
            if (entityGroup == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).cacheControl(noCache).build();
            }
        }
        catch (Exception e) {
            log.error((Object)"Error looking up policy group.", (Throwable)e);
            return Response.serverError().cacheControl(noCache).build();
        }
        try {
            entityPolicy = this.policyDao.getPolicyByName(use.getPolicy().getPolicyName());
            if (entityPolicy == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).cacheControl(noCache).build();
            }
        }
        catch (Exception e) {
            log.error((Object)"Error looking up policy.", (Throwable)e);
            return Response.serverError().cacheControl(noCache).build();
        }
        try {
            this.policyDao.addPolicyUseToGroup(entityGroup.getId(), entityPolicy.getId(), CertPolicyUse.valueOf((String)use.getPolicyUse().toString()), use.isIncoming(), use.isOutgoing());
            return Response.noContent().cacheControl(noCache).build();
        }
        catch (Exception e) {
            log.error((Object)"Error adding cert policy to group.", (Throwable)e);
            return Response.serverError().cacheControl(noCache).build();
        }
    }

    @POST
    @Path(value="groups/uses/{group}/removePolicy")
    @Consumes(value={"application/json"})
    public Response removedPolicyUseFromGroup(@PathParam(value="group") String groupName, CertPolicyGroupUse use) {
        org.nhindirect.config.store.CertPolicyGroup entityGroup;
        try {
            entityGroup = this.policyDao.getPolicyGroupByName(groupName);
            if (entityGroup == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).cacheControl(noCache).build();
            }
        }
        catch (Exception e) {
            log.error((Object)"Error looking up policy group.", (Throwable)e);
            return Response.serverError().cacheControl(noCache).build();
        }
        CertPolicyUse entityUse = CertPolicyUse.valueOf((String)use.getPolicyUse().toString());
        boolean reltnFound = false;
        if (entityGroup.getCertPolicyGroupReltn() != null) {
            for (CertPolicyGroupReltn groupReltn : entityGroup.getCertPolicyGroupReltn()) {
                if (!groupReltn.getCertPolicy().getPolicyName().equals(use.getPolicy().getPolicyName()) || groupReltn.isIncoming() != use.isIncoming() || groupReltn.isOutgoing() != use.isOutgoing() || groupReltn.getPolicyUse() != entityUse) continue;
                try {
                    this.policyDao.removePolicyUseFromGroup(groupReltn.getId());
                    reltnFound = true;
                }
                catch (Exception e) {
                    log.error((Object)"Error removing cert policy from group.", (Throwable)e);
                    return Response.serverError().cacheControl(noCache).build();
                }
            }
        }
        if (!reltnFound) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).cacheControl(noCache).build();
        }
        return Response.ok().cacheControl(noCache).build();
    }

    @GET
    @Path(value="groups/domain")
    @Produces(value={"application/json"})
    public Response getPolicyGroupDomainReltns() {
        Collection retReltn;
        try {
            retReltn = this.policyDao.getPolicyGroupDomainReltns();
            if (retReltn.isEmpty()) {
                return Response.status((Response.Status)Response.Status.NO_CONTENT).cacheControl(noCache).build();
            }
        }
        catch (Exception e) {
            log.error((Object)"Error looking up policy group/domain relations.", (Throwable)e);
            return Response.serverError().cacheControl(noCache).build();
        }
        ArrayList<CertPolicyGroupDomainReltn> modelReltns = new ArrayList<CertPolicyGroupDomainReltn>();
        for (org.nhindirect.config.store.CertPolicyGroupDomainReltn reltn : retReltn) {
            modelReltns.add(EntityModelConversion.toModelCertPolicyGroupDomainReltn(reltn));
        }
        GenericEntity<Collection<CertPolicyGroupDomainReltn>> entity = new GenericEntity<Collection<CertPolicyGroupDomainReltn>>(modelReltns){};
        return Response.ok((Object)entity).cacheControl(noCache).build();
    }

    @GET
    @Path(value="groups/domain/{domain}")
    @Produces(value={"application/json"})
    public Response getPolicyGroupsByDomain(@PathParam(value="domain") String domainName) {
        Collection retPolicyGroups;
        Domain entityDomain;
        try {
            entityDomain = this.domainDao.getDomainByName(domainName);
            if (entityDomain == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).cacheControl(noCache).build();
            }
        }
        catch (Exception e) {
            log.error((Object)"Error looking up domain.", (Throwable)e);
            return Response.serverError().cacheControl(noCache).build();
        }
        try {
            retPolicyGroups = this.policyDao.getPolicyGroupsByDomain(entityDomain.getId().longValue());
            if (retPolicyGroups.isEmpty()) {
                return Response.status((Response.Status)Response.Status.NO_CONTENT).cacheControl(noCache).build();
            }
        }
        catch (Exception e) {
            log.error((Object)"Error looking up cert policy groups.", (Throwable)e);
            return Response.serverError().cacheControl(noCache).build();
        }
        ArrayList<CertPolicyGroup> modelGroups = new ArrayList<CertPolicyGroup>();
        for (org.nhindirect.config.store.CertPolicyGroupDomainReltn reltn : retPolicyGroups) {
            modelGroups.add(EntityModelConversion.toModelCertPolicyGroup(reltn.getCertPolicyGroup()));
        }
        GenericEntity<Collection<CertPolicyGroup>> entity = new GenericEntity<Collection<CertPolicyGroup>>(modelGroups){};
        return Response.ok((Object)entity).cacheControl(noCache).build();
    }

    @POST
    @Path(value="groups/domain/{group}/{domain}")
    public Response associatePolicyGroupToDomain(@PathParam(value="group") String groupName, @PathParam(value="domain") String domainName) {
        Domain entityDomain;
        org.nhindirect.config.store.CertPolicyGroup entityGroup;
        try {
            entityGroup = this.policyDao.getPolicyGroupByName(groupName);
            if (entityGroup == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).cacheControl(noCache).build();
            }
        }
        catch (Exception e) {
            log.error((Object)"Error looking up policy group.", (Throwable)e);
            return Response.serverError().cacheControl(noCache).build();
        }
        try {
            entityDomain = this.domainDao.getDomainByName(domainName);
            if (entityDomain == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).cacheControl(noCache).build();
            }
        }
        catch (Exception e) {
            log.error((Object)"Error looking up domain.", (Throwable)e);
            return Response.serverError().cacheControl(noCache).build();
        }
        try {
            this.policyDao.associatePolicyGroupToDomain(entityDomain.getId().longValue(), entityGroup.getId());
            return Response.noContent().cacheControl(noCache).build();
        }
        catch (Exception e) {
            log.error((Object)"Error associating policy group to domain.", (Throwable)e);
            return Response.serverError().cacheControl(noCache).build();
        }
    }

    @DELETE
    @Path(value="groups/domain/{group}/{domain}")
    public Response disassociatePolicyGroupFromDomain(@PathParam(value="group") String groupName, @PathParam(value="domain") String domainName) {
        Domain entityDomain;
        org.nhindirect.config.store.CertPolicyGroup entityGroup;
        try {
            entityGroup = this.policyDao.getPolicyGroupByName(groupName);
            if (entityGroup == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).cacheControl(noCache).build();
            }
        }
        catch (Exception e) {
            log.error((Object)"Error looking up policy group.", (Throwable)e);
            return Response.serverError().cacheControl(noCache).build();
        }
        try {
            entityDomain = this.domainDao.getDomainByName(domainName);
            if (entityDomain == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).cacheControl(noCache).build();
            }
        }
        catch (Exception e) {
            log.error((Object)"Error looking up domain.", (Throwable)e);
            return Response.serverError().cacheControl(noCache).build();
        }
        try {
            this.policyDao.disassociatePolicyGroupFromDomain(entityDomain.getId().longValue(), entityGroup.getId());
            return Response.ok().cacheControl(noCache).build();
        }
        catch (Exception e) {
            log.error((Object)"Error disassociating policy group from domain.", (Throwable)e);
            return Response.serverError().cacheControl(noCache).build();
        }
    }

    @DELETE
    @Path(value="groups/domain/{domain}/deleteFromDomain")
    @Consumes(value={"application/json"})
    public Response disassociatePolicyGroupsFromDomain(@PathParam(value="domain") String domainName) {
        Domain entityDomain;
        try {
            entityDomain = this.domainDao.getDomainByName(domainName);
            if (entityDomain == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).cacheControl(noCache).build();
            }
        }
        catch (Exception e) {
            log.error((Object)"Error looking up domain.", (Throwable)e);
            return Response.serverError().cacheControl(noCache).build();
        }
        try {
            this.policyDao.disassociatePolicyGroupsFromDomain(entityDomain.getId().longValue());
            return Response.ok().cacheControl(noCache).build();
        }
        catch (Exception e) {
            log.error((Object)"Error disassociating policy groups from domain.", (Throwable)e);
            return Response.serverError().cacheControl(noCache).build();
        }
    }

    @DELETE
    @Path(value="groups/domain/{group}/deleteFromGroup")
    @Consumes(value={"application/json"})
    public Response disassociatePolicyGroupFromDomains(@PathParam(value="group") String groupName) {
        org.nhindirect.config.store.CertPolicyGroup entityGroup;
        try {
            entityGroup = this.policyDao.getPolicyGroupByName(groupName);
            if (entityGroup == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).cacheControl(noCache).build();
            }
        }
        catch (Exception e) {
            log.error((Object)"Error looking up policy group.", (Throwable)e);
            return Response.serverError().cacheControl(noCache).build();
        }
        try {
            this.policyDao.disassociatePolicyGroupFromDomains(entityGroup.getId());
            return Response.ok().cacheControl(noCache).build();
        }
        catch (Exception e) {
            log.error((Object)"Error disassociating policy groups from domain.", (Throwable)e);
            return Response.serverError().cacheControl(noCache).build();
        }
    }

    static {
        log = LogFactory.getLog(CertPolicyResource.class);
        noCache = new CacheControl();
        noCache.setNoCache(true);
    }
}

