/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.resources;

import com.google.inject.Singleton;
import java.net.URI;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nhindirect.config.model.Certificate;
import org.nhindirect.config.model.utils.CertUtils;
import org.nhindirect.config.resources.ProtectedResource;
import org.nhindirect.config.resources.util.EntityModelConversion;
import org.nhindirect.config.store.dao.CertificateDao;
import org.nhindirect.stagent.cert.Thumbprint;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Path(value="certificate/")
@Singleton
public class CertificateResource
extends ProtectedResource {
    private static final Log log = LogFactory.getLog(CertificateResource.class);
    protected CertificateDao certDao;

    @Autowired
    public void setCertificateDao(CertificateDao certDao) {
        this.certDao = certDao;
    }

    @Produces(value={"application/json"})
    @GET
    public Response getAllCertificates() {
        return this.getCertificatesByOwner(null);
    }

    @Path(value="{owner}")
    @Produces(value={"application/json"})
    @GET
    public Response getCertificatesByOwner(@PathParam(value="owner") String owner) {
        List retCertificates;
        try {
            retCertificates = this.certDao.list(owner);
            if (retCertificates.isEmpty()) {
                return Response.status((Response.Status)Response.Status.NO_CONTENT).cacheControl(noCache).build();
            }
        }
        catch (Exception e) {
            log.error((Object)"Error looking up certificates.", (Throwable)e);
            return Response.serverError().cacheControl(noCache).build();
        }
        ArrayList<Certificate> modelCerts = new ArrayList<Certificate>();
        for (org.nhindirect.config.store.Certificate cert : retCertificates) {
            modelCerts.add(EntityModelConversion.toModelCertificate(cert));
        }
        GenericEntity<Collection<Certificate>> entity = new GenericEntity<Collection<Certificate>>(modelCerts){};
        return Response.ok((Object)entity).cacheControl(noCache).build();
    }

    @Path(value="{owner}/{thumbprint}")
    @Produces(value={"application/json"})
    @GET
    public Response getCertificatesByOwnerAndThumbprint(@PathParam(value="owner") String owner, @PathParam(value="thumbprint") String thumbprint) {
        org.nhindirect.config.store.Certificate retCertificate;
        try {
            retCertificate = this.certDao.load(owner, thumbprint);
            if (retCertificate == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).cacheControl(noCache).build();
            }
        }
        catch (Exception e) {
            log.error((Object)"Error looking up certificate.", (Throwable)e);
            return Response.serverError().cacheControl(noCache).build();
        }
        return Response.ok((Object)EntityModelConversion.toModelCertificate(retCertificate)).cacheControl(noCache).build();
    }

    @PUT
    @Consumes(value={"application/json"})
    public Response addCertificate(@Context UriInfo uriInfo, Certificate cert) {
        CertUtils.CertContainer cont = null;
        try {
            cont = CertUtils.toCertContainer((byte[])cert.getData());
            if (this.certDao.load(cert.getOwner(), Thumbprint.toThumbprint((X509Certificate)cont.getCert()).toString()) != null) {
                return Response.status((Response.Status)Response.Status.CONFLICT).cacheControl(noCache).build();
            }
        }
        catch (Exception e) {
            log.error((Object)"Error looking up certificate.", (Throwable)e);
            return Response.serverError().cacheControl(noCache).build();
        }
        try {
            String theOwner;
            if ((cert.getOwner() == null || cert.getOwner().isEmpty()) && cont != null && cont.getCert() != null && (theOwner = CertUtils.getOwner((X509Certificate)cont.getCert())) != null && !theOwner.isEmpty()) {
                cert.setOwner(theOwner);
            }
            org.nhindirect.config.store.Certificate entCert = EntityModelConversion.toEntityCertificate(cert);
            this.certDao.save(entCert);
            UriBuilder newLocBuilder = uriInfo.getBaseUriBuilder();
            URI newLoc = newLocBuilder.path("certificate/" + entCert.getOwner() + "/" + entCert.getThumbprint()).build(new Object[0]);
            return Response.created((URI)newLoc).cacheControl(noCache).build();
        }
        catch (Exception e) {
            log.error((Object)"Error adding certificate.", (Throwable)e);
            return Response.serverError().cacheControl(noCache).build();
        }
    }

    @Path(value="ids/{ids}")
    @DELETE
    public Response removeCertificatesByIds(@PathParam(value="ids") String ids) {
        String[] idArray = ids.split(",");
        ArrayList<Long> idList = new ArrayList<Long>();
        try {
            for (String id : idArray) {
                idList.add(Long.parseLong(id));
            }
            this.certDao.delete(idList);
            return Response.ok().cacheControl(noCache).build();
        }
        catch (Exception e) {
            log.error((Object)"Error removing certificates by ids.", (Throwable)e);
            return Response.serverError().cacheControl(noCache).build();
        }
    }

    @DELETE
    @Path(value="{owner}")
    public Response removeCertificatesByOwner(@PathParam(value="owner") String owner) {
        try {
            this.certDao.delete(owner);
            return Response.ok().cacheControl(noCache).build();
        }
        catch (Exception e) {
            log.error((Object)"Error removing certificates by owner.", (Throwable)e);
            return Response.serverError().cacheControl(noCache).build();
        }
    }
}

