/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.resources;

import com.google.inject.Singleton;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nhindirect.config.model.DNSRecord;
import org.nhindirect.config.resources.ProtectedResource;
import org.nhindirect.config.resources.util.EntityModelConversion;
import org.nhindirect.config.store.dao.DNSDao;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Path(value="dns/")
@Singleton
public class DNSResource
extends ProtectedResource {
    private static final Log log = LogFactory.getLog(DNSResource.class);
    protected DNSDao dnsDao;

    @Autowired
    public void setDNSDao(DNSDao dnsDao) {
        this.dnsDao = dnsDao;
    }

    @Produces(value={"application/json"})
    @GET
    public Response getDNSRecords(@QueryParam(value="type") @DefaultValue(value="-1") int type, @QueryParam(value="name") @DefaultValue(value="") String name) {
        Collection retRecords;
        try {
            if (type > -1 && !name.isEmpty()) {
                retRecords = this.dnsDao.get(name.endsWith(".") ? name : name + ".", type);
            } else if (type > -1) {
                retRecords = this.dnsDao.get(type);
            } else if (!name.isEmpty()) {
                retRecords = this.dnsDao.get(name.endsWith(".") ? name : name + ".");
            } else {
                log.error((Object)"Either a DNS query name or type (or both) must be specified.");
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).cacheControl(noCache).build();
            }
            if (retRecords.isEmpty()) {
                return Response.status((Response.Status)Response.Status.NO_CONTENT).cacheControl(noCache).build();
            }
        }
        catch (Exception e) {
            log.error((Object)"Error looking up DNS records.", (Throwable)e);
            return Response.serverError().cacheControl(noCache).build();
        }
        ArrayList<DNSRecord> modelRecords = new ArrayList<DNSRecord>();
        for (org.nhindirect.config.store.DNSRecord record : retRecords) {
            modelRecords.add(EntityModelConversion.toModelDNSRecord(record));
        }
        GenericEntity<Collection<DNSRecord>> entity = new GenericEntity<Collection<DNSRecord>>(modelRecords){};
        return Response.ok((Object)entity).cacheControl(noCache).build();
    }

    @PUT
    @Consumes(value={"application/json"})
    public Response addDNSRecord(@Context UriInfo uriInfo, DNSRecord record) {
        if (!record.getName().endsWith(".")) {
            record.setName(record.getName() + ".");
        }
        try {
            Collection records = this.dnsDao.get(record.getName(), record.getType());
            for (org.nhindirect.config.store.DNSRecord compareRecord : records) {
                if (!Arrays.equals(record.getData(), compareRecord.getData())) continue;
                return Response.status((Response.Status)Response.Status.CONFLICT).cacheControl(noCache).build();
            }
        }
        catch (Exception e) {
            log.error((Object)"Error looking up DNS records.", (Throwable)e);
            return Response.serverError().cacheControl(noCache).build();
        }
        try {
            this.dnsDao.add(Arrays.asList(EntityModelConversion.toEntityDNSRecord(record)));
            UriBuilder newLocBuilder = uriInfo.getBaseUriBuilder();
            URI newLoc = newLocBuilder.path("dns?type=" + record.getType() + "&name=" + record.getName()).build(new Object[0]);
            return Response.created((URI)newLoc).cacheControl(noCache).build();
        }
        catch (Exception e) {
            log.error((Object)"Error adding DNS record.", (Throwable)e);
            return Response.serverError().cacheControl(noCache).build();
        }
    }

    @POST
    @Consumes(value={"application/json"})
    public Response updateDNSRecord(DNSRecord updateRecord) {
        try {
            if (this.dnsDao.get(updateRecord.getId()) == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).cacheControl(noCache).build();
            }
        }
        catch (Exception e) {
            log.error((Object)"Error looking up DNS records.", (Throwable)e);
            return Response.serverError().cacheControl(noCache).build();
        }
        if (!updateRecord.getName().endsWith(".")) {
            updateRecord.setName(updateRecord.getName() + ".");
        }
        try {
            this.dnsDao.update(updateRecord.getId(), EntityModelConversion.toEntityDNSRecord(updateRecord));
            return Response.noContent().cacheControl(noCache).build();
        }
        catch (Exception e) {
            log.error((Object)"Error updating DNS record.", (Throwable)e);
            return Response.serverError().cacheControl(noCache).build();
        }
    }

    @Path(value="{ids}")
    @DELETE
    public Response removeDNSRecordsByIds(@PathParam(value="ids") String ids) {
        String[] idArray = ids.split(",");
        long[] idList = new long[idArray.length];
        try {
            for (int i = 0; i < idArray.length; ++i) {
                idList[i] = Long.parseLong(idArray[i]);
            }
            this.dnsDao.remove(idList);
            return Response.ok().cacheControl(noCache).build();
        }
        catch (Exception e) {
            log.error((Object)"Error removing DNS records by ids.", (Throwable)e);
            return Response.serverError().cacheControl(noCache).build();
        }
    }
}

