/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.resources;

import com.google.inject.Singleton;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nhindirect.config.model.Domain;
import org.nhindirect.config.resources.ProtectedResource;
import org.nhindirect.config.resources.util.EntityModelConversion;
import org.nhindirect.config.store.EntityStatus;
import org.nhindirect.config.store.dao.AddressDao;
import org.nhindirect.config.store.dao.DomainDao;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Path(value="domain/")
@Singleton
public class DomainResource
extends ProtectedResource {
    private static final Log log = LogFactory.getLog(DomainResource.class);
    protected AddressDao addressDao;
    protected DomainDao domainDao;

    @Autowired
    public void setAddressDao(AddressDao addressDao) {
        this.addressDao = addressDao;
    }

    @Autowired
    public void setDomainDao(DomainDao domainDao) {
        this.domainDao = domainDao;
    }

    @Path(value="{domain}")
    @Produces(value={"application/json"})
    @GET
    public Response getDomain(@PathParam(value="domain") String domain) {
        try {
            org.nhindirect.config.store.Domain retDomain = this.domainDao.getDomainByName(domain);
            if (retDomain == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).cacheControl(noCache).build();
            }
            return Response.ok((Object)EntityModelConversion.toModelDomain(retDomain)).cacheControl(noCache).build();
        }
        catch (Exception e) {
            log.error((Object)"Error looking up domain.", (Throwable)e);
            return Response.serverError().cacheControl(noCache).build();
        }
    }

    @Produces(value={"application/json"})
    @GET
    public Response searchDomains(@QueryParam(value="domainName") @DefaultValue(value="") String domainName, @QueryParam(value="entityStatus") @DefaultValue(value="") String entityStatus) {
        EntityStatus status = null;
        if (!entityStatus.isEmpty()) {
            try {
                status = EntityStatus.valueOf((String)entityStatus);
            }
            catch (IllegalArgumentException e) {
                log.warn((Object)("EntityStatus enum value of " + entityStatus + " encountered.  Defaulting EntityStatus to null"));
            }
        }
        try {
            List domains = this.domainDao.searchDomain(domainName.isEmpty() ? null : domainName, status);
            if (domains.isEmpty()) {
                return Response.status((Response.Status)Response.Status.NO_CONTENT).cacheControl(noCache).build();
            }
            ArrayList<Domain> retDomains = new ArrayList<Domain>();
            for (org.nhindirect.config.store.Domain domain : domains) {
                retDomains.add(EntityModelConversion.toModelDomain(domain));
            }
            GenericEntity<Collection<Domain>> entity = new GenericEntity<Collection<Domain>>(retDomains){};
            return Response.ok((Object)entity).cacheControl(noCache).build();
        }
        catch (Exception e) {
            log.error((Object)"Error looking up domains.", (Throwable)e);
            return Response.serverError().cacheControl(noCache).build();
        }
    }

    @PUT
    @Consumes(value={"application/json"})
    public Response addDomain(@Context UriInfo uriInfo, Domain domain) {
        try {
            if (this.domainDao.getDomainByName(domain.getDomainName()) != null) {
                return Response.status((Response.Status)Response.Status.CONFLICT).cacheControl(noCache).build();
            }
        }
        catch (Exception e) {
            log.error((Object)"Error looking up existing domain.", (Throwable)e);
            return Response.serverError().cacheControl(noCache).build();
        }
        org.nhindirect.config.store.Domain toDomain = EntityModelConversion.toEntityDomain(domain);
        try {
            this.domainDao.add(toDomain);
            UriBuilder newLocBuilder = uriInfo.getBaseUriBuilder();
            URI newLoc = newLocBuilder.path("domain/" + domain.getDomainName()).build(new Object[0]);
            return Response.created((URI)newLoc).cacheControl(noCache).build();
        }
        catch (Exception e) {
            log.error((Object)"Error adding domain.", (Throwable)e);
            return Response.serverError().cacheControl(noCache).build();
        }
    }

    @POST
    @Consumes(value={"application/json"})
    public Response updateDomain(Domain domain) {
        org.nhindirect.config.store.Domain existingDomain;
        try {
            existingDomain = this.domainDao.getDomainByName(domain.getDomainName());
            if (existingDomain == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).cacheControl(noCache).build();
            }
        }
        catch (Exception e) {
            log.error((Object)"Error looking up existing domain.", (Throwable)e);
            return Response.serverError().cacheControl(noCache).build();
        }
        org.nhindirect.config.store.Domain toDomain = EntityModelConversion.toEntityDomain(domain);
        toDomain.setId(existingDomain.getId());
        try {
            this.domainDao.update(toDomain);
            return Response.noContent().cacheControl(noCache).build();
        }
        catch (Exception e) {
            log.error((Object)"Error updating domain.", (Throwable)e);
            return Response.serverError().cacheControl(noCache).build();
        }
    }

    @DELETE
    @Path(value="{domain}")
    public Response removedDomain(@PathParam(value="domain") String domain) {
        try {
            if (this.domainDao.getDomainByName(domain) == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).cacheControl(noCache).build();
            }
        }
        catch (Exception e) {
            log.error((Object)"Error looking up existing domain.", (Throwable)e);
            return Response.serverError().cacheControl(noCache).build();
        }
        try {
            this.domainDao.delete(domain);
            return Response.ok().cacheControl(noCache).build();
        }
        catch (Exception e) {
            log.error((Object)"Error deleting domain.", (Throwable)e);
            return Response.serverError().cacheControl(noCache).build();
        }
    }
}

