/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.resources;

import com.google.inject.Singleton;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nhindirect.config.model.Setting;
import org.nhindirect.config.resources.ProtectedResource;
import org.nhindirect.config.resources.util.EntityModelConversion;
import org.nhindirect.config.store.dao.SettingDao;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Path(value="setting/")
@Singleton
public class SettingResource
extends ProtectedResource {
    private static final Log log = LogFactory.getLog(SettingResource.class);
    protected SettingDao settingDao;

    @Autowired
    public void setSettingDao(SettingDao settingDao) {
        this.settingDao = settingDao;
    }

    @Produces(value={"application/json"})
    @GET
    public Response getAllSettings() {
        Collection retSettings;
        try {
            retSettings = this.settingDao.getAll();
            if (retSettings.isEmpty()) {
                return Response.status((Response.Status)Response.Status.NO_CONTENT).cacheControl(noCache).build();
            }
        }
        catch (Exception e) {
            log.error((Object)"Error looking up settings.", (Throwable)e);
            return Response.serverError().cacheControl(noCache).build();
        }
        ArrayList<Setting> modelSettings = new ArrayList<Setting>();
        for (org.nhindirect.config.store.Setting setting : retSettings) {
            modelSettings.add(EntityModelConversion.toModelSetting(setting));
        }
        GenericEntity<Collection<Setting>> entity = new GenericEntity<Collection<Setting>>(modelSettings){};
        return Response.ok((Object)entity).cacheControl(noCache).build();
    }

    @Produces(value={"application/json"})
    @Path(value="{name}")
    @GET
    public Response getSettingByName(@PathParam(value="name") String name) {
        try {
            Collection retSettings = this.settingDao.getByNames(Arrays.asList(name));
            if (retSettings.isEmpty()) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).cacheControl(noCache).build();
            }
            Setting modelSetting = EntityModelConversion.toModelSetting((org.nhindirect.config.store.Setting)retSettings.iterator().next());
            return Response.ok((Object)modelSetting).cacheControl(noCache).build();
        }
        catch (Exception e) {
            log.error((Object)"Error looking up setting.", (Throwable)e);
            return Response.serverError().cacheControl(noCache).build();
        }
    }

    @PUT
    @Path(value="{name}/{value}")
    public Response addSetting(@Context UriInfo uriInfo, @PathParam(value="name") String name, @PathParam(value="value") String value) {
        try {
            Collection retSettings = this.settingDao.getByNames(Arrays.asList(name));
            if (!retSettings.isEmpty()) {
                return Response.status((Response.Status)Response.Status.CONFLICT).cacheControl(noCache).build();
            }
        }
        catch (Exception e) {
            log.error((Object)"Error looking up setting.", (Throwable)e);
            return Response.serverError().cacheControl(noCache).build();
        }
        try {
            this.settingDao.add(name, value);
            UriBuilder newLocBuilder = uriInfo.getBaseUriBuilder();
            URI newLoc = newLocBuilder.path("setting/" + name).build(new Object[0]);
            return Response.created((URI)newLoc).cacheControl(noCache).build();
        }
        catch (Exception e) {
            log.error((Object)"Error adding setting.", (Throwable)e);
            return Response.serverError().cacheControl(noCache).build();
        }
    }

    @Path(value="{name}/{value}")
    @POST
    public Response updateSetting(@PathParam(value="name") String name, @PathParam(value="value") String value) {
        try {
            Collection retSettings = this.settingDao.getByNames(Arrays.asList(name));
            if (retSettings.isEmpty()) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).cacheControl(noCache).build();
            }
        }
        catch (Exception e) {
            log.error((Object)"Error looking up setting.", (Throwable)e);
            return Response.serverError().cacheControl(noCache).build();
        }
        try {
            this.settingDao.update(name, value);
            return Response.noContent().cacheControl(noCache).build();
        }
        catch (Exception e) {
            log.error((Object)"Error updating setting.", (Throwable)e);
            return Response.serverError().cacheControl(noCache).build();
        }
    }

    @DELETE
    @Path(value="{name}")
    public Response removeSettingByName(@PathParam(value="name") String name) {
        try {
            Collection retSettings = this.settingDao.getByNames(Arrays.asList(name));
            if (retSettings.isEmpty()) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).cacheControl(noCache).build();
            }
        }
        catch (Exception e) {
            log.error((Object)"Error looking up setting.", (Throwable)e);
            return Response.serverError().cacheControl(noCache).build();
        }
        try {
            this.settingDao.delete(Arrays.asList(name));
            return Response.ok().cacheControl(noCache).build();
        }
        catch (Exception e) {
            log.error((Object)"Error removing setting by name.", (Throwable)e);
            return Response.serverError().cacheControl(noCache).build();
        }
    }
}

