/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.service.impl;

import java.security.Provider;
import java.security.Security;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import javax.jws.WebService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.nhindirect.config.model.utils.CertUtils;
import org.nhindirect.config.service.CertificateService;
import org.nhindirect.config.service.ConfigurationServiceException;
import org.nhindirect.config.service.impl.CertificateGetOptions;
import org.nhindirect.config.store.Certificate;
import org.nhindirect.config.store.EntityStatus;
import org.nhindirect.config.store.dao.CertificateDao;
import org.springframework.beans.factory.annotation.Autowired;

@WebService(endpointInterface="org.nhindirect.config.service.CertificateService")
public class CertificateServiceImpl
implements CertificateService {
    private static final Log log = LogFactory.getLog(CertificateServiceImpl.class);
    private CertificateDao dao;

    @Autowired
    public void setDao(CertificateDao aDao) {
        this.dao = aDao;
    }

    public void init() {
        log.info((Object)"CertificateService initialized");
    }

    @Override
    public void addCertificates(Collection<Certificate> certs) throws ConfigurationServiceException {
        if (certs != null && certs.size() > 0) {
            for (Certificate cert : certs) {
                String theOwner;
                CertUtils.CertContainer cont;
                if ((cert.getOwner() == null || cert.getOwner().isEmpty()) && cert.getData() != null && (cont = CertUtils.toCertContainer((byte[])cert.getData())) != null && cont.getCert() != null && (theOwner = CertUtils.getOwner((X509Certificate)cont.getCert())) != null && !theOwner.isEmpty()) {
                    cert.setOwner(theOwner);
                }
                this.dao.save(cert);
            }
        }
    }

    @Override
    public Certificate getCertificate(String owner, String thumbprint, CertificateGetOptions options) throws ConfigurationServiceException {
        return this.dao.load(owner, thumbprint);
    }

    @Override
    public Collection<Certificate> getCertificates(Collection<Long> certIds, CertificateGetOptions options) throws ConfigurationServiceException {
        return this.dao.list(new ArrayList<Long>(certIds));
    }

    @Override
    public Collection<Certificate> getCertificatesForOwner(String owner, CertificateGetOptions options) throws ConfigurationServiceException {
        return this.dao.list(owner);
    }

    @Override
    public void setCertificateStatus(Collection<Long> certificateIDs, EntityStatus status) throws ConfigurationServiceException {
        this.dao.setStatus(new ArrayList<Long>(certificateIDs), status);
    }

    @Override
    public void setCertificateStatusForOwner(String owner, EntityStatus status) throws ConfigurationServiceException {
        this.dao.setStatus(owner, status);
    }

    @Override
    public void removeCertificates(Collection<Long> certificateIds) throws ConfigurationServiceException {
        this.dao.delete(new ArrayList<Long>(certificateIds));
    }

    @Override
    public void removeCertificatesForOwner(String owner) throws ConfigurationServiceException {
        this.dao.delete(owner);
    }

    @Override
    public Collection<Certificate> listCertificates(long lastCertificateID, int maxResults, CertificateGetOptions options) throws ConfigurationServiceException {
        return this.dao.list((String)null);
    }

    @Override
    public boolean contains(Certificate cert) {
        return this.dao.load(cert.getOwner(), cert.getThumbprint()) != null;
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

