/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.resources;

import java.net.URI;
import java.util.Collection;
import java.util.HashMap;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Criteria;
import org.hibernate.ScrollMode;
import org.hibernate.ScrollableResults;
import org.hibernate.Session;
import org.hibernate.StatelessSession;
import org.hibernate.criterion.CriteriaSpecification;
import org.nhindirect.config.model.CertPolicyGroup;
import org.nhindirect.config.model.CertPolicyGroupDomainReltn;
import org.nhindirect.config.model.CertPolicyGroupUse;
import org.nhindirect.config.repository.CertPolicyGroupDomainReltnRepository;
import org.nhindirect.config.repository.CertPolicyGroupRepository;
import org.nhindirect.config.repository.CertPolicyRepository;
import org.nhindirect.config.repository.DomainRepository;
import org.nhindirect.config.resources.ProtectedResource;
import org.nhindirect.config.resources.util.EntityModelConversion;
import org.nhindirect.config.store.CertPolicy;
import org.nhindirect.config.store.CertPolicyGroupReltn;
import org.nhindirect.config.store.CertPolicyUse;
import org.nhindirect.config.store.Domain;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.util.UriTemplate;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@RestController
@RequestMapping(value={"certpolicy"})
public class CertPolicyResource
extends ProtectedResource {
    private static final Log log = LogFactory.getLog(CertPolicyResource.class);
    protected CertPolicyRepository policyRepo;
    protected CertPolicyGroupRepository groupRepo;
    protected CertPolicyGroupDomainReltnRepository reltnRepo;
    protected DomainRepository domainRepo;
    protected CertPolicyResource transactionalThisProxy;
    @Autowired
    protected EntityManager entityManager;

    @Autowired
    public void setCertPolicyRepository(CertPolicyRepository policyRepo) {
        this.policyRepo = policyRepo;
    }

    @Autowired
    public void setDomainRepository(DomainRepository domainRepo) {
        this.domainRepo = domainRepo;
    }

    @Autowired
    public void setCertPolicyGroupRepository(CertPolicyGroupRepository groupRepo) {
        this.groupRepo = groupRepo;
    }

    @Autowired
    public void setCertPolicyGroupDomainReltnRepository(CertPolicyGroupDomainReltnRepository reltnRepo) {
        this.reltnRepo = reltnRepo;
    }

    @Autowired
    public void setInternalThisProxy(CertPolicyResource internalProxy) {
        this.transactionalThisProxy = internalProxy;
    }

    @GetMapping(produces={"application/json"})
    public ResponseEntity<Flux<org.nhindirect.config.model.CertPolicy>> getPolicies() {
        try {
            Flux retVal = Flux.fromStream(this.policyRepo.findAll().stream().map(pol -> EntityModelConversion.toModelCertPolicy(pol)));
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.OK).cacheControl(noCache)).body((Object)retVal);
        }
        catch (Exception e) {
            log.error((Object)"Error looking up cert policies.", (Throwable)e);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).cacheControl(noCache)).build();
        }
    }

    @GetMapping(value={"/{policyName}"}, produces={"application/json"})
    public ResponseEntity<Mono<org.nhindirect.config.model.CertPolicy>> getPolicyByName(@PathVariable(value="policyName") String policyName) {
        try {
            CertPolicy retPolicy = this.policyRepo.findByPolicyNameIgnoreCase(policyName);
            if (retPolicy == null) {
                return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).cacheControl(noCache)).build();
            }
            org.nhindirect.config.model.CertPolicy modelPolicy = EntityModelConversion.toModelCertPolicy(retPolicy);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.OK).cacheControl(noCache)).body((Object)Mono.just((Object)modelPolicy));
        }
        catch (Throwable e) {
            log.error((Object)"Error looking up cert policy", e);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).cacheControl(noCache)).build();
        }
    }

    @PutMapping(consumes={"application/json"})
    public ResponseEntity<Mono<Void>> addPolicy(@RequestBody org.nhindirect.config.model.CertPolicy policy) {
        try {
            if (this.policyRepo.findByPolicyNameIgnoreCase(policy.getPolicyName()) != null) {
                return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.CONFLICT).cacheControl(noCache)).build();
            }
        }
        catch (Exception e) {
            log.error((Object)"Error looking up cert policy.", (Throwable)e);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).cacheControl(noCache)).build();
        }
        try {
            CertPolicy entityPolicy = EntityModelConversion.toEntityCertPolicy(policy);
            this.policyRepo.save((Object)entityPolicy);
            URI uri = new UriTemplate("/{certpolicy}").expand(new Object[]{"certpolicy/" + policy.getPolicyName()});
            return ((ResponseEntity.BodyBuilder)ResponseEntity.created((URI)uri).cacheControl(noCache)).build();
        }
        catch (Exception e) {
            log.error((Object)"Error adding trust cert policy.", (Throwable)e);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).cacheControl(noCache)).build();
        }
    }

    @DeleteMapping(value={"{policyName}"})
    public ResponseEntity<Mono<Void>> removePolicyByName(@PathVariable(value="policyName") String policyName) {
        CertPolicy enitityPolicy = null;
        try {
            enitityPolicy = this.policyRepo.findByPolicyNameIgnoreCase(policyName);
            if (enitityPolicy == null) {
                return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).cacheControl(noCache)).build();
            }
        }
        catch (Exception e) {
            log.error((Object)"Error looking up existing cert policy.", (Throwable)e);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).cacheControl(noCache)).build();
        }
        HashMap<CertPolicyGroupUse, String> usesToRemove = new HashMap<CertPolicyGroupUse, String>();
        try (StatelessSession session = ((Session)this.entityManager.getDelegate()).getSessionFactory().openStatelessSession();){
            Criteria criteria = session.createCriteria(CertPolicyGroupReltn.class).setCacheable(false).setFetchSize(1000).setResultTransformer(CriteriaSpecification.DISTINCT_ROOT_ENTITY);
            ScrollableResults results = criteria.scroll(ScrollMode.FORWARD_ONLY);
            while (results.next()) {
                CertPolicyGroupReltn reltn = (CertPolicyGroupReltn)results.get(0);
                if (!reltn.getCertPolicy().getPolicyName().equals(policyName)) continue;
                CertPolicyGroupUse use2 = new CertPolicyGroupUse();
                use2.setPolicy(EntityModelConversion.toModelCertPolicy(reltn.getCertPolicy()));
                if (reltn.getPolicyUse() != null) {
                    use2.setPolicyUse(org.nhindirect.config.model.CertPolicyUse.valueOf((String)reltn.getPolicyUse().toString()));
                }
                use2.setIncoming(reltn.isIncoming());
                use2.setOutgoing(reltn.isOutgoing());
                usesToRemove.put(use2, reltn.getCertPolicyGroup().getPolicyGroupName());
            }
        }
        usesToRemove.forEach((use, groupName) -> this.transactionalThisProxy.removedPolicyUseFromGroup((String)groupName, (CertPolicyGroupUse)use));
        try {
            this.policyRepo.deleteById((Object)enitityPolicy.getId());
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.OK).cacheControl(noCache)).build();
        }
        catch (Exception e) {
            log.error((Object)"Error deleting cert policy.", (Throwable)e);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).cacheControl(noCache)).build();
        }
    }

    @PostMapping(value={"{policyName}/policyAttributes"}, consumes={"application/json"})
    public ResponseEntity<Mono<Void>> updatePolicyAttributes(@PathVariable(value="policyName") String policyName, @RequestBody org.nhindirect.config.model.CertPolicy policyData) {
        CertPolicy entityPolicy;
        try {
            entityPolicy = this.policyRepo.findByPolicyNameIgnoreCase(policyName);
            if (entityPolicy == null) {
                return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).cacheControl(noCache)).build();
            }
        }
        catch (Exception e) {
            log.error((Object)"Error looking up cert policy.", (Throwable)e);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).cacheControl(noCache)).build();
        }
        try {
            if (policyData.getPolicyData() != null && policyData.getPolicyData().length > 0) {
                entityPolicy.setPolicyData(policyData.getPolicyData());
            }
            if (!StringUtils.isEmpty((CharSequence)policyData.getPolicyName())) {
                entityPolicy.setPolicyName(policyData.getPolicyName());
            }
            if (policyData.getLexicon() != null) {
                entityPolicy.setLexicon(policyData.getLexicon());
            }
            this.policyRepo.save((Object)entityPolicy);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.NO_CONTENT).cacheControl(noCache)).build();
        }
        catch (Exception e) {
            log.error((Object)"Error updating cert policy attributes.", (Throwable)e);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).cacheControl(noCache)).build();
        }
    }

    @GetMapping(value={"groups"}, produces={"application/json"})
    @Transactional(readOnly=true)
    public ResponseEntity<Flux<CertPolicyGroup>> getPolicyGroups() {
        try {
            Collection retGroups = this.groupRepo.findAll().stream().map(group -> EntityModelConversion.toModelCertPolicyGroup(group)).collect(Collectors.toList());
            Flux retVal = Flux.fromIterable((Iterable)retGroups);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.OK).cacheControl(noCache)).body((Object)retVal);
        }
        catch (Exception e) {
            log.error((Object)"Error looking up cert policy groups.", (Throwable)e);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).cacheControl(noCache)).build();
        }
    }

    @GetMapping(value={"groups/{groupName}"}, produces={"application/json"})
    @Transactional(readOnly=true)
    public ResponseEntity<Mono<CertPolicyGroup>> getPolicyGroupByName(@PathVariable(value="groupName") String groupName) {
        try {
            org.nhindirect.config.store.CertPolicyGroup retGroup = this.groupRepo.findByPolicyGroupNameIgnoreCase(groupName);
            if (retGroup == null) {
                return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).cacheControl(noCache)).build();
            }
            CertPolicyGroup modelGroup = EntityModelConversion.toModelCertPolicyGroup(retGroup);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.OK).cacheControl(noCache)).body((Object)Mono.just((Object)modelGroup));
        }
        catch (Throwable e) {
            log.error((Object)"Error looking up cert policy group", e);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).cacheControl(noCache)).build();
        }
    }

    @PutMapping(value={"groups"}, consumes={"application/json"})
    public ResponseEntity<Mono<Void>> addPolicyGroup(@RequestBody CertPolicyGroup group) {
        try {
            if (this.groupRepo.findByPolicyGroupNameIgnoreCase(group.getPolicyGroupName()) != null) {
                return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.CONFLICT).cacheControl(noCache)).build();
            }
        }
        catch (Exception e) {
            log.error((Object)"Error looking up cert policy group.", (Throwable)e);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).cacheControl(noCache)).build();
        }
        try {
            org.nhindirect.config.store.CertPolicyGroup entityGroup = EntityModelConversion.toEntityCertPolicyGroup(group);
            this.groupRepo.save((Object)entityGroup);
            URI uri = new UriTemplate("/{certpolicy}").expand(new Object[]{"certpolicy/group+/" + group.getPolicyGroupName()});
            return ((ResponseEntity.BodyBuilder)ResponseEntity.created((URI)uri).cacheControl(noCache)).build();
        }
        catch (Exception e) {
            log.error((Object)"Error adding trust cert policy group.", (Throwable)e);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).cacheControl(noCache)).build();
        }
    }

    @DeleteMapping(value={"groups/{groupName}"})
    public ResponseEntity<Mono<Void>> removePolicyGroupByName(@PathVariable(value="groupName") String groupName) {
        org.nhindirect.config.store.CertPolicyGroup enitityGroup = null;
        try {
            enitityGroup = this.groupRepo.findByPolicyGroupNameIgnoreCase(groupName);
            if (enitityGroup == null) {
                return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).cacheControl(noCache)).build();
            }
        }
        catch (Exception e) {
            log.error((Object)"Error looking up existing cert policy group.", (Throwable)e);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).cacheControl(noCache)).build();
        }
        try {
            this.groupRepo.deleteById((Object)enitityGroup.getId());
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.OK).cacheControl(noCache)).build();
        }
        catch (Exception e) {
            log.error((Object)"Error deleting cert policy group.", (Throwable)e);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).cacheControl(noCache)).build();
        }
    }

    @PostMapping(value={"groups/{groupName}/groupAttributes"}, consumes={"application/json"})
    public ResponseEntity<Mono<Void>> updateGroupAttributes(@PathVariable(value="groupName") String groupName, @RequestBody String newGroupName) {
        org.nhindirect.config.store.CertPolicyGroup entityGroup;
        try {
            entityGroup = this.groupRepo.findByPolicyGroupNameIgnoreCase(groupName);
            if (entityGroup == null) {
                return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).cacheControl(noCache)).build();
            }
        }
        catch (Exception e) {
            log.error((Object)"Error looking up cert policy group.", (Throwable)e);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).cacheControl(noCache)).build();
        }
        try {
            if (!StringUtils.isEmpty((CharSequence)newGroupName)) {
                entityGroup.setPolicyGroupName(newGroupName);
            }
            this.groupRepo.save((Object)entityGroup);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.NO_CONTENT).cacheControl(noCache)).build();
        }
        catch (Exception e) {
            log.error((Object)"Error updating cert policy group attributes.", (Throwable)e);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).cacheControl(noCache)).build();
        }
    }

    @PostMapping(value={"groups/uses/{group}"}, consumes={"application/json"})
    @Transactional
    public ResponseEntity<Mono<Void>> addPolicyUseToGroup(@PathVariable(value="group") String groupName, @RequestBody CertPolicyGroupUse use) {
        CertPolicy entityPolicy;
        org.nhindirect.config.store.CertPolicyGroup entityGroup;
        try {
            entityGroup = this.groupRepo.findByPolicyGroupNameIgnoreCase(groupName);
            if (entityGroup == null) {
                return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).cacheControl(noCache)).build();
            }
        }
        catch (Exception e) {
            log.error((Object)"Error looking up policy group.", (Throwable)e);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).cacheControl(noCache)).build();
        }
        try {
            entityPolicy = this.policyRepo.findByPolicyNameIgnoreCase(use.getPolicy().getPolicyName());
            if (entityPolicy == null) {
                return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).cacheControl(noCache)).build();
            }
        }
        catch (Exception e) {
            log.error((Object)"Error looking up policy.", (Throwable)e);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).cacheControl(noCache)).build();
        }
        try {
            CertPolicyGroupReltn reltn = new CertPolicyGroupReltn();
            reltn.setCertPolicy(entityPolicy);
            reltn.setCertPolicyGroup(entityGroup);
            reltn.setPolicyUse(CertPolicyUse.valueOf((String)use.getPolicyUse().toString()));
            reltn.setIncoming(use.isIncoming());
            reltn.setOutgoing(use.isOutgoing());
            entityGroup.getCertPolicyGroupReltn().add(reltn);
            this.groupRepo.save((Object)entityGroup);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.NO_CONTENT).cacheControl(noCache)).build();
        }
        catch (Exception e) {
            log.error((Object)"Error adding cert policy to group.", (Throwable)e);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).cacheControl(noCache)).build();
        }
    }

    @PostMapping(value={"groups/uses/{group}/removePolicy"}, consumes={"application/json"})
    @Transactional
    public ResponseEntity<Mono<Void>> removedPolicyUseFromGroup(@PathVariable(value="group") String groupName, @RequestBody CertPolicyGroupUse use) {
        org.nhindirect.config.store.CertPolicyGroup entityGroup;
        try {
            entityGroup = this.groupRepo.findByPolicyGroupNameIgnoreCase(groupName);
            if (entityGroup == null) {
                return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).cacheControl(noCache)).build();
            }
        }
        catch (Exception e) {
            log.error((Object)"Error looking up policy group.", (Throwable)e);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).cacheControl(noCache)).build();
        }
        CertPolicyUse entityUse = CertPolicyUse.valueOf((String)use.getPolicyUse().toString());
        CertPolicyGroupReltn foundReltn = null;
        if (entityGroup.getCertPolicyGroupReltn() != null) {
            for (CertPolicyGroupReltn groupReltn : entityGroup.getCertPolicyGroupReltn()) {
                if (!groupReltn.getCertPolicy().getPolicyName().equals(use.getPolicy().getPolicyName()) || groupReltn.isIncoming() != use.isIncoming() || groupReltn.isOutgoing() != use.isOutgoing() || groupReltn.getPolicyUse() != entityUse) continue;
                foundReltn = groupReltn;
                break;
            }
        }
        if (foundReltn == null) {
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).cacheControl(noCache)).build();
        }
        entityGroup.getCertPolicyGroupReltn().remove(foundReltn);
        try {
            this.groupRepo.save((Object)entityGroup);
        }
        catch (Exception e) {
            log.error((Object)"Error removing cert policy from group.", (Throwable)e);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).cacheControl(noCache)).build();
        }
        return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.OK).cacheControl(noCache)).build();
    }

    @GetMapping(value={"/groups/domain"}, produces={"application/json"})
    @Transactional(readOnly=true)
    public ResponseEntity<Flux<CertPolicyGroupDomainReltn>> getPolicyGroupDomainReltns() {
        try {
            Collection retReltns = this.reltnRepo.findAll().stream().map(reltn -> EntityModelConversion.toModelCertPolicyGroupDomainReltn(reltn)).collect(Collectors.toList());
            Flux retVal = Flux.fromIterable((Iterable)retReltns);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.OK).cacheControl(noCache)).body((Object)retVal);
        }
        catch (Exception e) {
            log.error((Object)"Error looking up policy group/domain relations.", (Throwable)e);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).cacheControl(noCache)).build();
        }
    }

    @GetMapping(value={"groups/domain/{domain}"}, produces={"application/json"})
    @Transactional(readOnly=true)
    public ResponseEntity<Flux<CertPolicyGroup>> getPolicyGroupsByDomain(@PathVariable(value="domain") String domainName) {
        Domain entityDomain;
        try {
            entityDomain = this.domainRepo.findByDomainNameIgnoreCase(domainName);
            if (entityDomain == null) {
                return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).cacheControl(noCache)).build();
            }
        }
        catch (Exception e) {
            log.error((Object)"Error looking up domain.", (Throwable)e);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).cacheControl(noCache)).build();
        }
        try {
            Collection retReltns = this.reltnRepo.findByDomain(entityDomain).stream().map(reltn -> EntityModelConversion.toModelCertPolicyGroup(reltn.getCertPolicyGroup())).collect(Collectors.toList());
            Flux retVal = Flux.fromIterable((Iterable)retReltns);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.OK).cacheControl(noCache)).body((Object)retVal);
        }
        catch (Exception e) {
            log.error((Object)"Error looking up cert policy groups.", (Throwable)e);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).cacheControl(noCache)).build();
        }
    }

    @PostMapping(value={"groups/domain/{group}/{domain}"})
    public ResponseEntity<Mono<Void>> associatePolicyGroupToDomain(@PathVariable(value="group") String groupName, @PathVariable(value="domain") String domainName) {
        Domain entityDomain;
        org.nhindirect.config.store.CertPolicyGroup entityGroup;
        try {
            entityGroup = this.groupRepo.findByPolicyGroupNameIgnoreCase(groupName);
            if (entityGroup == null) {
                return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).cacheControl(noCache)).build();
            }
        }
        catch (Exception e) {
            log.error((Object)"Error looking up policy group.", (Throwable)e);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).cacheControl(noCache)).build();
        }
        try {
            entityDomain = this.domainRepo.findByDomainNameIgnoreCase(domainName);
            if (entityDomain == null) {
                return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).cacheControl(noCache)).build();
            }
        }
        catch (Exception e) {
            log.error((Object)"Error looking up domain.", (Throwable)e);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).cacheControl(noCache)).build();
        }
        try {
            org.nhindirect.config.store.CertPolicyGroupDomainReltn policyGroupDomainAssoc = new org.nhindirect.config.store.CertPolicyGroupDomainReltn();
            policyGroupDomainAssoc.setDomain(entityDomain);
            policyGroupDomainAssoc.setCertPolicyGroup(entityGroup);
            this.reltnRepo.save((Object)policyGroupDomainAssoc);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.NO_CONTENT).cacheControl(noCache)).build();
        }
        catch (Exception e) {
            log.error((Object)"Error associating policy group to domain.", (Throwable)e);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).cacheControl(noCache)).build();
        }
    }

    @DeleteMapping(value={"groups/domain/{group}/{domain}"})
    public ResponseEntity<Mono<Void>> disassociatePolicyGroupFromDomain(@PathVariable(value="group") String groupName, @PathVariable(value="domain") String domainName) {
        Domain entityDomain;
        org.nhindirect.config.store.CertPolicyGroup entityGroup;
        try {
            entityGroup = this.groupRepo.findByPolicyGroupNameIgnoreCase(groupName);
            if (entityGroup == null) {
                return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).cacheControl(noCache)).build();
            }
        }
        catch (Exception e) {
            log.error((Object)"Error looking up policy group.", (Throwable)e);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).cacheControl(noCache)).build();
        }
        try {
            entityDomain = this.domainRepo.findByDomainNameIgnoreCase(domainName);
            if (entityDomain == null) {
                return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).cacheControl(noCache)).build();
            }
        }
        catch (Exception e) {
            log.error((Object)"Error looking up domain.", (Throwable)e);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).cacheControl(noCache)).build();
        }
        try {
            this.reltnRepo.deleteByDomainAndCertPolicyGroup(entityDomain, entityGroup);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.OK).cacheControl(noCache)).build();
        }
        catch (Exception e) {
            log.error((Object)"Error disassociating policy group from domain.", (Throwable)e);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).cacheControl(noCache)).build();
        }
    }

    @DeleteMapping(value={"groups/domain/{domain}/deleteFromDomain"})
    @Transactional
    public ResponseEntity<Mono<Void>> disassociatePolicyGroupsFromDomain(@PathVariable(value="domain") String domainName) {
        Domain entityDomain;
        try {
            entityDomain = this.domainRepo.findByDomainNameIgnoreCase(domainName);
            if (entityDomain == null) {
                return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).cacheControl(noCache)).build();
            }
        }
        catch (Exception e) {
            log.error((Object)"Error looking up domain.", (Throwable)e);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).cacheControl(noCache)).build();
        }
        try {
            this.reltnRepo.deleteByDomain(entityDomain);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.OK).cacheControl(noCache)).build();
        }
        catch (Exception e) {
            log.error((Object)"Error disassociating policy groups from domain.", (Throwable)e);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).cacheControl(noCache)).build();
        }
    }

    @DeleteMapping(value={"groups/domain/{group}/deleteFromGroup"})
    public ResponseEntity<Mono<Void>> disassociatePolicyGroupFromDomains(@PathVariable(value="group") String groupName) {
        org.nhindirect.config.store.CertPolicyGroup entityGroup;
        try {
            entityGroup = this.groupRepo.findByPolicyGroupNameIgnoreCase(groupName);
            if (entityGroup == null) {
                return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).cacheControl(noCache)).build();
            }
        }
        catch (Exception e) {
            log.error((Object)"Error looking up policy group.", (Throwable)e);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).cacheControl(noCache)).build();
        }
        try {
            this.reltnRepo.deleteByCertPolicyGroup(entityGroup);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.OK).cacheControl(noCache)).build();
        }
        catch (Exception e) {
            log.error((Object)"Error disassociating policy groups from domain.", (Throwable)e);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).cacheControl(noCache)).build();
        }
    }
}

