/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.processor.impl;

import java.util.Calendar;
import java.util.List;
import org.apache.camel.Handler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nhindirect.config.processor.BundleCacheUpdateProcessor;
import org.nhindirect.config.processor.BundleRefreshProcessor;
import org.nhindirect.config.repository.TrustBundleRepository;
import org.nhindirect.config.store.TrustBundle;

public class DefaultBundleCacheUpdateProcessorImpl
implements BundleCacheUpdateProcessor {
    private static final Log log = LogFactory.getLog(DefaultBundleCacheUpdateProcessorImpl.class);
    protected TrustBundleRepository bundleRepo;
    protected BundleRefreshProcessor refreshProcessor;

    public void setRepository(TrustBundleRepository bundleRepo) {
        this.bundleRepo = bundleRepo;
    }

    public void setRefreshProcessor(BundleRefreshProcessor refreshProcessor) {
        this.refreshProcessor = refreshProcessor;
    }

    @Override
    @Handler
    public void updateBundleCache() {
        try {
            List bundles = this.bundleRepo.findAll();
            for (TrustBundle bundle : bundles) {
                boolean refresh = false;
                if (bundle.getRefreshInterval() <= 0) continue;
                Calendar lastAttempt = bundle.getLastSuccessfulRefresh();
                if (lastAttempt == null) {
                    refresh = true;
                } else {
                    long now = System.currentTimeMillis();
                    Calendar lastAttemptCheck = (Calendar)lastAttempt.clone();
                    lastAttemptCheck.add(13, bundle.getRefreshInterval());
                    if (lastAttemptCheck.getTimeInMillis() <= now) {
                        refresh = true;
                    }
                }
                if (!refresh) continue;
                try {
                    this.refreshProcessor.refreshBundle(bundle);
                }
                catch (Exception e) {
                    log.warn((Object)("Failed to check the status of bundle " + bundle.getBundleName()), (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            log.warn((Object)"Failed to check the status of trust bundles ", (Throwable)e);
        }
    }
}

