/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.resources;

import java.net.URI;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nhindirect.common.cert.Thumbprint;
import org.nhindirect.common.crypto.KeyStoreProtectionManager;
import org.nhindirect.config.model.Certificate;
import org.nhindirect.config.model.utils.CertUtils;
import org.nhindirect.config.repository.CertificateRepository;
import org.nhindirect.config.resources.ProtectedResource;
import org.nhindirect.config.resources.util.EntityModelConversion;
import org.nhindirect.config.store.util.CertificateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.util.UriTemplate;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@RestController
@RequestMapping(value={"certificate"})
public class CertificateResource
extends ProtectedResource {
    private static final Log log = LogFactory.getLog(CertificateResource.class);
    protected CertificateRepository certRepo;
    private KeyStoreProtectionManager kspMgr;

    @Autowired
    public void setCertificateRepository(CertificateRepository certRepo) {
        this.certRepo = certRepo;
    }

    @Autowired(required=false)
    public void setKeyStoreProtectionMgr(KeyStoreProtectionManager kspMgr) {
        this.kspMgr = kspMgr;
    }

    @GetMapping(produces={"application/json"})
    public ResponseEntity<Flux<Certificate>> getAllCertificates() {
        return this.getCertificatesByOwner(null);
    }

    @GetMapping(value={"/{owner}"}, produces={"application/json"})
    public ResponseEntity<Flux<Certificate>> getCertificatesByOwner(@PathVariable(value="owner") String owner) {
        try {
            List retCertificates = StringUtils.isEmpty((CharSequence)owner) ? this.certRepo.findAll() : this.certRepo.findByOwnerIgnoreCase(owner);
            Flux retVal = Flux.fromStream(retCertificates.stream().map(cert -> {
                CertificateUtils.stripP12Protection((org.nhindirect.config.store.Certificate)cert, (KeyStoreProtectionManager)this.kspMgr);
                return EntityModelConversion.toModelCertificate(cert);
            }));
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.OK).cacheControl(noCache)).body((Object)retVal);
        }
        catch (Exception e) {
            log.error((Object)"Error looking up certificates.", (Throwable)e);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).cacheControl(noCache)).build();
        }
    }

    @GetMapping(value={"/{owner}/{thumbprint}"}, produces={"application/json"})
    public ResponseEntity<Mono<Certificate>> getCertificatesByOwnerAndThumbprint(@PathVariable(value="owner") String owner, @PathVariable(value="thumbprint") String thumbprint) {
        org.nhindirect.config.store.Certificate retCertificate = null;
        List<org.nhindirect.config.store.Certificate> retCertificates = null;
        try {
            if (StringUtils.isEmpty((CharSequence)owner) && StringUtils.isEmpty((CharSequence)thumbprint)) {
                retCertificates = this.certRepo.findAll();
            } else if (!StringUtils.isEmpty((CharSequence)owner) && StringUtils.isEmpty((CharSequence)thumbprint)) {
                retCertificates = this.certRepo.findByOwnerIgnoreCase(owner);
            } else if (StringUtils.isEmpty((CharSequence)owner) && !StringUtils.isEmpty((CharSequence)thumbprint)) {
                retCertificates = this.certRepo.findByThumbprint(thumbprint);
            } else {
                retCertificates = new ArrayList();
                List potentialCerts = this.certRepo.findByOwnerIgnoreCase(owner);
                if (!potentialCerts.isEmpty()) {
                    Iterator iterator = potentialCerts.iterator();
                    while (iterator.hasNext()) {
                        org.nhindirect.config.store.Certificate cert = (org.nhindirect.config.store.Certificate)iterator.next();
                        if (!cert.getThumbprint().equals(thumbprint)) continue;
                        retCertificates.add(cert);
                    }
                }
            }
            if (retCertificates == null || retCertificates.isEmpty()) {
                return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).cacheControl(noCache)).build();
            }
            for (org.nhindirect.config.store.Certificate cert : retCertificates) {
                CertificateUtils.stripP12Protection((org.nhindirect.config.store.Certificate)cert, (KeyStoreProtectionManager)this.kspMgr);
            }
            retCertificate = (org.nhindirect.config.store.Certificate)retCertificates.iterator().next();
        }
        catch (Exception e) {
            log.error((Object)"Error looking up certificate.", (Throwable)e);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).cacheControl(noCache)).build();
        }
        return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.OK).cacheControl(noCache)).body((Object)Mono.just((Object)EntityModelConversion.toModelCertificate(retCertificate)));
    }

    @PutMapping(consumes={"application/json"})
    public ResponseEntity<Mono<Void>> addCertificate(@RequestBody Certificate cert) {
        String theOwner;
        CertUtils.CertContainer cont = null;
        cont = CertUtils.toCertContainer((byte[])cert.getData());
        if ((cert.getOwner() == null || cert.getOwner().isEmpty()) && cont != null && cont.getCert() != null && (theOwner = CertUtils.getOwner((X509Certificate)cont.getCert())) != null && !theOwner.isEmpty()) {
            cert.setOwner(theOwner);
        }
        try {
            if (this.certRepo.findByOwnerIgnoreCaseAndThumbprint(cert.getOwner(), Thumbprint.toThumbprint((X509Certificate)cont.getCert()).toString()) != null) {
                return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.CONFLICT).cacheControl(noCache)).build();
            }
        }
        catch (Exception e) {
            log.error((Object)"Error looking up certificate.", (Throwable)e);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).cacheControl(noCache)).build();
        }
        try {
            org.nhindirect.config.store.Certificate entCert = EntityModelConversion.toEntityCertificate(cert);
            entCert = CertificateUtils.applyCertRepositoryAttributes((org.nhindirect.config.store.Certificate)entCert, (KeyStoreProtectionManager)this.kspMgr);
            this.certRepo.save((Object)entCert);
            URI uri = new UriTemplate("/{certificate}").expand(new Object[]{"certificate/" + entCert.getOwner()});
            return ((ResponseEntity.BodyBuilder)ResponseEntity.created((URI)uri).cacheControl(noCache)).build();
        }
        catch (Exception e) {
            log.error((Object)"Error adding certificate.", (Throwable)e);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).cacheControl(noCache)).build();
        }
    }

    @DeleteMapping(value={"ids/{ids}"})
    public ResponseEntity<Mono<Void>> removeCertificatesByIds(@PathVariable(value="ids") String ids) {
        String[] idArray = ids.split(",");
        ArrayList<Long> idList = new ArrayList<Long>();
        try {
            for (String id : idArray) {
                idList.add(Long.parseLong(id));
            }
            this.certRepo.deleteByIdIn(idList);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.OK).cacheControl(noCache)).build();
        }
        catch (Exception e) {
            log.error((Object)"Error removing certificates by ids.", (Throwable)e);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).cacheControl(noCache)).build();
        }
    }

    @DeleteMapping(value={"{owner}"})
    public ResponseEntity<Mono<Void>> removeCertificatesByOwner(@PathVariable(value="owner") String owner) {
        try {
            this.certRepo.deleteByOwnerIgnoreCase(owner);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.OK).cacheControl(noCache)).build();
        }
        catch (Exception e) {
            log.error((Object)"Error removing certificates by owner.", (Throwable)e);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).cacheControl(noCache)).build();
        }
    }
}

