/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.resources;

import java.net.URI;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nhindirect.config.model.Domain;
import org.nhindirect.config.repository.AddressRepository;
import org.nhindirect.config.repository.DomainRepository;
import org.nhindirect.config.resources.ProtectedResource;
import org.nhindirect.config.resources.TrustBundleResource;
import org.nhindirect.config.resources.util.EntityModelConversion;
import org.nhindirect.config.store.Address;
import org.nhindirect.config.store.EntityStatus;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.util.UriTemplate;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@RestController
@RequestMapping(value={"domain"})
public class DomainResource
extends ProtectedResource {
    private static final Log log = LogFactory.getLog(DomainResource.class);
    protected TrustBundleResource bundleResource;
    protected AddressRepository addRepo;
    protected DomainRepository domainRepo;

    @Autowired
    public void setAddressRepository(AddressRepository addRepo) {
        this.addRepo = addRepo;
    }

    @Autowired
    public void setDomainRepository(DomainRepository domainRepo) {
        this.domainRepo = domainRepo;
    }

    @Autowired
    public void setAddressResource(TrustBundleResource bundleResource) {
        this.bundleResource = bundleResource;
    }

    @GetMapping(value={"{domain}"}, produces={"application/json"})
    @Transactional(readOnly=true)
    public ResponseEntity<Mono<Domain>> getDomain(@PathVariable(value="domain") String domain) {
        try {
            org.nhindirect.config.store.Domain retDomain = this.domainRepo.findByDomainNameIgnoreCase(domain);
            if (retDomain == null) {
                return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).cacheControl(noCache)).build();
            }
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.OK).cacheControl(noCache)).body((Object)Mono.just((Object)EntityModelConversion.toModelDomain(retDomain)));
        }
        catch (Exception e) {
            log.error((Object)"Error looking up domain.", (Throwable)e);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).cacheControl(noCache)).build();
        }
    }

    @GetMapping(produces={"application/json"})
    @Transactional(readOnly=true)
    public ResponseEntity<Flux<Domain>> searchDomains(@RequestParam(name="domainName", defaultValue="") String domainName, @RequestParam(name="entityStatus", defaultValue="") String entityStatus) {
        EntityStatus status = null;
        if (!entityStatus.isEmpty()) {
            try {
                status = EntityStatus.valueOf((String)entityStatus);
            }
            catch (IllegalArgumentException e) {
                log.warn((Object)("EntityStatus enum value of " + entityStatus + " encountered.  Defaulting EntityStatus to null"));
            }
        }
        domainName = StringUtils.remove((String)domainName, (char)'*');
        try {
            List domains = null;
            domains = status == null && domainName.isEmpty() ? this.domainRepo.findAll() : (status == null ? this.domainRepo.findByDomainNameContainingIgnoreCase(domainName) : (domainName.isEmpty() ? this.domainRepo.findByStatus(status) : this.domainRepo.findByDomainNameContainingIgnoreCaseAndStatus(domainName, status)));
            Flux retVal = Flux.fromStream(domains.stream().map(domain -> EntityModelConversion.toModelDomain(domain)));
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.OK).cacheControl(noCache)).body((Object)retVal);
        }
        catch (Exception e) {
            log.error((Object)"Error looking up domains.", (Throwable)e);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).cacheControl(noCache)).build();
        }
    }

    @PutMapping(consumes={"application/json"})
    public ResponseEntity<Mono<Void>> addDomain(@RequestBody Domain domain) {
        try {
            if (this.domainRepo.findByDomainNameIgnoreCase(domain.getDomainName()) != null) {
                return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.CONFLICT).cacheControl(noCache)).build();
            }
        }
        catch (Exception e) {
            log.error((Object)"Error looking up existing domain.", (Throwable)e);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).cacheControl(noCache)).build();
        }
        org.nhindirect.config.store.Domain toDomain = EntityModelConversion.toEntityDomain(domain);
        try {
            toDomain = (org.nhindirect.config.store.Domain)this.domainRepo.save((Object)toDomain);
            if (domain.getPostmasterAddress() != null) {
                for (Address addr : toDomain.getAddresses()) {
                    if (addr.getEmailAddress().compareToIgnoreCase(domain.getPostmasterAddress().getEmailAddress()) != 0) continue;
                    toDomain.setPostmasterAddressId(addr.getId());
                    this.domainRepo.save((Object)toDomain);
                    break;
                }
            }
            URI uri = new UriTemplate("/{domain}").expand(new Object[]{"domain/" + domain.getDomainName()});
            return ((ResponseEntity.BodyBuilder)ResponseEntity.created((URI)uri).cacheControl(noCache)).build();
        }
        catch (Exception e) {
            log.error((Object)"Error adding domain.", (Throwable)e);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).cacheControl(noCache)).build();
        }
    }

    @PostMapping(consumes={"application/json"})
    public ResponseEntity<Mono<Void>> updateDomain(@RequestBody Domain domain) {
        org.nhindirect.config.store.Domain existingDomain;
        try {
            existingDomain = this.domainRepo.findByDomainNameIgnoreCase(domain.getDomainName());
            if (existingDomain == null) {
                return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).cacheControl(noCache)).build();
            }
        }
        catch (Exception e) {
            log.error((Object)"Error looking up existing domain.", (Throwable)e);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).cacheControl(noCache)).build();
        }
        org.nhindirect.config.store.Domain toDomain = EntityModelConversion.toEntityDomain(domain);
        toDomain.setId(existingDomain.getId());
        if (domain.getPostmasterAddress() != null) {
            for (Address existingAddr : existingDomain.getAddresses()) {
                for (Address newAddr : toDomain.getAddresses()) {
                    if (!existingAddr.getEmailAddress().toLowerCase().equals(newAddr.getEmailAddress().toLowerCase())) continue;
                    newAddr.setId(existingAddr.getId());
                }
                if (domain.getPostmasterAddress() == null || !existingAddr.getEmailAddress().toLowerCase().equals(domain.getPostmasterAddress().getEmailAddress())) continue;
                toDomain.setPostmasterAddressId(existingAddr.getId());
            }
        }
        try {
            this.domainRepo.save((Object)toDomain);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.NO_CONTENT).cacheControl(noCache)).build();
        }
        catch (Exception e) {
            log.error((Object)"Error updating domain.", (Throwable)e);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).cacheControl(noCache)).build();
        }
    }

    @DeleteMapping(value={"{domain}"})
    public ResponseEntity<Mono<Void>> removedDomain(@PathVariable(value="domain") String domain) {
        try {
            if (this.domainRepo.findByDomainNameIgnoreCase(domain) == null) {
                return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).cacheControl(noCache)).build();
            }
        }
        catch (Exception e) {
            log.error((Object)"Error looking up existing domain.", (Throwable)e);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).cacheControl(noCache)).build();
        }
        try {
            this.bundleResource.disassociateTrustBundlesFromDomain(domain);
            this.domainRepo.deleteByDomainNameIgnoreCase(domain);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.OK).cacheControl(noCache)).build();
        }
        catch (Exception e) {
            log.error((Object)"Error deleting domain.", (Throwable)e);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).cacheControl(noCache)).build();
        }
    }
}

