/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.processor.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLConnection;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.camel.Handler;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.jcajce.JcaSimpleSignerInfoVerifierBuilder;
import org.nhindirect.common.crypto.CryptoExtensions;
import org.nhindirect.common.options.OptionsManager;
import org.nhindirect.common.options.OptionsParameter;
import org.nhindirect.config.processor.BundleRefreshProcessor;
import org.nhindirect.config.repository.TrustBundleRepository;
import org.nhindirect.config.store.BundleRefreshError;
import org.nhindirect.config.store.BundleThumbprint;
import org.nhindirect.config.store.TrustBundle;
import org.nhindirect.config.store.TrustBundleAnchor;

public class DefaultBundleRefreshProcessorImpl
implements BundleRefreshProcessor {
    public static final String BUNDLE_REFRESH_PROCESSOR_ALLOW_DOWNLOAD_FROM_UNTRUSTED = "BUNDLE_REFRESH_PROCESSOR_ALLOW_DOWNLOAD_FROM_UNTRUSTED";
    protected static final int DEFAULT_URL_CONNECTION_TIMEOUT = 10000;
    protected static final int DEFAULT_URL_READ_TIMEOUT = 10000;
    private static final Log log = LogFactory.getLog(DefaultBundleRefreshProcessorImpl.class);
    protected TrustBundleRepository bundleRepo;

    public static synchronized void initJVMParams() {
        HashMap<String, String> JVM_PARAMS = new HashMap<String, String>();
        JVM_PARAMS.put(BUNDLE_REFRESH_PROCESSOR_ALLOW_DOWNLOAD_FROM_UNTRUSTED, "org.nhindirect.config.processor.impl.bundlerefresh.AllowNonVerifiedSSL");
        OptionsManager.addInitParameters(JVM_PARAMS);
    }

    public DefaultBundleRefreshProcessorImpl() {
        OptionsParameter allowNonVerSSLParam = OptionsManager.getInstance().getParameter(BUNDLE_REFRESH_PROCESSOR_ALLOW_DOWNLOAD_FROM_UNTRUSTED);
        if (OptionsParameter.getParamValueAsBoolean((OptionsParameter)allowNonVerSSLParam, (boolean)false)) {
            try {
                TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                    @Override
                    public X509Certificate[] getAcceptedIssuers() {
                        return null;
                    }

                    @Override
                    public void checkClientTrusted(X509Certificate[] certs, String authType) {
                    }

                    @Override
                    public void checkServerTrusted(X509Certificate[] certs, String authType) {
                    }
                }};
                SSLContext sc = SSLContext.getInstance("SSL");
                sc.init(null, trustAllCerts, new SecureRandom());
                HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
                HostnameVerifier allHostsValid = new HostnameVerifier(){

                    @Override
                    public boolean verify(String hostname, SSLSession session) {
                        return true;
                    }
                };
                HttpsURLConnection.setDefaultHostnameVerifier(allHostsValid);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void setRepository(TrustBundleRepository bundleRepo) {
        this.bundleRepo = bundleRepo;
    }

    @Override
    @Handler
    public void refreshBundle(TrustBundle bundle) {
        Calendar processAttempStart = Calendar.getInstance(Locale.getDefault());
        byte[] rawBundle = this.downloadBundleToByteArray(bundle, processAttempStart);
        if (rawBundle == null) {
            return;
        }
        boolean update = false;
        String checkSum = "";
        if (bundle.getCheckSum() == null) {
            update = true;
        } else {
            try {
                checkSum = BundleThumbprint.toThumbprint((byte[])rawBundle).toString();
                update = !bundle.getCheckSum().equals(BundleThumbprint.toThumbprint((byte[])rawBundle).toString());
            }
            catch (NoSuchAlgorithmException ex) {
                bundle.setLastRefreshAttempt(processAttempStart);
                bundle.setLastRefreshError(BundleRefreshError.INVALID_BUNDLE_FORMAT);
                this.bundleRepo.save((Object)bundle);
                log.error((Object)"Failed to generate downloaded bundle thumbprint ", (Throwable)ex);
            }
        }
        if (!update) {
            bundle.setLastRefreshAttempt(processAttempStart);
            bundle.setLastRefreshError(BundleRefreshError.SUCCESS);
            this.bundleRepo.save((Object)bundle);
            return;
        }
        Collection<X509Certificate> bundleCerts = this.convertRawBundleToAnchorCollection(rawBundle, bundle, processAttempStart);
        if (bundleCerts == null) {
            return;
        }
        HashSet<X509Certificate> downloadedSet = new HashSet<X509Certificate>(bundleCerts);
        try {
            ArrayList<TrustBundleAnchor> newAnchors = new ArrayList<TrustBundleAnchor>();
            for (X509Certificate downloadedAnchor : downloadedSet) {
                try {
                    TrustBundleAnchor anchorToAdd = new TrustBundleAnchor();
                    anchorToAdd.setData(downloadedAnchor.getEncoded());
                    anchorToAdd.setTrustBundle(bundle);
                    newAnchors.add(anchorToAdd);
                }
                catch (Exception e) {
                    log.warn((Object)"Failed to convert downloaded anchor to byte array. ", (Throwable)e);
                }
            }
            bundle.setTrustBundleAnchors(newAnchors);
            bundle.setLastRefreshAttempt(processAttempStart);
            bundle.setLastRefreshError(BundleRefreshError.SUCCESS);
            bundle.setCheckSum(checkSum);
            bundle.setLastSuccessfulRefresh(Calendar.getInstance());
            this.bundleRepo.save((Object)bundle);
        }
        catch (Exception e) {
            bundle.setLastRefreshAttempt(processAttempStart);
            bundle.setLastRefreshError(BundleRefreshError.INVALID_BUNDLE_FORMAT);
            this.bundleRepo.save((Object)bundle);
            log.error((Object)"Failed to write updated bundle anchors to data store ", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected Collection<X509Certificate> convertRawBundleToAnchorCollection(byte[] rawBundle, TrustBundle existingBundle, Calendar processAttempStart) {
        ByteArrayInputStream inStream;
        Collection<? extends Certificate> bundleCerts;
        block16: {
            bundleCerts = null;
            inStream = null;
            try {
                inStream = new ByteArrayInputStream(rawBundle);
                bundleCerts = CertificateFactory.getInstance("X.509").generateCertificates(inStream);
                if (bundleCerts == null || bundleCerts.size() != 0) break block16;
                bundleCerts = null;
            }
            catch (Exception exception) {
                IOUtils.closeQuietly((InputStream)inStream);
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(inStream);
                    throw throwable;
                }
            }
        }
        IOUtils.closeQuietly((InputStream)inStream);
        if (bundleCerts == null) {
            try {
                CMSSignedData signed = new CMSSignedData(rawBundle);
                if (existingBundle.getSigningCertificateData() != null) {
                    boolean sigVerified = false;
                    X509Certificate signingCert = existingBundle.toSigningCertificate();
                    for (SignerInformation sigInfo : signed.getSignerInfos().getSigners()) {
                        try {
                            if (!sigInfo.verify(new JcaSimpleSignerInfoVerifierBuilder().setProvider(CryptoExtensions.getJCEProviderName()).build(signingCert))) continue;
                            sigVerified = true;
                            break;
                        }
                        catch (Exception exception) {
                        }
                    }
                    if (!sigVerified) {
                        existingBundle.setLastRefreshAttempt(processAttempStart);
                        existingBundle.setLastRefreshError(BundleRefreshError.UNMATCHED_SIGNATURE);
                        this.bundleRepo.save((Object)existingBundle);
                        log.warn((Object)"Downloaded bundle signature did not match configured signing certificate.");
                        Iterator iterator = null;
                        return iterator;
                    }
                }
                CMSProcessableByteArray signedContent = (CMSProcessableByteArray)signed.getSignedContent();
                inStream = new ByteArrayInputStream((byte[])signedContent.getContent());
                bundleCerts = CertificateFactory.getInstance("X.509").generateCertificates(inStream);
            }
            catch (Exception e) {
                existingBundle.setLastRefreshAttempt(processAttempStart);
                existingBundle.setLastRefreshError(BundleRefreshError.INVALID_BUNDLE_FORMAT);
                this.bundleRepo.save((Object)existingBundle);
                log.warn((Object)("Failed to extract anchors from downloaded bundle at URL " + existingBundle.getBundleURL()));
            }
            finally {
                IOUtils.closeQuietly((InputStream)inStream);
            }
        }
        return bundleCerts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected byte[] downloadBundleToByteArray(TrustBundle bundle, Calendar processAttempStart) {
        InputStream inputStream = null;
        byte[] retVal = null;
        ByteArrayOutputStream ouStream = new ByteArrayOutputStream();
        try {
            URL certURL = new URL(bundle.getBundleURL());
            URLConnection connection = certURL.openConnection();
            connection.setConnectTimeout(10000);
            connection.setReadTimeout(10000);
            inputStream = connection.getInputStream();
            int BUF_SIZE = 2048;
            int count = 0;
            byte[] buf = new byte[BUF_SIZE];
            while ((count = inputStream.read(buf)) > -1) {
                ouStream.write(buf, 0, count);
            }
            retVal = ouStream.toByteArray();
        }
        catch (SocketTimeoutException e) {
            bundle.setLastRefreshAttempt(processAttempStart);
            bundle.setLastRefreshError(BundleRefreshError.DOWNLOAD_TIMEOUT);
            this.bundleRepo.save((Object)bundle);
            log.warn((Object)("Failed to download bundle from URL " + bundle.getBundleURL()), (Throwable)e);
            IOUtils.closeQuietly((InputStream)inputStream);
            IOUtils.closeQuietly((OutputStream)ouStream);
        }
        catch (Exception e2) {
            bundle.setLastRefreshAttempt(processAttempStart);
            bundle.setLastRefreshError(BundleRefreshError.NOT_FOUND);
            this.bundleRepo.save((Object)bundle);
            log.warn((Object)("Failed to download bundle from URL " + bundle.getBundleURL()), (Throwable)e2);
            {
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(inputStream);
                    IOUtils.closeQuietly((OutputStream)ouStream);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((InputStream)inputStream);
            IOUtils.closeQuietly((OutputStream)ouStream);
        }
        IOUtils.closeQuietly((InputStream)inputStream);
        IOUtils.closeQuietly((OutputStream)ouStream);
        return retVal;
    }

    static {
        DefaultBundleRefreshProcessorImpl.initJVMParams();
        CryptoExtensions.registerJCEProviders();
    }
}

