/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.resources;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nhindirect.config.model.DNSRecord;
import org.nhindirect.config.repository.DNSRepository;
import org.nhindirect.config.resources.ProtectedResource;
import org.nhindirect.config.resources.util.EntityModelConversion;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.util.UriTemplate;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@RestController
@RequestMapping(value={"dns"})
public class DNSResource
extends ProtectedResource {
    private static final Log log = LogFactory.getLog(DNSResource.class);
    protected DNSRepository dnsRepo;

    @Autowired
    public void setDNSRepository(DNSRepository dnsRepo) {
        this.dnsRepo = dnsRepo;
    }

    @GetMapping(produces={"application/json"})
    public ResponseEntity<Flux<DNSRecord>> getDNSRecords(@RequestParam(name="type", defaultValue="-1") int type, @RequestParam(name="name", defaultValue="") String name) {
        try {
            List retRecords;
            if (type > -1 && !name.isEmpty()) {
                retRecords = type == 255 ? this.dnsRepo.findByNameIgnoreCase(name.endsWith(".") ? name : name + ".") : this.dnsRepo.findByNameIgnoreCaseAndType(name.endsWith(".") ? name : name + ".", type);
            } else if (type > -1) {
                retRecords = type == 255 ? this.dnsRepo.findAll() : this.dnsRepo.findByType(type);
            } else if (!name.isEmpty()) {
                retRecords = this.dnsRepo.findByNameIgnoreCase(name.endsWith(".") ? name : name + ".");
            } else {
                log.error((Object)"Either a DNS query name or type (or both) must be specified.");
                return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.BAD_REQUEST).cacheControl(noCache)).build();
            }
            Flux retVal = Flux.fromStream(retRecords.stream().map(record -> EntityModelConversion.toModelDNSRecord(record)));
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.OK).cacheControl(noCache)).body((Object)retVal);
        }
        catch (Exception e) {
            log.error((Object)"Error looking up DNS records.", (Throwable)e);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).cacheControl(noCache)).build();
        }
    }

    @PutMapping(consumes={"application/json"})
    public ResponseEntity<Mono<Void>> addDNSRecord(@RequestBody DNSRecord record) {
        if (record.getType() == 255) {
            log.error((Object)"Cannot add record with type ANY");
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.BAD_REQUEST).cacheControl(noCache)).build();
        }
        if (!record.getName().endsWith(".")) {
            record.setName(record.getName() + ".");
        }
        try {
            List records = this.dnsRepo.findByNameIgnoreCaseAndType(record.getName(), record.getType());
            for (org.nhindirect.config.store.DNSRecord compareRecord : records) {
                if (!Arrays.equals(record.getData(), compareRecord.getData())) continue;
                return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.CONFLICT).cacheControl(noCache)).build();
            }
        }
        catch (Exception e) {
            log.error((Object)"Error looking up DNS records.", (Throwable)e);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).cacheControl(noCache)).build();
        }
        try {
            this.dnsRepo.save((Object)EntityModelConversion.toEntityDNSRecord(record));
            URI uri = new UriTemplate("/dns?{type}&name={name}").expand(new Object[]{record.getType(), record.getName()});
            return ((ResponseEntity.BodyBuilder)ResponseEntity.created((URI)uri).cacheControl(noCache)).build();
        }
        catch (Exception e) {
            log.error((Object)"Error adding DNS record.", (Throwable)e);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).cacheControl(noCache)).build();
        }
    }

    @PostMapping(consumes={"application/json"})
    public ResponseEntity<Mono<Void>> updateDNSRecord(@RequestBody DNSRecord updateRecord) {
        try {
            if (!this.dnsRepo.findById((Object)updateRecord.getId()).isPresent()) {
                return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).cacheControl(noCache)).build();
            }
        }
        catch (Exception e) {
            log.error((Object)"Error looking up DNS records.", (Throwable)e);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).cacheControl(noCache)).build();
        }
        if (!updateRecord.getName().endsWith(".")) {
            updateRecord.setName(updateRecord.getName() + ".");
        }
        try {
            this.dnsRepo.save((Object)EntityModelConversion.toEntityDNSRecord(updateRecord));
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.NO_CONTENT).cacheControl(noCache)).build();
        }
        catch (Exception e) {
            log.error((Object)"Error updating DNS record.", (Throwable)e);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).cacheControl(noCache)).build();
        }
    }

    @DeleteMapping(value={"{ids}"})
    public ResponseEntity<Mono<Void>> removeDNSRecordsByIds(@PathVariable(value="ids") String ids) {
        String[] idArray = ids.split(",");
        ArrayList<Long> idList = new ArrayList<Long>(idArray.length);
        try {
            for (String id : idArray) {
                idList.add(Long.parseLong(id));
            }
            this.dnsRepo.deleteByIdIn(idList);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.OK).cacheControl(noCache)).build();
        }
        catch (Exception e) {
            log.error((Object)"Error removing DNS records by ids.", (Throwable)e);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).cacheControl(noCache)).build();
        }
    }
}

