/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.resources;

import java.net.URI;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.stream.Collectors;
import org.apache.camel.ProducerTemplate;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nhindirect.config.model.exceptions.CertificateConversionException;
import org.nhindirect.config.model.utils.CertUtils;
import org.nhindirect.config.repository.DomainRepository;
import org.nhindirect.config.repository.TrustBundleDomainReltnRepository;
import org.nhindirect.config.repository.TrustBundleRepository;
import org.nhindirect.config.resources.ProtectedResource;
import org.nhindirect.config.resources.util.EntityModelConversion;
import org.nhindirect.config.store.Domain;
import org.nhindirect.config.store.TrustBundle;
import org.nhindirect.config.store.TrustBundleDomainReltn;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.util.UriTemplate;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@RestController
@RequestMapping(value={"trustbundle"})
public class TrustBundleResource
extends ProtectedResource {
    private static final Log log = LogFactory.getLog(TrustBundleResource.class);
    protected TrustBundleRepository bundleRepo;
    protected TrustBundleDomainReltnRepository reltnRepo;
    protected DomainRepository domainRepo;
    protected ProducerTemplate template;

    @Autowired
    public void setTrustBundleRepository(TrustBundleRepository bundleRepo) {
        this.bundleRepo = bundleRepo;
    }

    @Autowired
    public void setTrustBundleDomainReltnRepository(TrustBundleDomainReltnRepository reltnRepo) {
        this.reltnRepo = reltnRepo;
    }

    @Autowired
    public void setDomainRepository(DomainRepository domainRepo) {
        this.domainRepo = domainRepo;
    }

    @Autowired
    @Qualifier(value="bundleRefresh")
    public void setTemplate(ProducerTemplate template) {
        this.template = template;
    }

    @GetMapping(produces={"application/json"})
    @Transactional(readOnly=true)
    public ResponseEntity<Flux<org.nhindirect.config.model.TrustBundle>> getTrustBundles(@RequestParam(name="fetchAnchors", defaultValue="true") boolean fetchAnchors) {
        try {
            Collection retBundles = this.bundleRepo.findAll().stream().map(bundle -> {
                if (!fetchAnchors) {
                    bundle.setTrustBundleAnchors(new ArrayList());
                }
                return EntityModelConversion.toModelTrustBundle(bundle);
            }).collect(Collectors.toList());
            Flux retVal = Flux.fromIterable((Iterable)retBundles);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.OK).cacheControl(noCache)).body((Object)retVal);
        }
        catch (Throwable e) {
            log.error((Object)"Error looking up trust bundles", e);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).cacheControl(noCache)).build();
        }
    }

    @GetMapping(value={"domains/bundles/reltns"}, produces={"application/json"})
    @Transactional(readOnly=true)
    public ResponseEntity<Flux<org.nhindirect.config.model.TrustBundleDomainReltn>> getAllTrustBundleDomainRelts(@RequestParam(name="fetchAnchors", defaultValue="true") boolean fetchAnchors) {
        try {
            Collection retReltns = this.reltnRepo.findAll().stream().map(bundleReltn -> {
                if (!fetchAnchors) {
                    bundleReltn.getTrustBundle().setTrustBundleAnchors(new ArrayList());
                }
                org.nhindirect.config.model.TrustBundleDomainReltn newReltn = new org.nhindirect.config.model.TrustBundleDomainReltn();
                newReltn.setIncoming(bundleReltn.isIncoming());
                newReltn.setOutgoing(bundleReltn.isOutgoing());
                newReltn.setDomain(EntityModelConversion.toModelDomain(bundleReltn.getDomain()));
                newReltn.setTrustBundle(EntityModelConversion.toModelTrustBundle(bundleReltn.getTrustBundle()));
                return newReltn;
            }).collect(Collectors.toList());
            Flux retVal = Flux.fromIterable((Iterable)retReltns);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.OK).cacheControl(noCache)).body((Object)retVal);
        }
        catch (Throwable e) {
            log.error((Object)"Error looking up trust bundles", e);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).cacheControl(noCache)).build();
        }
    }

    @GetMapping(value={"domains/{domainName}"}, produces={"application/json"})
    @Transactional(readOnly=true)
    public ResponseEntity<Flux<org.nhindirect.config.model.TrustBundleDomainReltn>> getTrustBundlesByDomain(@PathVariable(value="domainName") String domainName, @RequestParam(name="fetchAnchors", defaultValue="true") boolean fetchAnchors) {
        Domain entityDomain;
        try {
            entityDomain = this.domainRepo.findByDomainNameIgnoreCase(domainName);
            if (entityDomain == null) {
                return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).cacheControl(noCache)).build();
            }
        }
        catch (Exception e) {
            log.error((Object)"Error looking up domain.", (Throwable)e);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).cacheControl(noCache)).build();
        }
        try {
            Collection retReltns = this.reltnRepo.findByDomain(entityDomain).stream().map(bundleReltn -> {
                if (!fetchAnchors) {
                    bundleReltn.getTrustBundle().setTrustBundleAnchors(new ArrayList());
                }
                org.nhindirect.config.model.TrustBundleDomainReltn newReltn = new org.nhindirect.config.model.TrustBundleDomainReltn();
                newReltn.setIncoming(bundleReltn.isIncoming());
                newReltn.setOutgoing(bundleReltn.isOutgoing());
                newReltn.setDomain(EntityModelConversion.toModelDomain(bundleReltn.getDomain()));
                newReltn.setTrustBundle(EntityModelConversion.toModelTrustBundle(bundleReltn.getTrustBundle()));
                return newReltn;
            }).collect(Collectors.toList());
            Flux retVal = Flux.fromIterable((Iterable)retReltns);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.OK).cacheControl(noCache)).body((Object)retVal);
        }
        catch (Throwable e) {
            log.error((Object)"Error looking up trust bundles", e);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).cacheControl(noCache)).build();
        }
    }

    @GetMapping(value={"{bundleName}"}, produces={"application/json"})
    @Transactional(readOnly=true)
    public ResponseEntity<Mono<org.nhindirect.config.model.TrustBundle>> getTrustBundleByName(@PathVariable(value="bundleName") String bundleName) {
        try {
            TrustBundle retBundle = this.bundleRepo.findByBundleNameIgnoreCase(bundleName);
            if (retBundle == null) {
                return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).cacheControl(noCache)).build();
            }
            org.nhindirect.config.model.TrustBundle modelBundle = EntityModelConversion.toModelTrustBundle(retBundle);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.OK).cacheControl(noCache)).body((Object)Mono.just((Object)modelBundle));
        }
        catch (Throwable e) {
            log.error((Object)"Error looking up trust bundles", e);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).cacheControl(noCache)).build();
        }
    }

    @PutMapping(consumes={"application/json"})
    public ResponseEntity<Mono<Void>> addTrustBundle(@RequestBody org.nhindirect.config.model.TrustBundle bundle) {
        try {
            if (this.bundleRepo.findByBundleNameIgnoreCase(bundle.getBundleName()) != null) {
                return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.CONFLICT).cacheControl(noCache)).build();
            }
        }
        catch (Exception e) {
            log.error((Object)"Error looking up bundle.", (Throwable)e);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).cacheControl(noCache)).build();
        }
        try {
            TrustBundle entityBundle = EntityModelConversion.toEntityTrustBundle(bundle);
            this.bundleRepo.save((Object)entityBundle);
            this.template.sendBody((Object)entityBundle);
            URI uri = new UriTemplate("/{bundle}").expand(new Object[]{"trustbundle/" + bundle.getBundleName()});
            return ((ResponseEntity.BodyBuilder)ResponseEntity.created((URI)uri).cacheControl(noCache)).build();
        }
        catch (Exception e) {
            log.error((Object)"Error adding trust bundle.", (Throwable)e);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).cacheControl(noCache)).build();
        }
    }

    @PostMapping(value={"{bundle}/refreshBundle"})
    public ResponseEntity<Mono<Void>> refreshTrustBundle(@PathVariable(value="bundle") String bundleName) {
        try {
            TrustBundle entityBundle = this.bundleRepo.findByBundleNameIgnoreCase(bundleName);
            if (entityBundle == null) {
                return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).cacheControl(noCache)).build();
            }
            this.template.sendBody((Object)entityBundle);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.NO_CONTENT).cacheControl(noCache)).build();
        }
        catch (Exception e) {
            log.error((Object)"Error refreshing bundle.", (Throwable)e);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).cacheControl(noCache)).build();
        }
    }

    @DeleteMapping(value={"{bundle}"})
    public ResponseEntity<Mono<Void>> deleteBundle(@PathVariable(value="bundle") String bundleName) {
        TrustBundle entityBundle;
        try {
            entityBundle = this.bundleRepo.findByBundleNameIgnoreCase(bundleName);
            if (entityBundle == null) {
                return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).cacheControl(noCache)).build();
            }
        }
        catch (Exception e) {
            log.error((Object)"Error looking up bundle.", (Throwable)e);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).cacheControl(noCache)).build();
        }
        try {
            this.bundleRepo.deleteById((Object)entityBundle.getId());
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.OK).cacheControl(noCache)).build();
        }
        catch (Exception e) {
            log.error((Object)"Error deleting trust bundle.", (Throwable)e);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).cacheControl(noCache)).build();
        }
    }

    @PostMapping(value={"{bundle}/signingCert"}, consumes={"application/json"})
    public ResponseEntity<Mono<Void>> updateSigningCert(@PathVariable(value="bundle") String bundleName, @RequestBody(required=false) byte[] certData) {
        TrustBundle entityBundle;
        X509Certificate signingCert = null;
        if (certData != null && certData.length > 0) {
            try {
                signingCert = CertUtils.toX509Certificate((byte[])certData);
            }
            catch (CertificateConversionException ex) {
                log.error((Object)("Signing certificate is not in a valid format " + bundleName), (Throwable)ex);
                return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.BAD_REQUEST).cacheControl(noCache)).build();
            }
        }
        try {
            entityBundle = this.bundleRepo.findByBundleNameIgnoreCase(bundleName);
            if (entityBundle == null) {
                return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).cacheControl(noCache)).build();
            }
        }
        catch (Exception e) {
            log.error((Object)"Error looking up bundle.", (Throwable)e);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).cacheControl(noCache)).build();
        }
        try {
            entityBundle.setSigningCertificateData(signingCert == null ? null : signingCert.getEncoded());
            this.bundleRepo.save((Object)entityBundle);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.NO_CONTENT).cacheControl(noCache)).build();
        }
        catch (Exception e) {
            log.error((Object)"Error updating trust bundle signing certificate.", (Throwable)e);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).cacheControl(noCache)).build();
        }
    }

    @PostMapping(value={"{bundle}/bundleAttributes"}, consumes={"application/json"})
    public ResponseEntity<Mono<Void>> updateBundleAttributes(@PathVariable(value="bundle") String bundleName, @RequestBody org.nhindirect.config.model.TrustBundle bundleData) {
        TrustBundle entityBundle;
        try {
            entityBundle = this.bundleRepo.findByBundleNameIgnoreCase(bundleName);
            if (entityBundle == null) {
                return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).cacheControl(noCache)).build();
            }
        }
        catch (Exception e) {
            log.error((Object)"Error looking up bundle.", (Throwable)e);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).cacheControl(noCache)).build();
        }
        String oldBundleURL = entityBundle.getBundleURL();
        X509Certificate newSigningCert = null;
        if (bundleData.getSigningCertificateData() != null) {
            try {
                newSigningCert = CertUtils.toX509Certificate((byte[])bundleData.getSigningCertificateData());
            }
            catch (CertificateConversionException ex) {
                log.error((Object)("Signing certificate is not in a valid format " + bundleName), (Throwable)ex);
                return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.BAD_REQUEST).cacheControl(noCache)).build();
            }
        }
        try {
            if (newSigningCert == null) {
                entityBundle.setSigningCertificateData(null);
            } else {
                entityBundle.setSigningCertificateData(newSigningCert.getEncoded());
            }
            if (!StringUtils.isEmpty((CharSequence)bundleData.getBundleName())) {
                entityBundle.setBundleName(bundleData.getBundleName());
            }
            entityBundle.setRefreshInterval(bundleData.getRefreshInterval());
            if (!StringUtils.isEmpty((CharSequence)bundleData.getBundleURL())) {
                entityBundle.setBundleURL(bundleData.getBundleURL());
            }
            this.bundleRepo.save((Object)entityBundle);
            if (bundleData.getBundleURL() != null && !bundleData.getBundleURL().isEmpty() && !oldBundleURL.equals(bundleData.getBundleURL())) {
                entityBundle = (TrustBundle)this.bundleRepo.findById((Object)entityBundle.getId()).get();
                this.template.sendBody((Object)entityBundle);
            }
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.NO_CONTENT).cacheControl(noCache)).build();
        }
        catch (Exception e) {
            log.error((Object)"Error updating trust bundle attributes.", (Throwable)e);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).cacheControl(noCache)).build();
        }
    }

    @PostMapping(value={"{bundle}/{domain}"})
    public ResponseEntity<Mono<Void>> associateTrustBundleToDomain(@PathVariable(value="bundle") String bundleName, @PathVariable(value="domain") String domainName, @RequestParam(name="incoming", defaultValue="true") boolean incoming, @RequestParam(name="outgoing", defaultValue="true") boolean outgoing) {
        Domain entityDomain;
        TrustBundle entityBundle;
        try {
            entityBundle = this.bundleRepo.findByBundleNameIgnoreCase(bundleName);
            if (entityBundle == null) {
                return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).cacheControl(noCache)).build();
            }
        }
        catch (Exception e) {
            log.error((Object)"Error looking up bundle.", (Throwable)e);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).cacheControl(noCache)).build();
        }
        try {
            entityDomain = this.domainRepo.findByDomainNameIgnoreCase(domainName);
            if (entityDomain == null) {
                return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).cacheControl(noCache)).build();
            }
        }
        catch (Exception e) {
            log.error((Object)"Error looking up domain.", (Throwable)e);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).cacheControl(noCache)).build();
        }
        try {
            TrustBundleDomainReltn reltn = new TrustBundleDomainReltn();
            reltn.setDomain(entityDomain);
            reltn.setTrustBundle(entityBundle);
            reltn.setIncoming(incoming);
            reltn.setOutgoing(outgoing);
            this.reltnRepo.save((Object)reltn);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.NO_CONTENT).cacheControl(noCache)).build();
        }
        catch (Exception e) {
            log.error((Object)"Error associating trust bundle to domain.", (Throwable)e);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).cacheControl(noCache)).build();
        }
    }

    @DeleteMapping(value={"{bundle}/{domain}"})
    public ResponseEntity<Mono<Void>> disassociateTrustBundleFromDomain(@PathVariable(value="bundle") String bundleName, @PathVariable(value="domain") String domainName) {
        Domain entityDomain;
        TrustBundle entityBundle;
        try {
            entityBundle = this.bundleRepo.findByBundleNameIgnoreCase(bundleName);
            if (entityBundle == null) {
                return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).cacheControl(noCache)).build();
            }
        }
        catch (Exception e) {
            log.error((Object)"Error looking up bundle.", (Throwable)e);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).cacheControl(noCache)).build();
        }
        try {
            entityDomain = this.domainRepo.findByDomainNameIgnoreCase(domainName);
            if (entityDomain == null) {
                return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).cacheControl(noCache)).build();
            }
        }
        catch (Exception e) {
            log.error((Object)"Error looking up domain.", (Throwable)e);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).cacheControl(noCache)).build();
        }
        try {
            this.reltnRepo.deleteByDomainAndTrustBundle(entityDomain, entityBundle);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.OK).cacheControl(noCache)).build();
        }
        catch (Exception e) {
            log.error((Object)"Error disassociating trust bundle from domain.", (Throwable)e);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).cacheControl(noCache)).build();
        }
    }

    @DeleteMapping(value={"{domain}/deleteFromDomain"})
    public ResponseEntity<Mono<Void>> disassociateTrustBundlesFromDomain(@PathVariable(value="domain") String domainName) {
        Domain entityDomain;
        try {
            entityDomain = this.domainRepo.findByDomainNameIgnoreCase(domainName);
            if (entityDomain == null) {
                return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).cacheControl(noCache)).build();
            }
        }
        catch (Exception e) {
            log.error((Object)"Error looking up domain.", (Throwable)e);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).cacheControl(noCache)).build();
        }
        try {
            this.reltnRepo.deleteByDomain(entityDomain);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.OK).cacheControl(noCache)).build();
        }
        catch (Exception e) {
            log.error((Object)"Error disassociating trust bundles from domain.", (Throwable)e);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).cacheControl(noCache)).build();
        }
    }

    @DeleteMapping(value={"{bundle}/deleteFromBundle"})
    public ResponseEntity<Mono<Void>> disassociateTrustBundleFromDomains(@PathVariable(value="bundle") String bundleName) {
        TrustBundle entityBundle;
        try {
            entityBundle = this.bundleRepo.findByBundleNameIgnoreCase(bundleName);
            if (entityBundle == null) {
                return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).cacheControl(noCache)).build();
            }
        }
        catch (Exception e) {
            log.error((Object)"Error looking up bundle.", (Throwable)e);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).cacheControl(noCache)).build();
        }
        try {
            this.reltnRepo.deleteByTrustBundle(entityBundle);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.OK).cacheControl(noCache)).build();
        }
        catch (Exception e) {
            log.error((Object)"Error disassociating trust bundle from domains.", (Throwable)e);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).cacheControl(noCache)).build();
        }
    }
}

