/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.processor.impl;

import java.time.LocalDateTime;
import java.util.Collection;
import org.apache.camel.Handler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nhindirect.config.processor.BundleCacheUpdateProcessor;
import org.nhindirect.config.processor.BundleRefreshProcessor;
import org.nhindirect.config.repository.TrustBundleRepository;
import org.nhindirect.config.store.TrustBundle;

public class DefaultBundleCacheUpdateProcessorImpl
implements BundleCacheUpdateProcessor {
    private static final Log log = LogFactory.getLog(DefaultBundleCacheUpdateProcessorImpl.class);
    protected TrustBundleRepository bundleRepo;
    protected BundleRefreshProcessor refreshProcessor;

    public void setRepository(TrustBundleRepository bundleRepo) {
        this.bundleRepo = bundleRepo;
    }

    public void setRefreshProcessor(BundleRefreshProcessor refreshProcessor) {
        this.refreshProcessor = refreshProcessor;
    }

    @Override
    @Handler
    public void updateBundleCache() {
        try {
            Collection bundles = (Collection)this.bundleRepo.findAll().collectList().block();
            for (TrustBundle bundle : bundles) {
                boolean refresh = false;
                if (bundle.getRefreshInterval() <= 0) continue;
                LocalDateTime lastAttempt = bundle.getLastSuccessfulRefresh();
                if (lastAttempt == null) {
                    refresh = true;
                } else {
                    LocalDateTime now = LocalDateTime.now();
                    LocalDateTime lastAttemptCheck = LocalDateTime.from(lastAttempt);
                    lastAttemptCheck.plusSeconds(bundle.getRefreshInterval());
                    if (lastAttemptCheck.isBefore(now)) {
                        refresh = true;
                    }
                }
                if (!refresh) continue;
                try {
                    this.refreshProcessor.refreshBundle(bundle);
                }
                catch (Exception e) {
                    log.warn((Object)("Failed to check the status of bundle " + bundle.getBundleName()), (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            log.warn((Object)"Failed to check the status of trust bundles ", (Throwable)e);
        }
    }
}

