/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.resources;

import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nhindirect.config.repository.AddressRepository;
import org.nhindirect.config.repository.DomainRepository;
import org.nhindirect.config.resources.ProtectedResource;
import org.nhindirect.config.resources.util.EntityModelConversion;
import org.nhindirect.config.store.Address;
import org.nhindirect.config.store.Domain;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.util.UriTemplate;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@RestController
@RequestMapping(value={"address"})
public class AddressResource
extends ProtectedResource {
    private static final Log log = LogFactory.getLog(AddressResource.class);
    protected AddressRepository addRepo;
    protected DomainRepository domainRepo;

    @Autowired
    public void setAddressRepository(AddressRepository addRepo) {
        this.addRepo = addRepo;
    }

    @Autowired
    public void setDomainRepository(DomainRepository domainRepo) {
        this.domainRepo = domainRepo;
    }

    @GetMapping(value={"/{address}"}, produces={"application/json"})
    public ResponseEntity<Mono<org.nhindirect.config.model.Address>> getAddress(@PathVariable String address) {
        try {
            Address retAddress = (Address)this.addRepo.findByEmailAddressIgnoreCase(address).block();
            if (retAddress == null) {
                return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).cacheControl(noCache)).build();
            }
            Domain domain = (Domain)this.domainRepo.findById((Object)retAddress.getDomainId()).block();
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.OK).cacheControl(noCache)).body((Object)Mono.just((Object)EntityModelConversion.toModelAddress(retAddress, domain.getDomainName())));
        }
        catch (Exception e) {
            log.error((Object)"Error looking up address.", (Throwable)e);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).cacheControl(noCache)).build();
        }
    }

    @GetMapping(value={"domain/{domainName}"}, produces={"application/json"})
    public ResponseEntity<Flux<org.nhindirect.config.model.Address>> getAddressesByDomain(@PathVariable String domainName) {
        Domain domain = null;
        try {
            domain = (Domain)this.domainRepo.findByDomainNameIgnoreCase(domainName).block();
            if (domain == null) {
                return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.NO_CONTENT).cacheControl(noCache)).build();
            }
        }
        catch (Exception e) {
            log.error((Object)"Error looking up existing domain.", (Throwable)e);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).cacheControl(noCache)).build();
        }
        try {
            Flux retVal = this.addRepo.findByDomainId(domain.getId()).map(address -> EntityModelConversion.toModelAddress(address, domainName));
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.OK).cacheControl(noCache)).body((Object)retVal);
        }
        catch (Exception e) {
            log.error((Object)"Error looking up addresses.", (Throwable)e);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).cacheControl(noCache)).build();
        }
    }

    @PutMapping(consumes={"application/json"})
    public ResponseEntity<Mono<Void>> addAddress(@RequestBody org.nhindirect.config.model.Address address) {
        Domain domain;
        if (address.getDomainName() == null || address.getDomainName().isEmpty()) {
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.BAD_REQUEST).cacheControl(noCache)).build();
        }
        try {
            domain = (Domain)this.domainRepo.findByDomainNameIgnoreCase(address.getDomainName()).block();
            if (domain == null) {
                return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).cacheControl(noCache)).build();
            }
        }
        catch (Exception e) {
            log.error((Object)"Error looking up existing domain.", (Throwable)e);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).cacheControl(noCache)).build();
        }
        try {
            if (this.addRepo.findByEmailAddressIgnoreCase(address.getEmailAddress()).block() != null) {
                return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.CONFLICT).cacheControl(noCache)).build();
            }
        }
        catch (Exception e) {
            log.error((Object)"Error looking up existing address.", (Throwable)e);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).cacheControl(noCache)).build();
        }
        Address toAdd = EntityModelConversion.toEntityAddress(address, domain);
        toAdd.setId(null);
        try {
            this.addRepo.save((Object)toAdd).block();
            URI uri = new UriTemplate("/{address}").expand(new Object[]{"address/" + address.getEmailAddress()});
            return ((ResponseEntity.BodyBuilder)ResponseEntity.created((URI)uri).cacheControl(noCache)).build();
        }
        catch (Exception e) {
            log.error((Object)"Error adding address.", (Throwable)e);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).cacheControl(noCache)).build();
        }
    }

    @PostMapping(consumes={"application/json"})
    public ResponseEntity<Mono<Void>> updateAddress(@RequestBody org.nhindirect.config.model.Address address) {
        Domain domain;
        if (address.getDomainName() == null || address.getDomainName().isEmpty()) {
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.BAD_REQUEST).cacheControl(noCache)).build();
        }
        try {
            domain = (Domain)this.domainRepo.findByDomainNameIgnoreCase(address.getDomainName()).block();
            if (domain == null) {
                return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).cacheControl(noCache)).build();
            }
        }
        catch (Exception e) {
            log.error((Object)"Error looking up existing domain.", (Throwable)e);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).cacheControl(noCache)).build();
        }
        Address existingAdd = null;
        try {
            existingAdd = (Address)this.addRepo.findByEmailAddressIgnoreCase(address.getEmailAddress()).block();
            if (existingAdd == null) {
                return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).cacheControl(noCache)).build();
            }
        }
        catch (Exception e) {
            log.error((Object)"Error looking up existing address.", (Throwable)e);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).cacheControl(noCache)).build();
        }
        Address toAdd = EntityModelConversion.toEntityAddress(address, domain);
        toAdd.setId(existingAdd.getId());
        try {
            this.addRepo.save((Object)toAdd).block();
            return ResponseEntity.noContent().cacheControl(noCache).build();
        }
        catch (Exception e) {
            log.error((Object)"Error updating address.", (Throwable)e);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).cacheControl(noCache)).build();
        }
    }

    @DeleteMapping(value={"{address}"})
    public ResponseEntity<Mono<Void>> removedAddress(@PathVariable(value="address") String address) {
        Address addr;
        try {
            addr = (Address)this.addRepo.findByEmailAddressIgnoreCase(address).block();
            if (addr == null) {
                return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).cacheControl(noCache)).build();
            }
        }
        catch (Exception e) {
            log.error((Object)"Error looking up existing address.", (Throwable)e);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).cacheControl(noCache)).build();
        }
        try {
            this.addRepo.deleteById((Object)addr.getId()).block();
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.OK).cacheControl(noCache)).build();
        }
        catch (Exception e) {
            log.error((Object)"Error deleting address.", (Throwable)e);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).cacheControl(noCache)).build();
        }
    }
}

