/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.resources;

import java.net.URI;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nhindirect.common.cert.Thumbprint;
import org.nhindirect.config.model.Anchor;
import org.nhindirect.config.repository.AnchorRepository;
import org.nhindirect.config.resources.ProtectedResource;
import org.nhindirect.config.resources.util.EntityModelConversion;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.util.UriTemplate;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@RestController
@RequestMapping(value={"anchor"})
public class AnchorResource
extends ProtectedResource {
    private static final Log log = LogFactory.getLog(AnchorResource.class);
    protected AnchorRepository anchorRepo;

    @Autowired
    public void setAnchorRepository(AnchorRepository anchorRepo) {
        this.anchorRepo = anchorRepo;
    }

    @GetMapping(value={"/{owner}"}, produces={"application/json"})
    public ResponseEntity<Flux<Anchor>> getAnchorForOwner(@RequestParam(name="incoming", defaultValue="false") boolean incoming, @RequestParam(name="outgoing", defaultValue="false") boolean outgoing, @RequestParam(name="thumbprint", defaultValue="") String thumbprint, @PathVariable(value="owner") String owner) {
        try {
            Flux retVal = this.anchorRepo.findByOwnerIgnoreCase(owner).filter(anchor -> !(incoming && !anchor.isIncoming() || outgoing && !anchor.isOutgoing() || !thumbprint.isEmpty() && !thumbprint.equalsIgnoreCase(anchor.getThumbprint()))).map(anchor -> EntityModelConversion.toModelAnchor(anchor));
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.OK).cacheControl(noCache)).body((Object)retVal);
        }
        catch (Exception e) {
            log.error((Object)"Error looking up anchors.", (Throwable)e);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).cacheControl(noCache)).build();
        }
    }

    @GetMapping(produces={"application/json"})
    public ResponseEntity<Flux<Anchor>> getAnchors() {
        try {
            Flux retVal = this.anchorRepo.findAll().map(anchor -> EntityModelConversion.toModelAnchor(anchor));
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.OK).cacheControl(noCache)).body((Object)retVal);
        }
        catch (Exception e) {
            log.error((Object)"Error looking up anchors.", (Throwable)e);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).cacheControl(noCache)).build();
        }
    }

    @PutMapping(consumes={"application/json"})
    public ResponseEntity<Mono<Void>> addAnchor(@RequestBody Anchor anchor) {
        try {
            String thumbprint = anchor.getThumbprint() == null || anchor.getThumbprint().isEmpty() ? Thumbprint.toThumbprint((X509Certificate)anchor.getAnchorAsX509Certificate()).toString() : anchor.getThumbprint();
            Collection existingAnchors = (Collection)this.anchorRepo.findByOwnerIgnoreCase(anchor.getOwner()).collectList().block();
            for (org.nhindirect.config.store.Anchor existingAnchor : existingAnchors) {
                if (!existingAnchor.getThumbprint().equalsIgnoreCase(thumbprint)) continue;
                return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.CONFLICT).cacheControl(noCache)).build();
            }
        }
        catch (Exception e) {
            log.error((Object)"Error looking up existing anchor.", (Throwable)e);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).cacheControl(noCache)).build();
        }
        try {
            org.nhindirect.config.store.Anchor addAnchor = EntityModelConversion.toEntityAnchor(anchor);
            addAnchor.setId(null);
            this.anchorRepo.save((Object)addAnchor).block();
            URI uri = new UriTemplate("/{address}").expand(new Object[]{"anchor/" + anchor.getOwner()});
            return ((ResponseEntity.BodyBuilder)ResponseEntity.created((URI)uri).cacheControl(noCache)).build();
        }
        catch (Exception e) {
            log.error((Object)"Error adding anchor.", (Throwable)e);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).cacheControl(noCache)).build();
        }
    }

    @DeleteMapping(value={"ids/{ids}"})
    public ResponseEntity<Mono<Void>> removeAnchorsByIds(@PathVariable(value="ids") String ids) {
        String[] idArray = ids.split(",");
        ArrayList<Long> idList = new ArrayList<Long>();
        try {
            for (String id : idArray) {
                idList.add(Long.parseLong(id));
            }
            this.anchorRepo.deleteByIdIn(idList).block();
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.OK).cacheControl(noCache)).build();
        }
        catch (Exception e) {
            log.error((Object)"Error removing anchors by ids.", (Throwable)e);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).cacheControl(noCache)).build();
        }
    }

    @DeleteMapping(value={"{owner}"})
    public ResponseEntity<Mono<Void>> removeAnchorsByOwner(@PathVariable(value="owner") String owner) {
        try {
            this.anchorRepo.deleteByOwnerIgnoreCase(owner).block();
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.OK).cacheControl(noCache)).build();
        }
        catch (Exception e) {
            log.error((Object)"Error removing anchors by owner.", (Throwable)e);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).cacheControl(noCache)).build();
        }
    }
}

