/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.resources;

import com.google.common.collect.Maps;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nhindirect.config.model.CertPolicyGroup;
import org.nhindirect.config.model.CertPolicyGroupDomainReltn;
import org.nhindirect.config.model.CertPolicyGroupUse;
import org.nhindirect.config.repository.CertPolicyGroupDomainReltnRepository;
import org.nhindirect.config.repository.CertPolicyGroupReltnRepository;
import org.nhindirect.config.repository.CertPolicyGroupRepository;
import org.nhindirect.config.repository.CertPolicyRepository;
import org.nhindirect.config.repository.DomainRepository;
import org.nhindirect.config.resources.ProtectedResource;
import org.nhindirect.config.resources.util.EntityModelConversion;
import org.nhindirect.config.store.CertPolicy;
import org.nhindirect.config.store.CertPolicyGroupReltn;
import org.nhindirect.config.store.CertPolicyUse;
import org.nhindirect.config.store.Domain;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.util.UriTemplate;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@RestController
@RequestMapping(value={"certpolicy"})
public class CertPolicyResource
extends ProtectedResource {
    private static final Log log = LogFactory.getLog(CertPolicyResource.class);
    protected CertPolicyRepository policyRepo;
    protected CertPolicyGroupRepository groupRepo;
    protected CertPolicyGroupDomainReltnRepository domainReltnRepo;
    protected CertPolicyGroupReltnRepository polGroupReltnRepo;
    protected DomainRepository domainRepo;
    protected CertPolicyResource transactionalThisProxy;

    @Autowired
    public void setCertPolicyRepository(CertPolicyRepository policyRepo) {
        this.policyRepo = policyRepo;
    }

    @Autowired
    public void setDomainRepository(DomainRepository domainRepo) {
        this.domainRepo = domainRepo;
    }

    @Autowired
    public void setCertPolicyGroupRepository(CertPolicyGroupRepository groupRepo) {
        this.groupRepo = groupRepo;
    }

    @Autowired
    public void setCertPolicyGroupDomainReltnRepository(CertPolicyGroupDomainReltnRepository domainReltnRepo) {
        this.domainReltnRepo = domainReltnRepo;
    }

    @Autowired
    public void setCertPolicyGroupReltnRepository(CertPolicyGroupReltnRepository polGroupReltnRepo) {
        this.polGroupReltnRepo = polGroupReltnRepo;
    }

    @Autowired
    public void setInternalThisProxy(CertPolicyResource internalProxy) {
        this.transactionalThisProxy = internalProxy;
    }

    @GetMapping(produces={"application/json"})
    public ResponseEntity<Flux<org.nhindirect.config.model.CertPolicy>> getPolicies() {
        try {
            Flux retVal = this.policyRepo.findAll().map(pol -> EntityModelConversion.toModelCertPolicy(pol));
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.OK).cacheControl(noCache)).body((Object)retVal);
        }
        catch (Exception e) {
            log.error((Object)"Error looking up cert policies.", (Throwable)e);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).cacheControl(noCache)).build();
        }
    }

    @GetMapping(value={"/{policyName}"}, produces={"application/json"})
    public ResponseEntity<Mono<org.nhindirect.config.model.CertPolicy>> getPolicyByName(@PathVariable(value="policyName") String policyName) {
        try {
            CertPolicy retPolicy = (CertPolicy)this.policyRepo.findByPolicyNameIgnoreCase(policyName).block();
            if (retPolicy == null) {
                return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).cacheControl(noCache)).build();
            }
            org.nhindirect.config.model.CertPolicy modelPolicy = EntityModelConversion.toModelCertPolicy(retPolicy);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.OK).cacheControl(noCache)).body((Object)Mono.just((Object)modelPolicy));
        }
        catch (Throwable e) {
            log.error((Object)"Error looking up cert policy", e);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).cacheControl(noCache)).build();
        }
    }

    @PutMapping(consumes={"application/json"})
    public ResponseEntity<Mono<Void>> addPolicy(@RequestBody org.nhindirect.config.model.CertPolicy policy) {
        try {
            if (this.policyRepo.findByPolicyNameIgnoreCase(policy.getPolicyName()).block() != null) {
                return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.CONFLICT).cacheControl(noCache)).build();
            }
        }
        catch (Exception e) {
            log.error((Object)"Error looking up cert policy.", (Throwable)e);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).cacheControl(noCache)).build();
        }
        try {
            CertPolicy entityPolicy = EntityModelConversion.toEntityCertPolicy(policy);
            this.policyRepo.save((Object)entityPolicy).block();
            URI uri = new UriTemplate("/{certpolicy}").expand(new Object[]{"certpolicy/" + policy.getPolicyName()});
            return ((ResponseEntity.BodyBuilder)ResponseEntity.created((URI)uri).cacheControl(noCache)).build();
        }
        catch (Exception e) {
            log.error((Object)"Error adding trust cert policy.", (Throwable)e);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).cacheControl(noCache)).build();
        }
    }

    @DeleteMapping(value={"{policyName}"})
    public ResponseEntity<Mono<Void>> removePolicyByName(@PathVariable(value="policyName") String policyName) {
        CertPolicy enitityPolicy = null;
        try {
            enitityPolicy = (CertPolicy)this.policyRepo.findByPolicyNameIgnoreCase(policyName).block();
            if (enitityPolicy == null) {
                return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).cacheControl(noCache)).build();
            }
        }
        catch (Exception e) {
            log.error((Object)"Error looking up existing cert policy.", (Throwable)e);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).cacheControl(noCache)).build();
        }
        this.polGroupReltnRepo.deleteByPolicyId(enitityPolicy.getId()).block();
        try {
            this.policyRepo.deleteById((Object)enitityPolicy.getId()).block();
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.OK).cacheControl(noCache)).build();
        }
        catch (Exception e) {
            log.error((Object)"Error deleting cert policy.", (Throwable)e);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).cacheControl(noCache)).build();
        }
    }

    @PostMapping(value={"{policyName}/policyAttributes"}, consumes={"application/json"})
    public ResponseEntity<Mono<Void>> updatePolicyAttributes(@PathVariable(value="policyName") String policyName, @RequestBody org.nhindirect.config.model.CertPolicy policyData) {
        CertPolicy entityPolicy;
        try {
            entityPolicy = (CertPolicy)this.policyRepo.findByPolicyNameIgnoreCase(policyName).block();
            if (entityPolicy == null) {
                return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).cacheControl(noCache)).build();
            }
        }
        catch (Exception e) {
            log.error((Object)"Error looking up cert policy.", (Throwable)e);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).cacheControl(noCache)).build();
        }
        try {
            if (policyData.getPolicyData() != null && policyData.getPolicyData().length > 0) {
                entityPolicy.setPolicyData(policyData.getPolicyData());
            }
            if (!StringUtils.isEmpty((CharSequence)policyData.getPolicyName())) {
                entityPolicy.setPolicyName(policyData.getPolicyName());
            }
            if (policyData.getLexicon() != null) {
                entityPolicy.setLexicon(policyData.getLexicon().ordinal());
            }
            this.policyRepo.save((Object)entityPolicy).block();
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.NO_CONTENT).cacheControl(noCache)).build();
        }
        catch (Exception e) {
            log.error((Object)"Error updating cert policy attributes.", (Throwable)e);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).cacheControl(noCache)).build();
        }
    }

    @GetMapping(value={"groups"}, produces={"application/json"})
    public ResponseEntity<Flux<CertPolicyGroup>> getPolicyGroups() {
        try {
            Flux retVal = this.groupRepo.findAll().flatMap(group -> this.polGroupReltnRepo.findByGroupId(group.getId()).flatMap(reltn -> this.policyRepo.findById((Object)reltn.getCertPolicyId()).map(pol -> Maps.immutableEntry((Object)reltn, (Object)pol))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)).map(polUseMap -> EntityModelConversion.toModelCertPolicyGroup(group, polUseMap)));
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.OK).cacheControl(noCache)).body((Object)retVal);
        }
        catch (Exception e) {
            log.error((Object)"Error looking up cert policy groups.", (Throwable)e);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).cacheControl(noCache)).build();
        }
    }

    @GetMapping(value={"groups/{groupName}"}, produces={"application/json"})
    public ResponseEntity<Mono<CertPolicyGroup>> getPolicyGroupByName(@PathVariable(value="groupName") String groupName) {
        try {
            org.nhindirect.config.store.CertPolicyGroup retGroup = (org.nhindirect.config.store.CertPolicyGroup)this.groupRepo.findByPolicyGroupNameIgnoreCase(groupName).block();
            if (retGroup == null) {
                return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).cacheControl(noCache)).build();
            }
            Map polUseMap = (Map)this.polGroupReltnRepo.findByGroupId(retGroup.getId()).flatMap(reltn -> this.policyRepo.findById((Object)reltn.getCertPolicyId()).map(pol -> Maps.immutableEntry((Object)reltn, (Object)pol))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)).block();
            CertPolicyGroup modelGroup = EntityModelConversion.toModelCertPolicyGroup(retGroup, polUseMap);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.OK).cacheControl(noCache)).body((Object)Mono.just((Object)modelGroup));
        }
        catch (Throwable e) {
            log.error((Object)"Error looking up cert policy group", e);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).cacheControl(noCache)).build();
        }
    }

    @PutMapping(value={"groups"}, consumes={"application/json"})
    public ResponseEntity<Mono<Void>> addPolicyGroup(@RequestBody CertPolicyGroup group) {
        try {
            if (this.groupRepo.findByPolicyGroupNameIgnoreCase(group.getPolicyGroupName()).block() != null) {
                return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.CONFLICT).cacheControl(noCache)).build();
            }
        }
        catch (Exception e) {
            log.error((Object)"Error looking up cert policy group.", (Throwable)e);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).cacheControl(noCache)).build();
        }
        try {
            org.nhindirect.config.store.CertPolicyGroup entityGroup = EntityModelConversion.toEntityCertPolicyGroup(group);
            this.groupRepo.save((Object)entityGroup).block();
            URI uri = new UriTemplate("/{certpolicy}").expand(new Object[]{"certpolicy/group+/" + group.getPolicyGroupName()});
            return ((ResponseEntity.BodyBuilder)ResponseEntity.created((URI)uri).cacheControl(noCache)).build();
        }
        catch (Exception e) {
            log.error((Object)"Error adding trust cert policy group.", (Throwable)e);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).cacheControl(noCache)).build();
        }
    }

    @DeleteMapping(value={"groups/{groupName}"})
    public ResponseEntity<Mono<Void>> removePolicyGroupByName(@PathVariable(value="groupName") String groupName) {
        org.nhindirect.config.store.CertPolicyGroup enitityGroup = null;
        try {
            enitityGroup = (org.nhindirect.config.store.CertPolicyGroup)this.groupRepo.findByPolicyGroupNameIgnoreCase(groupName).block();
            if (enitityGroup == null) {
                return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).cacheControl(noCache)).build();
            }
        }
        catch (Exception e) {
            log.error((Object)"Error looking up existing cert policy group.", (Throwable)e);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).cacheControl(noCache)).build();
        }
        try {
            this.domainReltnRepo.deleteByCertPolicyGroupId(enitityGroup.getId()).block();
            this.polGroupReltnRepo.deleteByGroupId(enitityGroup.getId()).block();
            this.groupRepo.deleteById((Object)enitityGroup.getId()).block();
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.OK).cacheControl(noCache)).build();
        }
        catch (Exception e) {
            log.error((Object)"Error deleting cert policy group.", (Throwable)e);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).cacheControl(noCache)).build();
        }
    }

    @PostMapping(value={"groups/{groupName}/groupAttributes"}, consumes={"application/json"})
    public ResponseEntity<Mono<Void>> updateGroupAttributes(@PathVariable(value="groupName") String groupName, @RequestBody String newGroupName) {
        org.nhindirect.config.store.CertPolicyGroup entityGroup;
        try {
            entityGroup = (org.nhindirect.config.store.CertPolicyGroup)this.groupRepo.findByPolicyGroupNameIgnoreCase(groupName).block();
            if (entityGroup == null) {
                return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).cacheControl(noCache)).build();
            }
        }
        catch (Exception e) {
            log.error((Object)"Error looking up cert policy group.", (Throwable)e);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).cacheControl(noCache)).build();
        }
        try {
            if (!StringUtils.isEmpty((CharSequence)newGroupName)) {
                entityGroup.setPolicyGroupName(newGroupName);
            }
            this.groupRepo.save((Object)entityGroup).block();
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.NO_CONTENT).cacheControl(noCache)).build();
        }
        catch (Exception e) {
            log.error((Object)"Error updating cert policy group attributes.", (Throwable)e);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).cacheControl(noCache)).build();
        }
    }

    @PostMapping(value={"groups/uses/{group}"}, consumes={"application/json"})
    public ResponseEntity<Mono<Void>> addPolicyUseToGroup(@PathVariable(value="group") String groupName, @RequestBody CertPolicyGroupUse use) {
        CertPolicy entityPolicy;
        org.nhindirect.config.store.CertPolicyGroup entityGroup;
        try {
            entityGroup = (org.nhindirect.config.store.CertPolicyGroup)this.groupRepo.findByPolicyGroupNameIgnoreCase(groupName).block();
            if (entityGroup == null) {
                return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).cacheControl(noCache)).build();
            }
        }
        catch (Exception e) {
            log.error((Object)"Error looking up policy group.", (Throwable)e);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).cacheControl(noCache)).build();
        }
        try {
            entityPolicy = (CertPolicy)this.policyRepo.findByPolicyNameIgnoreCase(use.getPolicy().getPolicyName()).block();
            if (entityPolicy == null) {
                return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).cacheControl(noCache)).build();
            }
        }
        catch (Exception e) {
            log.error((Object)"Error looking up policy.", (Throwable)e);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).cacheControl(noCache)).build();
        }
        try {
            CertPolicyGroupReltn reltn = new CertPolicyGroupReltn();
            reltn.setCertPolicyId(entityPolicy.getId());
            reltn.setCertPolicyGroupId(entityGroup.getId());
            reltn.setPolicyUse(CertPolicyUse.valueOf((String)use.getPolicyUse().toString()).ordinal());
            reltn.setIncoming(use.isIncoming());
            reltn.setOutgoing(use.isOutgoing());
            this.polGroupReltnRepo.save((Object)reltn).block();
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.NO_CONTENT).cacheControl(noCache)).build();
        }
        catch (Exception e) {
            log.error((Object)"Error adding cert policy to group.", (Throwable)e);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).cacheControl(noCache)).build();
        }
    }

    @PostMapping(value={"groups/uses/{group}/removePolicy"}, consumes={"application/json"})
    public ResponseEntity<Mono<Void>> removedPolicyUseFromGroup(@PathVariable(value="group") String groupName, @RequestBody CertPolicyGroupUse use) {
        org.nhindirect.config.store.CertPolicyGroup entityGroup;
        try {
            entityGroup = (org.nhindirect.config.store.CertPolicyGroup)this.groupRepo.findByPolicyGroupNameIgnoreCase(groupName).block();
            if (entityGroup == null) {
                return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).cacheControl(noCache)).build();
            }
        }
        catch (Exception e) {
            log.error((Object)"Error looking up policy group.", (Throwable)e);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).cacheControl(noCache)).build();
        }
        CertPolicyUse entityUse = CertPolicyUse.valueOf((String)use.getPolicyUse().toString());
        CertPolicyGroupReltn foundReltn = null;
        Collection reltns = (Collection)this.polGroupReltnRepo.findByGroupId(entityGroup.getId()).collectList().block();
        if (reltns != null) {
            for (CertPolicyGroupReltn groupReltn : reltns) {
                CertPolicy certPol = (CertPolicy)this.policyRepo.findById((Object)groupReltn.getCertPolicyId()).block();
                if (!certPol.getPolicyName().equals(use.getPolicy().getPolicyName()) || groupReltn.isIncoming() != use.isIncoming() || groupReltn.isOutgoing() != use.isOutgoing() || groupReltn.getPolicyUse() != entityUse.ordinal()) continue;
                foundReltn = groupReltn;
                break;
            }
        }
        if (foundReltn == null) {
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).cacheControl(noCache)).build();
        }
        try {
            this.polGroupReltnRepo.deleteById((Object)foundReltn.getId()).block();
            this.groupRepo.save((Object)entityGroup).block();
        }
        catch (Exception e) {
            log.error((Object)"Error removing cert policy from group.", (Throwable)e);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).cacheControl(noCache)).build();
        }
        return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.OK).cacheControl(noCache)).build();
    }

    @GetMapping(value={"/groups/domain"}, produces={"application/json"})
    public ResponseEntity<Flux<CertPolicyGroupDomainReltn>> getPolicyGroupDomainReltns() {
        try {
            Flux retVal = this.domainReltnRepo.findAll().flatMap(reltn -> {
                Mono polGroup = this.groupRepo.findById((Object)reltn.getCertPolicyGroupId()).flatMap(group -> this.polGroupReltnRepo.findByGroupId(group.getId()).flatMap(groupReltn -> this.policyRepo.findById((Object)groupReltn.getCertPolicyId()).map(pol -> Maps.immutableEntry((Object)groupReltn, (Object)pol))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)).map(polUseMap -> EntityModelConversion.toModelCertPolicyGroup(group, polUseMap)));
                Mono domain = this.domainRepo.findById((Object)reltn.getDomainId());
                return domain.zipWith(polGroup, (d, p) -> {
                    CertPolicyGroupDomainReltn cpgdReltn = new CertPolicyGroupDomainReltn();
                    cpgdReltn.setId(reltn.getId().longValue());
                    cpgdReltn.setPolicyGroup(p);
                    cpgdReltn.setDomain(EntityModelConversion.toModelDomain(d, Collections.emptyList()));
                    return cpgdReltn;
                });
            });
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.OK).cacheControl(noCache)).body((Object)retVal);
        }
        catch (Exception e) {
            log.error((Object)"Error looking up policy group/domain relations.", (Throwable)e);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).cacheControl(noCache)).build();
        }
    }

    @GetMapping(value={"groups/domain/{domain}"}, produces={"application/json"})
    public ResponseEntity<Flux<CertPolicyGroup>> getPolicyGroupsByDomain(@PathVariable(value="domain") String domainName) {
        Domain entityDomain;
        try {
            entityDomain = (Domain)this.domainRepo.findByDomainNameIgnoreCase(domainName).block();
            if (entityDomain == null) {
                return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).cacheControl(noCache)).build();
            }
        }
        catch (Exception e) {
            log.error((Object)"Error looking up domain.", (Throwable)e);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).cacheControl(noCache)).build();
        }
        try {
            Flux retVal = this.domainReltnRepo.findByDomainId(entityDomain.getId()).flatMap(reltn -> this.groupRepo.findById((Object)reltn.getCertPolicyGroupId()).flatMap(group -> this.polGroupReltnRepo.findByGroupId(group.getId()).flatMap(groupReltn -> this.policyRepo.findById((Object)groupReltn.getCertPolicyId()).map(pol -> Maps.immutableEntry((Object)groupReltn, (Object)pol))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)).map(polUseMap -> EntityModelConversion.toModelCertPolicyGroup(group, polUseMap))));
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.OK).cacheControl(noCache)).body((Object)retVal);
        }
        catch (Exception e) {
            log.error((Object)"Error looking up cert policy groups.", (Throwable)e);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).cacheControl(noCache)).build();
        }
    }

    @PostMapping(value={"groups/domain/{group}/{domain}"})
    public ResponseEntity<Mono<Void>> associatePolicyGroupToDomain(@PathVariable(value="group") String groupName, @PathVariable(value="domain") String domainName) {
        Domain entityDomain;
        org.nhindirect.config.store.CertPolicyGroup entityGroup;
        try {
            entityGroup = (org.nhindirect.config.store.CertPolicyGroup)this.groupRepo.findByPolicyGroupNameIgnoreCase(groupName).block();
            if (entityGroup == null) {
                return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).cacheControl(noCache)).build();
            }
        }
        catch (Exception e) {
            log.error((Object)"Error looking up policy group.", (Throwable)e);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).cacheControl(noCache)).build();
        }
        try {
            entityDomain = (Domain)this.domainRepo.findByDomainNameIgnoreCase(domainName).block();
            if (entityDomain == null) {
                return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).cacheControl(noCache)).build();
            }
        }
        catch (Exception e) {
            log.error((Object)"Error looking up domain.", (Throwable)e);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).cacheControl(noCache)).build();
        }
        try {
            org.nhindirect.config.store.CertPolicyGroupDomainReltn policyGroupDomainAssoc = new org.nhindirect.config.store.CertPolicyGroupDomainReltn();
            policyGroupDomainAssoc.setDomainId(entityDomain.getId());
            policyGroupDomainAssoc.setCertPolicyGroupId(entityGroup.getId());
            this.domainReltnRepo.save((Object)policyGroupDomainAssoc).block();
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.NO_CONTENT).cacheControl(noCache)).build();
        }
        catch (Exception e) {
            log.error((Object)"Error associating policy group to domain.", (Throwable)e);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).cacheControl(noCache)).build();
        }
    }

    @DeleteMapping(value={"groups/domain/{group}/{domain}"})
    public ResponseEntity<Mono<Void>> disassociatePolicyGroupFromDomain(@PathVariable(value="group") String groupName, @PathVariable(value="domain") String domainName) {
        Domain entityDomain;
        org.nhindirect.config.store.CertPolicyGroup entityGroup;
        try {
            entityGroup = (org.nhindirect.config.store.CertPolicyGroup)this.groupRepo.findByPolicyGroupNameIgnoreCase(groupName).block();
            if (entityGroup == null) {
                return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).cacheControl(noCache)).build();
            }
        }
        catch (Exception e) {
            log.error((Object)"Error looking up policy group.", (Throwable)e);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).cacheControl(noCache)).build();
        }
        try {
            entityDomain = (Domain)this.domainRepo.findByDomainNameIgnoreCase(domainName).block();
            if (entityDomain == null) {
                return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).cacheControl(noCache)).build();
            }
        }
        catch (Exception e) {
            log.error((Object)"Error looking up domain.", (Throwable)e);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).cacheControl(noCache)).build();
        }
        try {
            this.domainReltnRepo.deleteByDomainIdAndCertPolicyGroupId(entityDomain.getId(), entityGroup.getId()).block();
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.OK).cacheControl(noCache)).build();
        }
        catch (Exception e) {
            log.error((Object)"Error disassociating policy group from domain.", (Throwable)e);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).cacheControl(noCache)).build();
        }
    }

    @DeleteMapping(value={"groups/domain/{domain}/deleteFromDomain"})
    public ResponseEntity<Mono<Void>> disassociatePolicyGroupsFromDomain(@PathVariable(value="domain") String domainName) {
        Domain entityDomain;
        try {
            entityDomain = (Domain)this.domainRepo.findByDomainNameIgnoreCase(domainName).block();
            if (entityDomain == null) {
                return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).cacheControl(noCache)).build();
            }
        }
        catch (Exception e) {
            log.error((Object)"Error looking up domain.", (Throwable)e);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).cacheControl(noCache)).build();
        }
        try {
            this.domainReltnRepo.deleteByDomainId(entityDomain.getId()).block();
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.OK).cacheControl(noCache)).build();
        }
        catch (Exception e) {
            log.error((Object)"Error disassociating policy groups from domain.", (Throwable)e);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).cacheControl(noCache)).build();
        }
    }

    @DeleteMapping(value={"groups/domain/{group}/deleteFromGroup"})
    public ResponseEntity<Mono<Void>> disassociatePolicyGroupFromDomains(@PathVariable(value="group") String groupName) {
        org.nhindirect.config.store.CertPolicyGroup entityGroup;
        try {
            entityGroup = (org.nhindirect.config.store.CertPolicyGroup)this.groupRepo.findByPolicyGroupNameIgnoreCase(groupName).block();
            if (entityGroup == null) {
                return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).cacheControl(noCache)).build();
            }
        }
        catch (Exception e) {
            log.error((Object)"Error looking up policy group.", (Throwable)e);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).cacheControl(noCache)).build();
        }
        try {
            this.domainReltnRepo.deleteByCertPolicyGroupId(entityGroup.getId()).block();
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.OK).cacheControl(noCache)).build();
        }
        catch (Exception e) {
            log.error((Object)"Error disassociating policy groups from domain.", (Throwable)e);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).cacheControl(noCache)).build();
        }
    }
}

