/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.resources;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nhindirect.config.model.Domain;
import org.nhindirect.config.repository.AddressRepository;
import org.nhindirect.config.repository.CertPolicyGroupDomainReltnRepository;
import org.nhindirect.config.repository.DomainRepository;
import org.nhindirect.config.resources.ProtectedResource;
import org.nhindirect.config.resources.TrustBundleResource;
import org.nhindirect.config.resources.util.EntityModelConversion;
import org.nhindirect.config.store.Address;
import org.nhindirect.config.store.EntityStatus;
import org.reactivestreams.Publisher;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.util.UriTemplate;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@RestController
@RequestMapping(value={"domain"})
public class DomainResource
extends ProtectedResource {
    private static final Log log = LogFactory.getLog(DomainResource.class);
    protected TrustBundleResource bundleResource;
    protected CertPolicyGroupDomainReltnRepository domainReltnRepo;
    protected AddressRepository addRepo;
    protected DomainRepository domainRepo;

    @Autowired
    public void setAddressRepository(AddressRepository addRepo) {
        this.addRepo = addRepo;
    }

    @Autowired
    public void setDomainRepository(DomainRepository domainRepo) {
        this.domainRepo = domainRepo;
    }

    @Autowired
    public void setAddressResource(TrustBundleResource bundleResource) {
        this.bundleResource = bundleResource;
    }

    @Autowired
    public void setDomainReltnRepository(CertPolicyGroupDomainReltnRepository domainReltnRepo) {
        this.domainReltnRepo = domainReltnRepo;
    }

    @GetMapping(value={"{domain}"}, produces={"application/json"})
    public ResponseEntity<Mono<Domain>> getDomain(@PathVariable(value="domain") String domain) {
        try {
            org.nhindirect.config.store.Domain retDomain = (org.nhindirect.config.store.Domain)this.domainRepo.findByDomainNameIgnoreCase(domain).block();
            if (retDomain == null) {
                return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).cacheControl(noCache)).build();
            }
            List addrs = (List)this.addRepo.findByDomainId(retDomain.getId()).collectList().block();
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.OK).cacheControl(noCache)).body((Object)Mono.just((Object)EntityModelConversion.toModelDomain(retDomain, addrs)));
        }
        catch (Exception e) {
            log.error((Object)"Error looking up domain.", (Throwable)e);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).cacheControl(noCache)).build();
        }
    }

    @GetMapping(produces={"application/json"})
    public ResponseEntity<Flux<Domain>> searchDomains(@RequestParam(name="domainName", defaultValue="") String domainName, @RequestParam(name="entityStatus", defaultValue="") String entityStatus) {
        EntityStatus status = null;
        if (!entityStatus.isEmpty()) {
            try {
                status = EntityStatus.valueOf((String)entityStatus);
            }
            catch (IllegalArgumentException e) {
                log.warn((Object)("EntityStatus enum value of " + entityStatus + " encountered.  Defaulting EntityStatus to null"));
            }
        }
        domainName = StringUtils.remove((String)domainName, (char)'*');
        try {
            Flux domains = null;
            domains = status == null && domainName.isEmpty() ? this.domainRepo.findAll() : (status == null ? this.domainRepo.findByDomainNameContainingIgnoreCase("%" + domainName.toUpperCase() + "%") : (domainName.isEmpty() ? this.domainRepo.findByStatus(status.ordinal()) : this.domainRepo.findByDomainNameContainingIgnoreCaseAndStatus("%" + domainName.toUpperCase() + "%", status.ordinal())));
            Flux retVal = domains.flatMap(domain -> this.addRepo.findByDomainId(domain.getId()).map(addr -> new DomainAddrsTuple((org.nhindirect.config.store.Domain)domain, (Address)addr)).switchIfEmpty((Publisher)Mono.just((Object)new DomainAddrsTuple((org.nhindirect.config.store.Domain)domain, null))).collectList()).map(tupls -> {
                ArrayList<Address> addrs = new ArrayList<Address>();
                for (DomainAddrsTuple tupl : tupls) {
                    if (tupl.getAddr() == null) continue;
                    addrs.add(tupl.getAddr());
                }
                return EntityModelConversion.toModelDomain(((DomainAddrsTuple)tupls.get(0)).getDomain(), addrs);
            });
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.OK).cacheControl(noCache)).body((Object)retVal);
        }
        catch (Exception e) {
            log.error((Object)"Error looking up domains.", (Throwable)e);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).cacheControl(noCache)).build();
        }
    }

    @PutMapping(consumes={"application/json"})
    public ResponseEntity<Mono<Void>> addDomain(@RequestBody Domain domain) {
        try {
            if (this.domainRepo.findByDomainNameIgnoreCase(domain.getDomainName()).block() != null) {
                return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.CONFLICT).cacheControl(noCache)).build();
            }
        }
        catch (Exception e) {
            log.error((Object)"Error looking up existing domain.", (Throwable)e);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).cacheControl(noCache)).build();
        }
        Map.Entry<org.nhindirect.config.store.Domain, Collection<Address>> toEntry = EntityModelConversion.toEntityDomain(domain);
        try {
            org.nhindirect.config.store.Domain savedDomain = toEntry.getKey();
            this.domainRepo.save((Object)savedDomain).block();
            Collection<Address> saveAddrs = toEntry.getValue();
            for (Address addr : saveAddrs) {
                addr.setId(null);
                addr.setDomainId(savedDomain.getId());
            }
            if (!saveAddrs.isEmpty()) {
                this.addRepo.saveAll(saveAddrs).collectList().block();
            }
            for (Address addr : saveAddrs) {
                if (addr.getEmailAddress().compareToIgnoreCase(domain.getPostmasterAddress().getEmailAddress()) != 0) continue;
                savedDomain.setPostmasterAddressId(addr.getId());
                this.domainRepo.save((Object)savedDomain).block();
                break;
            }
            URI uri = new UriTemplate("/{domain}").expand(new Object[]{"domain/" + domain.getDomainName()});
            return ((ResponseEntity.BodyBuilder)ResponseEntity.created((URI)uri).cacheControl(noCache)).build();
        }
        catch (Exception e) {
            log.error((Object)"Error adding domain.", (Throwable)e);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).cacheControl(noCache)).build();
        }
    }

    @PostMapping(consumes={"application/json"})
    public ResponseEntity<Mono<Void>> updateDomain(@RequestBody Domain domain) {
        org.nhindirect.config.store.Domain existingDomain;
        try {
            existingDomain = (org.nhindirect.config.store.Domain)this.domainRepo.findByDomainNameIgnoreCase(domain.getDomainName()).block();
            if (existingDomain == null) {
                return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).cacheControl(noCache)).build();
            }
        }
        catch (Exception e) {
            log.error((Object)"Error looking up existing domain.", (Throwable)e);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).cacheControl(noCache)).build();
        }
        org.nhindirect.config.store.Domain toDomain = EntityModelConversion.toEntityDomain(domain).getKey();
        toDomain.setId(existingDomain.getId());
        List addrs = (List)this.addRepo.findByDomainId(existingDomain.getId()).collectList().block();
        toDomain.setPostmasterAddressId(Long.valueOf(0L));
        if (domain.getPostmasterAddress() != null && !addrs.isEmpty()) {
            for (Address existingAddr : addrs) {
                if (!existingAddr.getEmailAddress().toLowerCase().equals(domain.getPostmasterAddress().getEmailAddress())) continue;
                toDomain.setPostmasterAddressId(existingAddr.getId());
            }
        }
        try {
            this.domainRepo.save((Object)toDomain).block();
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.NO_CONTENT).cacheControl(noCache)).build();
        }
        catch (Exception e) {
            log.error((Object)"Error updating domain.", (Throwable)e);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).cacheControl(noCache)).build();
        }
    }

    @DeleteMapping(value={"{domain}"})
    public ResponseEntity<Mono<Void>> removedDomain(@PathVariable(value="domain") String domain) {
        org.nhindirect.config.store.Domain foundDomain = (org.nhindirect.config.store.Domain)this.domainRepo.findByDomainNameIgnoreCase(domain).block();
        try {
            if (foundDomain == null) {
                return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).cacheControl(noCache)).build();
            }
        }
        catch (Exception e) {
            log.error((Object)"Error looking up existing domain.", (Throwable)e);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).cacheControl(noCache)).build();
        }
        try {
            this.bundleResource.disassociateTrustBundlesFromDomain(domain);
            this.domainReltnRepo.deleteByDomainId(foundDomain.getId()).block();
            this.addRepo.deleteByDomainId(foundDomain.getId()).block();
            this.domainRepo.deleteById((Object)foundDomain.getId()).block();
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.OK).cacheControl(noCache)).build();
        }
        catch (Exception e) {
            log.error((Object)"Error deleting domain.", (Throwable)e);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).cacheControl(noCache)).build();
        }
    }

    static class DomainAddrsTuple {
        final org.nhindirect.config.store.Domain domain;
        final Address addr;

        public DomainAddrsTuple(org.nhindirect.config.store.Domain domain, Address addr) {
            this.domain = domain;
            this.addr = addr;
        }

        public org.nhindirect.config.store.Domain getDomain() {
            return this.domain;
        }

        public Address getAddr() {
            return this.addr;
        }
    }
}

