/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.resources;

import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nhindirect.config.model.Setting;
import org.nhindirect.config.repository.SettingRepository;
import org.nhindirect.config.resources.ProtectedResource;
import org.nhindirect.config.resources.util.EntityModelConversion;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.util.UriTemplate;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@RestController
@RequestMapping(value={"setting"})
public class SettingResource
extends ProtectedResource {
    private static final Log log = LogFactory.getLog(SettingResource.class);
    protected SettingRepository settingRepo;

    @Autowired
    public void setSettingRepository(SettingRepository settingRepo) {
        this.settingRepo = settingRepo;
    }

    @GetMapping(produces={"application/json"})
    public ResponseEntity<Flux<Setting>> getAllSettings() {
        try {
            Flux retVal = this.settingRepo.findAll().map(setting -> EntityModelConversion.toModelSetting(setting));
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.OK).cacheControl(noCache)).body((Object)retVal);
        }
        catch (Exception e) {
            log.error((Object)"Error looking up settings.", (Throwable)e);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).cacheControl(noCache)).build();
        }
    }

    @GetMapping(value={"{name}"}, produces={"application/json"})
    public ResponseEntity<Mono<Setting>> getSettingByName(@PathVariable(value="name") String name) {
        try {
            Collection retSettings = (Collection)this.settingRepo.findByNameIgnoreCaseIn(Arrays.asList(name.toUpperCase())).collectList().block();
            if (retSettings.isEmpty()) {
                return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).cacheControl(noCache)).build();
            }
            Setting modelSetting = EntityModelConversion.toModelSetting((org.nhindirect.config.store.Setting)retSettings.iterator().next());
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.OK).cacheControl(noCache)).body((Object)Mono.just((Object)modelSetting));
        }
        catch (Exception e) {
            log.error((Object)"Error looking up setting.", (Throwable)e);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).cacheControl(noCache)).build();
        }
    }

    @PutMapping(value={"{name}/{value}"})
    public ResponseEntity<Mono<Void>> addSetting(@PathVariable(value="name") String name, @PathVariable(value="value") String value) {
        if (name == null || name.isEmpty()) {
            log.error((Object)"Name cannot be null or empty");
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.BAD_REQUEST).cacheControl(noCache)).build();
        }
        if (value == null) {
            log.error((Object)"Value cannot be null");
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.BAD_REQUEST).cacheControl(noCache)).build();
        }
        try {
            if (this.settingRepo.findByNameIgnoreCase(name).block() != null) {
                return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.CONFLICT).cacheControl(noCache)).build();
            }
        }
        catch (Exception e) {
            log.error((Object)"Error looking up setting.", (Throwable)e);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).cacheControl(noCache)).build();
        }
        try {
            org.nhindirect.config.store.Setting addSetting = new org.nhindirect.config.store.Setting();
            addSetting.setName(name);
            addSetting.setValue(value);
            addSetting.setId(null);
            this.settingRepo.save((Object)addSetting).block();
            URI uri = new UriTemplate("/{name}").expand(new Object[]{"setting/" + name});
            return ((ResponseEntity.BodyBuilder)ResponseEntity.created((URI)uri).cacheControl(noCache)).build();
        }
        catch (Exception e) {
            log.error((Object)"Error adding setting.", (Throwable)e);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).cacheControl(noCache)).build();
        }
    }

    @PostMapping(value={"{name}/{value}"})
    public ResponseEntity<Mono<Void>> updateSetting(@PathVariable(value="name") String name, @PathVariable(value="value") String value) {
        org.nhindirect.config.store.Setting retSetting = null;
        try {
            retSetting = (org.nhindirect.config.store.Setting)this.settingRepo.findByNameIgnoreCase(name).block();
            if (retSetting == null) {
                return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).cacheControl(noCache)).build();
            }
        }
        catch (Exception e) {
            log.error((Object)"Error looking up setting.", (Throwable)e);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).cacheControl(noCache)).build();
        }
        try {
            retSetting.setValue(value);
            this.settingRepo.save((Object)retSetting).block();
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.NO_CONTENT).cacheControl(noCache)).build();
        }
        catch (Exception e) {
            log.error((Object)"Error updating setting.", (Throwable)e);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).cacheControl(noCache)).build();
        }
    }

    @DeleteMapping(value={"{name}"})
    public ResponseEntity<Mono<Void>> removeSettingByName(@PathVariable(value="name") String name) {
        try {
            if (this.settingRepo.findByNameIgnoreCase(name).block() == null) {
                return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).cacheControl(noCache)).build();
            }
        }
        catch (Exception e) {
            log.error((Object)"Error looking up setting.", (Throwable)e);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).cacheControl(noCache)).build();
        }
        try {
            this.settingRepo.deleteByNameIgnoreCase(name).block();
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.OK).cacheControl(noCache)).build();
        }
        catch (Exception e) {
            log.error((Object)"Error removing setting by name.", (Throwable)e);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).cacheControl(noCache)).build();
        }
    }
}

