/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.resources;

import edu.emory.mathcs.backport.java.util.Arrays;
import java.net.URI;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.camel.ProducerTemplate;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nhindirect.config.model.exceptions.CertificateConversionException;
import org.nhindirect.config.model.utils.CertUtils;
import org.nhindirect.config.repository.AddressRepository;
import org.nhindirect.config.repository.DomainRepository;
import org.nhindirect.config.repository.TrustBundleAnchorRepository;
import org.nhindirect.config.repository.TrustBundleDomainReltnRepository;
import org.nhindirect.config.repository.TrustBundleRepository;
import org.nhindirect.config.resources.ProtectedResource;
import org.nhindirect.config.resources.util.EntityModelConversion;
import org.nhindirect.config.store.Address;
import org.nhindirect.config.store.Domain;
import org.nhindirect.config.store.TrustBundle;
import org.nhindirect.config.store.TrustBundleAnchor;
import org.nhindirect.config.store.TrustBundleDomainReltn;
import org.reactivestreams.Publisher;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.util.UriTemplate;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@RestController
@RequestMapping(value={"trustbundle"})
public class TrustBundleResource
extends ProtectedResource {
    private static final Log log = LogFactory.getLog(TrustBundleResource.class);
    protected TrustBundleRepository bundleRepo;
    protected TrustBundleAnchorRepository bundleAnchorRepo;
    protected TrustBundleDomainReltnRepository reltnRepo;
    protected DomainRepository domainRepo;
    protected AddressRepository addRepo;
    protected ProducerTemplate template;

    @Autowired
    public void setTrustBundleRepository(TrustBundleRepository bundleRepo) {
        this.bundleRepo = bundleRepo;
    }

    @Autowired
    public void setTrustBundleRepository(TrustBundleAnchorRepository bundleAnchorRepo) {
        this.bundleAnchorRepo = bundleAnchorRepo;
    }

    @Autowired
    public void setTrustBundleDomainReltnRepository(TrustBundleDomainReltnRepository reltnRepo) {
        this.reltnRepo = reltnRepo;
    }

    @Autowired
    public void setDomainRepository(DomainRepository domainRepo) {
        this.domainRepo = domainRepo;
    }

    @Autowired
    public void setAddressRepository(AddressRepository addRepo) {
        this.addRepo = addRepo;
    }

    @Autowired
    @Qualifier(value="bundleRefresh")
    public void setTemplate(ProducerTemplate template) {
        this.template = template;
    }

    @GetMapping(produces={"application/json"})
    public ResponseEntity<Flux<org.nhindirect.config.model.TrustBundle>> getTrustBundles(@RequestParam(name="fetchAnchors", defaultValue="true") boolean fetchAnchors) {
        try {
            Flux retVal = this.bundleRepo.findAll().flatMap(bundle -> {
                Flux anchorFlux = !fetchAnchors ? Flux.fromIterable(new ArrayList()) : this.bundleAnchorRepo.findByTrustBundleId(bundle.getId());
                return anchorFlux.map(anchor -> new BundleAnchorTuple((TrustBundle)bundle, (TrustBundleAnchor)anchor)).switchIfEmpty((Publisher)Mono.just((Object)new BundleAnchorTuple((TrustBundle)bundle, null))).collectList();
            }).map(tupls -> {
                ArrayList<TrustBundleAnchor> anchors = new ArrayList<TrustBundleAnchor>();
                for (BundleAnchorTuple tupl : tupls) {
                    if (tupl.getAnchor() == null) continue;
                    anchors.add(tupl.getAnchor());
                }
                return EntityModelConversion.toModelTrustBundle(((BundleAnchorTuple)tupls.get(0)).getBundle(), anchors);
            });
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.OK).cacheControl(noCache)).body((Object)retVal);
        }
        catch (Throwable e) {
            log.error((Object)"Error looking up trust bundles", e);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).cacheControl(noCache)).build();
        }
    }

    @GetMapping(value={"domains/bundles/reltns"}, produces={"application/json"})
    public ResponseEntity<Flux<org.nhindirect.config.model.TrustBundleDomainReltn>> getAllTrustBundleDomainRelts(@RequestParam(name="fetchAnchors", defaultValue="true") boolean fetchAnchors) {
        try {
            Flux retVal = this.reltnRepo.findAll().map(bundleReltn -> {
                ArrayList<TrustBundleAnchor> anchors = !fetchAnchors ? new ArrayList<TrustBundleAnchor>() : (List)this.bundleAnchorRepo.findByTrustBundleId(bundleReltn.getTrustBundleId()).collectList().block();
                ArrayList<Address> addrs = !fetchAnchors ? new ArrayList<Address>() : (List)this.addRepo.findByDomainId(bundleReltn.getDomainId()).collectList().block();
                org.nhindirect.config.model.TrustBundleDomainReltn newReltn = new org.nhindirect.config.model.TrustBundleDomainReltn();
                newReltn.setIncoming(bundleReltn.isIncoming());
                newReltn.setOutgoing(bundleReltn.isOutgoing());
                newReltn.setDomain(EntityModelConversion.toModelDomain((Domain)this.domainRepo.findById((Object)bundleReltn.getDomainId()).block(), addrs));
                newReltn.setTrustBundle(EntityModelConversion.toModelTrustBundle((TrustBundle)this.bundleRepo.findById((Object)bundleReltn.getTrustBundleId()).block(), anchors));
                return newReltn;
            });
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.OK).cacheControl(noCache)).body((Object)retVal);
        }
        catch (Throwable e) {
            log.error((Object)"Error looking up trust bundles", e);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).cacheControl(noCache)).build();
        }
    }

    @GetMapping(value={"domains/{domainName}"}, produces={"application/json"})
    public ResponseEntity<Flux<org.nhindirect.config.model.TrustBundleDomainReltn>> getTrustBundlesByDomain(@PathVariable(value="domainName") String domainName, @RequestParam(name="fetchAnchors", defaultValue="true") boolean fetchAnchors) {
        Domain entityDomain;
        try {
            entityDomain = (Domain)this.domainRepo.findByDomainNameIgnoreCase(domainName).block();
            if (entityDomain == null) {
                return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).cacheControl(noCache)).build();
            }
        }
        catch (Exception e) {
            log.error((Object)"Error looking up domain.", (Throwable)e);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).cacheControl(noCache)).build();
        }
        try {
            Flux retVal = this.reltnRepo.findByDomainId(entityDomain.getId()).flatMap(bundleReltn -> this.bundleRepo.findById((Object)bundleReltn.getTrustBundleId()).flatMap(bundle -> {
                Flux anchorFlux = !fetchAnchors ? Flux.fromIterable(new ArrayList()) : this.bundleAnchorRepo.findByTrustBundleId(bundle.getId());
                return anchorFlux.map(anchor -> new BundleAnchorTuple((TrustBundle)bundle, (TrustBundleAnchor)anchor)).switchIfEmpty((Publisher)Mono.just((Object)new BundleAnchorTuple((TrustBundle)bundle, null))).collectList();
            }).map(tupls -> {
                ArrayList<TrustBundleAnchor> anchors = new ArrayList<TrustBundleAnchor>();
                for (BundleAnchorTuple tupl : tupls) {
                    if (tupl.getAnchor() == null) continue;
                    anchors.add(tupl.getAnchor());
                }
                return EntityModelConversion.toModelTrustBundle(((BundleAnchorTuple)tupls.get(0)).getBundle(), anchors);
            }).map(bundle -> new BundleReltnTuple((org.nhindirect.config.model.TrustBundle)bundle, (TrustBundleDomainReltn)bundleReltn))).map(tupl -> {
                org.nhindirect.config.model.TrustBundleDomainReltn newReltn = new org.nhindirect.config.model.TrustBundleDomainReltn();
                newReltn.setIncoming(tupl.getReltn().isIncoming());
                newReltn.setOutgoing(tupl.getReltn().isOutgoing());
                newReltn.setDomain(EntityModelConversion.toModelDomain(entityDomain, Collections.emptyList()));
                newReltn.setTrustBundle(tupl.getBundle());
                return newReltn;
            });
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.OK).cacheControl(noCache)).body((Object)retVal);
        }
        catch (Throwable e) {
            log.error((Object)"Error looking up trust bundles", e);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).cacheControl(noCache)).build();
        }
    }

    @GetMapping(value={"{bundleName}"}, produces={"application/json"})
    public ResponseEntity<Mono<org.nhindirect.config.model.TrustBundle>> getTrustBundleByName(@PathVariable(value="bundleName") String bundleName) {
        try {
            TrustBundle retBundle = (TrustBundle)this.bundleRepo.findByBundleNameIgnoreCase(bundleName).block();
            if (retBundle == null) {
                return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).cacheControl(noCache)).build();
            }
            List anchors = (List)this.bundleAnchorRepo.findByTrustBundleId(retBundle.getId()).collectList().block();
            org.nhindirect.config.model.TrustBundle modelBundle = EntityModelConversion.toModelTrustBundle(retBundle, anchors);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.OK).cacheControl(noCache)).body((Object)Mono.just((Object)modelBundle));
        }
        catch (Throwable e) {
            log.error((Object)"Error looking up trust bundles", e);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).cacheControl(noCache)).build();
        }
    }

    @PutMapping(consumes={"application/json"})
    public ResponseEntity<Mono<Void>> addTrustBundle(@RequestBody org.nhindirect.config.model.TrustBundle bundle) {
        try {
            if (this.bundleRepo.findByBundleNameIgnoreCase(bundle.getBundleName()).block() != null) {
                return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.CONFLICT).cacheControl(noCache)).build();
            }
        }
        catch (Exception e) {
            log.error((Object)"Error looking up bundle.", (Throwable)e);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).cacheControl(noCache)).build();
        }
        try {
            Map.Entry<TrustBundle, Collection<TrustBundleAnchor>> entry = EntityModelConversion.toEntityTrustBundle(bundle);
            TrustBundle addBundle = entry.getKey();
            addBundle.setId(null);
            this.bundleRepo.save((Object)addBundle).block();
            this.template.sendBody((Object)addBundle);
            URI uri = new UriTemplate("/{bundle}").expand(new Object[]{"trustbundle/" + bundle.getBundleName()});
            return ((ResponseEntity.BodyBuilder)ResponseEntity.created((URI)uri).cacheControl(noCache)).build();
        }
        catch (Exception e) {
            log.error((Object)"Error adding trust bundle.", (Throwable)e);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).cacheControl(noCache)).build();
        }
    }

    @PostMapping(value={"{bundle}/refreshBundle"})
    public ResponseEntity<Mono<Void>> refreshTrustBundle(@PathVariable(value="bundle") String bundleName) {
        try {
            TrustBundle entityBundle = (TrustBundle)this.bundleRepo.findByBundleNameIgnoreCase(bundleName).block();
            if (entityBundle == null) {
                return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).cacheControl(noCache)).build();
            }
            this.template.sendBody((Object)entityBundle);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.NO_CONTENT).cacheControl(noCache)).build();
        }
        catch (Exception e) {
            log.error((Object)"Error refreshing bundle.", (Throwable)e);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).cacheControl(noCache)).build();
        }
    }

    @DeleteMapping(value={"{bundle}"})
    public ResponseEntity<Mono<Void>> deleteBundle(@PathVariable(value="bundle") String bundleName) {
        TrustBundle entityBundle;
        try {
            entityBundle = (TrustBundle)this.bundleRepo.findByBundleNameIgnoreCase(bundleName).block();
            if (entityBundle == null) {
                return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).cacheControl(noCache)).build();
            }
        }
        catch (Exception e) {
            log.error((Object)"Error looking up bundle.", (Throwable)e);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).cacheControl(noCache)).build();
        }
        try {
            this.bundleAnchorRepo.deleteByTrustBundleId(entityBundle.getId()).block();
            this.reltnRepo.deleteByTrustBundleId(entityBundle.getId()).block();
            this.bundleRepo.deleteById((Object)entityBundle.getId()).block();
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.OK).cacheControl(noCache)).build();
        }
        catch (Exception e) {
            log.error((Object)"Error deleting trust bundle.", (Throwable)e);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).cacheControl(noCache)).build();
        }
    }

    @PostMapping(value={"{bundle}/signingCert"}, consumes={"application/json"})
    public ResponseEntity<Mono<Void>> updateSigningCert(@PathVariable(value="bundle") String bundleName, @RequestBody(required=false) byte[] certData) {
        TrustBundle entityBundle;
        X509Certificate signingCert = null;
        if (certData != null && certData.length > 0) {
            try {
                signingCert = CertUtils.toX509Certificate((byte[])certData);
            }
            catch (CertificateConversionException ex) {
                log.error((Object)("Signing certificate is not in a valid format " + bundleName), (Throwable)ex);
                return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.BAD_REQUEST).cacheControl(noCache)).build();
            }
        }
        try {
            entityBundle = (TrustBundle)this.bundleRepo.findByBundleNameIgnoreCase(bundleName).block();
            if (entityBundle == null) {
                return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).cacheControl(noCache)).build();
            }
        }
        catch (Exception e) {
            log.error((Object)"Error looking up bundle.", (Throwable)e);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).cacheControl(noCache)).build();
        }
        try {
            entityBundle.setSigningCertificateData(signingCert == null ? null : signingCert.getEncoded());
            this.bundleRepo.save((Object)entityBundle).block();
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.NO_CONTENT).cacheControl(noCache)).build();
        }
        catch (Exception e) {
            log.error((Object)"Error updating trust bundle signing certificate.", (Throwable)e);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).cacheControl(noCache)).build();
        }
    }

    @PostMapping(value={"{bundle}/bundleAttributes"}, consumes={"application/json"})
    public ResponseEntity<Mono<Void>> updateBundleAttributes(@PathVariable(value="bundle") String bundleName, @RequestBody org.nhindirect.config.model.TrustBundle bundleData) {
        TrustBundle entityBundle;
        try {
            entityBundle = (TrustBundle)this.bundleRepo.findByBundleNameIgnoreCase(bundleName).block();
            if (entityBundle == null) {
                return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).cacheControl(noCache)).build();
            }
        }
        catch (Exception e) {
            log.error((Object)"Error looking up bundle.", (Throwable)e);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).cacheControl(noCache)).build();
        }
        if (entityBundle.getBundleName().equals(bundleData.getBundleName()) && entityBundle.getBundleURL().equals(bundleData.getBundleURL()) && entityBundle.getRefreshInterval() == bundleData.getRefreshInterval()) {
            if (bundleData.getSigningCertificateData() == null && entityBundle.getSigningCertificateData() == null) {
                return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.NO_CONTENT).cacheControl(noCache)).build();
            }
            if (bundleData.getSigningCertificateData() != null && entityBundle.getSigningCertificateData() != null && Arrays.equals((byte[])bundleData.getSigningCertificateData(), (byte[])entityBundle.getSigningCertificateData())) {
                return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.NO_CONTENT).cacheControl(noCache)).build();
            }
        }
        String oldBundleURL = entityBundle.getBundleURL();
        X509Certificate newSigningCert = null;
        if (bundleData.getSigningCertificateData() != null) {
            try {
                newSigningCert = CertUtils.toX509Certificate((byte[])bundleData.getSigningCertificateData());
            }
            catch (CertificateConversionException ex) {
                log.error((Object)("Signing certificate is not in a valid format " + bundleName), (Throwable)ex);
                return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.BAD_REQUEST).cacheControl(noCache)).build();
            }
        }
        try {
            if (newSigningCert == null) {
                entityBundle.setSigningCertificateData(null);
            } else {
                entityBundle.setSigningCertificateData(newSigningCert.getEncoded());
            }
            if (!StringUtils.isEmpty((CharSequence)bundleData.getBundleName())) {
                entityBundle.setBundleName(bundleData.getBundleName());
            }
            entityBundle.setRefreshInterval(bundleData.getRefreshInterval());
            if (!StringUtils.isEmpty((CharSequence)bundleData.getBundleURL())) {
                entityBundle.setBundleURL(bundleData.getBundleURL());
            }
            this.bundleRepo.save((Object)entityBundle).block();
            if (bundleData.getBundleURL() != null && !bundleData.getBundleURL().isEmpty() && !oldBundleURL.equals(bundleData.getBundleURL())) {
                entityBundle = (TrustBundle)this.bundleRepo.findById((Object)entityBundle.getId()).block();
                this.template.sendBody((Object)entityBundle);
            }
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.NO_CONTENT).cacheControl(noCache)).build();
        }
        catch (Exception e) {
            log.error((Object)"Error updating trust bundle attributes.", (Throwable)e);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).cacheControl(noCache)).build();
        }
    }

    @PostMapping(value={"{bundle}/{domain}"})
    public ResponseEntity<Mono<Void>> associateTrustBundleToDomain(@PathVariable(value="bundle") String bundleName, @PathVariable(value="domain") String domainName, @RequestParam(name="incoming", defaultValue="true") boolean incoming, @RequestParam(name="outgoing", defaultValue="true") boolean outgoing) {
        Domain entityDomain;
        TrustBundle entityBundle;
        try {
            entityBundle = (TrustBundle)this.bundleRepo.findByBundleNameIgnoreCase(bundleName).block();
            if (entityBundle == null) {
                return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).cacheControl(noCache)).build();
            }
        }
        catch (Exception e) {
            log.error((Object)"Error looking up bundle.", (Throwable)e);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).cacheControl(noCache)).build();
        }
        try {
            entityDomain = (Domain)this.domainRepo.findByDomainNameIgnoreCase(domainName).block();
            if (entityDomain == null) {
                return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).cacheControl(noCache)).build();
            }
        }
        catch (Exception e) {
            log.error((Object)"Error looking up domain.", (Throwable)e);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).cacheControl(noCache)).build();
        }
        try {
            TrustBundleDomainReltn reltn = new TrustBundleDomainReltn();
            reltn.setDomainId(entityDomain.getId());
            reltn.setTrustBundleId(entityBundle.getId());
            reltn.setIncoming(incoming);
            reltn.setOutgoing(outgoing);
            this.reltnRepo.save((Object)reltn).block();
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.NO_CONTENT).cacheControl(noCache)).build();
        }
        catch (Exception e) {
            log.error((Object)"Error associating trust bundle to domain.", (Throwable)e);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).cacheControl(noCache)).build();
        }
    }

    @DeleteMapping(value={"{bundle}/{domain}"})
    public ResponseEntity<Mono<Void>> disassociateTrustBundleFromDomain(@PathVariable(value="bundle") String bundleName, @PathVariable(value="domain") String domainName) {
        Domain entityDomain;
        TrustBundle entityBundle;
        try {
            entityBundle = (TrustBundle)this.bundleRepo.findByBundleNameIgnoreCase(bundleName).block();
            if (entityBundle == null) {
                return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).cacheControl(noCache)).build();
            }
        }
        catch (Exception e) {
            log.error((Object)"Error looking up bundle.", (Throwable)e);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).cacheControl(noCache)).build();
        }
        try {
            entityDomain = (Domain)this.domainRepo.findByDomainNameIgnoreCase(domainName).block();
            if (entityDomain == null) {
                return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).cacheControl(noCache)).build();
            }
        }
        catch (Exception e) {
            log.error((Object)"Error looking up domain.", (Throwable)e);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).cacheControl(noCache)).build();
        }
        try {
            this.reltnRepo.deleteByDomainIdAndTrustBundleId(entityDomain.getId(), entityBundle.getId()).block();
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.OK).cacheControl(noCache)).build();
        }
        catch (Exception e) {
            log.error((Object)"Error disassociating trust bundle from domain.", (Throwable)e);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).cacheControl(noCache)).build();
        }
    }

    @DeleteMapping(value={"{domain}/deleteFromDomain"})
    public ResponseEntity<Mono<Void>> disassociateTrustBundlesFromDomain(@PathVariable(value="domain") String domainName) {
        Domain entityDomain;
        try {
            entityDomain = (Domain)this.domainRepo.findByDomainNameIgnoreCase(domainName).block();
            if (entityDomain == null) {
                return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).cacheControl(noCache)).build();
            }
        }
        catch (Exception e) {
            log.error((Object)"Error looking up domain.", (Throwable)e);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).cacheControl(noCache)).build();
        }
        try {
            this.reltnRepo.deleteByDomainId(entityDomain.getId()).block();
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.OK).cacheControl(noCache)).build();
        }
        catch (Exception e) {
            log.error((Object)"Error disassociating trust bundles from domain.", (Throwable)e);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).cacheControl(noCache)).build();
        }
    }

    @DeleteMapping(value={"{bundle}/deleteFromBundle"})
    public ResponseEntity<Mono<Void>> disassociateTrustBundleFromDomains(@PathVariable(value="bundle") String bundleName) {
        TrustBundle entityBundle;
        try {
            entityBundle = (TrustBundle)this.bundleRepo.findByBundleNameIgnoreCase(bundleName).block();
            if (entityBundle == null) {
                return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).cacheControl(noCache)).build();
            }
        }
        catch (Exception e) {
            log.error((Object)"Error looking up bundle.", (Throwable)e);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).cacheControl(noCache)).build();
        }
        try {
            this.reltnRepo.deleteByTrustBundleId(entityBundle.getId()).block();
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.OK).cacheControl(noCache)).build();
        }
        catch (Exception e) {
            log.error((Object)"Error disassociating trust bundle from domains.", (Throwable)e);
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).cacheControl(noCache)).build();
        }
    }

    static class BundleReltnTuple {
        final org.nhindirect.config.model.TrustBundle bundle;
        final TrustBundleDomainReltn reltn;

        public BundleReltnTuple(org.nhindirect.config.model.TrustBundle bundle, TrustBundleDomainReltn reltn) {
            this.bundle = bundle;
            this.reltn = reltn;
        }

        public org.nhindirect.config.model.TrustBundle getBundle() {
            return this.bundle;
        }

        public TrustBundleDomainReltn getReltn() {
            return this.reltn;
        }
    }

    static class BundleAnchorTuple {
        final TrustBundle bundle;
        final TrustBundleAnchor anchor;

        public BundleAnchorTuple(TrustBundle bundle, TrustBundleAnchor anchor) {
            this.bundle = bundle;
            this.anchor = anchor;
        }

        public TrustBundle getBundle() {
            return this.bundle;
        }

        public TrustBundleAnchor getAnchor() {
            return this.anchor;
        }
    }
}

