/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.resources.util;

import com.google.common.collect.Maps;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.nhindirect.config.model.Anchor;
import org.nhindirect.config.model.CertPolicyGroup;
import org.nhindirect.config.model.CertPolicyGroupDomainReltn;
import org.nhindirect.config.model.CertPolicyGroupUse;
import org.nhindirect.config.model.CertPolicyUse;
import org.nhindirect.config.model.Certificate;
import org.nhindirect.config.model.DNSRecord;
import org.nhindirect.config.model.Domain;
import org.nhindirect.config.model.EntityStatus;
import org.nhindirect.config.model.Setting;
import org.nhindirect.config.model.exceptions.CertificateConversionException;
import org.nhindirect.config.model.utils.CertUtils;
import org.nhindirect.config.store.Address;
import org.nhindirect.config.store.BundleRefreshError;
import org.nhindirect.config.store.CertPolicy;
import org.nhindirect.config.store.CertPolicyGroupReltn;
import org.nhindirect.config.store.CertificateException;
import org.nhindirect.config.store.TrustBundle;
import org.nhindirect.config.store.TrustBundleAnchor;
import org.nhindirect.policy.PolicyLexicon;

public class EntityModelConversion {
    public static Map.Entry<org.nhindirect.config.store.Domain, Collection<Address>> toEntityDomain(Domain domain) {
        org.nhindirect.config.store.Domain retVal = new org.nhindirect.config.store.Domain();
        ArrayList<Address> addresses = new ArrayList<Address>();
        if (domain.getAddresses() != null) {
            boolean postmasterInAddressList = false;
            for (org.nhindirect.config.model.Address address : domain.getAddresses()) {
                addresses.add(EntityModelConversion.toEntityAddress(address, retVal));
                if (domain.getPostmasterAddress() == null || !address.getEmailAddress().equals(domain.getPostmasterAddress().getEmailAddress())) continue;
                if (address.getId() >= 0L) {
                    retVal.setPostmasterAddressId(Long.valueOf(address.getId()));
                }
                postmasterInAddressList = true;
            }
            if (!postmasterInAddressList && domain.getPostmasterAddress() != null) {
                addresses.add(EntityModelConversion.toEntityAddress(domain.getPostmasterAddress(), retVal));
            }
        }
        retVal.setCreateTime(EntityModelConversion.localDateTimeFromCalendar(domain.getCreateTime()));
        retVal.setDomainName(domain.getDomainName());
        if (domain.getId() > 0L) {
            retVal.setId(Long.valueOf(domain.getId()));
        }
        if (domain.getStatus() != null) {
            retVal.setStatus(org.nhindirect.config.store.EntityStatus.valueOf((String)domain.getStatus().toString()).ordinal());
        }
        retVal.setUpdateTime(EntityModelConversion.localDateTimeFromCalendar(domain.getUpdateTime()));
        return Maps.immutableEntry((Object)retVal, addresses);
    }

    public static Domain toModelDomain(org.nhindirect.config.store.Domain domain, List<Address> addrs) {
        Domain retVal = new Domain();
        ArrayList<org.nhindirect.config.model.Address> addresses = new ArrayList<org.nhindirect.config.model.Address>();
        if (addrs != null) {
            for (Address address : addrs) {
                addresses.add(EntityModelConversion.toModelAddress(address, domain.getDomainName()));
            }
        }
        retVal.setAddresses(addresses);
        retVal.setCreateTime(EntityModelConversion.calendarFromLocalDateTime(domain.getCreateTime()));
        retVal.setDomainName(domain.getDomainName());
        retVal.setId(domain.getId().longValue());
        if (addrs.size() > 0 && domain.getPostmasterAddressId() != null && domain.getPostmasterAddressId() > 0L) {
            for (Address address : addrs) {
                if (!address.getId().equals(domain.getPostmasterAddressId())) continue;
                retVal.setPostmasterAddress(EntityModelConversion.toModelAddress(address, domain.getDomainName()));
                break;
            }
        }
        if (domain.getStatus() >= 0) {
            retVal.setStatus(EntityStatus.values()[domain.getStatus()]);
        }
        retVal.setUpdateTime(EntityModelConversion.calendarFromLocalDateTime(domain.getUpdateTime()));
        return retVal;
    }

    public static org.nhindirect.config.model.Address toModelAddress(Address address, String domainName) {
        if (address == null) {
            return null;
        }
        org.nhindirect.config.model.Address retVal = new org.nhindirect.config.model.Address();
        retVal.setCreateTime(EntityModelConversion.calendarFromLocalDateTime(address.getCreateTime()));
        retVal.setDisplayName(address.getDisplayName());
        retVal.setEmailAddress(address.getEmailAddress());
        retVal.setEndpoint(address.getEndpoint());
        retVal.setId(address.getId().longValue());
        if (address.getStatus() >= 0) {
            retVal.setStatus(EntityStatus.values()[address.getStatus()]);
        }
        retVal.setType(address.getType());
        retVal.setUpdateTime(EntityModelConversion.calendarFromLocalDateTime(address.getUpdateTime()));
        if (!domainName.isEmpty()) {
            retVal.setDomainName(domainName);
        }
        return retVal;
    }

    public static Address toEntityAddress(org.nhindirect.config.model.Address address, org.nhindirect.config.store.Domain domain) {
        if (address == null) {
            return null;
        }
        Address retVal = new Address();
        retVal.setCreateTime(EntityModelConversion.localDateTimeFromCalendar(address.getCreateTime()));
        retVal.setDisplayName(address.getDisplayName());
        retVal.setEmailAddress(address.getEmailAddress());
        retVal.setEndpoint(address.getEndpoint());
        if (address.getId() >= 0L) {
            retVal.setId(Long.valueOf(address.getId()));
        }
        if (address.getStatus() != null) {
            retVal.setStatus(org.nhindirect.config.store.EntityStatus.valueOf((String)address.getStatus().toString()).ordinal());
        }
        retVal.setType(address.getType());
        retVal.setUpdateTime(EntityModelConversion.localDateTimeFromCalendar(address.getUpdateTime()));
        retVal.setDomainId(domain.getId());
        return retVal;
    }

    public static Anchor toModelAnchor(org.nhindirect.config.store.Anchor anchor) {
        if (anchor == null) {
            return null;
        }
        Anchor retVal = new Anchor();
        retVal.setCertificateData(anchor.getData());
        retVal.setCertificateId(anchor.getCertificateId());
        retVal.setCreateTime(EntityModelConversion.calendarFromLocalDateTime(anchor.getCreateTime()));
        retVal.setId(anchor.getId().longValue());
        retVal.setIncoming(anchor.isIncoming());
        retVal.setOutgoing(anchor.isOutgoing());
        retVal.setOwner(anchor.getOwner());
        retVal.setStatus(EntityStatus.values()[anchor.getStatus()]);
        retVal.setThumbprint(anchor.getThumbprint());
        retVal.setValidEndDate(EntityModelConversion.calendarFromLocalDateTime(anchor.getValidEndDate()));
        retVal.setValidStartDate(EntityModelConversion.calendarFromLocalDateTime(anchor.getValidStartDate()));
        return retVal;
    }

    public static org.nhindirect.config.store.Anchor toEntityAnchor(Anchor anchor) throws CertificateException {
        if (anchor == null) {
            return null;
        }
        org.nhindirect.config.store.Anchor retVal = new org.nhindirect.config.store.Anchor();
        retVal.setData(anchor.getCertificateData());
        retVal.setCertificateId(anchor.getCertificateId());
        retVal.setCreateTime(EntityModelConversion.localDateTimeFromCalendar(anchor.getCreateTime()));
        if (anchor.getId() >= 0L) {
            retVal.setId(Long.valueOf(anchor.getId()));
        }
        retVal.setIncoming(anchor.isIncoming());
        retVal.setOutgoing(anchor.isOutgoing());
        retVal.setOwner(anchor.getOwner());
        retVal.setStatus(org.nhindirect.config.store.EntityStatus.valueOf((String)anchor.getStatus().toString()).ordinal());
        retVal.setValidEndDate(EntityModelConversion.localDateTimeFromCalendar(anchor.getValidEndDate()));
        retVal.setValidStartDate(EntityModelConversion.localDateTimeFromCalendar(anchor.getValidStartDate()));
        return retVal;
    }

    public static Certificate toModelCertificate(org.nhindirect.config.store.Certificate cert) {
        if (cert == null) {
            return null;
        }
        Certificate retVal = new Certificate();
        retVal.setOwner(cert.getOwner());
        retVal.setCreateTime(EntityModelConversion.calendarFromLocalDateTime(cert.getCreateTime()));
        retVal.setData(cert.getData());
        retVal.setId(cert.getId().longValue());
        retVal.setPrivateKey(cert.isPrivateKey());
        if (cert.getStatus() >= 0) {
            retVal.setStatus(EntityStatus.values()[cert.getStatus()]);
        }
        retVal.setThumbprint(cert.getThumbprint());
        retVal.setValidEndDate(EntityModelConversion.calendarFromLocalDateTime(cert.getValidEndDate()));
        retVal.setValidStartDate(EntityModelConversion.calendarFromLocalDateTime(cert.getValidStartDate()));
        return retVal;
    }

    public static org.nhindirect.config.store.Certificate toEntityCertificate(Certificate cert) throws CertificateException {
        if (cert == null) {
            return null;
        }
        org.nhindirect.config.store.Certificate retVal = new org.nhindirect.config.store.Certificate();
        retVal.setOwner(cert.getOwner());
        retVal.setCreateTime(EntityModelConversion.localDateTimeFromCalendar(cert.getCreateTime()));
        retVal.setData(cert.getData());
        if (cert.getId() >= 0L) {
            retVal.setId(Long.valueOf(cert.getId()));
        }
        if (cert.getStatus() != null) {
            retVal.setStatus(org.nhindirect.config.store.EntityStatus.valueOf((String)cert.getStatus().toString()).ordinal());
        }
        CertUtils.CertContainer cont = CertUtils.toCertContainer((byte[])retVal.getData());
        Calendar endDate = Calendar.getInstance(Locale.getDefault());
        endDate.setTime(cont.getCert().getNotAfter());
        retVal.setValidEndDate(EntityModelConversion.localDateTimeFromCalendar(endDate));
        Calendar startDate = Calendar.getInstance(Locale.getDefault());
        startDate.setTime(cont.getCert().getNotBefore());
        retVal.setValidStartDate(EntityModelConversion.localDateTimeFromCalendar(startDate));
        return retVal;
    }

    public static DNSRecord toModelDNSRecord(org.nhindirect.config.store.DNSRecord record) {
        if (record == null) {
            return null;
        }
        DNSRecord retVal = new DNSRecord();
        retVal.setCreateTime(EntityModelConversion.calendarFromLocalDateTime(record.getCreateTime()));
        retVal.setData(record.getData());
        retVal.setDclass(record.getDclass());
        retVal.setId(record.getId().longValue());
        retVal.setName(record.getName());
        retVal.setTtl(record.getTtl());
        retVal.setType(record.getType());
        return retVal;
    }

    public static org.nhindirect.config.store.DNSRecord toEntityDNSRecord(DNSRecord record) {
        if (record == null) {
            return null;
        }
        org.nhindirect.config.store.DNSRecord retVal = new org.nhindirect.config.store.DNSRecord();
        retVal.setCreateTime(EntityModelConversion.localDateTimeFromCalendar(record.getCreateTime()));
        retVal.setData(record.getData());
        retVal.setDclass(record.getDclass());
        if (record.getId() >= 0L) {
            retVal.setId(Long.valueOf(record.getId()));
        }
        retVal.setName(record.getName());
        retVal.setTtl(record.getTtl());
        retVal.setType(record.getType());
        return retVal;
    }

    public static Setting toModelSetting(org.nhindirect.config.store.Setting setting) {
        if (setting == null) {
            return null;
        }
        Setting retVal = new Setting();
        retVal.setId(setting.getId().longValue());
        retVal.setName(setting.getName());
        if (setting.getStatus() >= 0) {
            retVal.setStatus(EntityStatus.values()[setting.getStatus()]);
        }
        retVal.setUpdateTime(EntityModelConversion.calendarFromLocalDateTime(setting.getUpdateTime()));
        retVal.setCreateTime(EntityModelConversion.calendarFromLocalDateTime(setting.getCreateTime()));
        retVal.setValue(setting.getValue());
        return retVal;
    }

    public static org.nhindirect.config.model.TrustBundle toModelTrustBundle(TrustBundle bundle, List<TrustBundleAnchor> anchors) {
        if (bundle == null) {
            return null;
        }
        org.nhindirect.config.model.TrustBundle retVal = new org.nhindirect.config.model.TrustBundle();
        ArrayList<org.nhindirect.config.model.TrustBundleAnchor> trustAnchors = new ArrayList<org.nhindirect.config.model.TrustBundleAnchor>();
        if (anchors != null) {
            for (TrustBundleAnchor anchor : anchors) {
                org.nhindirect.config.model.TrustBundleAnchor retAnchor = new org.nhindirect.config.model.TrustBundleAnchor();
                retAnchor.setAnchorData(anchor.getData());
                retAnchor.setThumbprint(anchor.getThumbprint());
                retAnchor.setId(anchor.getId().longValue());
                retAnchor.setValidEndDate(EntityModelConversion.calendarFromLocalDateTime(anchor.getValidEndDate()));
                retAnchor.setValidStartDate(EntityModelConversion.calendarFromLocalDateTime(anchor.getValidStartDate()));
                trustAnchors.add(retAnchor);
            }
        }
        retVal.setBundleName(bundle.getBundleName());
        retVal.setBundleURL(bundle.getBundleURL());
        retVal.setCheckSum(bundle.getCheckSum());
        retVal.setCreateTime(EntityModelConversion.calendarFromLocalDateTime(bundle.getCreateTime()));
        retVal.setId(bundle.getId().longValue());
        retVal.setLastRefreshAttempt(EntityModelConversion.calendarFromLocalDateTime(bundle.getLastRefreshAttempt()));
        if (bundle.getLastRefreshError() >= 0) {
            retVal.setLastRefreshError(org.nhindirect.config.model.BundleRefreshError.values()[bundle.getLastRefreshError()]);
        }
        retVal.setLastSuccessfulRefresh(EntityModelConversion.calendarFromLocalDateTime(bundle.getLastSuccessfulRefresh()));
        retVal.setRefreshInterval(bundle.getRefreshInterval());
        retVal.setSigningCertificateData(bundle.getSigningCertificateData());
        retVal.setTrustBundleAnchors(trustAnchors);
        return retVal;
    }

    public static Map.Entry<TrustBundle, Collection<TrustBundleAnchor>> toEntityTrustBundle(org.nhindirect.config.model.TrustBundle bundle) {
        if (bundle == null) {
            return null;
        }
        TrustBundle retVal = new TrustBundle();
        ArrayList<TrustBundleAnchor> trustAnchors = new ArrayList<TrustBundleAnchor>();
        if (bundle.getTrustBundleAnchors() != null) {
            for (org.nhindirect.config.model.TrustBundleAnchor anchor : bundle.getTrustBundleAnchors()) {
                TrustBundleAnchor retAnchor = new TrustBundleAnchor();
                try {
                    retAnchor.setData(anchor.getAnchorData());
                }
                catch (CertificateException e) {
                    throw new CertificateConversionException((Throwable)e);
                }
                retAnchor.setTrustBundleId(retVal.getId());
                trustAnchors.add(retAnchor);
            }
        }
        retVal.setBundleName(bundle.getBundleName());
        retVal.setBundleURL(bundle.getBundleURL());
        if (bundle.getCheckSum() == null) {
            retVal.setCheckSum("");
        } else {
            retVal.setCheckSum(bundle.getCheckSum());
        }
        retVal.setCreateTime(bundle.getCreateTime() != null ? EntityModelConversion.localDateTimeFromCalendar(bundle.getCreateTime()) : LocalDateTime.now());
        if (bundle.getId() >= 0L) {
            retVal.setId(Long.valueOf(bundle.getId()));
        }
        retVal.setLastRefreshAttempt(EntityModelConversion.localDateTimeFromCalendar(bundle.getLastRefreshAttempt()));
        if (bundle.getLastRefreshError() != null) {
            retVal.setLastRefreshError(BundleRefreshError.valueOf((String)bundle.getLastRefreshError().toString()).ordinal());
        }
        retVal.setLastSuccessfulRefresh(EntityModelConversion.localDateTimeFromCalendar(bundle.getLastSuccessfulRefresh()));
        retVal.setRefreshInterval(bundle.getRefreshInterval());
        if (bundle.getSigningCertificateData() != null) {
            try {
                retVal.setSigningCertificateData(bundle.getSigningCertificateData());
            }
            catch (CertificateException e) {
                throw new CertificateConversionException((Throwable)e);
            }
        }
        return Maps.immutableEntry((Object)retVal, trustAnchors);
    }

    public static org.nhindirect.config.model.CertPolicy toModelCertPolicy(CertPolicy policy) {
        if (policy == null) {
            return null;
        }
        org.nhindirect.config.model.CertPolicy retVal = new org.nhindirect.config.model.CertPolicy();
        retVal.setPolicyName(policy.getPolicyName());
        retVal.setCreateTime(EntityModelConversion.calendarFromLocalDateTime(policy.getCreateTime()));
        if (policy.getLexicon() >= 0) {
            retVal.setLexicon(PolicyLexicon.values()[policy.getLexicon()]);
        }
        retVal.setPolicyData(policy.getPolicyData());
        return retVal;
    }

    public static CertPolicy toEntityCertPolicy(org.nhindirect.config.model.CertPolicy policy) {
        if (policy == null) {
            return null;
        }
        CertPolicy retVal = new CertPolicy();
        retVal.setPolicyName(policy.getPolicyName());
        retVal.setCreateTime(policy.getCreateTime() != null ? EntityModelConversion.localDateTimeFromCalendar(policy.getCreateTime()) : LocalDateTime.now());
        if (policy.getLexicon() != null) {
            retVal.setLexicon(PolicyLexicon.valueOf((String)policy.getLexicon().toString()).ordinal());
        }
        retVal.setPolicyData(policy.getPolicyData());
        return retVal;
    }

    public static CertPolicyGroup toModelCertPolicyGroup(org.nhindirect.config.store.CertPolicyGroup group, Map<CertPolicyGroupReltn, CertPolicy> polUseMap) {
        if (group == null) {
            return null;
        }
        CertPolicyGroup retVal = new CertPolicyGroup();
        ArrayList<CertPolicyGroupUse> uses = new ArrayList<CertPolicyGroupUse>();
        if (!polUseMap.isEmpty()) {
            for (Map.Entry<CertPolicyGroupReltn, CertPolicy> reltnEntry : polUseMap.entrySet()) {
                CertPolicyGroupUse use = new CertPolicyGroupUse();
                CertPolicyGroupReltn reltn = reltnEntry.getKey();
                use.setPolicy(EntityModelConversion.toModelCertPolicy(reltnEntry.getValue()));
                if (reltn.getPolicyUse() >= 0) {
                    use.setPolicyUse(CertPolicyUse.values()[reltn.getPolicyUse()]);
                }
                use.setIncoming(reltn.isIncoming());
                use.setOutgoing(reltn.isOutgoing());
                uses.add(use);
            }
        }
        retVal.setPolicyGroupName(group.getPolicyGroupName());
        retVal.setCreateTime(EntityModelConversion.calendarFromLocalDateTime(group.getCreateTime()));
        retVal.setPolicies(uses);
        return retVal;
    }

    public static org.nhindirect.config.store.CertPolicyGroup toEntityCertPolicyGroup(CertPolicyGroup group) {
        if (group == null) {
            return null;
        }
        org.nhindirect.config.store.CertPolicyGroup retVal = new org.nhindirect.config.store.CertPolicyGroup();
        retVal.setPolicyGroupName(group.getPolicyGroupName());
        retVal.setCreateTime(group.getCreateTime() != null ? EntityModelConversion.localDateTimeFromCalendar(group.getCreateTime()) : LocalDateTime.now());
        return retVal;
    }

    public static CertPolicyGroupDomainReltn toModelCertPolicyGroupDomainReltn(Long id, org.nhindirect.config.store.Domain domain, org.nhindirect.config.store.CertPolicyGroup group, Map<CertPolicyGroupReltn, CertPolicy> polUseMap) {
        CertPolicyGroupDomainReltn retVal = new CertPolicyGroupDomainReltn();
        retVal.setId(id.longValue());
        retVal.setPolicyGroup(EntityModelConversion.toModelCertPolicyGroup(group, polUseMap));
        retVal.setDomain(EntityModelConversion.toModelDomain(domain, Collections.emptyList()));
        return retVal;
    }

    public static Calendar calendarFromLocalDateTime(LocalDateTime time) {
        if (time == null) {
            return null;
        }
        Date date = Date.from(time.atZone(ZoneId.systemDefault()).toInstant());
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar;
    }

    public static LocalDateTime localDateTimeFromCalendar(Calendar time) {
        if (time == null) {
            return null;
        }
        TimeZone tz = time.getTimeZone();
        ZoneId zid = tz == null ? ZoneId.systemDefault() : tz.toZoneId();
        return LocalDateTime.ofInstant(time.toInstant(), zid);
    }
}

