/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.springconfig;

import org.apache.camel.CamelContext;
import org.apache.camel.ProducerTemplate;
import org.nhindirect.config.processor.BundleCacheUpdateProcessor;
import org.nhindirect.config.processor.BundleRefreshProcessor;
import org.nhindirect.config.processor.impl.DefaultBundleCacheUpdateProcessorImpl;
import org.nhindirect.config.processor.impl.DefaultBundleRefreshProcessorImpl;
import org.nhindirect.config.repository.TrustBundleAnchorRepository;
import org.nhindirect.config.repository.TrustBundleRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class BundleProcessorConfig {
    @Autowired
    protected CamelContext camelContext;
    @Value(value="${direct.config.bundlerefresh.endpointuri:seda:refresh-start}")
    protected String refreshEndpoint;

    @Bean
    public BundleRefreshProcessor bundleRefreshProcessor(TrustBundleRepository trustBundleRepo, TrustBundleAnchorRepository bundleAnchorRepo) {
        DefaultBundleRefreshProcessorImpl retVal = new DefaultBundleRefreshProcessorImpl();
        retVal.setRepositories(trustBundleRepo, bundleAnchorRepo);
        return retVal;
    }

    @Bean
    public BundleCacheUpdateProcessor bundleCacheUpdateProcessor(BundleRefreshProcessor refreshProc, TrustBundleRepository trustBundleRepo) {
        DefaultBundleCacheUpdateProcessorImpl proc = new DefaultBundleCacheUpdateProcessorImpl();
        proc.setRefreshProcessor(refreshProc);
        proc.setRepository(trustBundleRepo);
        return proc;
    }

    @Bean
    public ProducerTemplate bundleRefresh() throws Exception {
        ProducerTemplate template = this.camelContext.createProducerTemplate();
        template.setDefaultEndpointUri(this.refreshEndpoint);
        return template;
    }
}

