/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.processor.impl;

import java.time.LocalDateTime;
import org.nhindirect.config.processor.BundleCacheUpdateProcessor;
import org.nhindirect.config.processor.BundleRefreshProcessor;
import org.nhindirect.config.repository.TrustBundleRepository;
import org.nhindirect.config.store.TrustBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class DefaultBundleCacheUpdateProcessorImpl
implements BundleCacheUpdateProcessor {
    private static final Logger log = LoggerFactory.getLogger(DefaultBundleCacheUpdateProcessorImpl.class);
    protected TrustBundleRepository bundleRepo;
    protected BundleRefreshProcessor refreshProcessor;

    public void setRepository(TrustBundleRepository bundleRepo) {
        this.bundleRepo = bundleRepo;
    }

    public void setRefreshProcessor(BundleRefreshProcessor refreshProcessor) {
        this.refreshProcessor = refreshProcessor;
    }

    @Override
    public Mono<Void> updateBundleCache() {
        try {
            return this.bundleRepo.findAll().flatMap(bundle -> {
                if (bundle.getRefreshInterval() <= 0) {
                    return Mono.empty();
                }
                boolean refresh = false;
                LocalDateTime lastAttempt = bundle.getLastSuccessfulRefresh();
                if (lastAttempt == null) {
                    refresh = true;
                } else {
                    LocalDateTime now = LocalDateTime.now();
                    LocalDateTime lastAttemptCheck = LocalDateTime.from(lastAttempt);
                    if ((lastAttemptCheck = lastAttemptCheck.plusSeconds(bundle.getRefreshInterval())).isBefore(now)) {
                        refresh = true;
                    }
                }
                Mono<?> retVal = refresh ? this.refreshProcessor.refreshBundle((TrustBundle)bundle) : Mono.empty();
                return retVal.onErrorResume(e -> {
                    log.error("Error refreshing trust bundles", e);
                    return Mono.empty();
                });
            }).onErrorResume(e -> {
                log.error("Error refreshing trust bundles", e);
                return Mono.empty();
            }).then();
        }
        catch (Exception e2) {
            log.error("Error retriving trust bundles", (Throwable)e2);
            return Mono.empty();
        }
    }
}

