/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.resources;

import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import org.nhindirect.common.cert.Thumbprint;
import org.nhindirect.config.model.Anchor;
import org.nhindirect.config.repository.AnchorRepository;
import org.nhindirect.config.resources.ProtectedResource;
import org.nhindirect.config.resources.util.EntityModelConversion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@RestController
@RequestMapping(value={"anchor"})
public class AnchorResource
extends ProtectedResource {
    private static final Logger log = LoggerFactory.getLogger(AnchorResource.class);
    protected AnchorRepository anchorRepo;

    @Autowired
    public void setAnchorRepository(AnchorRepository anchorRepo) {
        this.anchorRepo = anchorRepo;
    }

    @GetMapping(value={"/{owner}"}, produces={"application/json"})
    public Flux<Anchor> getAnchorForOwner(@RequestParam(name="incoming", defaultValue="false") boolean incoming, @RequestParam(name="outgoing", defaultValue="false") boolean outgoing, @RequestParam(name="thumbprint", defaultValue="") String thumbprint, @PathVariable(value="owner") String owner) {
        return this.anchorRepo.findByOwnerIgnoreCase(owner).filter(anchor -> !(incoming && !anchor.isIncoming() || outgoing && !anchor.isOutgoing() || !thumbprint.isEmpty() && !thumbprint.equalsIgnoreCase(anchor.getThumbprint()))).map(anchor -> EntityModelConversion.toModelAnchor(anchor)).onErrorResume(e -> {
            log.error("Error looking up anchors.", e);
            return Mono.error((Throwable)new ResponseStatusException(HttpStatus.INTERNAL_SERVER_ERROR));
        });
    }

    @GetMapping(produces={"application/json"})
    public Flux<Anchor> getAnchors() {
        return this.anchorRepo.findAll().map(anchor -> EntityModelConversion.toModelAnchor(anchor)).onErrorResume(e -> {
            log.error("Error looking up anchors.", e);
            return Mono.error((Throwable)new ResponseStatusException(HttpStatus.INTERNAL_SERVER_ERROR));
        });
    }

    @PutMapping(consumes={"application/json"})
    @ResponseStatus(value=HttpStatus.CREATED)
    public Mono<Void> addAnchor(@RequestBody Anchor anchor) {
        try {
            String thumbprint = anchor.getThumbprint() == null || anchor.getThumbprint().isEmpty() ? Thumbprint.toThumbprint((X509Certificate)anchor.getAnchorAsX509Certificate()).toString() : anchor.getThumbprint();
            return this.anchorRepo.findByOwnerIgnoreCase(anchor.getOwner()).filter(existingAnchor -> existingAnchor.getThumbprint().equalsIgnoreCase(thumbprint)).collectList().switchIfEmpty(Mono.just(Collections.emptyList())).flatMap(anchors -> {
                if (!anchors.isEmpty()) {
                    return Mono.error((Throwable)new ResponseStatusException(HttpStatus.CONFLICT));
                }
                try {
                    org.nhindirect.config.store.Anchor addAnchor = EntityModelConversion.toEntityAnchor(anchor);
                    addAnchor.setId(null);
                    return this.anchorRepo.save((Object)addAnchor).then().onErrorResume(e -> {
                        log.error("Error adding anchor.", e);
                        return Mono.error((Throwable)new ResponseStatusException(HttpStatus.INTERNAL_SERVER_ERROR));
                    });
                }
                catch (Exception e2) {
                    log.error("Error converting anchor.", (Throwable)e2);
                    return Mono.error((Throwable)new ResponseStatusException(HttpStatus.INTERNAL_SERVER_ERROR));
                }
            });
        }
        catch (CertificateException ex) {
            log.error("Error converting query thubmprint.", (Throwable)ex);
            return Mono.error((Throwable)new ResponseStatusException(HttpStatus.INTERNAL_SERVER_ERROR));
        }
    }

    @DeleteMapping(value={"ids/{ids}"})
    public Mono<Void> removeAnchorsByIds(@PathVariable(value="ids") String ids) {
        String[] idArray = ids.split(",");
        ArrayList<Long> idList = new ArrayList<Long>();
        for (String id : idArray) {
            idList.add(Long.parseLong(id));
        }
        return this.anchorRepo.deleteByIdIn(idList).onErrorResume(e -> {
            log.error("Error removing anchors by ids.", e);
            return Mono.error((Throwable)new ResponseStatusException(HttpStatus.INTERNAL_SERVER_ERROR));
        });
    }

    @DeleteMapping(value={"{owner}"})
    public Mono<Void> removeAnchorsByOwner(@PathVariable(value="owner") String owner) {
        return this.anchorRepo.deleteByOwnerIgnoreCase(owner).onErrorResume(e -> {
            log.error("Error removing anchors by owner.", e);
            return Mono.error((Throwable)new ResponseStatusException(HttpStatus.INTERNAL_SERVER_ERROR));
        });
    }
}

