/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.processor.impl;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import io.netty.handler.timeout.ReadTimeoutHandler;
import io.netty.handler.timeout.WriteTimeoutHandler;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.IOUtils;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.jcajce.JcaSimpleSignerInfoVerifierBuilder;
import org.nhindirect.common.crypto.CryptoExtensions;
import org.nhindirect.common.options.OptionsManager;
import org.nhindirect.common.options.OptionsParameter;
import org.nhindirect.config.processor.BundleRefreshProcessor;
import org.nhindirect.config.repository.TrustBundleAnchorRepository;
import org.nhindirect.config.repository.TrustBundleRepository;
import org.nhindirect.config.store.BundleRefreshError;
import org.nhindirect.config.store.BundleThumbprint;
import org.nhindirect.config.store.TrustBundle;
import org.nhindirect.config.store.TrustBundleAnchor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.http.client.reactive.ClientHttpConnector;
import org.springframework.http.client.reactive.ReactorClientHttpConnector;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Mono;
import reactor.netty.http.client.HttpClient;

public class DefaultBundleRefreshProcessorImpl
implements BundleRefreshProcessor {
    private static final Logger log = LoggerFactory.getLogger(DefaultBundleRefreshProcessorImpl.class);
    public static final String BUNDLE_REFRESH_PROCESSOR_ALLOW_DOWNLOAD_FROM_UNTRUSTED = "BUNDLE_REFRESH_PROCESSOR_ALLOW_DOWNLOAD_FROM_UNTRUSTED";
    protected static final int DEFAULT_URL_CONNECTION_TIMEOUT = 10000;
    protected static final int DEFAULT_URL_READ_TIMEOUT = 10000;
    protected TrustBundleRepository bundleRepo;
    protected TrustBundleAnchorRepository bundleAnchorRepo;
    protected SslContext sslContext;

    public static synchronized void initJVMParams() {
        HashMap<String, String> JVM_PARAMS = new HashMap<String, String>();
        JVM_PARAMS.put(BUNDLE_REFRESH_PROCESSOR_ALLOW_DOWNLOAD_FROM_UNTRUSTED, "org.nhindirect.config.processor.impl.bundlerefresh.AllowNonVerifiedSSL");
        OptionsManager.addInitParameters(JVM_PARAMS);
    }

    public DefaultBundleRefreshProcessorImpl() {
        OptionsParameter allowNonVerSSLParam = OptionsManager.getInstance().getParameter(BUNDLE_REFRESH_PROCESSOR_ALLOW_DOWNLOAD_FROM_UNTRUSTED);
        SslContextBuilder sslBuilder = SslContextBuilder.forClient();
        if (OptionsParameter.getParamValueAsBoolean((OptionsParameter)allowNonVerSSLParam, (boolean)false)) {
            sslBuilder.trustManager(InsecureTrustManagerFactory.INSTANCE);
        }
        this.sslContext = sslBuilder.build();
    }

    public void setRepository(TrustBundleRepository bundleRepo) {
        this.bundleRepo = bundleRepo;
    }

    public void setRepositories(TrustBundleRepository bundleRepo, TrustBundleAnchorRepository bundleAnchorRepo) {
        this.bundleRepo = bundleRepo;
        this.bundleAnchorRepo = bundleAnchorRepo;
    }

    @Override
    public Mono<?> refreshBundle(TrustBundle bundle) {
        Calendar processAttempStart = Calendar.getInstance(Locale.getDefault());
        return this.downloadBundleToByteArray(bundle, processAttempStart).flatMap(rawBundle -> {
            if (rawBundle == null || ((byte[])rawBundle).length == 0) {
                return Mono.empty();
            }
            boolean update = false;
            String checkSum = "";
            if (bundle.getCheckSum() == null) {
                update = true;
            } else {
                try {
                    checkSum = BundleThumbprint.toThumbprint((byte[])rawBundle).toString();
                    update = !bundle.getCheckSum().equals(BundleThumbprint.toThumbprint((byte[])rawBundle).toString());
                }
                catch (NoSuchAlgorithmException ex) {
                    bundle.setLastRefreshAttempt(new Timestamp(processAttempStart.getTime().getTime()).toLocalDateTime());
                    bundle.setLastRefreshError(BundleRefreshError.INVALID_BUNDLE_FORMAT.ordinal());
                    log.error("Failed to generate downloaded bundle thumbprint ", (Throwable)ex);
                    return this.bundleRepo.save((Object)bundle);
                }
            }
            String finalCheckSum = checkSum;
            if (!update) {
                bundle.setLastRefreshAttempt(new Timestamp(processAttempStart.getTime().getTime()).toLocalDateTime());
                bundle.setLastRefreshError(BundleRefreshError.SUCCESS.ordinal());
                return this.bundleRepo.save((Object)bundle);
            }
            return this.convertRawBundleToAnchorCollection((byte[])rawBundle, bundle, processAttempStart).flatMap(bundleCerts -> {
                if (bundleCerts == null || bundleCerts.isEmpty()) {
                    return Mono.empty();
                }
                HashSet downloadedSet = new HashSet(bundleCerts);
                ArrayList<TrustBundleAnchor> newAnchors = new ArrayList<TrustBundleAnchor>();
                for (X509Certificate downloadedAnchor : downloadedSet) {
                    try {
                        TrustBundleAnchor anchorToAdd = new TrustBundleAnchor();
                        anchorToAdd.setData(downloadedAnchor.getEncoded());
                        anchorToAdd.setTrustBundleId(bundle.getId());
                        newAnchors.add(anchorToAdd);
                    }
                    catch (Exception e) {
                        log.warn("Failed to convert downloaded anchor to byte array. ", (Throwable)e);
                        return Mono.empty();
                    }
                }
                return this.bundleAnchorRepo.deleteByTrustBundleId(bundle.getId()).then(this.bundleAnchorRepo.saveAll(newAnchors).collectList()).flatMap(res -> {
                    bundle.setLastRefreshAttempt(new Timestamp(processAttempStart.getTime().getTime()).toLocalDateTime());
                    bundle.setLastRefreshError(BundleRefreshError.SUCCESS.ordinal());
                    bundle.setCheckSum(finalCheckSum);
                    bundle.setLastSuccessfulRefresh(LocalDateTime.now());
                    return this.bundleRepo.save((Object)bundle).onErrorResume(ex -> {
                        log.error("Failed to write updated bundle anchors to data store ", ex);
                        bundle.setLastRefreshAttempt(new Timestamp(processAttempStart.getTime().getTime()).toLocalDateTime());
                        bundle.setLastRefreshError(BundleRefreshError.INVALID_BUNDLE_FORMAT.ordinal());
                        return this.bundleRepo.save((Object)bundle);
                    });
                });
            });
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected Mono<Collection<X509Certificate>> convertRawBundleToAnchorCollection(byte[] rawBundle, TrustBundle existingBundle, Calendar processAttempStart) {
        ByteArrayInputStream inStream;
        Collection<? extends Certificate> bundleCerts;
        block16: {
            bundleCerts = null;
            inStream = null;
            try {
                inStream = new ByteArrayInputStream(rawBundle);
                bundleCerts = CertificateFactory.getInstance("X.509").generateCertificates(inStream);
                if (bundleCerts == null || bundleCerts.size() != 0) break block16;
                bundleCerts = null;
            }
            catch (Exception exception) {
                IOUtils.closeQuietly((InputStream)inStream);
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(inStream);
                    throw throwable;
                }
            }
        }
        IOUtils.closeQuietly((InputStream)inStream);
        if (bundleCerts == null) {
            try {
                CMSSignedData signed = new CMSSignedData(rawBundle);
                if (existingBundle.getSigningCertificateData() != null) {
                    boolean sigVerified = false;
                    X509Certificate signingCert = existingBundle.toSigningCertificate();
                    for (SignerInformation sigInfo : signed.getSignerInfos().getSigners()) {
                        try {
                            if (!sigInfo.verify(new JcaSimpleSignerInfoVerifierBuilder().setProvider(CryptoExtensions.getJCEProviderName()).build(signingCert))) continue;
                            sigVerified = true;
                            break;
                        }
                        catch (Exception exception) {
                        }
                    }
                    if (!sigVerified) {
                        existingBundle.setLastRefreshAttempt(new Timestamp(processAttempStart.getTime().getTime()).toLocalDateTime());
                        existingBundle.setLastRefreshError(BundleRefreshError.UNMATCHED_SIGNATURE.ordinal());
                        log.warn("Downloaded bundle signature did not match configured signing certificate.");
                        Mono mono = this.bundleRepo.save((Object)existingBundle).thenReturn(Collections.emptyList());
                        return mono;
                    }
                }
                CMSProcessableByteArray signedContent = (CMSProcessableByteArray)signed.getSignedContent();
                inStream = new ByteArrayInputStream((byte[])signedContent.getContent());
                bundleCerts = CertificateFactory.getInstance("X.509").generateCertificates(inStream);
            }
            catch (Exception e) {
                existingBundle.setLastRefreshAttempt(new Timestamp(processAttempStart.getTime().getTime()).toLocalDateTime());
                existingBundle.setLastRefreshError(BundleRefreshError.INVALID_BUNDLE_FORMAT.ordinal());
                log.warn("Failed to extract anchors from downloaded bundle at URL " + existingBundle.getBundleURL());
                Mono mono = this.bundleRepo.save((Object)existingBundle).thenReturn(Collections.emptyList());
                return mono;
            }
            finally {
                IOUtils.closeQuietly((InputStream)inStream);
            }
        }
        return Mono.just(bundleCerts);
    }

    protected Mono<byte[]> downloadBundleToByteArray(TrustBundle bundle, Calendar processAttempStart) {
        try {
            URI uri = new URI(bundle.getBundleURL());
            if (uri.getScheme().compareToIgnoreCase("file") == 0) {
                ByteArrayOutputStream ouStream = new ByteArrayOutputStream();
                URL certURL = new URL(bundle.getBundleURL());
                URLConnection connection = certURL.openConnection();
                InputStream inputStream = connection.getInputStream();
                int BUF_SIZE = 2048;
                int count = 0;
                byte[] buf = new byte[BUF_SIZE];
                while ((count = inputStream.read(buf)) > -1) {
                    ouStream.write(buf, 0, count);
                }
                return Mono.just((Object)ouStream.toByteArray());
            }
            HttpClient httpClient = (HttpClient)((HttpClient)HttpClient.create().option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)10000)).secure(t -> t.sslContext(this.sslContext)).responseTimeout(Duration.ofMillis(10000L)).doOnConnected(conn -> conn.addHandlerLast((ChannelHandler)new ReadTimeoutHandler(10000L, TimeUnit.MILLISECONDS)).addHandlerLast((ChannelHandler)new WriteTimeoutHandler(10000L, TimeUnit.MILLISECONDS)));
            return WebClient.builder().baseUrl(bundle.getBundleURL()).clientConnector((ClientHttpConnector)new ReactorClientHttpConnector(httpClient)).build().get().exchange().flatMap(response -> response.bodyToMono(ByteArrayResource.class)).map(ByteArrayResource::getByteArray).onErrorResume(ex -> {
                log.warn("Failed to download bundle from URL " + bundle.getBundleURL(), ex);
                bundle.setLastRefreshAttempt(new Timestamp(processAttempStart.getTime().getTime()).toLocalDateTime());
                bundle.setLastRefreshError(BundleRefreshError.DOWNLOAD_TIMEOUT.ordinal());
                return this.bundleRepo.save((Object)bundle).then(Mono.empty());
            });
        }
        catch (Exception e) {
            log.warn("Failed to download bundle from URL " + bundle.getBundleURL(), (Throwable)e);
            bundle.setLastRefreshAttempt(new Timestamp(processAttempStart.getTime().getTime()).toLocalDateTime());
            bundle.setLastRefreshError(BundleRefreshError.NOT_FOUND.ordinal());
            return this.bundleRepo.save((Object)bundle).then(Mono.empty());
        }
    }

    static {
        DefaultBundleRefreshProcessorImpl.initJVMParams();
        CryptoExtensions.registerJCEProviders();
    }
}

