/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.resources;

import org.nhindirect.config.repository.AddressRepository;
import org.nhindirect.config.repository.DomainRepository;
import org.nhindirect.config.resources.ProtectedResource;
import org.nhindirect.config.resources.util.EntityModelConversion;
import org.nhindirect.config.store.Address;
import org.nhindirect.config.store.Domain;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@RestController
@RequestMapping(value={"address"})
public class AddressResource
extends ProtectedResource {
    private static final Logger log = LoggerFactory.getLogger(AddressResource.class);
    protected AddressRepository addRepo;
    protected DomainRepository domainRepo;

    @Autowired
    public void setAddressRepository(AddressRepository addRepo) {
        this.addRepo = addRepo;
    }

    @Autowired
    public void setDomainRepository(DomainRepository domainRepo) {
        this.domainRepo = domainRepo;
    }

    @GetMapping(value={"/{address}"}, produces={"application/json"})
    public Mono<org.nhindirect.config.model.Address> getAddress(@PathVariable String address) {
        return this.addRepo.findByEmailAddressIgnoreCase(address).switchIfEmpty(Mono.just((Object)new Address())).flatMap(addr -> {
            if (addr.getDomainId() == null) {
                return Mono.error((Throwable)new ResponseStatusException(HttpStatus.NOT_FOUND));
            }
            return this.domainRepo.findById((Object)addr.getDomainId()).map(domain -> EntityModelConversion.toModelAddress(addr, domain.getDomainName())).onErrorResume(e -> {
                log.error("Error looking up address", e);
                return Mono.error((Throwable)new ResponseStatusException(HttpStatus.INTERNAL_SERVER_ERROR));
            });
        });
    }

    @GetMapping(value={"domain/{domainName}"}, produces={"application/json"})
    public Flux<org.nhindirect.config.model.Address> getAddressesByDomain(@PathVariable String domainName) {
        return this.domainRepo.findByDomainNameIgnoreCase(domainName).switchIfEmpty(Mono.just((Object)new Domain())).flatMapMany(domain -> {
            if (domain.getDomainName() == null) {
                return Mono.error((Throwable)new ResponseStatusException(HttpStatus.NOT_FOUND));
            }
            return this.addRepo.findByDomainId(domain.getId()).map(address -> EntityModelConversion.toModelAddress(address, domainName)).onErrorResume(e -> {
                log.error("Error looking up addresses", e);
                return Flux.error((Throwable)new ResponseStatusException(HttpStatus.INTERNAL_SERVER_ERROR));
            });
        });
    }

    @PutMapping(consumes={"application/json"})
    @ResponseStatus(value=HttpStatus.CREATED)
    public Mono<Void> addAddress(@RequestBody org.nhindirect.config.model.Address address) {
        if (address.getDomainName() == null || address.getDomainName().isEmpty()) {
            return Mono.error((Throwable)new ResponseStatusException(HttpStatus.BAD_REQUEST));
        }
        return this.domainRepo.findByDomainNameIgnoreCase(address.getDomainName()).switchIfEmpty(Mono.just((Object)new Domain())).flatMap(domain -> {
            if (domain.getDomainName() == null) {
                return Mono.error((Throwable)new ResponseStatusException(HttpStatus.NOT_FOUND));
            }
            return this.addRepo.findByEmailAddressIgnoreCase(address.getEmailAddress()).switchIfEmpty(Mono.just((Object)new Address())).flatMap(addr -> {
                if (addr.getDomainId() != null) {
                    return Mono.error((Throwable)new ResponseStatusException(HttpStatus.CONFLICT));
                }
                Address toAdd = EntityModelConversion.toEntityAddress(address, domain);
                toAdd.setId(null);
                return this.addRepo.save((Object)toAdd).then().onErrorResume(e -> {
                    log.error("Error adding address.", e);
                    return Mono.error((Throwable)new ResponseStatusException(HttpStatus.INTERNAL_SERVER_ERROR));
                });
            });
        });
    }

    @PostMapping(consumes={"application/json"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public Mono<Void> updateAddress(@RequestBody org.nhindirect.config.model.Address address) {
        if (address.getDomainName() == null || address.getDomainName().isEmpty()) {
            return Mono.error((Throwable)new ResponseStatusException(HttpStatus.BAD_REQUEST));
        }
        return this.domainRepo.findByDomainNameIgnoreCase(address.getDomainName()).switchIfEmpty(Mono.just((Object)new Domain())).flatMap(domain -> {
            if (domain.getDomainName() == null) {
                return Mono.error((Throwable)new ResponseStatusException(HttpStatus.NOT_FOUND));
            }
            return this.addRepo.findByEmailAddressIgnoreCase(address.getEmailAddress()).switchIfEmpty(Mono.just((Object)new Address())).flatMap(addr -> {
                if (addr.getDomainId() == null) {
                    return Mono.error((Throwable)new ResponseStatusException(HttpStatus.NOT_FOUND));
                }
                Address toAdd = EntityModelConversion.toEntityAddress(address, domain);
                toAdd.setId(addr.getId());
                return this.addRepo.save((Object)toAdd).then().onErrorResume(e -> {
                    log.error("Error updating address.", e);
                    return Mono.error((Throwable)new ResponseStatusException(HttpStatus.INTERNAL_SERVER_ERROR));
                });
            });
        });
    }

    @DeleteMapping(value={"{address}"})
    public Mono<Void> removedAddress(@PathVariable(value="address") String address) {
        return this.addRepo.findByEmailAddressIgnoreCase(address).switchIfEmpty(Mono.just((Object)new Address())).flatMap(addr -> {
            if (addr.getDomainId() == null) {
                return Mono.error((Throwable)new ResponseStatusException(HttpStatus.NOT_FOUND));
            }
            return this.addRepo.deleteById((Object)addr.getId()).then().onErrorResume(e -> {
                log.error("Error deleting address.", e);
                return Mono.error((Throwable)new ResponseStatusException(HttpStatus.INTERNAL_SERVER_ERROR));
            });
        });
    }
}

