/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.resources;

import org.nhindirect.config.model.Setting;
import org.nhindirect.config.repository.SettingRepository;
import org.nhindirect.config.resources.ProtectedResource;
import org.nhindirect.config.resources.util.EntityModelConversion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@RestController
@RequestMapping(value={"setting"})
public class SettingResource
extends ProtectedResource {
    private static final Logger log = LoggerFactory.getLogger(SettingResource.class);
    protected SettingRepository settingRepo;

    @Autowired
    public void setSettingRepository(SettingRepository settingRepo) {
        this.settingRepo = settingRepo;
    }

    @GetMapping(produces={"application/json"})
    public Flux<Setting> getAllSettings() {
        return this.settingRepo.findAll().map(setting -> EntityModelConversion.toModelSetting(setting)).onErrorResume(e -> {
            log.error("Error looking up settings.", e);
            return Flux.error((Throwable)new ResponseStatusException(HttpStatus.INTERNAL_SERVER_ERROR));
        });
    }

    @GetMapping(value={"{name}"}, produces={"application/json"})
    public Mono<Setting> getSettingByName(@PathVariable(value="name") String name) {
        return this.settingRepo.findByNameIgnoreCase(name.toUpperCase()).switchIfEmpty(Mono.just((Object)new org.nhindirect.config.store.Setting())).flatMap(setting -> {
            if (setting.getName() == null) {
                return Mono.error((Throwable)new ResponseStatusException(HttpStatus.NOT_FOUND));
            }
            return Mono.just((Object)EntityModelConversion.toModelSetting(setting)).onErrorResume(e -> {
                log.error("Error looking up setting.", e);
                return Mono.error((Throwable)new ResponseStatusException(HttpStatus.INTERNAL_SERVER_ERROR));
            });
        });
    }

    @PutMapping(value={"{name}/{value}"})
    @ResponseStatus(value=HttpStatus.CREATED)
    public Mono<Void> addSetting(@PathVariable(value="name") String name, @PathVariable(value="value") String value) {
        if (name == null || name.isEmpty()) {
            log.error("Name cannot be null or empty");
            return Mono.error((Throwable)new ResponseStatusException(HttpStatus.BAD_REQUEST));
        }
        if (value == null) {
            log.error("Value cannot be null");
            return Mono.error((Throwable)new ResponseStatusException(HttpStatus.BAD_REQUEST));
        }
        return this.settingRepo.findByNameIgnoreCase(name).switchIfEmpty(Mono.just((Object)new org.nhindirect.config.store.Setting())).flatMap(setting -> {
            if (setting.getName() != null) {
                return Mono.error((Throwable)new ResponseStatusException(HttpStatus.CONFLICT));
            }
            org.nhindirect.config.store.Setting addSetting = new org.nhindirect.config.store.Setting();
            addSetting.setName(name);
            addSetting.setValue(value);
            addSetting.setId(null);
            return this.settingRepo.save((Object)addSetting).then().onErrorResume(e -> {
                log.error("Error looking up setting.", e);
                return Mono.error((Throwable)new ResponseStatusException(HttpStatus.INTERNAL_SERVER_ERROR));
            });
        });
    }

    @PutMapping
    @ResponseStatus(value=HttpStatus.CREATED)
    public Mono<Void> addSetting(@RequestBody Setting setting) {
        return this.addSetting(setting.getName(), setting.getValue());
    }

    @PostMapping(value={"{name}/{value}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public Mono<Void> updateSetting(@PathVariable(value="name") String name, @PathVariable(value="value") String value) {
        return this.settingRepo.findByNameIgnoreCase(name).switchIfEmpty(Mono.just((Object)new org.nhindirect.config.store.Setting())).flatMap(setting -> {
            if (setting.getName() == null) {
                return Mono.error((Throwable)new ResponseStatusException(HttpStatus.NOT_FOUND));
            }
            setting.setValue(value);
            return this.settingRepo.save(setting).then().onErrorResume(e -> {
                log.error("Error updating setting.", e);
                return Mono.error((Throwable)new ResponseStatusException(HttpStatus.INTERNAL_SERVER_ERROR));
            });
        });
    }

    @PostMapping
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public Mono<Void> updateSetting(@RequestBody Setting setting) {
        return this.updateSetting(setting.getName(), setting.getValue());
    }

    @DeleteMapping(value={"{name}"})
    public Mono<Void> removeSettingByName(@PathVariable(value="name") String name) {
        return this.settingRepo.findByNameIgnoreCase(name).switchIfEmpty(Mono.just((Object)new org.nhindirect.config.store.Setting())).flatMap(setting -> {
            if (setting.getName() == null) {
                return Mono.error((Throwable)new ResponseStatusException(HttpStatus.NOT_FOUND));
            }
            return this.settingRepo.deleteByNameIgnoreCase(name).onErrorResume(e -> {
                log.error("Error removing setting by name.", e);
                return Mono.error((Throwable)new ResponseStatusException(HttpStatus.INTERNAL_SERVER_ERROR));
            });
        });
    }
}

