/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.resources;

import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.nhindirect.config.model.CertPolicy;
import org.nhindirect.config.model.CertPolicyGroup;
import org.nhindirect.config.model.CertPolicyGroupDomainReltn;
import org.nhindirect.config.model.CertPolicyGroupUse;
import org.nhindirect.config.repository.CertPolicyGroupDomainReltnRepository;
import org.nhindirect.config.repository.CertPolicyGroupReltnRepository;
import org.nhindirect.config.repository.CertPolicyGroupRepository;
import org.nhindirect.config.repository.CertPolicyRepository;
import org.nhindirect.config.repository.DomainRepository;
import org.nhindirect.config.resources.ProtectedResource;
import org.nhindirect.config.resources.util.EntityModelConversion;
import org.nhindirect.config.store.CertPolicyGroupReltn;
import org.nhindirect.config.store.CertPolicyUse;
import org.nhindirect.config.store.Domain;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@RestController
@RequestMapping(value={"certpolicy"})
public class CertPolicyResource
extends ProtectedResource {
    private static final Logger log = LoggerFactory.getLogger(CertPolicyResource.class);
    protected CertPolicyRepository policyRepo;
    protected CertPolicyGroupRepository groupRepo;
    protected CertPolicyGroupDomainReltnRepository domainReltnRepo;
    protected CertPolicyGroupReltnRepository polGroupReltnRepo;
    protected DomainRepository domainRepo;
    protected CertPolicyResource transactionalThisProxy;

    @Autowired
    public void setCertPolicyRepository(CertPolicyRepository policyRepo) {
        this.policyRepo = policyRepo;
    }

    @Autowired
    public void setDomainRepository(DomainRepository domainRepo) {
        this.domainRepo = domainRepo;
    }

    @Autowired
    public void setCertPolicyGroupRepository(CertPolicyGroupRepository groupRepo) {
        this.groupRepo = groupRepo;
    }

    @Autowired
    public void setCertPolicyGroupDomainReltnRepository(CertPolicyGroupDomainReltnRepository domainReltnRepo) {
        this.domainReltnRepo = domainReltnRepo;
    }

    @Autowired
    public void setCertPolicyGroupReltnRepository(CertPolicyGroupReltnRepository polGroupReltnRepo) {
        this.polGroupReltnRepo = polGroupReltnRepo;
    }

    @Autowired
    public void setInternalThisProxy(CertPolicyResource internalProxy) {
        this.transactionalThisProxy = internalProxy;
    }

    @GetMapping(produces={"application/json"})
    public Flux<CertPolicy> getPolicies() {
        return this.policyRepo.findAll().map(pol -> EntityModelConversion.toModelCertPolicy(pol)).onErrorResume(e -> {
            log.error("Error looking up cert policies.", e);
            return Flux.error((Throwable)new ResponseStatusException(HttpStatus.INTERNAL_SERVER_ERROR));
        });
    }

    @GetMapping(value={"/{policyName}"}, produces={"application/json"})
    public Mono<CertPolicy> getPolicyByName(@PathVariable(value="policyName") String policyName) {
        return this.policyRepo.findByPolicyNameIgnoreCase(policyName).map(retPolicy -> EntityModelConversion.toModelCertPolicy(retPolicy)).onErrorResume(e -> {
            log.error("Error looking up cert policy.", e);
            return Mono.error((Throwable)new ResponseStatusException(HttpStatus.INTERNAL_SERVER_ERROR));
        });
    }

    @PutMapping(consumes={"application/json"})
    @ResponseStatus(value=HttpStatus.CREATED)
    public Mono<Void> addPolicy(@RequestBody CertPolicy policy) {
        return this.policyRepo.findByPolicyNameIgnoreCase(policy.getPolicyName()).switchIfEmpty(Mono.just((Object)new org.nhindirect.config.store.CertPolicy())).flatMap(pol -> {
            if (pol.getPolicyName() != null) {
                return Mono.error((Throwable)new ResponseStatusException(HttpStatus.CONFLICT));
            }
            org.nhindirect.config.store.CertPolicy entityPolicy = EntityModelConversion.toEntityCertPolicy(policy);
            return this.policyRepo.save((Object)entityPolicy).then().onErrorResume(e -> {
                log.error("Error looking up cert policy.", e);
                return Mono.error((Throwable)new ResponseStatusException(HttpStatus.INTERNAL_SERVER_ERROR));
            });
        });
    }

    @DeleteMapping(value={"{policyName}"})
    public Mono<Void> removePolicyByName(@PathVariable(value="policyName") String policyName) {
        return this.policyRepo.findByPolicyNameIgnoreCase(policyName).switchIfEmpty(Mono.just((Object)new org.nhindirect.config.store.CertPolicy())).flatMap(pol -> {
            if (pol.getPolicyName() == null) {
                return Mono.error((Throwable)new ResponseStatusException(HttpStatus.NOT_FOUND));
            }
            return this.polGroupReltnRepo.deleteByPolicyId(pol.getId()).then(this.policyRepo.deleteById((Object)pol.getId())).onErrorResume(e -> {
                log.error("Error deleting cert policy.", e);
                return Mono.error((Throwable)new ResponseStatusException(HttpStatus.INTERNAL_SERVER_ERROR));
            });
        });
    }

    @PostMapping(value={"{policyName}/policyAttributes"}, consumes={"application/json"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public Mono<Void> updatePolicyAttributes(@PathVariable(value="policyName") String policyName, @RequestBody CertPolicy policyData) {
        return this.policyRepo.findByPolicyNameIgnoreCase(policyName).switchIfEmpty(Mono.just((Object)new org.nhindirect.config.store.CertPolicy())).flatMap(pol -> {
            if (pol.getPolicyName() == null) {
                return Mono.error((Throwable)new ResponseStatusException(HttpStatus.NOT_FOUND));
            }
            if (policyData.getPolicyData() != null && policyData.getPolicyData().length > 0) {
                pol.setPolicyData(policyData.getPolicyData());
            }
            if (!StringUtils.isEmpty((CharSequence)policyData.getPolicyName())) {
                pol.setPolicyName(policyData.getPolicyName());
            }
            if (policyData.getLexicon() != null) {
                pol.setLexicon(policyData.getLexicon().ordinal());
            }
            return this.policyRepo.save(pol).then().onErrorResume(e -> {
                log.error("Error updating cert policy attributes.", e);
                return Mono.error((Throwable)new ResponseStatusException(HttpStatus.INTERNAL_SERVER_ERROR));
            });
        });
    }

    @GetMapping(value={"groups"}, produces={"application/json"})
    public Flux<CertPolicyGroup> getPolicyGroups() {
        return this.groupRepo.findAll().flatMap(group -> this.polGroupReltnRepo.findByPolicyGroupId(group.getId()).flatMap(reltn -> this.policyRepo.findById((Object)reltn.getPolicyId()).map(pol -> Maps.immutableEntry((Object)reltn, (Object)pol))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)).map(polUseMap -> EntityModelConversion.toModelCertPolicyGroup(group, polUseMap))).onErrorResume(e -> {
            log.error("Error looking up cert policy groups.", e);
            return Flux.error((Throwable)new ResponseStatusException(HttpStatus.INTERNAL_SERVER_ERROR));
        });
    }

    @GetMapping(value={"groups/{groupName}"}, produces={"application/json"})
    public Mono<CertPolicyGroup> getPolicyGroupByName(@PathVariable(value="groupName") String groupName) {
        return this.groupRepo.findByPolicyGroupNameIgnoreCase(groupName).switchIfEmpty(Mono.just((Object)new org.nhindirect.config.store.CertPolicyGroup())).flatMap(group -> {
            if (group.getPolicyGroupName() == null) {
                return Mono.error((Throwable)new ResponseStatusException(HttpStatus.NOT_FOUND));
            }
            return this.polGroupReltnRepo.findByPolicyGroupId(group.getId()).flatMap(reltn -> this.policyRepo.findById((Object)reltn.getPolicyId()).map(pol -> Maps.immutableEntry((Object)reltn, (Object)pol))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)).map(polUseMap -> EntityModelConversion.toModelCertPolicyGroup(group, polUseMap)).onErrorResume(e -> {
                log.error("Error looking up cert policy group.", e);
                return Mono.error((Throwable)new ResponseStatusException(HttpStatus.INTERNAL_SERVER_ERROR));
            });
        });
    }

    @PutMapping(value={"groups"}, consumes={"application/json"})
    @ResponseStatus(value=HttpStatus.CREATED)
    public Mono<Void> addPolicyGroup(@RequestBody CertPolicyGroup group) {
        return this.groupRepo.findByPolicyGroupNameIgnoreCase(group.getPolicyGroupName()).switchIfEmpty(Mono.just((Object)new org.nhindirect.config.store.CertPolicyGroup())).flatMap(foundGroup -> {
            if (foundGroup.getPolicyGroupName() != null) {
                return Mono.error((Throwable)new ResponseStatusException(HttpStatus.CONFLICT));
            }
            org.nhindirect.config.store.CertPolicyGroup entityGroup = EntityModelConversion.toEntityCertPolicyGroup(group);
            return this.groupRepo.save((Object)entityGroup).then().onErrorResume(e -> {
                log.error("Error adding trust cert policy group.", e);
                return Mono.error((Throwable)new ResponseStatusException(HttpStatus.INTERNAL_SERVER_ERROR));
            });
        });
    }

    @DeleteMapping(value={"groups/{groupName}"})
    public Mono<Void> removePolicyGroupByName(@PathVariable(value="groupName") String groupName) {
        return this.groupRepo.findByPolicyGroupNameIgnoreCase(groupName).switchIfEmpty(Mono.just((Object)new org.nhindirect.config.store.CertPolicyGroup())).flatMap(foundGroup -> {
            if (foundGroup.getPolicyGroupName() == null) {
                return Mono.error((Throwable)new ResponseStatusException(HttpStatus.NOT_FOUND));
            }
            return this.domainReltnRepo.deleteByPolicyGroupId(foundGroup.getId()).then(this.polGroupReltnRepo.deleteByPolicyGroupId(foundGroup.getId())).then(this.groupRepo.deleteById((Object)foundGroup.getId())).onErrorResume(e -> {
                log.error("Error looking up existing cert policy group.", e);
                return Mono.error((Throwable)new ResponseStatusException(HttpStatus.INTERNAL_SERVER_ERROR));
            });
        });
    }

    @PostMapping(value={"groups/{groupName}/groupAttributes"}, consumes={"application/json"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public Mono<Void> updateGroupAttributes(@PathVariable(value="groupName") String groupName, @RequestBody String newGroupName) {
        return this.groupRepo.findByPolicyGroupNameIgnoreCase(groupName).switchIfEmpty(Mono.just((Object)new org.nhindirect.config.store.CertPolicyGroup())).flatMap(foundGroup -> {
            if (foundGroup.getPolicyGroupName() == null) {
                return Mono.error((Throwable)new ResponseStatusException(HttpStatus.NOT_FOUND));
            }
            if (!StringUtils.isEmpty((CharSequence)newGroupName)) {
                foundGroup.setPolicyGroupName(newGroupName);
            }
            return this.groupRepo.save(foundGroup).then().onErrorResume(e -> {
                log.error("Error updating cert policy group attributes.", e);
                return Mono.error((Throwable)new ResponseStatusException(HttpStatus.INTERNAL_SERVER_ERROR));
            });
        });
    }

    @PostMapping(value={"groups/uses/{group}"}, consumes={"application/json"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public Mono<Void> addPolicyUseToGroup(@PathVariable(value="group") String groupName, @RequestBody CertPolicyGroupUse use) {
        return this.groupRepo.findByPolicyGroupNameIgnoreCase(groupName).switchIfEmpty(Mono.just((Object)new org.nhindirect.config.store.CertPolicyGroup())).flatMap(foundGroup -> {
            if (foundGroup.getPolicyGroupName() == null) {
                return Mono.error((Throwable)new ResponseStatusException(HttpStatus.NOT_FOUND));
            }
            return this.policyRepo.findByPolicyNameIgnoreCase(use.getPolicy().getPolicyName()).switchIfEmpty(Mono.just((Object)new org.nhindirect.config.store.CertPolicy())).flatMap(entityPolicy -> {
                if (entityPolicy.getPolicyName() == null) {
                    return Mono.error((Throwable)new ResponseStatusException(HttpStatus.NOT_FOUND));
                }
                CertPolicyGroupReltn reltn = new CertPolicyGroupReltn();
                reltn.setPolicyId(entityPolicy.getId());
                reltn.setPolicyGroupId(foundGroup.getId());
                reltn.setPolicyUse(CertPolicyUse.valueOf((String)use.getPolicyUse().toString()).ordinal());
                reltn.setIncoming(use.isIncoming());
                reltn.setOutgoing(use.isOutgoing());
                return this.polGroupReltnRepo.save((Object)reltn).then().onErrorResume(e -> {
                    log.error("Error adding cert policy to group.", e);
                    return Mono.error((Throwable)new ResponseStatusException(HttpStatus.INTERNAL_SERVER_ERROR));
                });
            });
        });
    }

    @PostMapping(value={"groups/uses/{group}/removePolicy"}, consumes={"application/json"})
    public Mono<Void> removedPolicyUseFromGroup(@PathVariable(value="group") String groupName, @RequestBody CertPolicyGroupUse use) {
        return this.groupRepo.findByPolicyGroupNameIgnoreCase(groupName).switchIfEmpty(Mono.just((Object)new org.nhindirect.config.store.CertPolicyGroup())).flatMap(foundGroup -> {
            if (foundGroup.getPolicyGroupName() == null) {
                return Mono.error((Throwable)new ResponseStatusException(HttpStatus.NOT_FOUND));
            }
            CertPolicyUse entityUse = CertPolicyUse.valueOf((String)use.getPolicyUse().toString());
            return this.polGroupReltnRepo.findByPolicyGroupId(foundGroup.getId()).next().flatMap(reltn -> this.policyRepo.findById((Object)reltn.getPolicyId()).flatMap(certPol -> {
                if (certPol.getPolicyName().equals(use.getPolicy().getPolicyName()) && reltn.isIncoming() == use.isIncoming() && reltn.isOutgoing() == use.isOutgoing() && reltn.getPolicyUse() == entityUse.ordinal()) {
                    return this.polGroupReltnRepo.deleteById((Object)reltn.getId()).then(this.groupRepo.save(foundGroup)).then();
                }
                return Mono.empty();
            }));
        });
    }

    @GetMapping(value={"/groups/domain"}, produces={"application/json"})
    public Flux<CertPolicyGroupDomainReltn> getPolicyGroupDomainReltns() {
        return this.domainReltnRepo.findAll().flatMap(reltn -> {
            Mono polGroup = this.groupRepo.findById((Object)reltn.getPolicyGroupId()).flatMap(group -> this.polGroupReltnRepo.findByPolicyGroupId(group.getId()).flatMap(groupReltn -> this.policyRepo.findById((Object)groupReltn.getPolicyId()).map(pol -> Maps.immutableEntry((Object)groupReltn, (Object)pol))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)).map(polUseMap -> EntityModelConversion.toModelCertPolicyGroup(group, polUseMap)));
            Mono domain = this.domainRepo.findById((Object)reltn.getDomainId());
            return domain.zipWith(polGroup, (d, p) -> {
                CertPolicyGroupDomainReltn cpgdReltn = new CertPolicyGroupDomainReltn();
                cpgdReltn.setId(reltn.getId().longValue());
                cpgdReltn.setPolicyGroup(p);
                cpgdReltn.setDomain(EntityModelConversion.toModelDomain(d, Collections.emptyList()));
                return cpgdReltn;
            });
        }).onErrorResume(e -> {
            log.error("Error looking up policy group/domain relations.", e);
            return Mono.error((Throwable)new ResponseStatusException(HttpStatus.INTERNAL_SERVER_ERROR));
        });
    }

    @GetMapping(value={"groups/domain/{domain}"}, produces={"application/json"})
    public Flux<CertPolicyGroup> getPolicyGroupsByDomain(@PathVariable(value="domain") String domainName) {
        return this.domainRepo.findByDomainNameIgnoreCase(domainName).switchIfEmpty(Mono.just((Object)new Domain())).flatMapMany(domain -> {
            if (domain.getDomainName() == null) {
                return Flux.error((Throwable)new ResponseStatusException(HttpStatus.NOT_FOUND));
            }
            return this.domainReltnRepo.findByDomainId(domain.getId()).flatMap(reltn -> this.groupRepo.findById((Object)reltn.getPolicyGroupId()).flatMap(group -> this.polGroupReltnRepo.findByPolicyGroupId(group.getId()).flatMap(groupReltn -> this.policyRepo.findById((Object)groupReltn.getPolicyId()).map(pol -> Maps.immutableEntry((Object)groupReltn, (Object)pol))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)).map(polUseMap -> EntityModelConversion.toModelCertPolicyGroup(group, polUseMap)))).onErrorResume(e -> {
                log.error("Error looking up cert policy groups.", e);
                return Flux.error((Throwable)new ResponseStatusException(HttpStatus.INTERNAL_SERVER_ERROR));
            });
        });
    }

    @PostMapping(value={"groups/domain/{group}/{domain}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public Mono<Void> associatePolicyGroupToDomain(@PathVariable(value="group") String groupName, @PathVariable(value="domain") String domainName) {
        return this.groupRepo.findByPolicyGroupNameIgnoreCase(groupName).switchIfEmpty(Mono.just((Object)new org.nhindirect.config.store.CertPolicyGroup())).flatMap(group -> {
            if (group.getPolicyGroupName() == null) {
                return Mono.error((Throwable)new ResponseStatusException(HttpStatus.NOT_FOUND));
            }
            return this.domainRepo.findByDomainNameIgnoreCase(domainName).switchIfEmpty(Mono.just((Object)new Domain())).flatMap(domain -> {
                if (domain.getDomainName() == null) {
                    return Mono.error((Throwable)new ResponseStatusException(HttpStatus.NOT_FOUND));
                }
                org.nhindirect.config.store.CertPolicyGroupDomainReltn policyGroupDomainAssoc = new org.nhindirect.config.store.CertPolicyGroupDomainReltn();
                policyGroupDomainAssoc.setDomainId(domain.getId());
                policyGroupDomainAssoc.setPolicyGroupId(group.getId());
                return this.domainReltnRepo.save((Object)policyGroupDomainAssoc).then().onErrorResume(e -> {
                    log.error("Error associating policy group to domain.", e);
                    return Mono.error((Throwable)new ResponseStatusException(HttpStatus.INTERNAL_SERVER_ERROR));
                });
            });
        });
    }

    @DeleteMapping(value={"groups/domain/{group}/{domain}"})
    public Mono<Void> disassociatePolicyGroupFromDomain(@PathVariable(value="group") String groupName, @PathVariable(value="domain") String domainName) {
        return this.groupRepo.findByPolicyGroupNameIgnoreCase(groupName).switchIfEmpty(Mono.just((Object)new org.nhindirect.config.store.CertPolicyGroup())).flatMap(group -> {
            if (group.getPolicyGroupName() == null) {
                return Mono.error((Throwable)new ResponseStatusException(HttpStatus.NOT_FOUND));
            }
            return this.domainRepo.findByDomainNameIgnoreCase(domainName).switchIfEmpty(Mono.just((Object)new Domain())).flatMap(domain -> {
                if (domain.getDomainName() == null) {
                    return Mono.error((Throwable)new ResponseStatusException(HttpStatus.NOT_FOUND));
                }
                return this.domainReltnRepo.deleteByDomainIdAndPolicyGroupId(domain.getId(), group.getId()).onErrorResume(e -> {
                    log.error("Error disassociating policy group from domain.", e);
                    return Mono.error((Throwable)new ResponseStatusException(HttpStatus.INTERNAL_SERVER_ERROR));
                });
            });
        });
    }

    @DeleteMapping(value={"groups/domain/{domain}/deleteFromDomain"})
    public Mono<Void> disassociatePolicyGroupsFromDomain(@PathVariable(value="domain") String domainName) {
        return this.domainRepo.findByDomainNameIgnoreCase(domainName).switchIfEmpty(Mono.just((Object)new Domain())).flatMap(domain -> {
            if (domain.getDomainName() == null) {
                return Mono.error((Throwable)new ResponseStatusException(HttpStatus.NOT_FOUND));
            }
            return this.domainReltnRepo.deleteByDomainId(domain.getId()).onErrorResume(e -> {
                log.error("Error disassociating policy groups from domain.", e);
                return Mono.error((Throwable)new ResponseStatusException(HttpStatus.INTERNAL_SERVER_ERROR));
            });
        });
    }

    @DeleteMapping(value={"groups/domain/{group}/deleteFromGroup"})
    public Mono<Void> disassociatePolicyGroupFromDomains(@PathVariable(value="group") String groupName) {
        return this.groupRepo.findByPolicyGroupNameIgnoreCase(groupName).switchIfEmpty(Mono.just((Object)new org.nhindirect.config.store.CertPolicyGroup())).flatMap(group -> {
            if (group.getPolicyGroupName() == null) {
                return Mono.error((Throwable)new ResponseStatusException(HttpStatus.NOT_FOUND));
            }
            return this.domainReltnRepo.deleteByPolicyGroupId(group.getId()).onErrorResume(e -> {
                log.error("Error disassociating policy groups from domain.", e);
                return Mono.error((Throwable)new ResponseStatusException(HttpStatus.INTERNAL_SERVER_ERROR));
            });
        });
    }
}

