/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.resources;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.nhindirect.config.model.Domain;
import org.nhindirect.config.repository.AddressRepository;
import org.nhindirect.config.repository.CertPolicyGroupDomainReltnRepository;
import org.nhindirect.config.repository.DomainRepository;
import org.nhindirect.config.resources.ProtectedResource;
import org.nhindirect.config.resources.TrustBundleResource;
import org.nhindirect.config.resources.util.EntityModelConversion;
import org.nhindirect.config.store.Address;
import org.nhindirect.config.store.EntityStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@RestController
@RequestMapping(value={"domain"})
public class DomainResource
extends ProtectedResource {
    private static final Logger log = LoggerFactory.getLogger(DomainResource.class);
    protected TrustBundleResource bundleResource;
    protected CertPolicyGroupDomainReltnRepository domainReltnRepo;
    protected AddressRepository addRepo;
    protected DomainRepository domainRepo;

    @Autowired
    public void setAddressRepository(AddressRepository addRepo) {
        this.addRepo = addRepo;
    }

    @Autowired
    public void setDomainRepository(DomainRepository domainRepo) {
        this.domainRepo = domainRepo;
    }

    @Autowired
    public void setAddressResource(TrustBundleResource bundleResource) {
        this.bundleResource = bundleResource;
    }

    @Autowired
    public void setDomainReltnRepository(CertPolicyGroupDomainReltnRepository domainReltnRepo) {
        this.domainReltnRepo = domainReltnRepo;
    }

    @GetMapping(value={"{domain}"}, produces={"application/json"})
    public Mono<Domain> getDomain(@PathVariable(value="domain") String domain) {
        return this.domainRepo.findByDomainNameIgnoreCase(domain).switchIfEmpty(Mono.just((Object)new org.nhindirect.config.store.Domain())).flatMap(foundDomain -> {
            if (foundDomain.getDomainName() == null) {
                return Mono.error((Throwable)new ResponseStatusException(HttpStatus.NOT_FOUND));
            }
            return this.addRepo.findByDomainId(foundDomain.getId()).collectList().switchIfEmpty(Mono.just(Collections.emptyList())).map(addrs -> EntityModelConversion.toModelDomain(foundDomain, addrs)).onErrorResume(e -> {
                log.error("Error looking up domain.", e);
                return Mono.error((Throwable)new ResponseStatusException(HttpStatus.INTERNAL_SERVER_ERROR));
            });
        });
    }

    @GetMapping(produces={"application/json"})
    public Flux<Domain> searchDomains(@RequestParam(name="domainName", defaultValue="") String domainName, @RequestParam(name="entityStatus", defaultValue="") String entityStatus) {
        EntityStatus status = null;
        if (!entityStatus.isEmpty()) {
            try {
                status = EntityStatus.valueOf((String)entityStatus);
            }
            catch (IllegalArgumentException e2) {
                log.warn("EntityStatus enum value of " + entityStatus + " encountered.  Defaulting EntityStatus to null");
            }
        }
        domainName = StringUtils.remove((String)domainName, (char)'*');
        Flux domains = null;
        domains = status == null && domainName.isEmpty() ? this.domainRepo.findAll() : (status == null ? this.domainRepo.findByDomainNameContainingIgnoreCase("%" + domainName.toUpperCase() + "%") : (domainName.isEmpty() ? this.domainRepo.findByStatus(status.ordinal()) : this.domainRepo.findByDomainNameContainingIgnoreCaseAndStatus("%" + domainName.toUpperCase() + "%", status.ordinal())));
        return domains.flatMap(domain -> this.addRepo.findByDomainId(domain.getId()).collectList().switchIfEmpty(Mono.just(Collections.emptyList())).map(addrs -> EntityModelConversion.toModelDomain(domain, addrs))).onErrorResume(e -> {
            log.error("Error looking up domains.", e);
            return Flux.error((Throwable)new ResponseStatusException(HttpStatus.INTERNAL_SERVER_ERROR));
        });
    }

    @PutMapping(consumes={"application/json"})
    @ResponseStatus(value=HttpStatus.CREATED)
    public Mono<Void> addDomain(@RequestBody Domain domain) {
        return this.domainRepo.findByDomainNameIgnoreCase(domain.getDomainName()).switchIfEmpty(Mono.just((Object)new org.nhindirect.config.store.Domain())).flatMap(foundDomain -> {
            if (foundDomain.getDomainName() != null) {
                return Mono.error((Throwable)new ResponseStatusException(HttpStatus.CONFLICT));
            }
            Map.Entry<org.nhindirect.config.store.Domain, Collection<Address>> toEntry = EntityModelConversion.toEntityDomain(domain);
            org.nhindirect.config.store.Domain savedDomain = toEntry.getKey();
            return this.domainRepo.save((Object)savedDomain).flatMap(dom -> {
                Collection saveAddrs = (Collection)toEntry.getValue();
                if (!saveAddrs.isEmpty()) {
                    for (Address addr2 : saveAddrs) {
                        addr2.setId(null);
                        addr2.setDomainId(savedDomain.getId());
                    }
                    return this.addRepo.saveAll((Iterable)saveAddrs).flatMap(addr -> {
                        if (domain.getPostmasterAddress() != null && addr.getEmailAddress().compareToIgnoreCase(domain.getPostmasterAddress().getEmailAddress()) == 0) {
                            dom.setPostmasterAddressId(addr.getId());
                            return this.domainRepo.save(dom).then();
                        }
                        return Mono.empty();
                    }).collectList().then();
                }
                return Mono.empty();
            }).onErrorResume(e -> {
                log.error("Error adding domain.", e);
                return Mono.error((Throwable)new ResponseStatusException(HttpStatus.INTERNAL_SERVER_ERROR));
            });
        });
    }

    @PostMapping(consumes={"application/json"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public Mono<Void> updateDomain(@RequestBody Domain domain) {
        return this.domainRepo.findByDomainNameIgnoreCase(domain.getDomainName()).switchIfEmpty(Mono.just((Object)new org.nhindirect.config.store.Domain())).flatMap(existingDomain -> {
            if (existingDomain.getDomainName() == null) {
                return Mono.error((Throwable)new ResponseStatusException(HttpStatus.NOT_FOUND));
            }
            org.nhindirect.config.store.Domain toDomain = EntityModelConversion.toEntityDomain(domain).getKey();
            toDomain.setId(existingDomain.getId());
            return this.addRepo.findByDomainId(existingDomain.getId()).collectList().switchIfEmpty(Mono.just(Collections.emptyList())).flatMap(addrs -> {
                toDomain.setPostmasterAddressId(Long.valueOf(0L));
                if (domain.getPostmasterAddress() != null && !addrs.isEmpty()) {
                    for (Address existingAddr : addrs) {
                        if (!existingAddr.getEmailAddress().toLowerCase().equals(domain.getPostmasterAddress().getEmailAddress())) continue;
                        toDomain.setPostmasterAddressId(existingAddr.getId());
                    }
                }
                return this.domainRepo.save((Object)toDomain).then();
            }).onErrorResume(e -> {
                log.error("Error updating domain.", e);
                return Mono.error((Throwable)new ResponseStatusException(HttpStatus.INTERNAL_SERVER_ERROR));
            });
        });
    }

    @DeleteMapping(value={"{domain}"})
    public Mono<Void> removedDomain(@PathVariable(value="domain") String domain) {
        return this.domainRepo.findByDomainNameIgnoreCase(domain).switchIfEmpty(Mono.just((Object)new org.nhindirect.config.store.Domain())).flatMap(existingDomain -> {
            if (existingDomain.getDomainName() == null) {
                return Mono.error((Throwable)new ResponseStatusException(HttpStatus.NOT_FOUND));
            }
            return this.bundleResource.disassociateTrustBundlesFromDomain(domain).then(this.domainReltnRepo.deleteByDomainId(existingDomain.getId())).then(this.addRepo.deleteByDomainId(existingDomain.getId())).then(this.domainRepo.deleteById((Object)existingDomain.getId())).onErrorResume(e -> {
                log.error("Error deleting domain.", e);
                return Mono.error((Throwable)new ResponseStatusException(HttpStatus.INTERNAL_SERVER_ERROR));
            });
        });
    }
}

