/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.resources;

import java.security.cert.X509Certificate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.commons.lang3.StringUtils;
import org.nhindirect.common.cert.Thumbprint;
import org.nhindirect.common.crypto.KeyStoreProtectionManager;
import org.nhindirect.config.model.Certificate;
import org.nhindirect.config.model.utils.CertUtils;
import org.nhindirect.config.repository.CertificateRepository;
import org.nhindirect.config.resources.ProtectedResource;
import org.nhindirect.config.resources.util.EntityModelConversion;
import org.nhindirect.config.store.util.CertificateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@RestController
@RequestMapping(value={"certificate"})
public class CertificateResource
extends ProtectedResource {
    private static final Logger log = LoggerFactory.getLogger(CertificateResource.class);
    protected CertificateRepository certRepo;
    private KeyStoreProtectionManager kspMgr;

    @Autowired
    public void setCertificateRepository(CertificateRepository certRepo) {
        this.certRepo = certRepo;
    }

    @Autowired(required=false)
    public void setKeyStoreProtectionMgr(KeyStoreProtectionManager kspMgr) {
        this.kspMgr = kspMgr;
    }

    @GetMapping(produces={"application/json"})
    public Flux<Certificate> getAllCertificates() {
        return this.getCertificatesByOwner(null);
    }

    @GetMapping(value={"/{owner}"}, produces={"application/json"})
    public Flux<Certificate> getCertificatesByOwner(@PathVariable(value="owner") String owner) {
        Flux lookupFlux = StringUtils.isEmpty((CharSequence)owner) ? this.certRepo.findAll() : this.certRepo.findByOwnerIgnoreCase(owner);
        return lookupFlux.map(cert -> {
            CertificateUtils.stripP12Protection((org.nhindirect.config.store.Certificate)cert, (KeyStoreProtectionManager)this.kspMgr);
            return EntityModelConversion.toModelCertificate(cert);
        }).onErrorResume(e -> {
            log.error("Error looking up certificates.", e);
            return Mono.error((Throwable)new ResponseStatusException(HttpStatus.INTERNAL_SERVER_ERROR));
        });
    }

    @GetMapping(value={"/{owner}/{thumbprint}"}, produces={"application/json"})
    public Mono<?> getCertificatesByOwnerAndThumbprint(@PathVariable(value="owner") String owner, @PathVariable(value="thumbprint") String thumbprint) {
        Mono retCertificates = null;
        retCertificates = StringUtils.isEmpty((CharSequence)owner) && StringUtils.isEmpty((CharSequence)thumbprint) ? this.certRepo.findAll().collectList() : (!StringUtils.isEmpty((CharSequence)owner) && StringUtils.isEmpty((CharSequence)thumbprint) ? this.certRepo.findByOwnerIgnoreCase(owner).collectList() : (StringUtils.isEmpty((CharSequence)owner) && !StringUtils.isEmpty((CharSequence)thumbprint) ? this.certRepo.findByThumbprint(thumbprint).collectList() : this.certRepo.findByThumbprint(thumbprint).filter(cert -> cert.getOwner().equalsIgnoreCase(owner)).collectList()));
        return retCertificates.switchIfEmpty(Mono.just(Collections.emptyList())).flatMap(certs -> {
            if (certs.isEmpty()) {
                return Mono.empty();
            }
            for (org.nhindirect.config.store.Certificate cert : certs) {
                CertificateUtils.stripP12Protection((org.nhindirect.config.store.Certificate)cert, (KeyStoreProtectionManager)this.kspMgr);
            }
            return Mono.just((Object)EntityModelConversion.toModelCertificate((org.nhindirect.config.store.Certificate)certs.iterator().next()));
        }).onErrorResume(e -> {
            log.error("Error looking up certificates.", e);
            return Mono.error((Throwable)new ResponseStatusException(HttpStatus.INTERNAL_SERVER_ERROR));
        });
    }

    @PutMapping(consumes={"application/json"})
    @ResponseStatus(value=HttpStatus.CREATED)
    public Mono<Void> addCertificate(@RequestBody Certificate cert) {
        String theOwner;
        CertUtils.CertContainer cont = null;
        cont = CertUtils.toCertContainer((byte[])cert.getData());
        if ((cert.getOwner() == null || cert.getOwner().isEmpty()) && cont != null && cont.getCert() != null && (theOwner = CertUtils.getOwner((X509Certificate)cont.getCert())) != null && !theOwner.isEmpty()) {
            cert.setOwner(theOwner);
        }
        try {
            return this.certRepo.findByOwnerIgnoreCaseAndThumbprint(cert.getOwner(), Thumbprint.toThumbprint((X509Certificate)cont.getCert()).toString()).switchIfEmpty(Mono.just((Object)new org.nhindirect.config.store.Certificate())).flatMap(lookupCert -> {
                if (lookupCert.getData() != null) {
                    log.error("Certificate already exists");
                    return Mono.error((Throwable)new ResponseStatusException(HttpStatus.CONFLICT));
                }
                try {
                    org.nhindirect.config.store.Certificate entCert = EntityModelConversion.toEntityCertificate(cert);
                    entCert = CertificateUtils.applyCertRepositoryAttributes((org.nhindirect.config.store.Certificate)entCert, (KeyStoreProtectionManager)this.kspMgr);
                    entCert.setId(null);
                    entCert.setCreateTime(LocalDateTime.now());
                    return this.certRepo.save((Object)entCert).then().onErrorResume(e -> {
                        log.error("Error adding certificate.", e);
                        return Mono.error((Throwable)new ResponseStatusException(HttpStatus.INTERNAL_SERVER_ERROR));
                    });
                }
                catch (Exception e2) {
                    log.error("Error adding certificate.", (Throwable)e2);
                    return Mono.error((Throwable)new ResponseStatusException(HttpStatus.INTERNAL_SERVER_ERROR));
                }
            });
        }
        catch (Exception e) {
            log.error("Error adding certificate.", (Throwable)e);
            return Mono.error((Throwable)new ResponseStatusException(HttpStatus.INTERNAL_SERVER_ERROR));
        }
    }

    @DeleteMapping(value={"ids/{ids}"})
    public Mono<Void> removeCertificatesByIds(@PathVariable(value="ids") String ids) {
        String[] idArray = ids.split(",");
        ArrayList<Long> idList = new ArrayList<Long>();
        for (String id : idArray) {
            idList.add(Long.parseLong(id));
        }
        return this.certRepo.deleteByIdIn(idList).onErrorResume(e -> {
            log.error("Error removing anchors by ids.", e);
            return Mono.error((Throwable)new ResponseStatusException(HttpStatus.INTERNAL_SERVER_ERROR));
        });
    }

    @DeleteMapping(value={"{owner}"})
    public Mono<Void> removeCertificatesByOwner(@PathVariable(value="owner") String owner) {
        return this.certRepo.deleteByOwnerIgnoreCase(owner).onErrorResume(e -> {
            log.error("Error removing certificates by owner.", e);
            return Mono.error((Throwable)new ResponseStatusException(HttpStatus.INTERNAL_SERVER_ERROR));
        });
    }
}

