/*
 * Decompiled with CFR 0.152.
 */
package org.nhindirect.config.resources;

import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.nhindirect.config.model.exceptions.CertificateConversionException;
import org.nhindirect.config.model.utils.CertUtils;
import org.nhindirect.config.processor.BundleRefreshProcessor;
import org.nhindirect.config.repository.AddressRepository;
import org.nhindirect.config.repository.DomainRepository;
import org.nhindirect.config.repository.TrustBundleAnchorRepository;
import org.nhindirect.config.repository.TrustBundleDomainReltnRepository;
import org.nhindirect.config.repository.TrustBundleRepository;
import org.nhindirect.config.resources.ProtectedResource;
import org.nhindirect.config.resources.util.EntityModelConversion;
import org.nhindirect.config.store.Domain;
import org.nhindirect.config.store.TrustBundle;
import org.nhindirect.config.store.TrustBundleAnchor;
import org.nhindirect.config.store.TrustBundleDomainReltn;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@RestController
@RequestMapping(value={"trustbundle"})
public class TrustBundleResource
extends ProtectedResource {
    private static final Logger log = LoggerFactory.getLogger(TrustBundleResource.class);
    protected TrustBundleRepository bundleRepo;
    protected TrustBundleAnchorRepository bundleAnchorRepo;
    protected TrustBundleDomainReltnRepository reltnRepo;
    protected DomainRepository domainRepo;
    protected AddressRepository addRepo;
    protected BundleRefreshProcessor bundleRefreshProcessor;

    @Autowired
    public void setTrustBundleRepository(TrustBundleRepository bundleRepo) {
        this.bundleRepo = bundleRepo;
    }

    @Autowired
    public void setTrustBundleRepository(TrustBundleAnchorRepository bundleAnchorRepo) {
        this.bundleAnchorRepo = bundleAnchorRepo;
    }

    @Autowired
    public void setTrustBundleDomainReltnRepository(TrustBundleDomainReltnRepository reltnRepo) {
        this.reltnRepo = reltnRepo;
    }

    @Autowired
    public void setDomainRepository(DomainRepository domainRepo) {
        this.domainRepo = domainRepo;
    }

    @Autowired
    public void setAddressRepository(AddressRepository addRepo) {
        this.addRepo = addRepo;
    }

    @Autowired
    public void setBunldeRefreshProcessor(BundleRefreshProcessor bundleRefreshProcessor) {
        this.bundleRefreshProcessor = bundleRefreshProcessor;
    }

    @GetMapping(produces={"application/json"})
    public Flux<org.nhindirect.config.model.TrustBundle> getTrustBundles(@RequestParam(name="fetchAnchors", defaultValue="true") boolean fetchAnchors) {
        return this.bundleRepo.findAll().flatMap(bundle -> {
            Flux anchorFlux = !fetchAnchors ? Flux.fromIterable(new ArrayList()) : this.bundleAnchorRepo.findByTrustBundleId(bundle.getId());
            return anchorFlux.collectList().map(anchors -> EntityModelConversion.toModelTrustBundle(bundle, anchors));
        }).onErrorResume(e -> {
            log.error("Error looking up trust bundles", e);
            return Flux.error((Throwable)new ResponseStatusException(HttpStatus.INTERNAL_SERVER_ERROR));
        });
    }

    @GetMapping(value={"domains/bundles/reltns"}, produces={"application/json"})
    public Flux<org.nhindirect.config.model.TrustBundleDomainReltn> getAllTrustBundleDomainRelts(@RequestParam(name="fetchAnchors", defaultValue="true") boolean fetchAnchors) {
        return this.reltnRepo.findAll().flatMap(bundleReltn -> this.bundleRepo.findById((Object)bundleReltn.getTrustBundleId()).flatMap(bundle -> {
            Flux anchorFlux = !fetchAnchors ? Flux.fromIterable(new ArrayList()) : this.bundleAnchorRepo.findByTrustBundleId(bundle.getId());
            return anchorFlux.collectList().map(anchors -> EntityModelConversion.toModelTrustBundle(bundle, anchors));
        }).flatMap(bundle -> this.domainRepo.findById((Object)bundleReltn.getDomainId()).map(domain -> {
            org.nhindirect.config.model.TrustBundleDomainReltn newReltn = new org.nhindirect.config.model.TrustBundleDomainReltn();
            newReltn.setIncoming(bundleReltn.isIncoming());
            newReltn.setOutgoing(bundleReltn.isOutgoing());
            newReltn.setDomain(EntityModelConversion.toModelDomain(domain, Collections.emptyList()));
            newReltn.setTrustBundle(bundle);
            return newReltn;
        }))).onErrorResume(e -> {
            log.error("Error looking up trust bundles", e);
            return Flux.error((Throwable)new ResponseStatusException(HttpStatus.INTERNAL_SERVER_ERROR));
        });
    }

    @GetMapping(value={"domains/{domainName}"}, produces={"application/json"})
    public Flux<org.nhindirect.config.model.TrustBundleDomainReltn> getTrustBundlesByDomain(@PathVariable(value="domainName") String domainName, @RequestParam(name="fetchAnchors", defaultValue="true") boolean fetchAnchors) {
        return this.domainRepo.findByDomainNameIgnoreCase(domainName).switchIfEmpty(Mono.just((Object)new Domain())).flatMapMany(domain -> {
            if (domain.getDomainName() == null) {
                return Flux.error((Throwable)new ResponseStatusException(HttpStatus.NOT_FOUND));
            }
            return this.reltnRepo.findByDomainId(domain.getId()).flatMap(bundleReltn -> this.bundleRepo.findById((Object)bundleReltn.getTrustBundleId()).flatMap(bundle -> {
                Flux anchorFlux = !fetchAnchors ? Flux.fromIterable(new ArrayList()) : this.bundleAnchorRepo.findByTrustBundleId(bundle.getId());
                return anchorFlux.collectList().map(anchors -> EntityModelConversion.toModelTrustBundle(bundle, anchors));
            }).map(bundle -> {
                org.nhindirect.config.model.TrustBundleDomainReltn newReltn = new org.nhindirect.config.model.TrustBundleDomainReltn();
                newReltn.setIncoming(bundleReltn.isIncoming());
                newReltn.setOutgoing(bundleReltn.isOutgoing());
                newReltn.setDomain(EntityModelConversion.toModelDomain(domain, Collections.emptyList()));
                newReltn.setTrustBundle(bundle);
                return newReltn;
            })).onErrorResume(e -> {
                log.error("Error looking up trust bundles", e);
                return Flux.error((Throwable)new ResponseStatusException(HttpStatus.INTERNAL_SERVER_ERROR));
            });
        });
    }

    @GetMapping(value={"{bundleName}"}, produces={"application/json"})
    public Mono<org.nhindirect.config.model.TrustBundle> getTrustBundleByName(@PathVariable(value="bundleName") String bundleName) {
        return this.bundleRepo.findByBundleNameIgnoreCase(bundleName).switchIfEmpty(Mono.just((Object)new TrustBundle())).flatMap(bundle -> {
            if (bundle.getBundleName() == null) {
                return Mono.error((Throwable)new ResponseStatusException(HttpStatus.NOT_FOUND));
            }
            Flux anchorFlux = this.bundleAnchorRepo.findByTrustBundleId(bundle.getId());
            return anchorFlux.collectList().map(anchors -> EntityModelConversion.toModelTrustBundle(bundle, anchors)).onErrorResume(e -> {
                log.error("Error looking up trust bundles", e);
                return Mono.error((Throwable)new ResponseStatusException(HttpStatus.INTERNAL_SERVER_ERROR));
            });
        });
    }

    @PutMapping(consumes={"application/json"})
    @ResponseStatus(value=HttpStatus.CREATED)
    public Mono<Void> addTrustBundle(@RequestBody org.nhindirect.config.model.TrustBundle bundle) {
        return this.bundleRepo.findByBundleNameIgnoreCase(bundle.getBundleName()).switchIfEmpty(Mono.just((Object)new TrustBundle())).flatMap(foundBundle -> {
            if (foundBundle.getBundleName() != null) {
                return Mono.error((Throwable)new ResponseStatusException(HttpStatus.CONFLICT));
            }
            Map.Entry<TrustBundle, Collection<TrustBundleAnchor>> entry = EntityModelConversion.toEntityTrustBundle(bundle);
            TrustBundle addBundle = entry.getKey();
            addBundle.setId(null);
            return this.bundleRepo.save((Object)addBundle).flatMap(trustBundle -> this.bundleRefreshProcessor.refreshBundle((TrustBundle)trustBundle).then()).onErrorResume(e -> {
                log.error("Error adding trust bundle", e);
                return Mono.error((Throwable)new ResponseStatusException(HttpStatus.INTERNAL_SERVER_ERROR));
            });
        });
    }

    @PostMapping(value={"{bundle}/refreshBundle"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public Mono<Void> refreshTrustBundle(@PathVariable(value="bundle") String bundleName) {
        return this.bundleRepo.findByBundleNameIgnoreCase(bundleName).switchIfEmpty(Mono.just((Object)new TrustBundle())).flatMap(foundBundle -> {
            if (foundBundle.getBundleName() == null) {
                return Mono.error((Throwable)new ResponseStatusException(HttpStatus.NOT_FOUND));
            }
            return this.bundleRefreshProcessor.refreshBundle((TrustBundle)foundBundle).then();
        });
    }

    @DeleteMapping(value={"{bundle}"})
    public Mono<Void> deleteBundle(@PathVariable(value="bundle") String bundleName) {
        return this.bundleRepo.findByBundleNameIgnoreCase(bundleName).switchIfEmpty(Mono.just((Object)new TrustBundle())).flatMap(foundBundle -> {
            if (foundBundle.getBundleName() == null) {
                return Mono.error((Throwable)new ResponseStatusException(HttpStatus.NOT_FOUND));
            }
            return this.bundleAnchorRepo.deleteByTrustBundleId(foundBundle.getId()).then(this.reltnRepo.deleteByTrustBundleId(foundBundle.getId()).then(this.bundleRepo.deleteById((Object)foundBundle.getId()))).onErrorResume(e -> {
                log.error("Error deleting bundle", e);
                return Mono.error((Throwable)new ResponseStatusException(HttpStatus.INTERNAL_SERVER_ERROR));
            });
        });
    }

    @PostMapping(value={"{bundle}/signingCert"}, consumes={"application/json"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public Mono<Void> updateSigningCert(@PathVariable(value="bundle") String bundleName, @RequestBody(required=false) byte[] certData) {
        return this.bundleRepo.findByBundleNameIgnoreCase(bundleName).switchIfEmpty(Mono.just((Object)new TrustBundle())).flatMap(foundBundle -> {
            block5: {
                if (foundBundle.getBundleName() == null) {
                    return Mono.error((Throwable)new ResponseStatusException(HttpStatus.NOT_FOUND));
                }
                try {
                    foundBundle.setSigningCertificateData(null);
                    if (certData == null || certData.length <= 0) break block5;
                    try {
                        X509Certificate signingCert = CertUtils.toX509Certificate((byte[])certData);
                        foundBundle.setSigningCertificateData(signingCert.getEncoded());
                    }
                    catch (CertificateConversionException ex) {
                        log.error("Signing certificate is not in a valid format " + bundleName, (Throwable)ex);
                        return Mono.error((Throwable)new ResponseStatusException(HttpStatus.BAD_REQUEST));
                    }
                }
                catch (Exception e2) {
                    log.error("Error geting encoded signing certificate ", (Throwable)e2);
                    return Mono.error((Throwable)new ResponseStatusException(HttpStatus.INTERNAL_SERVER_ERROR));
                }
            }
            return this.bundleRepo.save(foundBundle).then().onErrorResume(e -> {
                log.error("Error updating trust bundle signing certificate.", e);
                return Mono.error((Throwable)new ResponseStatusException(HttpStatus.INTERNAL_SERVER_ERROR));
            });
        });
    }

    @PostMapping(value={"{bundle}/bundleAttributes"}, consumes={"application/json"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public Mono<Void> updateBundleAttributes(@PathVariable(value="bundle") String bundleName, @RequestBody org.nhindirect.config.model.TrustBundle bundleData) {
        return this.bundleRepo.findByBundleNameIgnoreCase(bundleName).switchIfEmpty(Mono.just((Object)new TrustBundle())).flatMap(foundBundle -> {
            if (foundBundle.getBundleName() == null) {
                return Mono.error((Throwable)new ResponseStatusException(HttpStatus.NOT_FOUND));
            }
            if (foundBundle.getBundleName().equals(bundleData.getBundleName()) && foundBundle.getBundleURL().equals(bundleData.getBundleURL()) && foundBundle.getRefreshInterval() == bundleData.getRefreshInterval()) {
                if (bundleData.getSigningCertificateData() == null && foundBundle.getSigningCertificateData() == null) {
                    return Mono.empty();
                }
                if (bundleData.getSigningCertificateData() != null && foundBundle.getSigningCertificateData() != null && Arrays.equals(bundleData.getSigningCertificateData(), foundBundle.getSigningCertificateData())) {
                    return Mono.empty();
                }
            }
            String oldBundleURL = foundBundle.getBundleURL();
            X509Certificate newSigningCert = null;
            if (bundleData.getSigningCertificateData() != null) {
                try {
                    newSigningCert = CertUtils.toX509Certificate((byte[])bundleData.getSigningCertificateData());
                }
                catch (CertificateConversionException ex) {
                    log.error("Signing certificate is not in a valid format " + bundleName, (Throwable)ex);
                    return Mono.error((Throwable)new ResponseStatusException(HttpStatus.BAD_REQUEST));
                }
            }
            try {
                if (newSigningCert == null) {
                    foundBundle.setSigningCertificateData(null);
                } else {
                    foundBundle.setSigningCertificateData(newSigningCert.getEncoded());
                }
            }
            catch (Exception e2) {
                log.error("Setting signing certificate encoded data", (Throwable)e2);
                return Mono.error((Throwable)new ResponseStatusException(HttpStatus.INTERNAL_SERVER_ERROR));
            }
            if (!StringUtils.isEmpty((CharSequence)bundleData.getBundleName())) {
                foundBundle.setBundleName(bundleData.getBundleName());
            }
            foundBundle.setRefreshInterval(bundleData.getRefreshInterval());
            if (!StringUtils.isEmpty((CharSequence)bundleData.getBundleURL())) {
                foundBundle.setBundleURL(bundleData.getBundleURL());
            }
            return this.bundleRepo.save(foundBundle).doOnSuccess(trustBundle -> {
                if (bundleData.getBundleURL() != null && !bundleData.getBundleURL().isEmpty() && !oldBundleURL.equals(bundleData.getBundleURL())) {
                    this.bundleRefreshProcessor.refreshBundle((TrustBundle)foundBundle);
                }
            }).then().onErrorResume(e -> {
                log.error("Error updating bundle attributes", e);
                return Mono.error((Throwable)new ResponseStatusException(HttpStatus.INTERNAL_SERVER_ERROR));
            });
        });
    }

    @PostMapping(value={"{bundle}/{domain}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public Mono<Void> associateTrustBundleToDomain(@PathVariable(value="bundle") String bundleName, @PathVariable(value="domain") String domainName, @RequestParam(name="incoming", defaultValue="true") boolean incoming, @RequestParam(name="outgoing", defaultValue="true") boolean outgoing) {
        return this.bundleRepo.findByBundleNameIgnoreCase(bundleName).switchIfEmpty(Mono.just((Object)new TrustBundle())).flatMap(foundBundle -> {
            if (foundBundle.getBundleName() == null) {
                return Mono.error((Throwable)new ResponseStatusException(HttpStatus.NOT_FOUND));
            }
            return this.domainRepo.findByDomainNameIgnoreCase(domainName).switchIfEmpty(Mono.just((Object)new Domain())).flatMap(foundDomain -> {
                if (foundDomain.getDomainName() == null) {
                    return Mono.error((Throwable)new ResponseStatusException(HttpStatus.NOT_FOUND));
                }
                TrustBundleDomainReltn reltn = new TrustBundleDomainReltn();
                reltn.setDomainId(foundDomain.getId());
                reltn.setTrustBundleId(foundBundle.getId());
                reltn.setIncoming(incoming);
                reltn.setOutgoing(outgoing);
                return this.reltnRepo.save((Object)reltn).then().onErrorResume(e -> {
                    log.error("Error associating trust bundle to domain.", e);
                    return Mono.error((Throwable)new ResponseStatusException(HttpStatus.INTERNAL_SERVER_ERROR));
                });
            });
        });
    }

    @DeleteMapping(value={"{bundle}/{domain}"})
    public Mono<Void> disassociateTrustBundleFromDomain(@PathVariable(value="bundle") String bundleName, @PathVariable(value="domain") String domainName) {
        return this.bundleRepo.findByBundleNameIgnoreCase(bundleName).switchIfEmpty(Mono.just((Object)new TrustBundle())).flatMap(foundBundle -> {
            if (foundBundle.getBundleName() == null) {
                return Mono.error((Throwable)new ResponseStatusException(HttpStatus.NOT_FOUND));
            }
            return this.domainRepo.findByDomainNameIgnoreCase(domainName).switchIfEmpty(Mono.just((Object)new Domain())).flatMap(foundDomain -> {
                if (foundDomain.getDomainName() == null) {
                    return Mono.error((Throwable)new ResponseStatusException(HttpStatus.NOT_FOUND));
                }
                return this.reltnRepo.deleteByDomainIdAndTrustBundleId(foundDomain.getId(), foundBundle.getId()).then().onErrorResume(e -> {
                    log.error("Error disassociating trust bundle from domain.", e);
                    return Mono.error((Throwable)new ResponseStatusException(HttpStatus.INTERNAL_SERVER_ERROR));
                });
            });
        });
    }

    @DeleteMapping(value={"{domain}/deleteFromDomain"})
    public Mono<Void> disassociateTrustBundlesFromDomain(@PathVariable(value="domain") String domainName) {
        return this.domainRepo.findByDomainNameIgnoreCase(domainName).switchIfEmpty(Mono.just((Object)new Domain())).flatMap(foundDomain -> {
            if (foundDomain.getDomainName() == null) {
                return Mono.error((Throwable)new ResponseStatusException(HttpStatus.NOT_FOUND));
            }
            return this.reltnRepo.deleteByDomainId(foundDomain.getId()).then().onErrorResume(e -> {
                log.error("Error disassociating trust bundle from domain.", e);
                return Mono.error((Throwable)new ResponseStatusException(HttpStatus.INTERNAL_SERVER_ERROR));
            });
        });
    }

    @DeleteMapping(value={"{bundle}/deleteFromBundle"})
    public Mono<Void> disassociateTrustBundleFromDomains(@PathVariable(value="bundle") String bundleName) {
        return this.bundleRepo.findByBundleNameIgnoreCase(bundleName).switchIfEmpty(Mono.just((Object)new TrustBundle())).flatMap(foundBundle -> {
            if (foundBundle.getBundleName() == null) {
                return Mono.error((Throwable)new ResponseStatusException(HttpStatus.NOT_FOUND));
            }
            return this.reltnRepo.deleteByTrustBundleId(foundBundle.getId()).then().onErrorResume(e -> {
                log.error("Error disassociating trust bundle from domains.", e);
                return Mono.error((Throwable)new ResponseStatusException(HttpStatus.INTERNAL_SERVER_ERROR));
            });
        });
    }
}

